/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.openide.filesystems.FileSystem;

class EventControl {
    private int requests;
    private int priorityRequests;
    private AtomicActionLink currentAtomAction;
    private LinkedList<FileSystem.EventDispatcher> requestsQueue;

    EventControl() {
    }

    void dispatchEvent(FileSystem.EventDispatcher eventDispatcher) {
        if (this.postponeFiring(eventDispatcher)) {
            return;
        }
        eventDispatcher.run();
    }

    void beginAtomicAction(FileSystem.AtomicAction atomicAction) {
        this.enterAtomicAction(atomicAction, true);
    }

    void finishAtomicAction() {
        this.exitAtomicAction(true);
    }

    void runAtomicAction(FileSystem.AtomicAction atomicAction) throws IOException {
        try {
            this.enterAtomicAction(atomicAction, false);
            atomicAction.run();
        }
        finally {
            this.exitAtomicAction(false);
        }
    }

    private synchronized void enterAtomicAction(Object object, boolean bl) {
        AtomicActionLink atomicActionLink = new AtomicActionLink(object);
        atomicActionLink.setPreviousLink(this.currentAtomAction);
        this.currentAtomAction = atomicActionLink;
        if (bl) {
            ++this.priorityRequests;
        }
        if (this.requests++ == 0) {
            this.setRequestsQueue(new LinkedList<FileSystem.EventDispatcher>());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitAtomicAction(boolean bl) {
        LinkedList<FileSystem.EventDispatcher> linkedList;
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = this;
        synchronized (object) {
            this.currentAtomAction = this.currentAtomAction.getPreviousLink();
            --this.requests;
            if (bl) {
                --this.priorityRequests;
            }
            if (this.requests == 0) {
                bl2 = true;
            }
            if (!bl2 && bl && this.priorityRequests == 0) {
                bl3 = true;
            }
            if (!bl2 && !bl3) {
                return;
            }
            linkedList = this.getRequestsQueue();
            this.setRequestsQueue(null);
            this.priorityRequests = 0;
            if (bl3 && !bl2) {
                this.setRequestsQueue(new LinkedList<FileSystem.EventDispatcher>());
            }
        }
        if (bl2) {
            this.invokeDispatchers(false, linkedList);
            return;
        }
        if (bl3) {
            object = this.invokeDispatchers(true, linkedList);
            EventControl eventControl = this;
            synchronized (eventControl) {
                while (this.getRequestsQueue() != null && !this.getRequestsQueue().isEmpty()) {
                    FileSystem.EventDispatcher eventDispatcher = this.getRequestsQueue().removeFirst();
                    ((LinkedList)object).add(eventDispatcher);
                }
                this.setRequestsQueue((LinkedList<FileSystem.EventDispatcher>)object);
            }
        }
    }

    private LinkedList<FileSystem.EventDispatcher> invokeDispatchers(boolean bl, LinkedList<FileSystem.EventDispatcher> linkedList) {
        LinkedList<FileSystem.EventDispatcher> linkedList2 = new LinkedList<FileSystem.EventDispatcher>();
        LinkedHashSet<Runnable> linkedHashSet = new LinkedHashSet<Runnable>();
        while (linkedList != null && !linkedList.isEmpty()) {
            FileSystem.EventDispatcher eventDispatcher = linkedList.removeFirst();
            eventDispatcher.dispatch(bl, linkedHashSet);
            if (!bl) continue;
            linkedList2.add(eventDispatcher);
        }
        for (Runnable runnable : linkedHashSet) {
            runnable.run();
        }
        return linkedList2;
    }

    private synchronized boolean postponeFiring(FileSystem.EventDispatcher eventDispatcher) {
        if (this.priorityRequests == 0) {
            eventDispatcher.setAtomicActionLink(this.currentAtomAction);
            eventDispatcher.dispatch(true, null);
        }
        if (this.getRequestsQueue() != null) {
            eventDispatcher.setAtomicActionLink(this.currentAtomAction);
            this.getRequestsQueue().add(eventDispatcher);
            return true;
        }
        return false;
    }

    private LinkedList<FileSystem.EventDispatcher> getRequestsQueue() {
        assert (Thread.holdsLock(this));
        return this.requestsQueue;
    }

    private void setRequestsQueue(LinkedList<FileSystem.EventDispatcher> linkedList) {
        assert (Thread.holdsLock(this));
        this.requestsQueue = linkedList;
    }

    static final class AtomicActionLink {
        private AtomicActionLink upper;
        private Object propagationID;

        AtomicActionLink(Object object) {
            this.propagationID = object;
        }

        Object getAtomicAction() {
            return this.propagationID;
        }

        void setPreviousLink(AtomicActionLink atomicActionLink) {
            this.upper = atomicActionLink;
        }

        AtomicActionLink getPreviousLink() {
            return this.upper;
        }
    }
}

