/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.ui;

import com.sun.tools.visualvm.heapviewer.HeapContext;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.swing.MultiSplitContainer;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewPlugin;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerActions;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableView;
import com.sun.tools.visualvm.heapviewer.ui.TreeTableViewColumn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CloseButton;
import org.netbeans.lib.profiler.ui.components.JExtendedSplitPane;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.openide.util.Lookup;

public class PluggableTreeTableView
extends TreeTableView {
    private static final Color SEPARATOR_COLOR = UIManager.getColor("Separator.foreground");
    private final List<HeapViewPlugin> plugins = new ArrayList<HeapViewPlugin>();
    private ProfilerToolbar toolbar;
    private JComponent pluginsComponent;

    public PluggableTreeTableView(String viewID, HeapContext context, HeapViewerActions actions, TreeTableViewColumn ... columns) {
        this(viewID, context, actions, true, true, columns);
    }

    public PluggableTreeTableView(String viewID, HeapContext context, HeapViewerActions actions, boolean useBreadCrumbs, boolean pluggableColumns, TreeTableViewColumn ... columns) {
        super(viewID, context, actions, useBreadCrumbs, pluggableColumns, columns);
        Collection pluginProviders = Lookup.getDefault().lookupAll(HeapViewPlugin.Provider.class);
        for (HeapViewPlugin.Provider provider : pluginProviders) {
            HeapViewPlugin plugin = provider.createPlugin(context, actions, viewID);
            if (plugin == null) continue;
            this.plugins.add(plugin);
        }
    }

    public boolean hasPlugins() {
        return !this.plugins.isEmpty();
    }

    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    @Override
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        super.nodeSelected(node, adjusting);
        for (HeapViewPlugin plugin : this.plugins) {
            plugin.doNodeSelected(node, adjusting);
        }
    }

    @Override
    protected JComponent createComponent() {
        final JComponent comp = super.createComponent();
        if (this.toolbar == null) {
            this.init();
        }
        JExtendedSplitPane contentSplit = new JExtendedSplitPane(0, true, comp, this.pluginsComponent){

            public boolean requestFocusInWindow() {
                return comp.requestFocusInWindow();
            }
        };
        BasicSplitPaneDivider contentDivider = ((BasicSplitPaneUI)contentSplit.getUI()).getDivider();
        contentDivider.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, SEPARATOR_COLOR));
        contentDivider.setDividerSize(5);
        contentSplit.setBorder(BorderFactory.createEmptyBorder());
        contentSplit.setResizeWeight(0.7);
        return contentSplit;
    }

    private void init() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.pluginsComponent = new MultiSplitContainer();
        this.pluginsComponent.setPreferredSize(new Dimension(300, 300));
        int pcount = this.plugins.size();
        for (int i = 0; i < pcount; ++i) {
            HeapViewPlugin plugin = this.plugins.get(i);
            PluginPresenter presenter = new PluginPresenter(plugin);
            presenter.putClientProperty("JButton.buttonType", "segmented");
            if (i == 0) {
                presenter.putClientProperty("JButton.segmentPosition", "first");
            } else if (i == pcount - 1) {
                presenter.putClientProperty("JButton.segmentPosition", "last");
            } else {
                presenter.putClientProperty("JButton.segmentPosition", "middle");
            }
            PluginContainer container = new PluginContainer(plugin, presenter);
            this.toolbar.add((Component)presenter);
            this.pluginsComponent.add(container);
        }
        PluggableTreeTableView.checkVisibility(this.pluginsComponent);
    }

    private static void checkVisibility(JComponent comp) {
        if (comp == null) {
            return;
        }
        comp.invalidate();
        comp.revalidate();
        comp.doLayout();
        comp.repaint();
        for (Component c : comp.getComponents()) {
            if (!c.isVisible()) continue;
            comp.setVisible(true);
            return;
        }
        comp.setVisible(false);
    }

    private static class PluginContainer
    extends JPanel {
        PluginContainer(HeapViewPlugin plugin, final PluginPresenter pluginPresenter) {
            super(new BorderLayout());
            JPanel detailHeader = new JPanel(null);
            detailHeader.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, SEPARATOR_COLOR));
            detailHeader.setLayout(new BoxLayout(detailHeader, 2));
            detailHeader.setBackground(UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground()));
            JLabel captionL = new JLabel(plugin.getName(), plugin.getIcon(), 10);
            captionL.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            detailHeader.add(captionL);
            detailHeader.add(Box.createGlue());
            detailHeader.add(CloseButton.create((Runnable)new Runnable(){

                @Override
                public void run() {
                    pluginPresenter.setSelected(false);
                }
            }));
            this.add((Component)detailHeader, "North");
            this.add((Component)plugin.getComponent(), "Center");
            this.setVisible(pluginPresenter.isSelected());
        }
    }

    private static class PluginPresenter
    extends JToggleButton {
        private final JComponent component;

        PluginPresenter(HeapViewPlugin plugin) {
            super(plugin.getName(), plugin.getIcon());
            this.setToolTipText(plugin.getDescription());
            this.component = plugin.getComponent();
        }

        @Override
        protected void fireItemStateChanged(ItemEvent e) {
            this.component.getParent().setVisible(e.getStateChange() == 1);
            PluggableTreeTableView.checkVisibility((JComponent)this.component.getParent().getParent());
        }
    }
}

