/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.intent;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.intent.Callback;
import org.netbeans.api.intent.IntentAction;
import org.netbeans.api.intent.NoAvailableHandlerException;
import org.netbeans.modules.intent.CallbackResult;
import org.netbeans.modules.intent.IntentHandler;
import org.netbeans.modules.intent.SettableResult;
import org.netbeans.spi.intent.Result;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class Intent {
    private static final Logger LOG = Logger.getLogger(Intent.class.getName());
    public static final String ACTION_VIEW = "VIEW";
    public static final String ACTION_EDIT = "EDIT";
    private final String action;
    private final URI uri;

    public Intent(@NonNull String string, @NonNull URI uRI) {
        Parameters.notNull((CharSequence)"action", (Object)string);
        Parameters.notNull((CharSequence)"uri", (Object)uRI);
        this.action = string;
        this.uri = uRI;
    }

    @NonNull
    public String getAction() {
        return this.action;
    }

    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @NonNull
    public Future<Object> execute() {
        return IntentHandler.RP.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SettableResult settableResult = new SettableResult();
                Intent.invoke(Intent.this, settableResult);
                if (settableResult.getException() != null) {
                    throw settableResult.getException();
                }
                return settableResult.getResult();
            }
        });
    }

    public void execute(final @NullAllowed Callback callback) {
        IntentHandler.RP.post(new Runnable(){

            @Override
            public void run() {
                Intent.invoke(Intent.this, callback == null ? null : new CallbackResult(callback));
            }
        });
    }

    @NonNull
    public SortedSet<? extends IntentAction> getIntentActions() {
        SortedSet<IntentHandler> sortedSet = Intent.getIntentHandlers(this);
        TreeSet<IntentAction> treeSet = new TreeSet<IntentAction>(new Comparator<IntentAction>(){

            @Override
            public int compare(IntentAction intentAction, IntentAction intentAction2) {
                return intentAction.getPosition() - intentAction2.getPosition();
            }
        });
        for (IntentHandler intentHandler : sortedSet) {
            treeSet.add(new IntentAction(this, intentHandler));
        }
        return Collections.unmodifiableSortedSet(treeSet);
    }

    private static SortedSet<IntentHandler> getIntentHandlers(Intent intent) {
        FileObject fileObject = FileUtil.getConfigFile((String)"Services/Intent/Handlers");
        if (fileObject == null) {
            return null;
        }
        TreeSet<IntentHandler> treeSet = new TreeSet<IntentHandler>();
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (!"instance".equals(fileObject2.getExt())) continue;
            Object object = fileObject2.getAttribute("uriPattern");
            Object object2 = fileObject2.getAttribute("displayName");
            Object object3 = fileObject2.getAttribute("position");
            Object object4 = fileObject2.getAttribute("actions");
            if (object instanceof String && object2 instanceof String && object3 instanceof Integer && object4 instanceof String) {
                if (!Intent.canSupport((String)object, (String)object4, intent)) continue;
                try {
                    IntentHandler intentHandler = (IntentHandler)FileUtil.getConfigObject((String)fileObject2.getPath(), IntentHandler.class);
                    treeSet.add(intentHandler);
                }
                catch (Exception exception) {
                    LOG.log(Level.INFO, "Cannot instantiate handler for " + fileObject2.getPath(), exception);
                }
                continue;
            }
            LOG.log(Level.FINE, "Invalid URI handler {0}", fileObject2.getPath());
        }
        return treeSet;
    }

    private static boolean canSupport(String string, String string2, Intent intent) {
        Pattern pattern = Pattern.compile(string);
        if (pattern.matcher(intent.getUri().toString()).matches()) {
            if ("*".equals(string2)) {
                return true;
            }
            List<String> list = Arrays.asList(string2.split(","));
            return list.contains(intent.getAction());
        }
        return false;
    }

    private static void invoke(Intent intent, Result result) {
        Exception exception = null;
        boolean bl = false;
        for (IntentHandler intentHandler : Intent.getIntentHandlers(intent)) {
            try {
                intentHandler.handle(intent, result);
                bl = true;
                break;
            }
            catch (Exception exception2) {
                exception = exception2;
                LOG.log(Level.WARNING, null, exception2);
            }
        }
        if (!bl) {
            if (result != null) {
                result.setException(exception == null ? new NoAvailableHandlerException(intent) : new NoAvailableHandlerException(intent, (Throwable)exception));
            }
            LOG.log(Level.INFO, "Intent {0} cannot be handled", intent);
        }
    }

    public String toString() {
        return "Intent{action=" + this.action + ", uri=" + this.uri + '}';
    }
}

