/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.actions.Savable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.actions.CookieAction;

public class SaveAction
extends CookieAction {
    private static Class<? extends Node.Cookie> dataObject;
    private static Method getNodeDelegate;

    public SaveAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected Class[] cookieClasses() {
        return new Class[]{Savable.class};
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new Delegate(this, lookup);
    }

    final void performAction(Lookup lookup) {
        Collection collection = lookup.lookupAll(Savable.class);
        LinkedList linkedList = new LinkedList(lookup.lookupAll(Node.class));
        block0: for (Savable savable : collection) {
            for (Node node : linkedList) {
                if (!savable.equals(node.getLookup().lookup(Savable.class))) continue;
                this.performAction(savable, node);
                linkedList.remove(node);
                continue block0;
            }
            this.performAction(savable, null);
        }
    }

    protected void performAction(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node = nodeArray[i];
            Savable savable = (Savable)node.getLookup().lookup(Savable.class);
            assert (savable != null) : "Savable must be present on " + node + ". See http://www.netbeans.org/issues/show_bug.cgi?id=68285 for details on overriding " + node.getClass().getName() + ".getCookie correctly.";
            if (savable == null) {
                return;
            }
            this.performAction(savable, node);
        }
    }

    private void performAction(Savable savable, Node node) {
        UserQuestionException userQuestionException = null;
        while (true) {
            try {
                if (userQuestionException == null) {
                    savable.save();
                } else {
                    userQuestionException.confirmed();
                }
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(SaveAction.class, (String)"MSG_saved", (Object)this.getSaveMessage(savable, node)));
            }
            catch (UserQuestionException userQuestionException2) {
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)userQuestionException2.getLocalizedMessage(), 0);
                Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (!NotifyDescriptor.OK_OPTION.equals(object)) break;
                userQuestionException = userQuestionException2;
                continue;
            }
            catch (IOException iOException) {
                Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(SaveAction.class, (String)"EXC_notsaved", (Object)this.getSaveMessage(savable, node), (Object)iOException.getLocalizedMessage()));
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, null, iOException);
            }
            break;
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private String getSaveMessage(Savable savable, Node node) {
        ClassLoader classLoader;
        if (node == null) {
            return savable.toString();
        }
        if (dataObject == null) {
            classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (classLoader == null) {
                classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            try {
                dataObject = Class.forName("org.openide.loaders.DataObject", true, classLoader).asSubclass(Node.Cookie.class);
                getNodeDelegate = dataObject.getMethod("getNodeDelegate", new Class[0]);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        if (getNodeDelegate != null && (classLoader = node.getCookie(dataObject)) != null) {
            try {
                node = (Node)getNodeDelegate.invoke((Object)classLoader, new Object[0]);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return node.getDisplayName();
    }

    protected int mode() {
        return 7;
    }

    public String getName() {
        return NbBundle.getMessage(SaveAction.class, (String)"Save");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SaveAction.class);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/save.png";
    }

    private static final class Delegate
    extends AbstractAction
    implements ContextAwareAction {
        final SaveAction sa;
        final Lookup context;

        public Delegate(SaveAction saveAction, Lookup lookup) {
            this.sa = saveAction;
            this.context = lookup;
        }

        public Action createContextAwareInstance(Lookup lookup) {
            return new Delegate(this.sa, lookup);
        }

        @Override
        public Object getValue(String string) {
            return this.sa.getValue(string);
        }

        @Override
        public void putValue(String string, Object object) {
            this.sa.putValue(string, object);
        }

        @Override
        public boolean isEnabled() {
            return this.context.lookup(Savable.class) != null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.sa.performAction(this.context);
        }
    }
}

