/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.scheduler;

import com.sun.tools.visualvm.core.scheduler.DefaultScheduledTask;
import com.sun.tools.visualvm.core.scheduler.Quantum;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SchedulingPipe {
    private static final Logger LOGGER = Logger.getLogger(SchedulingPipe.class.getName());
    private final Object pipeLock = new Object();
    private final ReadWriteLock tasksLock = new ReentrantReadWriteLock();
    private ScheduledFuture pipeFuture = null;
    private static final ScheduledExecutorService schedulerService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
    private static final ExecutorService dispatcher = Executors.newCachedThreadPool();
    private final Set<WeakReference<DefaultScheduledTask>> tasks = new HashSet<WeakReference<DefaultScheduledTask>>();
    private Quantum interval;

    SchedulingPipe(Quantum interval) {
        this.interval = interval;
    }

    void addTask(DefaultScheduledTask task) {
        try {
            this.tasksLock.writeLock().lock();
            if (this.tasks.isEmpty()) {
                this.startPipe();
            }
            this.tasks.add(new WeakReference<DefaultScheduledTask>(task));
        }
        finally {
            this.tasksLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPipe() {
        Object object = this.pipeLock;
        synchronized (object) {
            this.pipeFuture = schedulerService.scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block8: {
                        try {
                            SchedulingPipe.this.tasksLock.writeLock().lock();
                            final long timeStamp = System.currentTimeMillis();
                            Iterator iter = SchedulingPipe.this.tasks.iterator();
                            while (iter.hasNext()) {
                                WeakReference ref = (WeakReference)iter.next();
                                final DefaultScheduledTask t = (DefaultScheduledTask)ref.get();
                                if (t != null) {
                                    dispatcher.submit(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                t.onSchedule(timeStamp);
                                            }
                                            catch (Throwable e) {
                                                LOGGER.log(Level.SEVERE, null, e);
                                            }
                                        }
                                    });
                                    continue;
                                }
                                iter.remove();
                            }
                            if (!SchedulingPipe.this.tasks.isEmpty()) break block8;
                            Object object = SchedulingPipe.this.pipeLock;
                            synchronized (object) {
                                SchedulingPipe.this.pipeFuture.cancel(false);
                                SchedulingPipe.this.pipeFuture = null;
                            }
                        }
                        finally {
                            SchedulingPipe.this.tasksLock.writeLock().unlock();
                        }
                    }
                }
            }, this.interval.interval, this.interval.interval, this.interval.unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTask(DefaultScheduledTask task) {
        try {
            this.tasksLock.writeLock().lock();
            Iterator<WeakReference<DefaultScheduledTask>> iter = this.tasks.iterator();
            while (iter.hasNext()) {
                WeakReference<DefaultScheduledTask> ref = iter.next();
                DefaultScheduledTask t = (DefaultScheduledTask)ref.get();
                if (t != null && !t.equals(task)) continue;
                iter.remove();
            }
        }
        finally {
            this.tasksLock.writeLock().unlock();
        }
        if (this.tasks.isEmpty()) {
            Object object = this.pipeLock;
            synchronized (object) {
                this.pipeFuture.cancel(false);
                this.pipeFuture = null;
            }
        }
    }
}

