/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class TemplateWizard2
extends JPanel
implements DocumentListener {
    private ChangeListener listener;
    private static final String PROP_LOCATION_FOLDER = "locationFolder";
    private File locationFolder;
    private DefaultPropertyModel locationFolderModel;
    private String extension;
    private PropertyPanel dataFolderPanel;
    private JLabel jLabel1;
    private JPanel namePanel;
    private JTextField newObjectName;

    public TemplateWizard2() {
        this.initLocationFolder();
        this.initComponents();
        this.setName(DataObject.getString("LAB_TargetLocationPanelName"));
        ResourceBundle resourceBundle = NbBundle.getBundle(TemplateWizard2.class);
        this.newObjectName.getDocument().addDocumentListener(this);
        this.newObjectName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.newObjectName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_NewObjectName"));
    }

    private void initLocationFolder() {
        PropertyDescriptor propertyDescriptor = null;
        try {
            Method method = this.getClass().getDeclaredMethod("getLocationFolder", new Class[0]);
            method.setAccessible(true);
            Method method2 = this.getClass().getDeclaredMethod("setLocationFolder", File.class);
            method2.setAccessible(true);
            propertyDescriptor = new PropertyDescriptor(PROP_LOCATION_FOLDER, method, method2);
            propertyDescriptor.setValue("directories", true);
            propertyDescriptor.setValue("files", false);
        }
        catch (IntrospectionException introspectionException) {
            Exceptions.printStackTrace((Throwable)introspectionException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        this.locationFolderModel = new DefaultPropertyModel((Object)this, propertyDescriptor);
    }

    private static String defaultNewObjectName() {
        return DataObject.getString("FMT_DefaultNewObjectName");
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.newObjectName = new JTextField();
        this.dataFolderPanel = this.dataFolderPanel = new PropertyPanel((PropertyModel)this.locationFolderModel, 2);
        FormListener formListener = new FormListener();
        this.setLayout(new BorderLayout());
        this.namePanel.setLayout(new BorderLayout(12, 0));
        this.jLabel1.setLabelFor(this.newObjectName);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/openide/loaders/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)resourceBundle.getString("CTL_NewObjectName"));
        this.namePanel.add((Component)this.jLabel1, "West");
        this.newObjectName.addFocusListener(formListener);
        this.namePanel.add((Component)this.newObjectName, "Center");
        this.add((Component)this.namePanel, "North");
        this.add((Component)this.dataFolderPanel, "Center");
    }

    private void newObjectNameFocusGained(FocusEvent focusEvent) {
        this.newObjectName.selectAll();
    }

    void addChangeListener(ChangeListener changeListener) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = changeListener;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.newObjectName.requestFocus();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(TemplateWizard2.class).getString("ACSD_TemplateWizard2"));
    }

    void implReadSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)((Object)object);
        DataObject dataObject = templateWizard.getTemplate();
        if (dataObject != null) {
            this.extension = dataObject.getPrimaryFile().getExt();
        }
        this.setNewObjectName(templateWizard.getTargetName());
        try {
            this.setLocationDataFolder(templateWizard.getTargetFolder());
        }
        catch (IOException iOException) {
            this.setLocationFolder(null);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listener = null;
    }

    void implStoreSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)((Object)object);
        templateWizard.setTargetFolder(this.getLocationDataFolder());
        String string = this.newObjectName.getText();
        if (string.equals(TemplateWizard2.defaultNewObjectName())) {
            string = null;
        }
        templateWizard.setTargetName(string);
    }

    String implIsValid() {
        DataFolder dataFolder = this.getLocationDataFolder();
        if (dataFolder == null) {
            return NbBundle.getMessage(TemplateWizard2.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        if (!dataFolder.getPrimaryFile().canWrite()) {
            return NbBundle.getMessage(TemplateWizard2.class, (String)"MSG_fs_is_readonly");
        }
        if (this.locationFolder.exists()) {
            return NbBundle.getMessage(TemplateWizard2.class, (String)"MSG_file_already_exist", (Object)this.locationFolder.getAbsolutePath());
        }
        if ((Utilities.isWindows() || Utilities.getOperatingSystem() == 2048) && TemplateWizard.checkCaseInsensitiveName(dataFolder.getPrimaryFile(), this.newObjectName.getText(), this.extension)) {
            return NbBundle.getMessage(TemplateWizard2.class, (String)"MSG_file_already_exist", (Object)this.newObjectName.getText());
        }
        return null;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.newObjectName.getDocument()) {
            SwingUtilities.invokeLater(new Updater());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.newObjectName.getDocument()) {
            SwingUtilities.invokeLater(new Updater());
        }
    }

    @Override
    public void requestFocus() {
        this.newObjectName.requestFocus();
        this.newObjectName.selectAll();
    }

    private void setNewObjectName(String string) {
        String string2 = string;
        if (string == null || string.length() == 0) {
            string2 = TemplateWizard2.defaultNewObjectName();
        }
        this.newObjectName.getDocument().removeDocumentListener(this);
        this.newObjectName.setText(string2);
        this.newObjectName.getDocument().addDocumentListener(this);
        if (string == null || string.length() == 0) {
            this.newObjectName.selectAll();
        }
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void setLocationFolder(File file) {
        if (this.locationFolder == file) {
            return;
        }
        if (this.locationFolder != null && this.locationFolder.equals(file)) {
            return;
        }
        File file2 = this.locationFolder;
        this.locationFolder = file;
        this.firePropertyChange(PROP_LOCATION_FOLDER, file2, this.locationFolder);
        this.fireStateChanged();
    }

    private void setLocationDataFolder(DataFolder dataFolder) {
        this.setLocationFolder(dataFolder != null ? FileUtil.toFile((FileObject)dataFolder.getPrimaryFile()) : null);
    }

    public File getLocationFolder() {
        return this.locationFolder;
    }

    private DataFolder getLocationDataFolder() {
        FileObject fileObject;
        if (this.locationFolder != null && (fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.locationFolder))) != null && fileObject.isFolder()) {
            return DataFolder.findFolder(fileObject);
        }
        return null;
    }

    private class Updater
    implements Runnable {
        Updater() {
        }

        @Override
        public void run() {
            if (TemplateWizard2.this.newObjectName.getText().equals("")) {
                TemplateWizard2.this.setNewObjectName("");
            }
            TemplateWizard2.this.fireStateChanged();
        }
    }

    private class FormListener
    implements FocusListener {
        FormListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == TemplateWizard2.this.newObjectName) {
                TemplateWizard2.this.newObjectNameFocusGained(focusEvent);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

