/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DefaultFontFamilyResolver;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.bridge.Mark;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.event.EventDispatcher;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.SVGFeatureStrings;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;

public class UserAgentAdapter
implements UserAgent {
    protected Set FEATURES = new HashSet();
    protected Set extensions = new HashSet();
    protected BridgeContext ctx;

    public void setBridgeContext(BridgeContext bridgeContext) {
        this.ctx = bridgeContext;
    }

    public void addStdFeatures() {
        SVGFeatureStrings.addSupportedFeatureStrings((Set)this.FEATURES);
    }

    @Override
    public Dimension2D getViewportSize() {
        return new Dimension(1, 1);
    }

    @Override
    public void displayMessage(String string) {
    }

    public void displayError(String string) {
        this.displayMessage(string);
    }

    @Override
    public void displayError(Exception exception) {
        this.displayError(exception.getMessage());
    }

    @Override
    public void showAlert(String string) {
    }

    @Override
    public String showPrompt(String string) {
        return null;
    }

    @Override
    public String showPrompt(String string, String string2) {
        return null;
    }

    @Override
    public boolean showConfirm(String string) {
        return false;
    }

    @Override
    public float getPixelUnitToMillimeter() {
        return 0.26458332f;
    }

    @Override
    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    @Override
    public String getDefaultFontFamily() {
        return "Arial, Helvetica, sans-serif";
    }

    @Override
    public float getMediumFontSize() {
        return 228.59999f / (72.0f * this.getPixelUnitToMillimeter());
    }

    @Override
    public float getLighterFontWeight(float f) {
        return UserAgentAdapter.getStandardLighterFontWeight(f);
    }

    @Override
    public float getBolderFontWeight(float f) {
        return UserAgentAdapter.getStandardBolderFontWeight(f);
    }

    @Override
    public String getLanguages() {
        return "en";
    }

    @Override
    public String getMedia() {
        return "all";
    }

    @Override
    public String getAlternateStyleSheet() {
        return null;
    }

    @Override
    public String getUserStyleSheetURI() {
        return null;
    }

    @Override
    public String getXMLParserClassName() {
        return XMLResourceDescriptor.getXMLParserClassName();
    }

    @Override
    public boolean isXMLParserValidating() {
        return false;
    }

    @Override
    public EventDispatcher getEventDispatcher() {
        return null;
    }

    @Override
    public void openLink(SVGAElement sVGAElement) {
    }

    @Override
    public void setSVGCursor(Cursor cursor) {
    }

    @Override
    public void setTextSelection(Mark mark, Mark mark2) {
    }

    @Override
    public void deselectAll() {
    }

    public void runThread(Thread thread) {
    }

    @Override
    public AffineTransform getTransform() {
        return null;
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
    }

    @Override
    public Point getClientAreaLocationOnScreen() {
        return new Point();
    }

    @Override
    public boolean hasFeature(String string) {
        return this.FEATURES.contains(string);
    }

    @Override
    public boolean supportExtension(String string) {
        return this.extensions.contains(string);
    }

    @Override
    public void registerExtension(BridgeExtension bridgeExtension) {
        Iterator iterator = bridgeExtension.getImplementedExtensions();
        while (iterator.hasNext()) {
            this.extensions.add(iterator.next());
        }
    }

    @Override
    public void handleElement(Element element, Object object) {
    }

    @Override
    public ScriptSecurity getScriptSecurity(String string, ParsedURL parsedURL, ParsedURL parsedURL2) {
        return new DefaultScriptSecurity(string, parsedURL, parsedURL2);
    }

    @Override
    public void checkLoadScript(String string, ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
        ScriptSecurity scriptSecurity = this.getScriptSecurity(string, parsedURL, parsedURL2);
        if (scriptSecurity != null) {
            scriptSecurity.checkLoadScript();
        }
    }

    @Override
    public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL parsedURL, ParsedURL parsedURL2) {
        return new RelaxedExternalResourceSecurity(parsedURL, parsedURL2);
    }

    @Override
    public void checkLoadExternalResource(ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
        ExternalResourceSecurity externalResourceSecurity = this.getExternalResourceSecurity(parsedURL, parsedURL2);
        if (externalResourceSecurity != null) {
            externalResourceSecurity.checkLoadExternalResource();
        }
    }

    public static float getStandardLighterFontWeight(float f) {
        int n = (int)((f + 50.0f) / 100.0f) * 100;
        switch (n) {
            case 100: {
                return 100.0f;
            }
            case 200: {
                return 100.0f;
            }
            case 300: {
                return 200.0f;
            }
            case 400: {
                return 300.0f;
            }
            case 500: {
                return 400.0f;
            }
            case 600: {
                return 400.0f;
            }
            case 700: {
                return 400.0f;
            }
            case 800: {
                return 400.0f;
            }
            case 900: {
                return 400.0f;
            }
        }
        throw new IllegalArgumentException("Bad Font Weight: " + f);
    }

    public static float getStandardBolderFontWeight(float f) {
        int n = (int)((f + 50.0f) / 100.0f) * 100;
        switch (n) {
            case 100: {
                return 600.0f;
            }
            case 200: {
                return 600.0f;
            }
            case 300: {
                return 600.0f;
            }
            case 400: {
                return 600.0f;
            }
            case 500: {
                return 600.0f;
            }
            case 600: {
                return 700.0f;
            }
            case 700: {
                return 800.0f;
            }
            case 800: {
                return 900.0f;
            }
            case 900: {
                return 900.0f;
            }
        }
        throw new IllegalArgumentException("Bad Font Weight: " + f);
    }

    @Override
    public SVGDocument getBrokenLinkDocument(Element element, String string, String string2) {
        throw new BridgeException(this.ctx, element, "uri.image.broken", new Object[]{string, string2});
    }

    @Override
    public void loadDocument(String string) {
    }

    @Override
    public FontFamilyResolver getFontFamilyResolver() {
        return DefaultFontFamilyResolver.SINGLETON;
    }
}

