/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmConstraints;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLParameters;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.JsseUtils_7;
import org.bouncycastle.jsse.provider.JsseUtils_8;
import org.bouncycastle.jsse.provider.ProvSSLParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class SSLParametersUtil {
    SSLParametersUtil() {
    }

    static BCSSLParameters getParameters(ProvSSLParameters provSSLParameters) {
        BCSSLParameters bCSSLParameters = new BCSSLParameters(provSSLParameters.getCipherSuites(), provSSLParameters.getProtocols());
        if (provSSLParameters.getNeedClientAuth()) {
            bCSSLParameters.setNeedClientAuth(true);
        } else if (provSSLParameters.getWantClientAuth()) {
            bCSSLParameters.setWantClientAuth(true);
        } else {
            bCSSLParameters.setWantClientAuth(false);
        }
        bCSSLParameters.setAlgorithmConstraints(provSSLParameters.getAlgorithmConstraints());
        bCSSLParameters.setEndpointIdentificationAlgorithm(provSSLParameters.getEndpointIdentificationAlgorithm());
        bCSSLParameters.setUseCipherSuitesOrder(provSSLParameters.getUseCipherSuitesOrder());
        bCSSLParameters.setServerNames(provSSLParameters.getServerNames());
        bCSSLParameters.setSNIMatchers(provSSLParameters.getSNIMatchers());
        bCSSLParameters.setApplicationProtocols(provSSLParameters.getApplicationProtocols());
        return bCSSLParameters;
    }

    static SSLParameters getSSLParameters(ProvSSLParameters provSSLParameters) {
        SSLParameters sSLParameters = new SSLParameters(provSSLParameters.getCipherSuites(), provSSLParameters.getProtocols());
        if (provSSLParameters.getNeedClientAuth()) {
            sSLParameters.setNeedClientAuth(true);
        } else if (provSSLParameters.getWantClientAuth()) {
            sSLParameters.setWantClientAuth(true);
        } else {
            sSLParameters.setWantClientAuth(false);
        }
        sSLParameters.setAlgorithmConstraints((AlgorithmConstraints)JsseUtils_7.exportAlgorithmConstraints(provSSLParameters.getAlgorithmConstraints()));
        sSLParameters.setEndpointIdentificationAlgorithm(provSSLParameters.getEndpointIdentificationAlgorithm());
        sSLParameters.setUseCipherSuitesOrder(provSSLParameters.getUseCipherSuitesOrder());
        Collection<Object> collection = provSSLParameters.getServerNames();
        if (null != collection) {
            sSLParameters.setServerNames((List)JsseUtils_8.exportSNIServerNames(collection));
        }
        if (null != (collection = provSSLParameters.getSNIMatchers())) {
            sSLParameters.setSNIMatchers((Collection)JsseUtils_8.exportSNIMatchers(collection));
        }
        sSLParameters.setApplicationProtocols(provSSLParameters.getApplicationProtocols());
        return sSLParameters;
    }

    static BCSSLParameters importSSLParameters(SSLParameters sSLParameters) {
        BCSSLParameters bCSSLParameters = new BCSSLParameters(sSLParameters.getCipherSuites(), sSLParameters.getProtocols());
        if (sSLParameters.getNeedClientAuth()) {
            bCSSLParameters.setNeedClientAuth(true);
        } else if (sSLParameters.getWantClientAuth()) {
            bCSSLParameters.setWantClientAuth(true);
        } else {
            bCSSLParameters.setWantClientAuth(false);
        }
        String[] stringArray = sSLParameters.getAlgorithmConstraints();
        if (null != stringArray) {
            bCSSLParameters.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraints(stringArray));
        }
        if (null != (stringArray = sSLParameters.getEndpointIdentificationAlgorithm())) {
            bCSSLParameters.setEndpointIdentificationAlgorithm((String)stringArray);
        }
        bCSSLParameters.setUseCipherSuitesOrder(sSLParameters.getUseCipherSuitesOrder());
        stringArray = sSLParameters.getServerNames();
        if (null != stringArray) {
            bCSSLParameters.setServerNames(JsseUtils_8.importSNIServerNames(stringArray));
        }
        if (null != (stringArray = sSLParameters.getSNIMatchers())) {
            bCSSLParameters.setSNIMatchers(JsseUtils_8.importSNIMatchers(stringArray));
        }
        if (null != (stringArray = sSLParameters.getApplicationProtocols())) {
            bCSSLParameters.setApplicationProtocols(stringArray);
        }
        return bCSSLParameters;
    }

    static void setParameters(ProvSSLParameters provSSLParameters, BCSSLParameters bCSSLParameters) {
        String[] stringArray;
        Collection<BCSNIMatcher> collection;
        String string;
        String[] stringArray2;
        String[] stringArray3 = bCSSLParameters.getCipherSuites();
        if (null != stringArray3) {
            provSSLParameters.setCipherSuites(stringArray3);
        }
        if (null != (stringArray2 = bCSSLParameters.getProtocols())) {
            provSSLParameters.setProtocols(stringArray2);
        }
        if (bCSSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else if (bCSSLParameters.getWantClientAuth()) {
            provSSLParameters.setWantClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(false);
        }
        BCAlgorithmConstraints bCAlgorithmConstraints = bCSSLParameters.getAlgorithmConstraints();
        if (null != bCAlgorithmConstraints) {
            provSSLParameters.setAlgorithmConstraints(bCAlgorithmConstraints);
        }
        if (null != (string = bCSSLParameters.getEndpointIdentificationAlgorithm())) {
            provSSLParameters.setEndpointIdentificationAlgorithm(string);
        }
        provSSLParameters.setUseCipherSuitesOrder(bCSSLParameters.getUseCipherSuitesOrder());
        List<BCSNIServerName> list = bCSSLParameters.getServerNames();
        if (null != list) {
            provSSLParameters.setServerNames(list);
        }
        if (null != (collection = bCSSLParameters.getSNIMatchers())) {
            provSSLParameters.setSNIMatchers(collection);
        }
        if (null != (stringArray = bCSSLParameters.getApplicationProtocols())) {
            provSSLParameters.setApplicationProtocols(stringArray);
        }
    }

    static void setSSLParameters(ProvSSLParameters provSSLParameters, SSLParameters sSLParameters) {
        String[] stringArray;
        String[] stringArray2 = sSLParameters.getCipherSuites();
        if (null != stringArray2) {
            provSSLParameters.setCipherSuites(stringArray2);
        }
        if (null != (stringArray = sSLParameters.getProtocols())) {
            provSSLParameters.setProtocols(stringArray);
        }
        if (sSLParameters.getNeedClientAuth()) {
            provSSLParameters.setNeedClientAuth(true);
        } else if (sSLParameters.getWantClientAuth()) {
            provSSLParameters.setWantClientAuth(true);
        } else {
            provSSLParameters.setWantClientAuth(false);
        }
        String[] stringArray3 = sSLParameters.getAlgorithmConstraints();
        if (null != stringArray3) {
            provSSLParameters.setAlgorithmConstraints(JsseUtils_7.importAlgorithmConstraints(stringArray3));
        }
        if (null != (stringArray3 = sSLParameters.getEndpointIdentificationAlgorithm())) {
            provSSLParameters.setEndpointIdentificationAlgorithm((String)stringArray3);
        }
        provSSLParameters.setUseCipherSuitesOrder(sSLParameters.getUseCipherSuitesOrder());
        stringArray3 = sSLParameters.getServerNames();
        if (null != stringArray3) {
            provSSLParameters.setServerNames(JsseUtils_8.importSNIServerNames(stringArray3));
        }
        if (null != (stringArray3 = sSLParameters.getSNIMatchers())) {
            provSSLParameters.setSNIMatchers(JsseUtils_8.importSNIMatchers(stringArray3));
        }
        if (null != (stringArray3 = sSLParameters.getApplicationProtocols())) {
            provSSLParameters.setApplicationProtocols(stringArray3);
        }
    }
}

