/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.impl.ECPrivateKeyWithName;

public class PKey {
    public static KeyPair readPrivateKey(byte[] input, String type) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeySpec privSpec;
        KeySpec pubSpec;
        ASN1Sequence seq = (ASN1Sequence)new ASN1InputStream(input).readObject();
        if (type.equals("RSA")) {
            ASN1Integer mod2 = (ASN1Integer)seq.getObjectAt(1);
            ASN1Integer pubExp = (ASN1Integer)seq.getObjectAt(2);
            ASN1Integer privExp = (ASN1Integer)seq.getObjectAt(3);
            ASN1Integer p1 = (ASN1Integer)seq.getObjectAt(4);
            ASN1Integer p2 = (ASN1Integer)seq.getObjectAt(5);
            ASN1Integer exp1 = (ASN1Integer)seq.getObjectAt(6);
            ASN1Integer exp2 = (ASN1Integer)seq.getObjectAt(7);
            ASN1Integer crtCoef = (ASN1Integer)seq.getObjectAt(8);
            pubSpec = new RSAPublicKeySpec(mod2.getValue(), pubExp.getValue());
            privSpec = new RSAPrivateCrtKeySpec(mod2.getValue(), pubExp.getValue(), privExp.getValue(), p1.getValue(), p2.getValue(), exp1.getValue(), exp2.getValue(), crtCoef.getValue());
        } else if (type.equals("DSA")) {
            ASN1Integer p = (ASN1Integer)seq.getObjectAt(1);
            ASN1Integer q = (ASN1Integer)seq.getObjectAt(2);
            ASN1Integer g = (ASN1Integer)seq.getObjectAt(3);
            ASN1Integer y = (ASN1Integer)seq.getObjectAt(4);
            ASN1Integer x = (ASN1Integer)seq.getObjectAt(5);
            privSpec = new DSAPrivateKeySpec(x.getValue(), p.getValue(), q.getValue(), g.getValue());
            pubSpec = new DSAPublicKeySpec(y.getValue(), p.getValue(), q.getValue(), g.getValue());
        } else {
            if (type.equals("ECDSA")) {
                return PKey.readECPrivateKey(input);
            }
            throw new IllegalStateException("unsupported type: " + type);
        }
        KeyFactory fact = SecurityHelper.getKeyFactory(type);
        return new KeyPair(fact.generatePublic(pubSpec), fact.generatePrivate(privSpec));
    }

    public static KeyPair readPrivateKey(byte[] input) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyPair key = null;
        try {
            key = PKey.readRSAPrivateKey(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        if (key == null) {
            try {
                key = PKey.readDSAPrivateKey(input);
            }
            catch (NoSuchAlgorithmException e) {
                throw e;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                // empty catch block
            }
        }
        return key;
    }

    public static PublicKey readPublicKey(byte[] input) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        PublicKey key = null;
        try {
            key = PKey.readRSAPublicKey(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (InvalidKeySpecException e) {
            // empty catch block
        }
        if (key == null) {
            try {
                key = PKey.readDSAPublicKey(input);
            }
            catch (NoSuchAlgorithmException e) {
                throw e;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                // empty catch block
            }
        }
        return key;
    }

    public static KeyPair readRSAPrivateKey(byte[] input) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        return PKey.readRSAPrivateKey(SecurityHelper.getKeyFactory("RSA"), input);
    }

    public static KeyPair readRSAPrivateKey(KeyFactory rsaFactory, byte[] input) throws IOException, InvalidKeySpecException {
        ASN1Sequence seq;
        ASN1Primitive obj = new ASN1InputStream(input).readObject();
        if (obj instanceof ASN1Sequence && (seq = (ASN1Sequence)obj).size() == 9) {
            BigInteger mod2 = ((ASN1Integer)seq.getObjectAt(1)).getValue();
            BigInteger pubexp = ((ASN1Integer)seq.getObjectAt(2)).getValue();
            BigInteger privexp = ((ASN1Integer)seq.getObjectAt(3)).getValue();
            BigInteger primep = ((ASN1Integer)seq.getObjectAt(4)).getValue();
            BigInteger primeq = ((ASN1Integer)seq.getObjectAt(5)).getValue();
            BigInteger primeep = ((ASN1Integer)seq.getObjectAt(6)).getValue();
            BigInteger primeeq = ((ASN1Integer)seq.getObjectAt(7)).getValue();
            BigInteger crtcoeff = ((ASN1Integer)seq.getObjectAt(8)).getValue();
            PrivateKey priv = rsaFactory.generatePrivate(new RSAPrivateCrtKeySpec(mod2, pubexp, privexp, primep, primeq, primeep, primeeq, crtcoeff));
            PublicKey pub = rsaFactory.generatePublic(new RSAPublicKeySpec(mod2, pubexp));
            return new KeyPair(pub, priv);
        }
        return null;
    }

    public static PublicKey readRSAPublicKey(byte[] input) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        return PKey.readRSAPublicKey(SecurityHelper.getKeyFactory("RSA"), input);
    }

    public static PublicKey readRSAPublicKey(KeyFactory rsaFactory, byte[] input) throws IOException, InvalidKeySpecException {
        ASN1Sequence seq;
        ASN1Primitive obj = new ASN1InputStream(input).readObject();
        if (obj instanceof ASN1Sequence && (seq = (ASN1Sequence)obj).size() == 2) {
            BigInteger mod2 = ((ASN1Integer)seq.getObjectAt(0)).getValue();
            BigInteger pubexp = ((ASN1Integer)seq.getObjectAt(1)).getValue();
            return rsaFactory.generatePublic(new RSAPublicKeySpec(mod2, pubexp));
        }
        return null;
    }

    public static KeyPair readDSAPrivateKey(byte[] input) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        return PKey.readDSAPrivateKey(SecurityHelper.getKeyFactory("DSA"), input);
    }

    public static KeyPair readDSAPrivateKey(KeyFactory dsaFactory, byte[] input) throws IOException, InvalidKeySpecException {
        ASN1Sequence seq;
        ASN1Primitive obj = new ASN1InputStream(input).readObject();
        if (obj instanceof ASN1Sequence && (seq = (ASN1Sequence)obj).size() == 6) {
            BigInteger p = ((ASN1Integer)seq.getObjectAt(1)).getValue();
            BigInteger q = ((ASN1Integer)seq.getObjectAt(2)).getValue();
            BigInteger g = ((ASN1Integer)seq.getObjectAt(3)).getValue();
            BigInteger y = ((ASN1Integer)seq.getObjectAt(4)).getValue();
            BigInteger x = ((ASN1Integer)seq.getObjectAt(5)).getValue();
            PrivateKey priv = dsaFactory.generatePrivate(new DSAPrivateKeySpec(x, p, q, g));
            PublicKey pub = dsaFactory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
            return new KeyPair(pub, priv);
        }
        return null;
    }

    public static PublicKey readDSAPublicKey(byte[] input) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        return PKey.readDSAPublicKey(SecurityHelper.getKeyFactory("DSA"), input);
    }

    public static PublicKey readDSAPublicKey(KeyFactory dsaFactory, byte[] input) throws IOException, InvalidKeySpecException {
        ASN1Primitive obj = new ASN1InputStream(input).readObject();
        if (obj instanceof ASN1Sequence) {
            ASN1Sequence seq = (ASN1Sequence)obj;
            if (seq.size() == 4) {
                BigInteger y = ((ASN1Integer)seq.getObjectAt(0)).getValue();
                BigInteger p = ((ASN1Integer)seq.getObjectAt(1)).getValue();
                BigInteger q = ((ASN1Integer)seq.getObjectAt(2)).getValue();
                BigInteger g = ((ASN1Integer)seq.getObjectAt(3)).getValue();
                return dsaFactory.generatePublic(new DSAPublicKeySpec(y, p, q, g));
            }
            if (seq.size() == 2 && seq.getObjectAt(1) instanceof DERBitString) {
                ASN1Integer y = (ASN1Integer)new ASN1InputStream(((DERBitString)seq.getObjectAt(1)).getBytes()).readObject();
                seq = (ASN1Sequence)((ASN1Sequence)seq.getObjectAt(0)).getObjectAt(1);
                BigInteger p = ((ASN1Integer)seq.getObjectAt(0)).getValue();
                BigInteger q = ((ASN1Integer)seq.getObjectAt(1)).getValue();
                BigInteger g = ((ASN1Integer)seq.getObjectAt(2)).getValue();
                return dsaFactory.generatePublic(new DSAPublicKeySpec(y.getPositiveValue(), p, q, g));
            }
        }
        return null;
    }

    public static DHParameterSpec readDHParameter(byte[] input) throws IOException {
        ASN1InputStream aIn = new ASN1InputStream(input);
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        BigInteger p = ((ASN1Integer)seq.getObjectAt(0)).getValue();
        BigInteger g = ((ASN1Integer)seq.getObjectAt(1)).getValue();
        return new DHParameterSpec(p, g);
    }

    public static KeyPair readECPrivateKey(byte[] input) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        return PKey.readECPrivateKey(SecurityHelper.getKeyFactory("ECDSA"), input);
    }

    public static KeyPair readECPrivateKey(KeyFactory ecFactory, byte[] input) throws IOException, InvalidKeySpecException {
        try {
            ECPrivateKeyStructure pKey = new ECPrivateKeyStructure((ASN1Sequence)ASN1Primitive.fromByteArray((byte[])input));
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)pKey.getParameters());
            PrivateKeyInfo privInfo = new PrivateKeyInfo(algId, (ASN1Encodable)pKey.toASN1Primitive());
            SubjectPublicKeyInfo pubInfo = new SubjectPublicKeyInfo(algId, pKey.getPublicKey().getBytes());
            PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privInfo.getEncoded());
            X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(pubInfo.getEncoded());
            ECPrivateKey privateKey = (ECPrivateKey)ecFactory.generatePrivate(privSpec);
            if (algId.getParameters() instanceof ASN1ObjectIdentifier) {
                privateKey = ECPrivateKeyWithName.wrap(privateKey, (ASN1ObjectIdentifier)algId.getParameters());
            }
            return new KeyPair(ecFactory.generatePublic(pubSpec), privateKey);
        }
        catch (ClassCastException ex) {
            throw new IOException("wrong ASN.1 object found in stream", ex);
        }
    }

    public static byte[] toDerRSAKey(RSAPublicKey pubKey, RSAPrivateCrtKey privKey) throws IOException {
        if (pubKey != null && privKey == null) {
            return KeyUtil.getEncodedSubjectPublicKeyInfo((AlgorithmIdentifier)new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, (ASN1Encodable)DERNull.INSTANCE), (ASN1Encodable)PKey.toASN1Primitive(pubKey));
        }
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1Integer(BigInteger.ZERO));
        vec.add((ASN1Encodable)new ASN1Integer(privKey.getModulus()));
        vec.add((ASN1Encodable)new ASN1Integer(privKey.getPublicExponent()));
        vec.add((ASN1Encodable)new ASN1Integer(privKey.getPrivateExponent()));
        vec.add((ASN1Encodable)new ASN1Integer(privKey.getPrimeP()));
        vec.add((ASN1Encodable)new ASN1Integer(privKey.getPrimeQ()));
        vec.add((ASN1Encodable)new ASN1Integer(privKey.getPrimeExponentP()));
        vec.add((ASN1Encodable)new ASN1Integer(privKey.getPrimeExponentQ()));
        vec.add((ASN1Encodable)new ASN1Integer(privKey.getCrtCoefficient()));
        return new DERSequence(vec).toASN1Primitive().getEncoded("DER");
    }

    public static ASN1Sequence toASN1Primitive(RSAPublicKey pubKey) {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add((ASN1Encodable)new ASN1Integer(pubKey.getModulus()));
        vec.add((ASN1Encodable)new ASN1Integer(pubKey.getPublicExponent()));
        return new DERSequence(vec);
    }

    public static byte[] toDerDSAKey(DSAPublicKey pubKey, DSAPrivateKey privKey) throws IOException {
        if (pubKey != null && privKey == null) {
            DSAParams params2 = pubKey.getParams();
            if (params2 == null) {
                return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa), (ASN1Encodable)PKey.toASN1Primitive(pubKey)).getEncoded("DER");
            }
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)new DSAParameter(params2.getP(), params2.getQ(), params2.getG())), (ASN1Encodable)PKey.toASN1Primitive(pubKey)).getEncoded("DER");
        }
        if (privKey != null && pubKey != null) {
            ASN1EncodableVector vec = new ASN1EncodableVector();
            DSAParams params3 = privKey.getParams();
            vec.add((ASN1Encodable)new ASN1Integer(BigInteger.ZERO));
            vec.add((ASN1Encodable)new ASN1Integer(params3.getP()));
            vec.add((ASN1Encodable)new ASN1Integer(params3.getQ()));
            vec.add((ASN1Encodable)new ASN1Integer(params3.getG()));
            vec.add((ASN1Encodable)new ASN1Integer(pubKey.getY()));
            vec.add((ASN1Encodable)new ASN1Integer(privKey.getX()));
            return new DERSequence(vec).toASN1Primitive().getEncoded("DER");
        }
        if (privKey == null) {
            throw new IllegalArgumentException("private key as well as public key are null");
        }
        DSAParams params4 = privKey.getParams();
        return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, (ASN1Encodable)new DSAParameter(params4.getP(), params4.getQ(), params4.getG())), (ASN1Encodable)new ASN1Integer(privKey.getX())).getEncoded("DER");
    }

    public static ASN1Primitive toASN1Primitive(DSAPublicKey pubKey) {
        return new ASN1Integer(pubKey.getY());
    }

    public static byte[] toDerDHKey(BigInteger p, BigInteger g) throws IOException {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        if (p != null) {
            vec.add((ASN1Encodable)new ASN1Integer(p));
        }
        if (g != null) {
            vec.add((ASN1Encodable)new ASN1Integer(g));
        }
        return new DLSequence(vec).getEncoded();
    }
}

