/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.poi;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.CollatorStringMatcher;
import net.osmand.Location;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.Amenity;
import net.osmand.data.LatLon;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiFilter;
import net.osmand.osm.PoiType;
import net.osmand.plus.OsmAndFormatter;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.osmand.util.OpeningHoursParser;
import net.sourceforge.offroad.OsmWindow;

public class PoiUIFilter
implements BinaryMapIndexReader.SearchPoiTypeFilter {
    public static final String STD_PREFIX = "std_";
    public static final String USER_PREFIX = "user_";
    public static final String CUSTOM_FILTER_ID = "user_custom_id";
    public static final String BY_NAME_FILTER_ID = "user_by_name";
    private Map<PoiCategory, LinkedHashSet<String>> acceptedTypes = new LinkedHashMap<PoiCategory, LinkedHashSet<String>>();
    private Map<String, PoiType> poiAdditionals = new HashMap<String, PoiType>();
    protected String filterId;
    protected String standardIconId = "";
    protected String name;
    protected boolean isStandardFilter;
    protected final OsmWindow app;
    protected int distanceInd = 1;
    protected double[] distanceToSearchValues = new double[]{1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0};
    private final MapPoiTypes poiTypes;
    protected String filterByName = null;
    protected String savedFilterByName = null;
    protected List<Amenity> currentSearchResult = null;

    public PoiUIFilter(AbstractPoiType type, OsmWindow application, String idSuffix) {
        this.app = application;
        this.isStandardFilter = true;
        this.standardIconId = type == null ? null : type.getKeyName();
        this.filterId = STD_PREFIX + this.standardIconId + idSuffix;
        this.poiTypes = application.getPoiTypes();
        String string2 = this.name = type == null ? application.getString(548) : type.getTranslation() + idSuffix;
        if (type == null) {
            this.initSearchAll();
            this.updatePoiAdditionals();
        } else {
            if (type.isAdditional()) {
                this.setSavedFilterByName(type.getKeyName().replace('_', ':'));
            }
            this.updateTypesToAccept(type);
        }
    }

    protected PoiUIFilter(OsmWindow application) {
        this.app = application;
        this.isStandardFilter = true;
        this.filterId = STD_PREFIX;
        this.poiTypes = application.getPoiTypes();
    }

    public PoiUIFilter(String name, String filterId, Map<PoiCategory, LinkedHashSet<String>> acceptedTypes, OsmWindow app) {
        this.app = app;
        this.isStandardFilter = false;
        this.poiTypes = app.getPoiTypes();
        if (filterId == null) {
            filterId = USER_PREFIX + name.replace(' ', '_').toLowerCase();
        }
        this.filterId = filterId;
        this.name = name;
        if (acceptedTypes == null) {
            this.initSearchAll();
        } else {
            this.acceptedTypes.putAll(acceptedTypes);
        }
        this.updatePoiAdditionals();
    }

    public String getFilterByName() {
        return this.filterByName;
    }

    public void setFilterByName(String filterByName) {
        this.filterByName = filterByName;
        this.updateFilterResults();
    }

    public void updateFilterResults() {
        List<Amenity> prev = this.currentSearchResult;
        if (prev != null) {
            AmenityNameFilter nameFilter = this.getNameFilter(this.filterByName);
            ArrayList<Amenity> newResults = new ArrayList<Amenity>();
            for (Amenity a : prev) {
                if (!nameFilter.accept(a)) continue;
                newResults.add(a);
            }
            this.currentSearchResult = newResults;
        }
    }

    public void setSavedFilterByName(String filterByName) {
        this.filterByName = filterByName;
        this.savedFilterByName = filterByName;
    }

    public String getSavedFilterByName() {
        return this.savedFilterByName;
    }

    public List<Amenity> getCurrentSearchResult() {
        return this.currentSearchResult;
    }

    public List<Amenity> searchAgain(double lat, double lon) {
        List<Amenity> amenityList = this.currentSearchResult != null ? this.currentSearchResult : this.searchAmenities(lat, lon, null);
        MapUtils.sortListOfMapObject(amenityList, lat, lon);
        return amenityList;
    }

    public List<Amenity> searchFurther(double latitude, double longitude, ResultMatcher<Amenity> matcher) {
        if (this.distanceInd < this.distanceToSearchValues.length - 1) {
            ++this.distanceInd;
        }
        List<Amenity> amenityList = this.searchAmenities(latitude, longitude, matcher);
        MapUtils.sortListOfMapObject(amenityList, latitude, longitude);
        return amenityList;
    }

    private void initSearchAll() {
        for (PoiCategory t : this.poiTypes.getCategories(false)) {
            this.acceptedTypes.put(t, null);
        }
        this.distanceToSearchValues = new double[]{0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0};
    }

    public boolean isSearchFurtherAvailable() {
        return this.distanceInd < this.distanceToSearchValues.length - 1;
    }

    public String getSearchArea() {
        double val = this.distanceToSearchValues[this.distanceInd];
        if (val >= 1.0) {
            return " < " + OsmAndFormatter.getFormattedDistance((int)val * 1000, this.app);
        }
        return " < " + OsmAndFormatter.getFormattedDistance(500.0f, this.app);
    }

    public void clearPreviousZoom() {
        this.distanceInd = 0;
    }

    public List<Amenity> initializeNewSearch(double lat, double lon, int firstTimeLimit, ResultMatcher<Amenity> matcher) {
        this.clearPreviousZoom();
        List<Amenity> amenityList = this.searchAmenities(lat, lon, matcher);
        MapUtils.sortListOfMapObject(amenityList, lat, lon);
        if (firstTimeLimit > 0) {
            while (amenityList.size() > firstTimeLimit) {
                amenityList.remove(amenityList.size() - 1);
            }
        }
        if (amenityList.size() == 0 && this.isAutomaticallyIncreaseSearch()) {
            int step = 5;
            while (amenityList.size() == 0 && step-- > 0 && this.isSearchFurtherAvailable()) {
                amenityList = this.searchFurther(lat, lon, matcher);
            }
        }
        return amenityList;
    }

    public boolean isAutomaticallyIncreaseSearch() {
        return true;
    }

    private List<Amenity> searchAmenities(double lat, double lon, ResultMatcher<Amenity> matcher) {
        double baseDistY = MapUtils.getDistance(lat, lon, lat - 1.0, lon);
        double baseDistX = MapUtils.getDistance(lat, lon, lat, lon - 1.0);
        double distance = this.distanceToSearchValues[this.distanceInd] * 1000.0;
        double topLatitude = Math.min(lat + distance / baseDistY, 84.0);
        double bottomLatitude = Math.max(lat - distance / baseDistY, -84.0);
        double leftLongitude = Math.max(lon - distance / baseDistX, -180.0);
        double rightLongitude = Math.min(lon + distance / baseDistX, 180.0);
        return this.searchAmenitiesInternal(lat, lon, topLatitude, bottomLatitude, leftLongitude, rightLongitude, matcher);
    }

    public List<Amenity> searchAmenities(double top, double left, double bottom, double right, int zoom, ResultMatcher<Amenity> matcher) {
        ArrayList<Amenity> results = new ArrayList<Amenity>();
        List<Amenity> tempResults = this.currentSearchResult;
        if (tempResults != null) {
            for (Amenity a : tempResults) {
                LatLon l = a.getLocation();
                if (l == null || !(l.getLatitude() <= top) || !(l.getLatitude() >= bottom) || !(l.getLongitude() >= left) || !(l.getLongitude() <= right) || matcher != null && !matcher.publish(a)) continue;
                results.add(a);
            }
        }
        List<Amenity> amenities = this.app.getResourceManager().searchAmenities(this, top, left, bottom, right, zoom, this.wrapResultMatcher(matcher));
        results.addAll(amenities);
        return results;
    }

    public List<Amenity> searchAmenitiesOnThePath(List<Location> locs, int poiSearchDeviationRadius) {
        return this.app.getResourceManager().searchAmenitiesOnThePath(locs, poiSearchDeviationRadius, this, this.wrapResultMatcher(null));
    }

    protected List<Amenity> searchAmenitiesInternal(double lat, double lon, double topLatitude, double bottomLatitude, double leftLongitude, double rightLongitude, ResultMatcher<Amenity> matcher) {
        return this.app.getResourceManager().searchAmenities(this, topLatitude, leftLongitude, bottomLatitude, rightLongitude, -1, this.wrapResultMatcher(matcher));
    }

    public AmenityNameFilter getNameFilter(String filter) {
        if (Algorithms.isEmpty(filter)) {
            return new AmenityNameFilter(){

                @Override
                public boolean accept(Amenity a) {
                    return true;
                }
            };
        }
        StringBuilder nmFilter = new StringBuilder();
        String[] items = filter.split(" ");
        boolean allTime = false;
        boolean open = false;
        LinkedHashMap<PoiType, Object> poiAdditionalsFilter = null;
        for (String s : items) {
            if (Algorithms.isEmpty(s = s.trim())) continue;
            if (this.getNameToken24H().equalsIgnoreCase(s)) {
                allTime = true;
                continue;
            }
            if (this.getNameTokenOpen().equalsIgnoreCase(s)) {
                open = true;
                continue;
            }
            if (this.poiAdditionals.containsKey(s.toLowerCase())) {
                if (poiAdditionalsFilter == null) {
                    poiAdditionalsFilter = new LinkedHashMap<PoiType, Object>();
                }
                poiAdditionalsFilter.put(this.poiAdditionals.get(s.toLowerCase()), null);
                continue;
            }
            nmFilter.append(s).append(" ");
        }
        return this.getNameFilterInternal(nmFilter, allTime, open, poiAdditionalsFilter);
    }

    private AmenityNameFilter getNameFilterInternal(StringBuilder nmFilter, final boolean allTime, final boolean open, final Map<PoiType, String> poiAdditionals) {
        final CollatorStringMatcher sm = nmFilter.length() > 0 ? new CollatorStringMatcher(nmFilter.toString().trim(), CollatorStringMatcher.StringMatcherMode.CHECK_CONTAINS) : null;
        return new AmenityNameFilter(){

            @Override
            public boolean accept(Amenity a) {
                String lower;
                if (sm != null && !sm.matches(lower = OsmAndFormatter.getPoiStringWithoutType(a, PoiUIFilter.this.app.getSettings().MAP_PREFERRED_LOCALE.get()))) {
                    return false;
                }
                if (poiAdditionals != null) {
                    for (Map.Entry e : poiAdditionals.entrySet()) {
                        String inf = a.getAdditionalInfo(((PoiType)e.getKey()).getKeyName());
                        if (inf == null) {
                            return false;
                        }
                        if (e.getValue() == null || ((String)e.getValue()).equalsIgnoreCase(inf)) continue;
                        return false;
                    }
                }
                if (allTime && !"24/7".equalsIgnoreCase(a.getOpeningHours())) {
                    return false;
                }
                if (open) {
                    OpeningHoursParser.OpeningHours rs = OpeningHoursParser.parseOpenedHours(a.getOpeningHours());
                    if (rs != null) {
                        Calendar inst = Calendar.getInstance();
                        inst.setTimeInMillis(System.currentTimeMillis());
                        boolean work = rs.isOpenedForTime(inst);
                        if (!work) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public String getNameToken24H() {
        return "24/7";
    }

    public String getNameTokenOpen() {
        return this.app.getString(1682);
    }

    private ResultMatcher<Amenity> wrapResultMatcher(final ResultMatcher<Amenity> matcher) {
        final AmenityNameFilter nm = this.getNameFilter(this.filterByName);
        return new ResultMatcher<Amenity>(){

            @Override
            public boolean publish(Amenity a) {
                return nm.accept(a) && (matcher == null || matcher.publish(a));
            }

            @Override
            public boolean isCancelled() {
                return matcher != null && matcher.isCancelled();
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public String getGeneratedName(int chars) {
        LinkedHashSet<String> set;
        if (!this.filterId.equals(CUSTOM_FILTER_ID) || this.areAllTypesAccepted() || this.acceptedTypes.isEmpty()) {
            return this.getName();
        }
        StringBuilder res = new StringBuilder();
        for (PoiCategory p : this.acceptedTypes.keySet()) {
            set = this.acceptedTypes.get(p);
            if (set == null) {
                if (res.length() > 0) {
                    res.append(", ");
                }
                res.append(p.getTranslation());
            }
            if (res.length() <= chars) continue;
            return res.toString();
        }
        for (PoiCategory p : this.acceptedTypes.keySet()) {
            set = this.acceptedTypes.get(p);
            if (set == null) continue;
            for (String st : set) {
                PoiType pt;
                if (res.length() > 0) {
                    res.append(", ");
                }
                if ((pt = this.poiTypes.getPoiTypeByKey(st)) == null) continue;
                res.append(pt.getTranslation());
                if (res.length() <= chars) continue;
                return res.toString();
            }
        }
        return res.toString();
    }

    public Set<String> getAcceptedSubtypes(PoiCategory type) {
        if (!this.acceptedTypes.containsKey(type)) {
            return Collections.emptySet();
        }
        return this.acceptedTypes.get(type);
    }

    public boolean isTypeAccepted(PoiCategory t) {
        return this.acceptedTypes.containsKey(t);
    }

    public void clearFilter() {
        this.acceptedTypes = new LinkedHashMap<PoiCategory, LinkedHashSet<String>>();
        this.poiAdditionals.clear();
    }

    public boolean areAllTypesAccepted() {
        if (this.poiTypes.getCategories(false).size() == this.acceptedTypes.size()) {
            for (PoiCategory a : this.acceptedTypes.keySet()) {
                if (this.acceptedTypes.get(a) == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void updateTypesToAccept(AbstractPoiType pt) {
        pt.putTypes(this.acceptedTypes);
        if (pt instanceof PoiType && ((PoiType)pt).isAdditional() && ((PoiType)pt).getParentType() != null) {
            this.fillPoiAdditionals(((PoiType)pt).getParentType());
        } else {
            this.fillPoiAdditionals(pt);
        }
    }

    private void fillPoiAdditionals(AbstractPoiType pt) {
        for (PoiType add : pt.getPoiAdditionals()) {
            this.poiAdditionals.put(add.getKeyName().replace('_', ':').replace(' ', ':'), add);
            this.poiAdditionals.put(add.getTranslation().replace(' ', ':').toLowerCase(), add);
        }
        if (pt instanceof PoiFilter && !(pt instanceof PoiCategory)) {
            for (PoiType ps : ((PoiFilter)pt).getPoiTypes()) {
                this.fillPoiAdditionals(ps);
            }
        }
    }

    private void updatePoiAdditionals() {
        Iterator<Map.Entry<PoiCategory, LinkedHashSet<String>>> e = this.acceptedTypes.entrySet().iterator();
        this.poiAdditionals.clear();
        while (e.hasNext()) {
            Map.Entry<PoiCategory, LinkedHashSet<String>> pc = e.next();
            this.fillPoiAdditionals(pc.getKey());
            if (pc.getValue() == null) continue;
            for (String s : pc.getValue()) {
                PoiType subtype = this.poiTypes.getPoiTypeByKey(s);
                if (subtype == null) continue;
                this.fillPoiAdditionals(subtype);
            }
        }
    }

    public void replaceWithPoiFilter(PoiUIFilter f) {
        this.acceptedTypes.clear();
        this.acceptedTypes.putAll(f.acceptedTypes);
        this.poiAdditionals.clear();
        this.poiAdditionals.putAll(f.poiAdditionals);
    }

    public Map<PoiCategory, LinkedHashSet<String>> getAcceptedTypes() {
        return new LinkedHashMap<PoiCategory, LinkedHashSet<String>>(this.acceptedTypes);
    }

    public void selectSubTypesToAccept(PoiCategory t, LinkedHashSet<String> accept) {
        this.acceptedTypes.put(t, accept);
        this.fillPoiAdditionals(t);
    }

    public void setTypeToAccept(PoiCategory poiCategory, boolean b) {
        if (b) {
            this.acceptedTypes.put(poiCategory, null);
        } else {
            this.acceptedTypes.remove(poiCategory);
        }
        this.updatePoiAdditionals();
    }

    public String getFilterId() {
        return this.filterId;
    }

    public Map<String, PoiType> getPoiAdditionals() {
        return this.poiAdditionals;
    }

    public String getIconId() {
        if (this.filterId.startsWith(STD_PREFIX)) {
            return this.standardIconId;
        }
        if (this.filterId.startsWith(USER_PREFIX)) {
            return this.filterId.substring(USER_PREFIX.length()).toLowerCase();
        }
        return this.filterId;
    }

    public boolean isStandardFilter() {
        return this.isStandardFilter;
    }

    public void setStandardFilter(boolean isStandardFilter) {
        this.isStandardFilter = isStandardFilter;
    }

    public OsmWindow getApplication() {
        return this.app;
    }

    @Override
    public boolean accept(PoiCategory type, String subtype) {
        if (type == null) {
            return true;
        }
        if (!this.poiTypes.isRegisteredType(type)) {
            type = this.poiTypes.getOtherPoiCategory();
        }
        if (!this.acceptedTypes.containsKey(type)) {
            return false;
        }
        LinkedHashSet<String> set = this.acceptedTypes.get(type);
        if (set == null) {
            return true;
        }
        return set.contains(subtype);
    }

    @Override
    public boolean isEmpty() {
        return this.acceptedTypes.isEmpty();
    }

    public static interface AmenityNameFilter {
        public boolean accept(Amenity var1);
    }
}

