# ModClean History

## 3.0.0-beta.1 (5/21/2018)
First beta release of ModClean 3.0.0.

* **IMPROVEMENT:** Remove "ignore" patterns from that matching patterns array to prevent race condition in node-glob (#19).
* **NEW:** Added ability to send in no pattern definitions. This will allow custom patterns to be quickly used (without a definition module) by using `options.additionalPatterns`.
* Make `additionalPatterns` option `null` by default to match other options.
* Refactored how file objects are generated by moving functionality to its own function.
* Misc. cleanup and refactoring.

## 3.0.0-alpha.6 (5/18/2018)
* **FIX:** Fixed old variable reference in CLI (#24)

## 3.0.0-alpha.5 (5/17/2018)
* **IMPROVEMENT:** Better checking whether a directory is a module by ensuring the parent directory is equal to `options.modulesDir`.

## 3.0.0-alpha.4 (5/17/2018)
* **FIX:** Fix typo that caused all directories to be marked as a module.

## 3.0.0-alpha.3 (5/16/2018)
* **NEW:** Added `modclean.version` and `ModClean.version`.

## 3.0.0-alpha.2 (5/16/2018)
* **NEW:** Added `isDirectory` as a property of file objects.

## 3.0.0-alpha.1 (5/10/2018)
* Updated dependencies:
    - `chalk` @ 2.4.1
    - `empty-dir` @ 1.0.0
    - `glob` @ 7.1.2
    - `subdirs` @ 1.0.1
* Removed dependencies:
    - `async-each-series`
    - `clui`
    - `modclean-patterns-default`
    - `update-notifier`
* Added dependencies:
    - `await-handler`
    - `ora`
    - `progress`
    
#### ModClean API Changes
* **BREAKING:** Switch from callbacks to promises.
* **BREAKING:** Utilizes async/await which will require Node 8+.
* **BREAKING:** ModClean constructor no longer calls `clean()` by default, it must be manually called.
* **BREAKING:** Stored errors in `errors` is now the pure `Error` with additional properties attached.
* **BREAKING:** Renamed and namespaced most emitted events for clarity:
    - `start` is now `clean:start`
    - `complete` is now `clean:complete`
    - `deleted` is now `file:deleted`
    - `process` is now `file:list`
    - `finish` is now `process:done`
    - `beforeFind` is now `file:find`
    - `beforeEmptyDirs` is now `emptydir:start`
    - `afterEmptyDirs` is now `emptydir:done`
    - `emptyDirs` is now `emptydir:list`
    - `deletedEmptyDir` is now `emptydir:deleted`
* **BREAKING:** Removed `finish` event.
* **BREAKING:** Empty directory errors no longer emit event `emptyDirError`, but emit standard `error` event instead.
* **BREAKING:** File deletion errors no longer emit event `fileError`, but emit standard `error` event instead.
* **BREAKING:** `cleanEmptyDirs()` results are now an object containing `empty` (array of all empty directories) and `deleted` (array of all removed directories).
* **BREAKING:** Files are now objects instead of strings. The new file objects contain more information about a file/directory being removed. _This does not apply to empty directories._
* **BREAKING:** Removed `process` option in favor for new `filter` option.
* **NEW:** Added `globOptions` to options object.
* **NEW:** Added `filter` function to options object.
* **NEW:** Added `skipModules` to options object. Will skip deletion of a directory if determined it is a module.
* **NEW:** Added `file:skipped` event when a file/directory is skipped due to `filter` result.
* **NEW:** Added `process:start` event when file processing starts.
* **PERFORMANCE:** Reduced old and outdated dependencies to bring ModCleans dependency weight from over 9MB down to 1.2MB.
* **PERFORMANCE:** Files are now deleted in parallel instead of series.

#### ModClean CLI Changes
* **BREAKING:** Removed `-i, --interactive` option. This option provided no real gain and added overhead which slows down the entire process. You should run in test mode if you want to see the files/folders being deleted prior.
* **NEW:** Added `-l, --log` option. Outputs log files for deleted and skipped files along with errors in the current working directory on completion.

## 2.1.2 (11/6/2017)
* Update package.json to use latest version of `modclean-patterns-default`

## 2.1.1 (11/6/2017)
* **New!** Added options to ignore symlinked modules (@ben8p) #15
    - Added `followSymlink` configuration option.
    - Added `-f`, `--follow-symlink` CLI option.
* Added `.eslintrc.yml` file to help enforce rules.
* Minor cleanup

## 2.1.0 (1/17/2017)
* Added `emptyDirFilter` configuration option.
* Use `Object.assign` instead of `extend` module.
    - Removed `extend` dependency.
* Removed unused `pad` dependency.
* Removed duplicate call to `clean()` in shortcut method.
* Misc. cleanup
* **Breaking Change:** All error events (`error`, `fileError` and `emptyDirsError`) now return error object.
* **New!** Added `errors` property on the ModClean class which contains all errors that occurred.
* Moved documentation to the Wiki.

## 2.0.0 (1/11/2017)
### ModClean API Changes
* Complete rewrite using ES6 and some breaking changes (now requires Node v6.9+)
* No longer includes `patterns.json` file, instead uses plugins to allow further customization.
* **Breaking Change:** `patterns` option now takes array of pattern plugins instead of patterns. See README for more information.
* **Breaking Change:** `ignore` option has been renamed to `ignorePatterns`.
* **Breaking Change:** `process` option now is sync with only 1 argument and async with 2.
* **New!** Added `additionalPatterns` option that takes array of glob patterns to use with any provided pattern plugins.
* **New!** Added `dotFiles` option that allows disabling of removing dot files.
* **New!** Added `process` event which will be fired before the files start processing.
* **New!** When finding empty directories, it will now ignore `.DS_Store` and `Thumbs.db` files.
* **New!** Added `beforeFind` event.
* **New!** Added `beforeEmptyDirs` event.
* **New!** Added `emptyDirs` event.
* **New!** Added `emptyDirError` event.
* **New!** Added `afterEmptyDirs` event.
* **New!** Added `deletedEmptyDir` event.
* Removed utility functions in favor for micro-packages.
    * Removed unused dependencies.
    * Replaced `node-dir` dependency with `subdirs`.
    * Replaced `colors` dependency with `chalk`.
    * Added `empty-dir` dependency.
    * Added `async-each-series` dependency.
    * Added `extend` dependency.
    * Added `lodash.uniq` dependency.
* Updated all dependcies to their latest versions.
* Benchmarks updated for 2017.

### ModClean CLI Changes
* Rewrite using ES6 with new features and bug fixes.
* **Breaking Change:** `-n, --patterns` option now takes list of plugins instead of a pattern rule name.
* **Removed:** `-d, --empty` option.
* **New!** Added `-D, --modules-dir` option.
* **New!** Added `-a, --additional-patterns` option.
* **New!** Added `-k, --keep-empty` option.
* **New!** Added `--no-dotfiles` option.
* Removed `inquirer` dependency in favor of `clui` and utility functions.
* Reduced memory usage of the CLI.
* Logging has been rewritten to handle stack overflow errors.
* Updated some text.

_If you still need to support Node < v6.9, use ModClean 1.3.0 instead. For more information about these changes, refer to the README._

## 1.3.0 (1/6/2017)
* Added `noDirs` option to exclude directories from being removed (#8)
    - Added `--no-dirs` option to CLI (#8)
* Added `ignore` option to exclude array of glob patterns from being removed (#8)
    - Added `-I, --ignore` option to CLI to pass in comma-separated list of glob patterns (#8)
* Changed the `*.map` safe pattern to `*.js.map` (#10)
* Moved `*.map` to danger patterns (#10)
* Skip inital logging if not verbose to prevent stack overflow (#9)

## 1.2.6 (3/4/2016)
* Added additional patterns #6 (@KenRmk)
* Added Node 4.0 and 4.1 to `.travis.yml`
* Updated dependencies:
    * glob@7.0.0
    * inquirer@0.12.0
    * update-notifier@0.6.1

## 1.2.5 (8/26/2015)
* Fix a deprecated function in inquirer that was missed during testing (#5)

## 1.2.4 (8/26/2015)
* Added ability to disable progress bar in CLI (#5)
* Updated dependencies:
    * inquirer@0.9.0
    * update-notifier@0.5.0
    * colors@1.1.2
    * commander@2.8.1
    * glob@5.0.14
    * node-dir@0.1.9
    * rimraf@2.4.2
* Updated dev dependencies:
    * should@7.0.4
    * mocha@2.2.5

## 1.2.3 (6/30/2015)
* Removed `.bin` pattern from safe patterns (#4)

## 1.2.2 (5/28/2015)
* Adjusted `history*` pattern (#3)

## 1.2.1 (4/29/2015)
* Removed lingering `console.log`.

## 1.2.0 (4/28/2015)
* Added several new patterns to `patterns.json`.
* Added ability to delete empty directories.
    * Added `ModClean()._removeEmpty()`.
    * Added `removeEmptyDirs` option.
    * Added `-d, --empty` flags to the CLI to toggle `removeEmptyDirs` on.
* Added `node-dir` dependency.
* Added `BENCHMARK.md` file to store a list of benchmarks.
* Updated `.travis.yml` to include io.js
* Updated and fixed `README.md`.
* Updated tests.

## 1.1.2 (4/25/2015)
* Fixed line endings for OS X and Linux systems

## 1.1.0 (4/24/2015)
* Exposes `modclean.patterns` object.
* Changed `patterns.json` to be an object with 3 different levels of file matching.
* Changed `options.patterns` to default to `modclean.patterns.safe`.
* `options.patterns` can now be an Array of Arrays that will be flattened.
* Added additional safe patterns to `patterns.json`.
* modclean CLI now takes option `-n, --patterns [patterns]`.
* Updated tests and README.

## 1.0.0 (4/23/2015)
* Initial release
