/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.ws.yahoo.search.imagesearch;

import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jdesktop.swingx.ws.yahoo.search.ResultsArrayList;
import org.jdesktop.swingx.ws.yahoo.search.ResultsList;
import org.jdesktop.swingx.ws.yahoo.search.Type;
import org.jdesktop.swingx.ws.yahoo.search.YahooSearch;
import org.jdesktop.swingx.ws.yahoo.search.imagesearch.Coloration;
import org.jdesktop.swingx.ws.yahoo.search.imagesearch.FileFormat;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class YahooImageSearch
extends YahooSearch {
    private String appId;
    private String query;
    private Type type;
    private FileFormat format;
    private boolean adultOk;
    private Coloration coloration;
    private Set<String> sites = new HashSet<String>();

    @Override
    protected final String getVersionNumber() {
        return "V1";
    }

    @Override
    protected final String getServiceName() {
        return "ImageSearchService";
    }

    @Override
    protected final String getMethod() {
        return "imageSearch";
    }

    @Override
    protected final Map getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("appid", this.appId);
        params.put("query", this.query);
        if (this.type != null) {
            params.put("type", this.type.getCode());
        }
        if (this.format != null) {
            params.put("format", this.format.getCode());
        }
        if (this.coloration != null) {
            params.put("coloration", this.coloration.getCode());
        }
        params.put("adult_ok", this.adultOk ? 1 : 0);
        if (this.sites.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            for (String site : this.sites) {
                if (buffer.length() > 0) {
                    buffer.append("&");
                    buffer.append("site=");
                    buffer.append(site);
                    continue;
                }
                buffer.append(site);
            }
            params.put("site", buffer.toString());
        }
        return params;
    }

    protected ResultsList<Result> readResults(InputStream in) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser p = factory.newSAXParser();
        Parser pp = new Parser();
        p.parse(in, (DefaultHandler)pp);
        return pp.results;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        String old = this.getAppId();
        this.appId = appId;
        this.firePropertyChange("appId", old, this.getAppId());
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        String old = this.getQuery();
        this.query = query;
        this.firePropertyChange("query", old, this.getQuery());
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        Type old = this.getType();
        this.type = type;
        this.firePropertyChange("type", (Object)old, (Object)this.getType());
    }

    public FileFormat getFileFormat() {
        return this.format;
    }

    public void setFileFormat(FileFormat format) {
        FileFormat old = this.getFileFormat();
        this.format = format;
        this.firePropertyChange("fileFormat", (Object)old, (Object)this.getFileFormat());
    }

    public boolean isAdultOk() {
        return this.adultOk;
    }

    public void setAdultOk(boolean adultOk) {
        boolean old = this.isAdultOk();
        this.adultOk = adultOk;
        this.firePropertyChange("adultOk", old, this.isAdultOk());
    }

    public Coloration getColoration() {
        return this.coloration;
    }

    public void setColoration(Coloration coloration) {
        Coloration old = this.getColoration();
        this.coloration = coloration;
        this.firePropertyChange("coloration", (Object)old, (Object)this.getColoration());
    }

    private final class Parser
    extends DefaultHandler {
        private StringBuilder buffer;
        private ResultsList<Result> results;
        private Result result;

        private Parser() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("ResultSet".equals(qName)) {
                this.results = new ResultsArrayList<Result>(YahooImageSearch.this, Integer.parseInt(attributes.getValue("totalResultsAvailable")), Integer.parseInt(attributes.getValue("firstResultPosition")));
            } else if ("Result".equals(qName)) {
                this.result = new Result();
                this.results.add(this.result);
            } else {
                this.buffer = new StringBuilder();
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            block20: {
                try {
                    if ("Title".equals(qName)) {
                        this.result.title = this.buffer.toString();
                        break block20;
                    }
                    if ("Summary".equals(qName)) {
                        this.result.summary = this.buffer.toString();
                        break block20;
                    }
                    if ("Url".equals(qName)) {
                        this.result.url = new URL(this.buffer.toString());
                        break block20;
                    }
                    if ("ClickUrl".equals(qName)) {
                        this.result.clickUrl = new URL(this.buffer.toString());
                        break block20;
                    }
                    if ("RefererUrl".equals(qName)) {
                        this.result.refererUrl = new URL(this.buffer.toString());
                        break block20;
                    }
                    if ("FileSize".equals(qName)) {
                        this.result.fileSize = Integer.parseInt(this.buffer.toString());
                        break block20;
                    }
                    if ("FileFormat".equals(qName)) {
                        String format = this.buffer.toString();
                        for (FileFormat f : FileFormat.values()) {
                            if (!f.getCode().equals(format)) continue;
                            this.result.fileFormat = f;
                            break block20;
                        }
                        break block20;
                    }
                    if ("Height".equals(qName)) {
                        this.result.height = Integer.parseInt(this.buffer.toString());
                    } else if ("Width".equals(qName)) {
                        this.result.width = Integer.parseInt(this.buffer.toString());
                    } else if (!"Thumbnail".equals(qName)) {
                        if ("Publisher".equals(qName)) {
                            this.result.publisher = this.buffer.toString();
                        } else if ("Restrictions".equals(qName)) {
                            System.out.println(this.buffer.toString());
                        } else if ("Copyright".equals(qName)) {
                            this.result.copyright = this.buffer.toString();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void characters(char[] chars, int start, int offset) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(chars, start, offset);
            } else {
                System.out.println(new String(chars, start, offset));
            }
        }
    }

    public static final class Result {
        private String title;
        private String summary;
        private URL url;
        private URL clickUrl;
        private URL refererUrl;
        private int fileSize;
        private FileFormat fileFormat;
        private int height;
        private int width;
        private URL thumbnail;
        private String publisher;
        private String copyright;

        public String getTitle() {
            return this.title;
        }

        public String getSummary() {
            return this.summary;
        }

        public URL getUrl() {
            return this.url;
        }

        public URL getClickUrl() {
            return this.clickUrl;
        }

        public URL getRefererUrl() {
            return this.refererUrl;
        }

        public int getFileSize() {
            return this.fileSize;
        }

        public FileFormat getFileFormat() {
            return this.fileFormat;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public URL getThumbnail() {
            return this.thumbnail;
        }

        public String getPublisher() {
            return this.publisher;
        }

        public String getCopyright() {
            return this.copyright;
        }
    }
}

