/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.IOException;
import org.jcodings.Encoding;
import org.jruby.ast.RegexpNode;
import org.jruby.lexer.LexingCommon;
import org.jruby.lexer.yacc.RubyLexer;
import org.jruby.lexer.yacc.StrTerm;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpOptions;

public class StringTerm
extends StrTerm {
    private int flags;
    private final char begin;
    private final char end;
    private final int startLine;
    private int nest;

    public StringTerm(int flags2, int begin2, int end2, int startLine) {
        this.flags = flags2;
        this.begin = (char)begin2;
        this.end = (char)end2;
        this.nest = 0;
        this.startLine = startLine;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    protected ByteList createByteList(RubyLexer lexer) {
        ByteList bytelist = new ByteList(15);
        bytelist.setEncoding(lexer.getEncoding());
        return bytelist;
    }

    private int endFound(RubyLexer lexer) throws IOException {
        if ((this.flags & 8) != 0) {
            this.flags |= 0x8000;
            lexer.pushback(0);
            lexer.getPosition();
            return 32;
        }
        lexer.setStrTerm(null);
        if ((this.flags & 4) != 0) {
            RegexpOptions options2 = lexer.parseRegexpFlags();
            ByteList regexpBytelist = ByteList.create("");
            lexer.setState(6);
            lexer.setValue(new RegexpNode(lexer.getPosition(), regexpBytelist, options2));
            return 383;
        }
        if ((this.flags & 0x40) != 0 && lexer.isLabelSuffix()) {
            lexer.nextc();
            lexer.setState(1025);
            return 388;
        }
        lexer.setState(6);
        lexer.setValue(String.valueOf(this.end));
        return 373;
    }

    @Override
    public int parseString(RubyLexer lexer) throws IOException {
        boolean spaceSeen = false;
        if ((this.flags & 0x8000) != 0) {
            if ((this.flags & 8) != 0) {
                lexer.nextc();
            }
            lexer.setState(6);
            lexer.setValue(String.valueOf(this.end));
            lexer.setStrTerm(null);
            return (this.flags & 4) != 0 ? 383 : 373;
        }
        int c = lexer.nextc();
        if ((this.flags & 8) != 0 && Character.isWhitespace(c)) {
            while (Character.isWhitespace(c = lexer.nextc())) {
            }
            spaceSeen = true;
        }
        if ((this.flags & 0x4000) != 0) {
            this.flags &= 0xFFFFBFFF;
            spaceSeen = true;
        }
        if (c == this.end && this.nest == 0) {
            return this.endFound(lexer);
        }
        if (spaceSeen) {
            lexer.pushback(c);
            lexer.getPosition();
            return 32;
        }
        ByteList buffer = this.createByteList(lexer);
        lexer.newtok(true);
        if ((this.flags & 2) != 0 && c == 35) {
            int token = lexer.peekVariableName(372, 371);
            if (token != 0) {
                return token;
            }
            buffer.append(35);
        }
        lexer.pushback(c);
        if (this.parseStringIntoBuffer(lexer, buffer, lexer.getEncoding()) == -1) {
            lexer.setRubySourceline(this.startLine);
            lexer.compile_error("unterminated " + ((this.flags & 4) != 0 ? "regexp" : "string") + " meets end of file");
        }
        lexer.setValue(lexer.createStr(buffer, this.flags));
        return 378;
    }

    private void mixedEscape(RubyLexer lexer, Encoding foundEncoding, Encoding parserEncoding) {
        lexer.compile_error(SyntaxException.PID.MIXED_ENCODING, "" + foundEncoding + " mixed within " + parserEncoding);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int parseStringIntoBuffer(RubyLexer lexer, ByteList buffer, Encoding encoding2) throws IOException {
        int c;
        boolean qwords = (this.flags & 8) != 0;
        boolean expand = (this.flags & 2) != 0;
        boolean escape2 = (this.flags & 1) != 0;
        boolean regexp2 = (this.flags & 4) != 0;
        boolean symbol = (this.flags & 0x10) != 0;
        boolean hasNonAscii = false;
        block5: while ((c = lexer.nextc()) != -1) {
            block30: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                if (lexer.getHeredocIndent() > 0) {
                                    lexer.update_heredoc_indent(c);
                                }
                                if (this.begin == '\u0000' || c != this.begin) break block31;
                                ++this.nest;
                                break block30;
                            }
                            if (c != this.end) break block32;
                            if (this.nest == 0) {
                                lexer.pushback(c);
                                return c;
                            }
                            --this.nest;
                            break block30;
                        }
                        if (!expand || c != 35 || lexer.peek(10)) break block33;
                        int c2 = lexer.nextc();
                        if (c2 == 36 || c2 == 64 || c2 == 123) {
                            lexer.pushback(c2);
                            lexer.pushback(c);
                            return c;
                        }
                        lexer.pushback(c2);
                        break block30;
                    }
                    if (c != 92) break block34;
                    c = lexer.nextc();
                    switch (c) {
                        case 10: {
                            if (!qwords) {
                                if (expand) break;
                                buffer.append(92);
                            }
                            break block30;
                        }
                        case 92: {
                            if (escape2) {
                                buffer.append(c);
                            }
                            break block30;
                        }
                        case 117: {
                            if (!expand) {
                                buffer.append(92);
                                break block30;
                            } else {
                                if (regexp2) {
                                    lexer.readUTFEscapeRegexpLiteral(buffer);
                                } else {
                                    lexer.readUTFEscape(buffer, true, symbol);
                                }
                                if (!hasNonAscii || buffer.getEncoding() == encoding2) continue block5;
                                this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                                break;
                            }
                        }
                        default: {
                            if (c == -1) {
                                return -1;
                            }
                            if (!lexer.isASCII(c)) {
                                if (!expand) {
                                    buffer.append(92);
                                }
                                hasNonAscii = true;
                                if (buffer.getEncoding() != encoding2) {
                                    this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                                    break;
                                }
                                if (lexer.tokadd_mbchar(c, buffer)) continue block5;
                                lexer.compile_error(SyntaxException.PID.INVALID_MULTIBYTE_CHAR, "invalid multibyte char (" + encoding2 + ")");
                                break;
                            }
                            if (regexp2) {
                                if (c == this.end && !this.simple_re_meta(c)) {
                                    buffer.append(c);
                                    break;
                                }
                                lexer.pushback(c);
                                this.parseEscapeIntoBuffer(lexer, buffer);
                                if (!hasNonAscii || buffer.getEncoding() == encoding2) continue block5;
                                this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                                break;
                            }
                            if (expand) {
                                lexer.pushback(c);
                                if (escape2) {
                                    buffer.append(92);
                                }
                                c = lexer.readEscape();
                                break block30;
                            } else if (!(qwords && Character.isWhitespace(c) || c == this.end || this.begin != '\u0000' && c == this.begin)) {
                                buffer.append(92);
                                lexer.pushback(c);
                                break;
                            }
                            break block30;
                        }
                    }
                    continue;
                }
                if (!lexer.isASCII(c)) {
                    hasNonAscii = true;
                    if (buffer.getEncoding() != encoding2) {
                        this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                        continue;
                    }
                    if (lexer.tokadd_mbchar(c, buffer)) continue;
                    lexer.compile_error(SyntaxException.PID.INVALID_MULTIBYTE_CHAR, "invalid multibyte char (" + encoding2 + ")");
                    continue;
                }
                if (qwords && Character.isWhitespace(c)) {
                    lexer.pushback(c);
                    return c;
                }
            }
            if ((c & 0x80) != 0) {
                hasNonAscii = true;
                if (buffer.getEncoding() != encoding2) {
                    this.mixedEscape(lexer, buffer.getEncoding(), encoding2);
                    continue;
                }
            }
            buffer.append(c);
        }
        return c;
    }

    private boolean simple_re_meta(int c) {
        switch (c) {
            case 36: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 62: 
            case 63: 
            case 93: 
            case 94: 
            case 124: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    private void escaped(RubyLexer lexer, ByteList buffer) throws IOException {
        int c = lexer.nextc();
        switch (c) {
            case 92: {
                this.parseEscapeIntoBuffer(lexer, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                buffer.append(c);
            }
        }
    }

    private void parseEscapeIntoBuffer(RubyLexer lexer, ByteList buffer) throws IOException {
        int c = lexer.nextc();
        block0 : switch (c) {
            case 10: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                buffer.append(92);
                buffer.append(c);
                for (int i2 = 0; i2 < 2; ++i2) {
                    c = lexer.nextc();
                    if (c == -1) {
                        lexer.compile_error("Invalid escape character syntax");
                    }
                    if (!LexingCommon.isOctChar(c)) {
                        lexer.pushback(c);
                        break block0;
                    }
                    buffer.append(c);
                }
                break;
            }
            case 120: {
                buffer.append(92);
                buffer.append(c);
                c = lexer.nextc();
                if (!LexingCommon.isHexChar(c)) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(c);
                c = lexer.nextc();
                if (LexingCommon.isHexChar(c)) {
                    buffer.append(c);
                    break;
                }
                lexer.pushback(c);
                break;
            }
            case 77: {
                if (lexer.nextc() != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 77, 45});
                this.escaped(lexer, buffer);
                break;
            }
            case 67: {
                if (lexer.nextc() != 45) {
                    lexer.compile_error("Invalid escape character syntax");
                }
                buffer.append(new byte[]{92, 67, 45});
                this.escaped(lexer, buffer);
                break;
            }
            case 99: {
                buffer.append(new byte[]{92, 99});
                this.escaped(lexer, buffer);
                break;
            }
            case -1: {
                lexer.compile_error("Invalid escape character syntax");
            }
            default: {
                if (c != 92 || c != this.end) {
                    buffer.append(92);
                }
                buffer.append(c);
            }
        }
    }
}

