/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.bio;

import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.DataSender;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.PooledSender;
import org.apache.catalina.tribes.transport.bio.MultipointBioSender;

public class PooledMultiSender
extends PooledSender {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage) throws ChannelException {
        MultiPointSender multiPointSender = null;
        try {
            multiPointSender = (MultiPointSender)this.getSender();
            if (multiPointSender == null) {
                ChannelException channelException = new ChannelException("Unable to retrieve a data sender, time out(" + this.getMaxWait() + " ms) error.");
                for (int i = 0; i < memberArray.length; ++i) {
                    channelException.addFaultyMember(memberArray[i], new NullPointerException("Unable to retrieve a sender from the sender pool"));
                }
                throw channelException;
            }
            multiPointSender.sendMessage(memberArray, channelMessage);
            multiPointSender.keepalive();
        }
        finally {
            if (multiPointSender != null) {
                this.returnSender(multiPointSender);
            }
        }
    }

    @Override
    public DataSender getNewDataSender() {
        MultipointBioSender multipointBioSender = new MultipointBioSender();
        AbstractSender.transferProperties(this, multipointBioSender);
        return multipointBioSender;
    }
}

