/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.progress.spi.RunOffEDTProvider;
import org.netbeans.modules.progress.ui.AbstractWindowRunner;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class RunOffEDTImpl
implements RunOffEDTProvider,
RunOffEDTProvider.Progress,
RunOffEDTProvider.Progress2 {
    private static final RequestProcessor TI_WORKER = new RequestProcessor("TI_" + ProgressUtils.class.getName(), 1, true);
    private static final Map<String, Long> CUMULATIVE_SPENT_TIME = new HashMap<String, Long>();
    private static final Map<String, Long> MAXIMAL_SPENT_TIME = new HashMap<String, Long>();
    private static final Map<String, Integer> INVOCATION_COUNT = new HashMap<String, Integer>();
    private static final int CANCEL_TIME = 1000;
    private static final int WARNING_TIME = Integer.getInteger("org.netbeans.modules.progress.ui.WARNING_TIME", 10000);
    private static final Logger LOG = Logger.getLogger(RunOffEDTImpl.class.getName());
    private final Map<Class<?>, Pair<Integer, RequestProcessor>> rqByClz = new HashMap();
    private final boolean assertionsOn;

    public void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
        Parameters.notNull((CharSequence)"operation", (Object)runnable);
        Parameters.notNull((CharSequence)"cancelOperation", (Object)atomicBoolean);
        if (!SwingUtilities.isEventDispatchThread()) {
            runnable.run();
            return;
        }
        long l = System.currentTimeMillis();
        this.runOffEventDispatchThreadImpl(runnable, string, atomicBoolean, bl, n, n2);
        long l2 = System.currentTimeMillis() - l;
        if (this.assertionsOn) {
            Integer n3;
            String string2 = runnable.getClass().getName();
            Long l3 = CUMULATIVE_SPENT_TIME.get(string2);
            if (l3 == null) {
                l3 = 0L;
            }
            l3 = l3 + l2;
            CUMULATIVE_SPENT_TIME.put(string2, l3);
            Long l4 = MAXIMAL_SPENT_TIME.get(string2);
            if (l4 == null) {
                l4 = 0L;
            }
            if (l2 > l4) {
                l4 = l2;
                MAXIMAL_SPENT_TIME.put(string2, l4);
            }
            if ((n3 = INVOCATION_COUNT.get(string2)) == null) {
                n3 = 0;
            }
            Integer n4 = n3;
            Integer n5 = n3 = Integer.valueOf(n3 + 1);
            INVOCATION_COUNT.put(string2, n3);
            if (l2 > (long)WARNING_TIME) {
                LOG.log(Level.WARNING, "Lengthy operation: {0}:{1}:{2}:{3}:{4}", new Object[]{string2, l3, n3, l4, String.format("%3.2f", (double)l3.longValue() / (double)n3.intValue())});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOffEventDispatchThreadImpl(final Runnable runnable, String string, final AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
        RequestProcessor requestProcessor;
        Object object;
        Serializable serializable;
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Dialog> atomicReference = new AtomicReference<Dialog>();
        Object object2 = this.rqByClz;
        synchronized (object2) {
            int n3;
            serializable = runnable.getClass();
            object = this.rqByClz.get(serializable);
            if (object == null) {
                n3 = 0;
                requestProcessor = new RequestProcessor(String.format("%s for: %s", ProgressUtils.class.getName(), serializable.getName()), 1, false);
            } else {
                n3 = (Integer)object.first();
                requestProcessor = (RequestProcessor)object.second();
            }
            object = Pair.of((Object)(n3 + 1), (Object)requestProcessor);
            this.rqByClz.put((Class<?>)serializable, (Pair<Integer, RequestProcessor>)object);
        }
        requestProcessor.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (atomicBoolean.get()) {
                    return;
                }
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    Map map = RunOffEDTImpl.this.rqByClz;
                    synchronized (map) {
                        Class<?> clazz = runnable.getClass();
                        Pair pair = (Pair)RunOffEDTImpl.this.rqByClz.remove(clazz);
                        if ((Integer)pair.first() > 1) {
                            RunOffEDTImpl.this.rqByClz.put(clazz, Pair.of((Object)((Integer)pair.first() - 1), (Object)pair.second()));
                        }
                    }
                    countDownLatch.countDown();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Dialog dialog = (Dialog)atomicReference.get();
                            if (dialog != null) {
                                dialog.setVisible(false);
                                dialog.dispose();
                            }
                        }
                    });
                    throw throwable;
                }
                Map map = RunOffEDTImpl.this.rqByClz;
                synchronized (map) {
                    Class<?> clazz = runnable.getClass();
                    Pair pair = (Pair)RunOffEDTImpl.this.rqByClz.remove(clazz);
                    if ((Integer)pair.first() > 1) {
                        RunOffEDTImpl.this.rqByClz.put(clazz, Pair.of((Object)((Integer)pair.first() - 1), (Object)pair.second()));
                    }
                }
                countDownLatch.countDown();
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        object2 = null;
        serializable = null;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component != null && (object2 = SwingUtilities.getWindowAncestor(component)) != null) {
            object = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, component));
            serializable = object.getGlassPane();
        }
        if (object2 == null || serializable == null) {
            object2 = WindowManager.getDefault().getMainWindow();
            serializable = ((JFrame)object2).getGlassPane();
        }
        if (RunOffEDTImpl.waitMomentarily(serializable, null, n, countDownLatch, (Window)object2)) {
            return;
        }
        object = Cursor.getPredefinedCursor(3);
        if (RunOffEDTImpl.waitMomentarily(serializable, (Cursor)object, n2, countDownLatch, (Window)object2)) {
            return;
        }
        String string2 = NbBundle.getMessage(RunOffEDTImpl.class, (String)"RunOffAWT.TITLE_Operation");
        String string3 = NbBundle.getMessage(RunOffEDTImpl.class, (String)"RunOffAWT.BTN_Cancel");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)string, string2, true, new Object[]{string3}, (Object)string3, 0, null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                atomicBoolean.set(true);
                ((Dialog)atomicReference.get()).setVisible(false);
                ((Dialog)atomicReference.get()).dispose();
            }
        });
        dialogDescriptor.setMessageType(1);
        atomicReference.set(DialogDisplayer.getDefault().createDialog(dialogDescriptor));
        ((Dialog)atomicReference.get()).setVisible(true);
        if (bl) {
            try {
                if (!countDownLatch.await(1000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Canceled operation did not finish in time.");
                }
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.FINE, null, interruptedException);
            }
        }
    }

    public void runOffEventThreadWithCustomDialogContent(Runnable runnable, String string, JPanel jPanel, int n, int n2) {
        this.runOffEventThreadCustomDialogImpl(runnable, string, jPanel, n, n2);
    }

    public void runOffEventThreadWithProgressDialog(Runnable runnable, String string, ProgressHandle progressHandle, boolean bl, int n, int n2) {
        JPanel jPanel = RunOffEDTImpl.contentPanel(progressHandle, bl);
        this.runOffEventThreadCustomDialogImpl(runnable, string, jPanel, n, n2);
    }

    private void runOffEventThreadCustomDialogImpl(final Runnable runnable, String string, JPanel jPanel, int n, int n2) {
        Object object;
        if (n < 0) {
            n = 1000;
        }
        if (n2 < 0) {
            n2 = 2000;
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Dialog> atomicReference = new AtomicReference<Dialog>();
        AtomicReference<RequestProcessor.Task> atomicReference2 = new AtomicReference<RequestProcessor.Task>();
        JDialog jDialog = RunOffEDTImpl.createModalDialog(runnable, string, jPanel, atomicReference, atomicReference2, runnable instanceof Cancellable);
        RequestProcessor.Task task = TI_WORKER.post(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                    countDownLatch.countDown();
                }
                catch (Throwable throwable) {
                    countDownLatch.countDown();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Dialog dialog = (Dialog)atomicReference.get();
                            if (dialog != null) {
                                dialog.setVisible(false);
                                dialog.dispose();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
        atomicReference2.set(task);
        Window window = null;
        Component component = null;
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component2 != null && (window = SwingUtilities.getWindowAncestor(component2)) != null) {
            object = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, component2));
            component = object.getGlassPane();
        }
        if (window == null || component == null) {
            window = WindowManager.getDefault().getMainWindow();
            component = ((JFrame)window).getGlassPane();
        }
        if (RunOffEDTImpl.waitMomentarily(component, null, n, countDownLatch, window)) {
            return;
        }
        object = Cursor.getPredefinedCursor(3);
        if (RunOffEDTImpl.waitMomentarily(component, (Cursor)object, n2, countDownLatch, window)) {
            return;
        }
        atomicReference.set(jDialog);
        if (EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((Dialog)atomicReference.get()).setVisible(true);
                }
            });
        } else {
            atomicReference.get().setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitMomentarily(Component component, Cursor cursor, int n, CountDownLatch countDownLatch, Window window) {
        Cursor cursor2 = window.getCursor();
        Cursor cursor3 = component.getCursor();
        try {
            if (cursor != null) {
                window.setCursor(cursor);
                component.setCursor(cursor);
            }
            component.setVisible(true);
            try {
                boolean bl = countDownLatch.await(n, TimeUnit.MILLISECONDS);
                return bl;
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.FINE, null, interruptedException);
                boolean bl = true;
                component.setVisible(false);
                window.setCursor(cursor2);
                component.setCursor(cursor3);
                return bl;
            }
        }
        finally {
            component.setVisible(false);
            window.setCursor(cursor2);
            component.setCursor(cursor3);
        }
    }

    public RunOffEDTImpl() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        this.assertionsOn = bl;
    }

    public <T> Future<T> showProgressDialogAndRunLater(ProgressRunnable<T> progressRunnable, ProgressHandle progressHandle, boolean bl) {
        ProgressBackgroundRunner<T> progressBackgroundRunner = new ProgressBackgroundRunner<T>(progressRunnable, progressHandle, bl, progressRunnable instanceof Cancellable);
        Future future = progressBackgroundRunner.start();
        assert (EventQueue.isDispatchThread() == (future != null));
        if (future == null) {
            try {
                future = progressBackgroundRunner.waitForStart();
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.FINE, "Interrupted/cancelled during start {0}", progressRunnable);
                LOG.log(Level.FINER, "Interrupted/cancelled during start", interruptedException);
                return null;
            }
        }
        return future;
    }

    public <T> T showProgressDialogAndRun(ProgressRunnable<T> progressRunnable, String string, boolean bl) {
        try {
            return this.showProgressDialogAndRunLater(progressRunnable, progressRunnable instanceof Cancellable ? ProgressHandleFactory.createHandle((String)string, (Cancellable)((Cancellable)progressRunnable)) : ProgressHandleFactory.createHandle((String)string), bl).get();
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (CancellationException cancellationException) {
            LOG.log(Level.FINER, "Cancelled " + progressRunnable, cancellationException);
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        return null;
    }

    public void showProgressDialogAndRun(Runnable runnable, ProgressHandle progressHandle, boolean bl) {
        boolean bl2 = runnable instanceof Cancellable;
        ProgressBackgroundRunner progressBackgroundRunner = new ProgressBackgroundRunner(runnable, progressHandle, bl, bl2);
        progressBackgroundRunner.start();
        try {
            try {
                progressBackgroundRunner.waitForStart().get();
            }
            catch (CancellationException cancellationException) {
                LOG.log(Level.FINER, "Cancelled " + runnable, cancellationException);
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
    }

    private static JPanel contentPanel(ProgressHandle progressHandle, boolean bl) {
        JComponent jComponent;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
        Font font = jLabel.getFont();
        if (font != null) {
            jLabel.setFont(font.deriveFont(1));
        }
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        JComponent jComponent2 = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        jPanel.add((Component)jComponent2, gridBagConstraints);
        if (bl) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 21;
            jComponent = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
            jPanel.add((Component)jComponent, gridBagConstraints);
        }
        jComponent = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = bl ? 3 : 2;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jComponent, gridBagConstraints);
        return jPanel;
    }

    private static JDialog createModalDialog(final Runnable runnable, String string, JPanel jPanel, final AtomicReference<Dialog> atomicReference, final AtomicReference<RequestProcessor.Task> atomicReference2, boolean bl) {
        Object object;
        Container container;
        assert (EventQueue.isDispatchThread());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        if (bl) {
            container = new JPanel();
            container.setLayout(new FlowLayout(2));
            object = NbBundle.getMessage(RunOffEDTImpl.class, (String)"RunOffAWT.BTN_Cancel");
            JButton jButton = new JButton((String)object);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (runnable instanceof Cancellable) {
                        ((Cancellable)runnable).cancel();
                        ((RequestProcessor.Task)atomicReference2.get()).cancel();
                        ((Dialog)atomicReference.get()).setVisible(false);
                        ((Dialog)atomicReference.get()).dispose();
                    }
                }
            });
            container.add(jButton);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            jPanel2.add((Component)container, gridBagConstraints);
        }
        container = WindowManager.getDefault().getMainWindow();
        object = new JDialog((Frame)container, string, true);
        ((JDialog)object).setDefaultCloseOperation(0);
        ((Window)object).setSize(400, 150);
        ((JDialog)object).setContentPane(jPanel2);
        ((Window)object).setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        return object;
    }

    private static final class ProgressBackgroundRunner<T>
    extends AbstractWindowRunner<T>
    implements Cancellable {
        private final ProgressRunnable<T> toRun;

        ProgressBackgroundRunner(ProgressRunnable<T> progressRunnable, String string, boolean bl, boolean bl2) {
            super(bl2 ? ProgressHandleFactory.createHandle((String)string, (Cancellable)((Cancellable)progressRunnable), null) : ProgressHandleFactory.createHandle((String)string, (Action)null), bl, bl2);
            this.toRun = progressRunnable;
        }

        ProgressBackgroundRunner(ProgressRunnable<T> progressRunnable, ProgressHandle progressHandle, boolean bl, boolean bl2) {
            super(progressHandle, bl, bl2);
            this.toRun = progressRunnable;
        }

        ProgressBackgroundRunner(Runnable runnable, ProgressHandle progressHandle, boolean bl, boolean bl2) {
            this(bl2 ? new CancellableRunnablePR(runnable) : new RunnablePR(runnable), progressHandle, bl, bl2);
        }

        @Override
        protected T runBackground() {
            Object object;
            this.handle.start();
            this.handle.switchToIndeterminate();
            try {
                object = this.toRun.run(this.handle);
            }
            finally {
                this.handle.finish();
            }
            return (T)object;
        }

        public boolean cancel() {
            if (this.toRun instanceof Cancellable) {
                return ((Cancellable)this.toRun).cancel();
            }
            return false;
        }

        private static final class CancellableRunnablePR<T>
        extends RunnablePR<T>
        implements Cancellable {
            CancellableRunnablePR(Runnable runnable) {
                super(runnable);
            }

            public boolean cancel() {
                return ((Cancellable)this.toRun).cancel();
            }
        }

        private static class RunnablePR<T>
        implements ProgressRunnable<T> {
            protected final Runnable toRun;

            RunnablePR(Runnable runnable) {
                this.toRun = runnable;
            }

            public T run(ProgressHandle progressHandle) {
                this.toRun.run();
                return null;
            }
        }
    }

    static final class TranslucentMask
    extends JComponent {
        private static final String PROGRESS_WINDOW_MASK_COLOR = "progress.windowMaskColor";

        TranslucentMask() {
            this.setVisible(false);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }

        @Override
        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = UIManager.getColor(PROGRESS_WINDOW_MASK_COLOR);
            if (color == null) {
                color = new Color(180, 180, 180, 148);
            }
            graphics2D.setColor(color);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    static class CancellableFutureTask<T>
    extends FutureTask<T>
    implements Cancellable {
        volatile RequestProcessor.Task task;
        private final Callable<T> c;

        CancellableFutureTask(Callable<T> callable) {
            super(callable);
            this.c = callable;
        }

        public boolean cancel() {
            return this.cancel(true);
        }

        @Override
        public boolean cancel(boolean bl) {
            boolean bl2 = this.c instanceof Cancellable ? ((Cancellable)this.c).cancel() : false;
            return bl2 &= super.cancel(bl) & this.task.cancel();
        }

        @Override
        public String toString() {
            return super.toString() + "[" + this.c + "]";
        }
    }
}

