/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx;

import eu.hansolo.tilesfx.Alarm;
import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.TimeSection;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.chart.RadarChartMode;
import eu.hansolo.tilesfx.chart.SunburstChart;
import eu.hansolo.tilesfx.chart.TilesFXSeries;
import eu.hansolo.tilesfx.colors.Bright;
import eu.hansolo.tilesfx.events.AlarmEventListener;
import eu.hansolo.tilesfx.events.TileEventListener;
import eu.hansolo.tilesfx.events.TimeEventListener;
import eu.hansolo.tilesfx.skins.BarChartItem;
import eu.hansolo.tilesfx.skins.LeaderBoardItem;
import eu.hansolo.tilesfx.tools.Country;
import eu.hansolo.tilesfx.tools.CountryGroup;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.tilesfx.tools.Location;
import eu.hansolo.tilesfx.tools.TreeNode;
import eu.hansolo.tilesfx.weather.DarkSky;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.XYChart;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Stop;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

public class TileBuilder<B extends TileBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected TileBuilder() {
    }

    public static final TileBuilder create() {
        return new TileBuilder();
    }

    public final B skinType(Tile.SkinType TYPE2) {
        this.properties.put("skinType", new SimpleObjectProperty<Tile.SkinType>(TYPE2));
        return (B)this;
    }

    public final B value(double VALUE) {
        this.properties.put("value", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B minValue(double VALUE) {
        this.properties.put("minValue", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B maxValue(double VALUE) {
        this.properties.put("maxValue", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B threshold(double VALUE) {
        this.properties.put("threshold", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B lowerThreshold(double VALUE) {
        this.properties.put("lowerThreshold", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B referenceValue(double VALUE) {
        this.properties.put("referenceValue", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B autoReferenceValue(boolean AUTO_REFERENCE_VALUE) {
        this.properties.put("autoReferenceValue", new SimpleBooleanProperty(AUTO_REFERENCE_VALUE));
        return (B)this;
    }

    public final B decimals(int DECIMALS) {
        this.properties.put("decimals", new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B tickLabelDecimals(int DECIMALS) {
        this.properties.put("tickLabelDecimals", new SimpleIntegerProperty(DECIMALS));
        return (B)this;
    }

    public final B title(String TITLE) {
        this.properties.put("title", new SimpleStringProperty(TITLE));
        return (B)this;
    }

    public final B titleAlignment(TextAlignment ALIGNMENT) {
        this.properties.put("titleAlignment", new SimpleObjectProperty<TextAlignment>(ALIGNMENT));
        return (B)this;
    }

    public final B description(String DESCRIPTION) {
        this.properties.put("description", new SimpleStringProperty(DESCRIPTION));
        return (B)this;
    }

    public final B descriptionAlignment(Pos ALIGNMENT) {
        this.properties.put("descriptionAlignment", new SimpleObjectProperty<Pos>(ALIGNMENT));
        return (B)this;
    }

    public final B unit(String UNIT) {
        this.properties.put("unit", new SimpleStringProperty(UNIT));
        return (B)this;
    }

    public final B flatUI(boolean FLAT_UI) {
        this.properties.put("flatUI", new SimpleBooleanProperty(FLAT_UI));
        return (B)this;
    }

    public final B duration(LocalTime DURATION) {
        this.properties.put("duration", new SimpleObjectProperty<LocalTime>(DURATION));
        return (B)this;
    }

    public final B selected(boolean SELECTED) {
        this.properties.put("selected", new SimpleBooleanProperty(SELECTED));
        return (B)this;
    }

    public final B averagingEnabled(boolean ENABLED) {
        this.properties.put("averagingEnabled", new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B averagingPeriod(int PERIOD) {
        this.properties.put("averagingPeriod", new SimpleIntegerProperty(PERIOD));
        return (B)this;
    }

    public final B timePeriod(Duration PERIOD) {
        this.properties.put("timePeriod", new SimpleObjectProperty<Duration>(PERIOD));
        return (B)this;
    }

    public final B maxTimePeriod(Duration MAX_PERIOD) {
        this.properties.put("maxTimePeriod", new SimpleObjectProperty<Duration>(MAX_PERIOD));
        return (B)this;
    }

    public final B timePeriodResolution(TimeUnit RESOLUTION) {
        this.properties.put("timePeriodResolution", new SimpleObjectProperty<TimeUnit>(RESOLUTION));
        return (B)this;
    }

    public final B foregroundBaseColor(Color COLOR) {
        this.properties.put("foregroundBaseColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B startFromZero(boolean START) {
        this.properties.put("startFromZero", new SimpleBooleanProperty(START));
        return (B)this;
    }

    public final B returnToZero(boolean RETURN) {
        this.properties.put("returnToZero", new SimpleBooleanProperty(RETURN));
        return (B)this;
    }

    public final B minMeasuredValueVisible(boolean VISIBLE) {
        this.properties.put("minMeasuredValueVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B maxMeasuredValueVisible(boolean VISIBLE) {
        this.properties.put("maxMeasuredValueVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B oldValueVisible(boolean VISIBLE) {
        this.properties.put("oldValueVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B valueVisible(boolean VISIBLE) {
        this.properties.put("valueVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B foregroundColor(Color COLOR) {
        this.properties.put("foregroundColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B backgroundColor(Color COLOR) {
        this.properties.put("backgroundColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B borderColor(Color COLOR) {
        this.properties.put("borderColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B borderWidth(double WIDTH) {
        this.properties.put("borderWidth", new SimpleDoubleProperty(WIDTH));
        return (B)this;
    }

    public final B knobColor(Color COLOR) {
        this.properties.put("knobColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B activeColor(Color COLOR) {
        this.properties.put("activeColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B animated(boolean ANIMATED) {
        this.properties.put("animated", new SimpleBooleanProperty(ANIMATED));
        return (B)this;
    }

    public final B animationDuration(long DURATION) {
        this.properties.put("animationDuration", new SimpleLongProperty(DURATION));
        return (B)this;
    }

    public final B startAngle(double ANGLE) {
        this.properties.put("startAngle", new SimpleDoubleProperty(ANGLE));
        return (B)this;
    }

    public final B angleRange(double RANGE) {
        this.properties.put("angleRange", new SimpleDoubleProperty(RANGE));
        return (B)this;
    }

    public final B autoScale(boolean AUTO_SCALE) {
        this.properties.put("autoScale", new SimpleBooleanProperty(AUTO_SCALE));
        return (B)this;
    }

    public final B needleColor(Color COLOR) {
        this.properties.put("needleColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B barColor(Color COLOR) {
        this.properties.put("barColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B barBackgroundColor(Color COLOR) {
        this.properties.put("barBackgroundColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B locale(Locale LOCALE) {
        this.properties.put("locale", new SimpleObjectProperty<Locale>(LOCALE));
        return (B)this;
    }

    public final B numberFormat(NumberFormat FORMAT) {
        this.properties.put("numberFormat", new SimpleObjectProperty<NumberFormat>(FORMAT));
        return (B)this;
    }

    public final B shadowsEnabled(boolean ENABLED) {
        this.properties.put("shadowsEnabled", new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B styleClass(String ... STYLES) {
        this.properties.put("styleClass", new SimpleObjectProperty<String[]>(STYLES));
        return (B)this;
    }

    public final B sections(Section ... SECTIONS) {
        this.properties.put("sectionsArray", new SimpleObjectProperty<Section[]>(SECTIONS));
        return (B)this;
    }

    public final B sections(List<Section> SECTIONS) {
        this.properties.put("sectionsList", new SimpleObjectProperty<List<Section>>(SECTIONS));
        return (B)this;
    }

    public final B series(XYChart.Series<String, Number> ... SERIES) {
        this.properties.put("seriesArray", new SimpleObjectProperty<XYChart.Series<String, Number>[]>(SERIES));
        return (B)this;
    }

    public final B series(List<XYChart.Series<String, Number>> SERIES) {
        this.properties.put("seriesList", new SimpleObjectProperty<List<XYChart.Series<String, Number>>>(SERIES));
        return (B)this;
    }

    public final B tilesFxSeries(TilesFXSeries<String, Number> ... SERIES) {
        this.properties.put("tilesFxSeriesArray", new SimpleObjectProperty<TilesFXSeries<String, Number>[]>(SERIES));
        return (B)this;
    }

    public final B tilesFxSeries(List<TilesFXSeries<String, Number>> SERIES) {
        this.properties.put("tilesFxSeriesList", new SimpleObjectProperty<List<TilesFXSeries<String, Number>>>(SERIES));
        return (B)this;
    }

    public final B chartType(Tile.ChartType TYPE2) {
        this.properties.put("chartType", new SimpleObjectProperty<Tile.ChartType>(TYPE2));
        return (B)this;
    }

    public final B tooltipTimeout(double TIMEOUT) {
        this.properties.put("tooltipTimeout", new SimpleDoubleProperty(TIMEOUT));
        return (B)this;
    }

    public final B barChartItems(BarChartItem ... ITEMS) {
        this.properties.put("barChartItemsArray", new SimpleObjectProperty<BarChartItem[]>(ITEMS));
        return (B)this;
    }

    public final B barChartItems(List<BarChartItem> ITEMS) {
        this.properties.put("barChartItemsList", new SimpleObjectProperty<List<BarChartItem>>(ITEMS));
        return (B)this;
    }

    public final B leaderBoardItems(LeaderBoardItem ... ITEMS) {
        this.properties.put("leaderBoardItemsArray", new SimpleObjectProperty<LeaderBoardItem[]>(ITEMS));
        return (B)this;
    }

    public final B leaderBoardItems(List<LeaderBoardItem> ITEMS) {
        this.properties.put("leaderBoardItemsList", new SimpleObjectProperty<List<LeaderBoardItem>>(ITEMS));
        return (B)this;
    }

    public final B chartData(ChartData ... DATA) {
        this.properties.put("chartDataArray", new SimpleObjectProperty<ChartData[]>(DATA));
        return (B)this;
    }

    public final B chartData(List<ChartData> DATA) {
        this.properties.put("chartDataList", new SimpleObjectProperty<List<ChartData>>(DATA));
        return (B)this;
    }

    public final B characters(String ... CHARACTERS) {
        this.properties.put("characterArray", new SimpleObjectProperty<String[]>(CHARACTERS));
        return (B)this;
    }

    public final B flipTimeInMS(long TIME) {
        this.properties.put("flipTimeInMS", new SimpleLongProperty(TIME));
        return (B)this;
    }

    public final B flipText(String TEXT) {
        this.properties.put("flipText", new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B titleColor(Color COLOR) {
        this.properties.put("titleColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B descriptionColor(Color COLOR) {
        this.properties.put("descriptionColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public B unitColor(Color COLOR) {
        this.properties.put("unitColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public B valueColor(Color COLOR) {
        this.properties.put("valueColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public B thresholdColor(Color COLOR) {
        this.properties.put("thresholdColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public B lowerThresholdColor(Color COLOR) {
        this.properties.put("lowerThresholdColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B checkSectionsForValue(boolean CHECK) {
        this.properties.put("checkSectionsForValue", new SimpleBooleanProperty(CHECK));
        return (B)this;
    }

    public final B checkThreshold(boolean CHECK) {
        this.properties.put("checkThreshold", new SimpleBooleanProperty(CHECK));
        return (B)this;
    }

    public final B checkLowerThreshold(boolean CHECK) {
        this.properties.put("checkLowerThreshold", new SimpleBooleanProperty(CHECK));
        return (B)this;
    }

    public final B innerShadowEnabled(boolean ENABLED) {
        this.properties.put("innerShadowEnabled", new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B thresholdVisible(boolean VISIBLE) {
        this.properties.put("thresholdVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B lowerThresholdVisible(boolean VISIBLE) {
        this.properties.put("lowerThresholdVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B averageVisible(boolean VISIBLE) {
        this.properties.put("averageVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B sectionsVisible(boolean VISIBLE) {
        this.properties.put("sectionsVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B sectionsAlwaysVisible(boolean VISIBLE) {
        this.properties.put("sectionsAlwaysVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B sectionTextVisible(boolean VISIBLE) {
        this.properties.put("sectionTextVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B sectionIconsVisible(boolean VISIBLE) {
        this.properties.put("sectionIconsVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B highlightSections(boolean HIGHLIGHT) {
        this.properties.put("highlightSections", new SimpleBooleanProperty(HIGHLIGHT));
        return (B)this;
    }

    public final B orientation(Orientation ORIENTATION) {
        this.properties.put("orientation", new SimpleObjectProperty<Orientation>(ORIENTATION));
        return (B)this;
    }

    public final B customFontEnabled(boolean ENABLED) {
        this.properties.put("customFontEnabled", new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B customFont(Font FONT) {
        this.properties.put("customFont", new SimpleObjectProperty<Font>(FONT));
        return (B)this;
    }

    public final B customDecimalFormatEnabled(boolean ENABLED) {
        this.properties.put("customDecimalFormatEnabled", new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B customDecimalFormat(DecimalFormat DECIMAL_FORMAT) {
        this.properties.put("customDecimalFormat", new SimpleObjectProperty<DecimalFormat>(DECIMAL_FORMAT));
        return (B)this;
    }

    public final B alertMessage(String MESSAGE) {
        this.properties.put("alertMessage", new SimpleStringProperty(MESSAGE));
        return (B)this;
    }

    public final B smoothing(boolean SMOOTHING) {
        this.properties.put("smoothing", new SimpleBooleanProperty(SMOOTHING));
        return (B)this;
    }

    public final B onValueChanged(InvalidationListener LISTENER) {
        this.properties.put("onValueChanged", new SimpleObjectProperty<InvalidationListener>(LISTENER));
        return (B)this;
    }

    public final B onThresholdExceeded(TileEventListener HANDLER) {
        this.properties.put("onThresholdExceeded", new SimpleObjectProperty<TileEventListener>(HANDLER));
        return (B)this;
    }

    public final B onThresholdUnderrun(TileEventListener HANDLER) {
        this.properties.put("onThresholdUnderrun", new SimpleObjectProperty<TileEventListener>(HANDLER));
        return (B)this;
    }

    public final B time(ZonedDateTime TIME) {
        this.properties.put("time", new SimpleObjectProperty<ZonedDateTime>(TIME));
        return (B)this;
    }

    public final B text(String TEXT) {
        this.properties.put("text", new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B textAlignment(TextAlignment ALIGNMENT) {
        this.properties.put("textAlignment", new SimpleObjectProperty<TextAlignment>(ALIGNMENT));
        return (B)this;
    }

    public final B timeSections(TimeSection ... SECTIONS) {
        this.properties.put("timeSectionsArray", new SimpleObjectProperty<TimeSection[]>(SECTIONS));
        return (B)this;
    }

    public final B timeSections(List<TimeSection> SECTIONS) {
        this.properties.put("timeSectionsList", new SimpleObjectProperty<List<TimeSection>>(SECTIONS));
        return (B)this;
    }

    public final B discreteSeconds(boolean DISCRETE) {
        this.properties.put("discreteSeconds", new SimpleBooleanProperty(DISCRETE));
        return (B)this;
    }

    public final B discreteMinutes(boolean DISCRETE) {
        this.properties.put("discreteMinutes", new SimpleBooleanProperty(DISCRETE));
        return (B)this;
    }

    public final B discreteHours(boolean DISCRETE) {
        this.properties.put("discreteHours", new SimpleBooleanProperty(DISCRETE));
        return (B)this;
    }

    public final B secondsVisible(boolean VISIBLE) {
        this.properties.put("secondsVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B textVisible(boolean VISIBLE) {
        this.properties.put("textVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B dateVisible(boolean VISIBLE) {
        this.properties.put("dateVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B running(boolean RUNNING) {
        this.properties.put("running", new SimpleBooleanProperty(RUNNING));
        return (B)this;
    }

    public final B textColor(Color COLOR) {
        this.properties.put("textColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B dateColor(Color COLOR) {
        this.properties.put("dateColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B hourTickMarkColor(Color COLOR) {
        this.properties.put("hourTickMarkColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B minuteTickMarkColor(Color COLOR) {
        this.properties.put("minuteTickMarkColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B alarmColor(Color COLOR) {
        this.properties.put("alarmColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B tickLabelColor(Color COLOR) {
        this.properties.put("tickLabelColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B tickMarkColor(Color COLOR) {
        this.properties.put("tickMarkColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B hourTickMarksVisible(boolean VISIBLE) {
        this.properties.put("hourTickMarksVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B minuteTickMarksVisible(boolean VISIBLE) {
        this.properties.put("minuteTickMarksVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B hourColor(Color COLOR) {
        this.properties.put("hourColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B minuteColor(Color COLOR) {
        this.properties.put("minuteColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B secondColor(Color COLOR) {
        this.properties.put("secondColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B alarmsEnabled(boolean ENABLED) {
        this.properties.put("alarmsEnabled", new SimpleBooleanProperty(ENABLED));
        return (B)this;
    }

    public final B alarmsVisible(boolean VISIBLE) {
        this.properties.put("alarmsVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B tooltipText(String TEXT) {
        this.properties.put("tooltipText", new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B alarms(Alarm ... ALARMS) {
        this.properties.put("alarmsArray", new SimpleObjectProperty<Alarm[]>(ALARMS));
        return (B)this;
    }

    public final B alarms(List<Alarm> ALARMS) {
        this.properties.put("alarmsList", new SimpleObjectProperty<List<Alarm>>(ALARMS));
        return (B)this;
    }

    public final B onAlarm(AlarmEventListener LISTENER) {
        this.properties.put("onAlarm", new SimpleObjectProperty<AlarmEventListener>(LISTENER));
        return (B)this;
    }

    public final B onTimeEvent(TimeEventListener LISTENER) {
        this.properties.put("onTimeEvent", new SimpleObjectProperty<TimeEventListener>(LISTENER));
        return (B)this;
    }

    public final B onTileEvent(TileEventListener LISTENER) {
        this.properties.put("onTileEvent", new SimpleObjectProperty<TileEventListener>(LISTENER));
        return (B)this;
    }

    public final B increment(double INCREMENT) {
        this.properties.put("increment", new SimpleDoubleProperty(INCREMENT));
        return (B)this;
    }

    public final B darkSky(DarkSky DARK_SKY) {
        this.properties.put("darkSky", new SimpleObjectProperty<DarkSky>(DARK_SKY));
        return (B)this;
    }

    public final B image(Image IMAGE) {
        this.properties.put("image", new SimpleObjectProperty<Image>(IMAGE));
        return (B)this;
    }

    public final B imageMask(Tile.ImageMask MASK) {
        this.properties.put("imageMask", new SimpleObjectProperty<Tile.ImageMask>(MASK));
        return (B)this;
    }

    public final B graphic(Node GRAPHIC) {
        this.properties.put("graphic", new SimpleObjectProperty<Node>(GRAPHIC));
        return (B)this;
    }

    public final B svgPath(SVGPath SVG_PATH) {
        this.properties.put("svgPath", new SimpleObjectProperty<SVGPath>(SVG_PATH));
        return (B)this;
    }

    public final B currentLocation(Location LOCATION) {
        this.properties.put("currentLocation", new SimpleObjectProperty<Location>(LOCATION));
        return (B)this;
    }

    public final B pointsOfInterest(Location ... LOCATIONS) {
        this.properties.put("poiArray", new SimpleObjectProperty<Location[]>(LOCATIONS));
        return (B)this;
    }

    public final B pointsOfInterest(List<Location> LOCATIONS) {
        this.properties.put("poiList", new SimpleObjectProperty<List<Location>>(LOCATIONS));
        return (B)this;
    }

    public final B track(Location ... LOCATIONS) {
        this.properties.put("trackArray", new SimpleObjectProperty<Location[]>(LOCATIONS));
        return (B)this;
    }

    public final B track(List<Location> LOCATIONS) {
        this.properties.put("trackList", new SimpleObjectProperty<List<Location>>(LOCATIONS));
        return (B)this;
    }

    public final B trackColor(Tile.TileColor COLOR) {
        this.properties.put("trackColor", new SimpleObjectProperty<Tile.TileColor>(COLOR));
        return (B)this;
    }

    public final B mapProvider(Tile.MapProvider PROVIDER) {
        this.properties.put("mapProvider", new SimpleObjectProperty<Tile.MapProvider>(PROVIDER));
        return (B)this;
    }

    public final B gradientStops(Stop ... STOPS) {
        this.properties.put("gradientStopsArray", new SimpleObjectProperty<Stop[]>(STOPS));
        return (B)this;
    }

    public final B gradientStops(List<Stop> STOPS) {
        this.properties.put("gradientStopsList", new SimpleObjectProperty<List<Stop>>(STOPS));
        return (B)this;
    }

    public final B strokeWithGradient(boolean STROKE_WITH_GRADIENT) {
        this.properties.put("strokeWithGradient", new SimpleBooleanProperty(STROKE_WITH_GRADIENT));
        return (B)this;
    }

    public final B fillWithGradient(boolean FILL_WITH_GRADIENT) {
        this.properties.put("fillWithGradient", new SimpleBooleanProperty(FILL_WITH_GRADIENT));
        return (B)this;
    }

    public final B roundedCorners(boolean ROUNDED) {
        this.properties.put("roundedCorners", new SimpleBooleanProperty(ROUNDED));
        return (B)this;
    }

    public final B textSize(Tile.TextSize SIZE2) {
        this.properties.put("textSize", new SimpleObjectProperty<Tile.TextSize>(SIZE2));
        return (B)this;
    }

    public final B xAxis(Axis AXIS) {
        this.properties.put("xAxis", new SimpleObjectProperty<Axis>(AXIS));
        return (B)this;
    }

    public final B yAxis(Axis AXIS) {
        this.properties.put("yAxis", new SimpleObjectProperty<Axis>(AXIS));
        return (B)this;
    }

    public final B radarChartMode(RadarChartMode RadarChartMODE) {
        this.properties.put("radarChartMode", new SimpleObjectProperty<RadarChartMode>(RadarChartMODE));
        return (B)this;
    }

    public final B chartGridColor(Color COLOR) {
        this.properties.put("chartGridColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B country(Country COUNTRY) {
        this.properties.put("country", new SimpleObjectProperty<Country>(COUNTRY));
        return (B)this;
    }

    public final B countryGroup(CountryGroup COUNTRY_GROUP) {
        this.properties.put("countryGroup", new SimpleObjectProperty<CountryGroup>(COUNTRY_GROUP));
        return (B)this;
    }

    public final B sortedData(boolean SORTED) {
        this.properties.put("sortedData", new SimpleBooleanProperty(SORTED));
        return (B)this;
    }

    public final B dataPointsVisible(boolean VISIBLE) {
        this.properties.put("dataPointsVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B sunburstTree(TreeNode TREE) {
        this.properties.put("sunburstTree", new SimpleObjectProperty<TreeNode>(TREE));
        return (B)this;
    }

    public final B sunburstBackgroundColor(Color COLOR) {
        this.properties.put("sunburstBackgroundColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B sunburstTextColor(Color COLOR) {
        this.properties.put("sunburstTextColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B sunburstUseColorFromParent(boolean USE) {
        this.properties.put("sunburstUseColorFromParent", new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B sunburstTextOrientation(SunburstChart.TextOrientation ORIENTATION) {
        this.properties.put("sunburstTextOrientation", new SimpleObjectProperty<SunburstChart.TextOrientation>(ORIENTATION));
        return (B)this;
    }

    public final B sunburstVisibleData(SunburstChart.VisibleData VISIBLE_DATA) {
        this.properties.put("sunburstVisibleData", new SimpleObjectProperty<SunburstChart.VisibleData>(VISIBLE_DATA));
        return (B)this;
    }

    public final B sunburstInteractive(boolean INTERACTIVE) {
        this.properties.put("sunburstInteractive", new SimpleBooleanProperty(INTERACTIVE));
        return (B)this;
    }

    public final B sunburstAutoTextColor(boolean AUTOMATIC) {
        this.properties.put("sunburstAutoTextColor", new SimpleBooleanProperty(AUTOMATIC));
        return (B)this;
    }

    public final B sunburstUseChartDataTextColor(boolean USE) {
        this.properties.put("sunburstUseChartDataTextColor", new SimpleBooleanProperty(USE));
        return (B)this;
    }

    public final B snapToTicks(boolean SNAP) {
        this.properties.put("snapToTicks", new SimpleBooleanProperty(SNAP));
        return (B)this;
    }

    public final B minorTickCount(int COUNT) {
        this.properties.put("minorTickCount", new SimpleIntegerProperty(COUNT));
        return (B)this;
    }

    public final B majorTickUnit(double UNIT) {
        this.properties.put("majorTickUnit", new SimpleDoubleProperty(UNIT));
        return (B)this;
    }

    public final B matrixSize(int COLS, int ROWS) {
        this.properties.put("matrixSize", null);
        this.properties.put("matrixColumns", new SimpleIntegerProperty(COLS));
        this.properties.put("matrixRows", new SimpleIntegerProperty(ROWS));
        return (B)this;
    }

    public final B notifyRegionBackgroundColor(Color COLOR) {
        this.properties.put("notifyRegionBackgroundColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B notifyRegionForegroundColor(Color COLOR) {
        this.properties.put("notifyRegionForegroundColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B notifyRegionTooltipText(String TEXT) {
        this.properties.put("notifyRegionTooltipText", new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B showNotifyRegion(boolean SHOW) {
        this.properties.put("showNotifyRegion", new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B infoRegionBackgroundColor(Color COLOR) {
        this.properties.put("infoRegionBackgroundColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B infoRegionForegroundColor(Color COLOR) {
        this.properties.put("infoRegionForegroundColor", new SimpleObjectProperty<Color>(COLOR));
        return (B)this;
    }

    public final B infoRegionTooltipText(String TEXT) {
        this.properties.put("infoRegionTooltipText", new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B showInfoRegion(boolean SHOW) {
        this.properties.put("showInfoRegion", new SimpleBooleanProperty(SHOW));
        return (B)this;
    }

    public final B leftText(String TEXT) {
        this.properties.put("leftText", new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B middleText(String TEXT) {
        this.properties.put("middleText", new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B rightText(String TEXT) {
        this.properties.put("rightText", new SimpleStringProperty(TEXT));
        return (B)this;
    }

    public final B leftValue(double VALUE) {
        this.properties.put("leftValue", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B middleValue(double VALUE) {
        this.properties.put("middleValue", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B rightValue(double VALUE) {
        this.properties.put("rightValue", new SimpleDoubleProperty(VALUE));
        return (B)this;
    }

    public final B leftGraphics(Node NODE) {
        this.properties.put("leftGraphics", new SimpleObjectProperty<Node>(NODE));
        return (B)this;
    }

    public final B middleGraphics(Node NODE) {
        this.properties.put("middleGraphics", new SimpleObjectProperty<Node>(NODE));
        return (B)this;
    }

    public final B rightGraphics(Node NODE) {
        this.properties.put("rightGraphics", new SimpleObjectProperty<Node>(NODE));
        return (B)this;
    }

    public final B trendVisible(boolean VISIBLE) {
        this.properties.put("trendVisible", new SimpleBooleanProperty(VISIBLE));
        return (B)this;
    }

    public final B timeoutMs(long TIMEOUT_MS) {
        this.properties.put("timeoutMs", new SimpleLongProperty(TIMEOUT_MS));
        return (B)this;
    }

    public final B numberOfValuesForTrendCalculation(int NUMBER) {
        this.properties.put("numberOfValuesForTrendCalculation", new SimpleIntegerProperty(NUMBER));
        return (B)this;
    }

    public final B backgroundImage(Image IMAGE) {
        this.properties.put("backgroundImage", new SimpleObjectProperty<Image>(IMAGE));
        return (B)this;
    }

    public final B backgroundImageOpacity(double OPACITY) {
        this.properties.put("backgroundImageOpacity", new SimpleDoubleProperty(OPACITY));
        return (B)this;
    }

    public final B backgroundImageKeepAspect(boolean KEEP_ASPECT) {
        this.properties.put("backgroundImageKeepAspect", new SimpleBooleanProperty(KEEP_ASPECT));
        return (B)this;
    }

    public final B infoRegionEventHandler(EventHandler<MouseEvent> HANDLER) {
        this.properties.put("infoRegionEventHandler", new SimpleObjectProperty<EventHandler<MouseEvent>>(HANDLER));
        return (B)this;
    }

    public final B prefSize(double WIDTH, double HEIGHT) {
        this.properties.put("prefSize", new SimpleObjectProperty<Dimension2D>(new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B minSize(double WIDTH, double HEIGHT) {
        this.properties.put("minSize", new SimpleObjectProperty<Dimension2D>(new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B maxSize(double WIDTH, double HEIGHT) {
        this.properties.put("maxSize", new SimpleObjectProperty<Dimension2D>(new Dimension2D(WIDTH, HEIGHT)));
        return (B)this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", new SimpleDoubleProperty(PREF_WIDTH));
        return (B)this;
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)this;
    }

    public final B minWidth(double MIN_WIDTH) {
        this.properties.put("minWidth", new SimpleDoubleProperty(MIN_WIDTH));
        return (B)this;
    }

    public final B minHeight(double MIN_HEIGHT) {
        this.properties.put("minHeight", new SimpleDoubleProperty(MIN_HEIGHT));
        return (B)this;
    }

    public final B maxWidth(double MAX_WIDTH) {
        this.properties.put("maxWidth", new SimpleDoubleProperty(MAX_WIDTH));
        return (B)this;
    }

    public final B maxHeight(double MAX_HEIGHT) {
        this.properties.put("maxHeight", new SimpleDoubleProperty(MAX_HEIGHT));
        return (B)this;
    }

    public final B scaleX(double SCALE_X) {
        this.properties.put("scaleX", new SimpleDoubleProperty(SCALE_X));
        return (B)this;
    }

    public final B scaleY(double SCALE_Y) {
        this.properties.put("scaleY", new SimpleDoubleProperty(SCALE_Y));
        return (B)this;
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", new SimpleDoubleProperty(LAYOUT_X));
        return (B)this;
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", new SimpleDoubleProperty(LAYOUT_Y));
        return (B)this;
    }

    public final B translateX(double TRANSLATE_X) {
        this.properties.put("translateX", new SimpleDoubleProperty(TRANSLATE_X));
        return (B)this;
    }

    public final B translateY(double TRANSLATE_Y) {
        this.properties.put("translateY", new SimpleDoubleProperty(TRANSLATE_Y));
        return (B)this;
    }

    public final B padding(Insets INSETS) {
        this.properties.put("padding", new SimpleObjectProperty<Insets>(INSETS));
        return (B)this;
    }

    public final Tile build() {
        Tile TILE;
        if (this.properties.containsKey("skinType")) {
            Tile.SkinType skinType = (Tile.SkinType)((Object)((ObjectProperty)this.properties.get("skinType")).get());
            TILE = new Tile(skinType);
            switch (skinType) {
                case SMOOTHED_CHART: {
                    break;
                }
                case BAR_CHART: {
                    break;
                }
                case CLOCK: {
                    break;
                }
                case GAUGE: {
                    TILE.setAnimated(true);
                    TILE.setTickLabelDecimals(0);
                    TILE.setBarColor(Tile.FOREGROUND);
                    TILE.setThresholdColor(Tile.BLUE);
                    TILE.setThresholdVisible(true);
                    break;
                }
                case HIGH_LOW: {
                    TILE.setMaxValue(Double.MAX_VALUE);
                    TILE.setDecimals(2);
                    TILE.setTickLabelDecimals(1);
                    break;
                }
                case PERCENTAGE: {
                    TILE.setAnimated(true);
                    TILE.setThresholdColor(Tile.GRAY);
                    TILE.setTickLabelDecimals(0);
                    break;
                }
                case PLUS_MINUS: {
                    break;
                }
                case SLIDER: {
                    TILE.setBarBackgroundColor(Tile.FOREGROUND);
                    break;
                }
                case SPARK_LINE: {
                    TILE.setTextVisible(false);
                    TILE.setAnimated(false);
                    TILE.setAveragingEnabled(true);
                    TILE.setAveragingPeriod(10);
                    TILE.setDecimals(0);
                    TILE.setTickLabelDecimals(0);
                    break;
                }
                case SWITCH: {
                    break;
                }
                case WORLDMAP: {
                    TILE.setPrefSize(380.0, 250.0);
                    break;
                }
                case TIMER_CONTROL: {
                    TILE.setSectionsVisible(true);
                    TILE.setHighlightSections(true);
                    TILE.setCheckSectionsForValue(true);
                    break;
                }
                case NUMBER: {
                    break;
                }
                case TEXT: {
                    break;
                }
                case WEATHER: {
                    break;
                }
                case TIME: {
                    break;
                }
                case CUSTOM: {
                    break;
                }
                case LEADER_BOARD: {
                    break;
                }
                case MAP: {
                    break;
                }
                case RADIAL_CHART: {
                    TILE.setAnimated(true);
                    break;
                }
                case DONUT_CHART: {
                    TILE.setAnimated(true);
                    break;
                }
                case CIRCULAR_PROGRESS: {
                    TILE.setBarBackgroundColor(TILE.getBackgroundColor().brighter());
                    TILE.setAnimated(true);
                    break;
                }
                case STOCK: {
                    TILE.setAnimated(false);
                    TILE.setAveragingPeriod(720);
                    TILE.setAveragingEnabled(true);
                    TILE.setDecimals(2);
                    TILE.setTickLabelDecimals(2);
                    TILE.setThresholdColor(Tile.GRAY);
                    TILE.setTextVisible(false);
                    break;
                }
                case GAUGE_SPARK_LINE: {
                    TILE.setBarColor(Tile.BLUE);
                    TILE.setAngleRange(270.0);
                    break;
                }
                case SMOOTH_AREA_CHART: {
                    TILE.setSmoothing(true);
                    TILE.setChartType(Tile.ChartType.AREA);
                    break;
                }
                case RADAR_CHART: {
                    break;
                }
                case RADAR_NODE_CHART: {
                    break;
                }
                case COUNTRY: {
                    break;
                }
                case EPHEMERIS: {
                    break;
                }
                case CHARACTER: {
                    break;
                }
                case FLIP: {
                    break;
                }
                case SWITCH_SLIDER: {
                    TILE.setBarBackgroundColor(Tile.FOREGROUND);
                    break;
                }
                case DATE: {
                    TILE.setTitleAlignment(TextAlignment.CENTER);
                    TILE.setTextAlignment(TextAlignment.CENTER);
                    break;
                }
                case CALENDAR: {
                    TILE.setTitleAlignment(TextAlignment.CENTER);
                    TILE.setTextAlignment(TextAlignment.CENTER);
                    break;
                }
                case SUNBURST: {
                    break;
                }
                case MATRIX: {
                    break;
                }
                case RADIAL_PERCENTAGE: {
                    TILE.setBarBackgroundColor(TILE.getBackgroundColor().brighter());
                    TILE.setAnimated(true);
                    break;
                }
                case STATUS: {
                    TILE.setDescriptionAlignment(Pos.TOP_CENTER);
                    break;
                }
                case BAR_GAUGE: {
                    TILE.setBarBackgroundColor(Tile.BACKGROUND.brighter());
                    TILE.setBarColor(Tile.BLUE);
                    TILE.setAngleRange(180.0);
                    TILE.setTickLabelDecimals(0);
                    break;
                }
                case IMAGE: {
                    TILE.setTextAlignment(TextAlignment.CENTER);
                    break;
                }
                case IMAGE_COUNTER: {
                    TILE.setTextAlignment(TextAlignment.LEFT);
                    TILE.setDecimals(0);
                    break;
                }
                case TIMELINE: {
                    TILE.setDataPointsVisible(true);
                    TILE.setTextVisible(false);
                    TILE.setAnimated(false);
                    TILE.setAveragingEnabled(true);
                    TILE.setAveragingPeriod(Helper.calcNumberOfDatapointsForPeriod(TILE.getTimePeriod(), TILE.getTimePeriodResolution()));
                    TILE.setDecimals(0);
                    TILE.setTickLabelDecimals(0);
                    break;
                }
                case CLUSTER_MONITOR: {
                    TILE.setTitle("");
                    TILE.setTextVisible(false);
                    TILE.setUnit("%");
                    TILE.setAnimated(false);
                    TILE.setDecimals(0);
                    TILE.setBarColor(Tile.BLUE);
                    break;
                }
                case LED: {
                    TILE.setActiveColor(Bright.GREEN);
                    break;
                }
                case COUNTDOWN_TIMER: {
                    TILE.setBarBackgroundColor(TILE.getBackgroundColor().brighter());
                    TILE.setAnimated(false);
                    TILE.setTimePeriod(Duration.ofSeconds(60L));
                    break;
                }
            }
        } else {
            TILE = new Tile();
        }
        if (this.properties.keySet().contains("sectionsArray")) {
            TILE.setSections((Section[])((ObjectProperty)this.properties.get("sectionsArray")).get());
        }
        if (this.properties.keySet().contains("sectionsList")) {
            TILE.setSections((List)((ObjectProperty)this.properties.get("sectionsList")).get());
        }
        if (this.properties.keySet().contains("characterArray")) {
            TILE.setCharacters((String[])((ObjectProperty)this.properties.get("characterArray")).get());
        }
        if (this.properties.keySet().contains("foregroundBaseColor")) {
            TILE.setForegroundBaseColor((Color)((ObjectProperty)this.properties.get("foregroundBaseColor")).get());
        }
        if (this.properties.keySet().contains("maxValue")) {
            TILE.setMaxValue(((DoubleProperty)this.properties.get("maxValue")).get());
        }
        if (this.properties.keySet().contains("minValue")) {
            TILE.setMinValue(((DoubleProperty)this.properties.get("minValue")).get());
        }
        if (this.properties.keySet().contains("alarmsArray")) {
            TILE.setAlarms((Alarm[])((ObjectProperty)this.properties.get("alarmsArray")).get());
        }
        if (this.properties.keySet().contains("alarmsList")) {
            TILE.setAlarms((List)((ObjectProperty)this.properties.get("alarmsList")).get());
        }
        if (this.properties.keySet().contains("timeSectionsArray")) {
            TILE.setTimeSections((TimeSection[])((ObjectProperty)this.properties.get("timeSectionsArray")).get());
        }
        if (this.properties.keySet().contains("timeSectionsList")) {
            TILE.setTimeSections((List)((ObjectProperty)this.properties.get("timeSectionsList")).get());
        }
        if (this.properties.keySet().contains("seriesArray")) {
            TILE.setSeries((XYChart.Series[])((ObjectProperty)this.properties.get("seriesArray")).get());
        }
        if (this.properties.keySet().contains("seriesList")) {
            TILE.setSeries((List)((ObjectProperty)this.properties.get("seriesList")).get());
        }
        if (this.properties.keySet().contains("tilesFxSeriesArray")) {
            TILE.setTilesFXSeries((TilesFXSeries[])((ObjectProperty)this.properties.get("tilesFxSeriesArray")).get());
        }
        if (this.properties.keySet().contains("tilesFxSeriesList")) {
            TILE.setTilesFXSeries((List)((ObjectProperty)this.properties.get("tilesFxSeriesList")).get());
        }
        if (this.properties.keySet().contains("barChartItemsArray")) {
            TILE.setBarChartItems((BarChartItem[])((ObjectProperty)this.properties.get("barChartItemsArray")).get());
        }
        if (this.properties.keySet().contains("barChartItemsList")) {
            TILE.setBarChartItems((List)((ObjectProperty)this.properties.get("barChartItemsList")).get());
        }
        if (this.properties.keySet().contains("leaderBoardItemsArray")) {
            TILE.setLeaderBoardItems((LeaderBoardItem[])((ObjectProperty)this.properties.get("leaderBoardItemsArray")).get());
        }
        if (this.properties.keySet().contains("leaderBoardItemsList")) {
            TILE.setLeaderBoardItems((List)((ObjectProperty)this.properties.get("leaderBoardItemsList")).get());
        }
        if (this.properties.keySet().contains("gradientStopsArray")) {
            TILE.setGradientStops((Stop[])((ObjectProperty)this.properties.get("gradientStopsArray")).get());
        }
        if (this.properties.keySet().contains("gradientStopsList")) {
            TILE.setGradientStops((List)((ObjectProperty)this.properties.get("gradientStopsList")).get());
        }
        if (this.properties.keySet().contains("chartDataArray")) {
            TILE.setChartData((ChartData[])((ObjectProperty)this.properties.get("chartDataArray")).get());
        }
        if (this.properties.keySet().contains("chartDataList")) {
            TILE.setChartData((List)((ObjectProperty)this.properties.get("chartDataList")).get());
        }
        if (this.properties.keySet().contains("poiArray")) {
            TILE.setPoiLocations((Location[])((ObjectProperty)this.properties.get("poiArray")).get());
        }
        if (this.properties.keySet().contains("poiList")) {
            TILE.setPoiList((List)((ObjectProperty)this.properties.get("poiList")).get());
        }
        if (this.properties.keySet().contains("trackArray")) {
            TILE.setTrack((Location[])((ObjectProperty)this.properties.get("trackArray")).get());
        }
        if (this.properties.keySet().contains("trackList")) {
            TILE.setTrack((List)((ObjectProperty)this.properties.get("trackList")).get());
        }
        for (String key : this.properties.keySet()) {
            if ("prefSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                TILE.setPrefSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("minSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                TILE.setMinSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("maxSize".equals(key)) {
                Dimension2D dim = (Dimension2D)((ObjectProperty)this.properties.get(key)).get();
                TILE.setMaxSize(dim.getWidth(), dim.getHeight());
                continue;
            }
            if ("prefWidth".equals(key)) {
                TILE.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                TILE.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minWidth".equals(key)) {
                TILE.setMinWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minHeight".equals(key)) {
                TILE.setMinHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxWidth".equals(key)) {
                TILE.setMaxWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxHeight".equals(key)) {
                TILE.setMaxHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleX".equals(key)) {
                TILE.setScaleX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("scaleY".equals(key)) {
                TILE.setScaleY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                TILE.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutY".equals(key)) {
                TILE.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateX".equals(key)) {
                TILE.setTranslateX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("translateY".equals(key)) {
                TILE.setTranslateY(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("padding".equals(key)) {
                TILE.setPadding((Insets)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("styleClass".equals(key)) {
                TILE.getStyleClass().setAll((String[])new String[]{"tile"});
                TILE.getStyleClass().addAll((String[])((String[])((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("autoScale".equals(key)) {
                TILE.setAutoScale(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("value".equals(key)) {
                TILE.setValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("decimals".equals(key)) {
                TILE.setDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelDecimals".equals(key)) {
                TILE.setTickLabelDecimals(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("title".equals(key)) {
                TILE.setTitle((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("titleAlignment".equals(key)) {
                TILE.setTitleAlignment((TextAlignment)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("description".equals(key)) {
                TILE.setDescription((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("descriptionAlignment".equals(key)) {
                TILE.setDescriptionAlignment((Pos)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("unit".equals(key)) {
                TILE.setUnit((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("flatUI".equals(key)) {
                TILE.setFlatUI(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("selected".equals(key)) {
                TILE.setActive(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("averagingEnabled".equals(key)) {
                TILE.setAveragingEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("averagingPeriod".equals(key)) {
                TILE.setAveragingPeriod(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timePeriod".equals(key)) {
                TILE.setTimePeriod((Duration)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxTimePeriod".equals(key)) {
                TILE.setMaxTimePeriod((Duration)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timePeriodResolution".equals(key)) {
                TILE.setTimePeriodResolution((TimeUnit)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("startFromZero".equals(key)) {
                TILE.setStartFromZero(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("returnToZero".equals(key)) {
                TILE.setReturnToZero(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minMeasuredValueVisible".equals(key)) {
                TILE.setMinMeasuredValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("maxMeasuredValueVisible".equals(key)) {
                TILE.setMaxMeasuredValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("oldValueVisible".equals(key)) {
                TILE.setOldValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("valueVisible".equals(key)) {
                TILE.setValueVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("foregroundColor".equals(key)) {
                TILE.setForegroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundColor".equals(key)) {
                TILE.setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("borderColor".equals(key)) {
                TILE.setBorderColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("borderWidth".equals(key)) {
                TILE.setBorderWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("knobColor".equals(key)) {
                TILE.setKnobColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("animated".equals(key)) {
                TILE.setAnimated(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("animationDuration".equals(key)) {
                TILE.setAnimationDuration(((LongProperty)this.properties.get(key)).get());
                continue;
            }
            if ("startAngle".equals(key)) {
                TILE.setStartAngle(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("angleRange".equals(key)) {
                TILE.setAngleRange(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("needleColor".equals(key)) {
                TILE.setNeedleColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("barColor".equals(key)) {
                TILE.setBarColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("barBackgroundColor".equals(key)) {
                TILE.setBarBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("locale".equals(key)) {
                TILE.setLocale((Locale)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("numberFormat".equals(key)) {
                TILE.setNumberFormat((NumberFormat)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("shadowsEnabled".equals(key)) {
                TILE.setShadowsEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("style".equals(key)) {
                TILE.setStyle((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("innerShadowEnabled".equals(key)) {
                TILE.setInnerShadowEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("thresholdVisible".equals(key)) {
                TILE.setThresholdVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerThresholdVisible".equals(key)) {
                TILE.setLowerThresholdVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("averageVisible".equals(key)) {
                TILE.setAverageVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sectionsVisible".equals(key)) {
                TILE.setSectionsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sectionsAlwaysVisible".equals(key)) {
                TILE.setSectionsAlwaysVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sectionTextVisible".equals(key)) {
                TILE.setSectionTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sectionIconsVisible".equals(key)) {
                TILE.setSectionIconsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("highlightSections".equals(key)) {
                TILE.setHighlightSections(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("titleColor".equals(key)) {
                TILE.setTitleColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("descriptionColor".equals(key)) {
                TILE.setDescriptionColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("unitColor".equals(key)) {
                TILE.setUnitColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("valueColor".equals(key)) {
                TILE.setValueColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("thresholdColor".equals(key)) {
                TILE.setThresholdColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerThresholdColor".equals(key)) {
                TILE.setLowerThresholdColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("orientation".equals(key)) {
                TILE.setOrientation((Orientation)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("checkSectionsForValue".equals(key)) {
                TILE.setCheckSectionsForValue(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("checkThreshold".equals(key)) {
                TILE.setCheckThreshold(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("checkLowerThreshold".equals(key)) {
                TILE.setCheckLowerThreshold(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onValueChanged".equals(key)) {
                TILE.currentValueProperty().addListener((InvalidationListener)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("keepAspect".equals(key)) {
                TILE.setKeepAspect(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("threshold".equals(key)) {
                TILE.setThreshold(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("lowerThreshold".equals(key)) {
                TILE.setLowerThreshold(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("referenceValue".equals(key)) {
                TILE.setReferenceValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("autoReferenceValue".equals(key)) {
                TILE.setAutoReferenceValue(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("customFontEnabled".equals(key)) {
                TILE.setCustomFontEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("customFont".equals(key)) {
                TILE.setCustomFont((Font)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("customDecimalFormatEnabled".equals(key)) {
                TILE.setCustomDecimalFormatEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("customDecimalFormat".equals(key)) {
                TILE.setCustomDecimalFormat((DecimalFormat)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("alertMessage".equals(key)) {
                TILE.setAlertMessage((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("smoothing".equals(key)) {
                TILE.setSmoothing(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("time".equals(key)) {
                TILE.setTime((ZonedDateTime)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("text".equals(key)) {
                TILE.setText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textAlignment".equals(key)) {
                TILE.setTextAlignment((TextAlignment)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("discreteSeconds".equals(key)) {
                TILE.setDiscreteSeconds(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("discreteMinutes".equals(key)) {
                TILE.setDiscreteMinutes(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("discreteHours".equals(key)) {
                TILE.setDiscreteHours(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("secondsVisible".equals(key)) {
                TILE.setSecondsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textVisible".equals(key)) {
                TILE.setTextVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("dateVisible".equals(key)) {
                TILE.setDateVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textColor".equals(key)) {
                TILE.setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("dateColor".equals(key)) {
                TILE.setDateColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("hourTickMarkColor".equals(key)) {
                TILE.setHourTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minuteTickMarkColor".equals(key)) {
                TILE.setMinuteTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("alarmColor".equals(key)) {
                TILE.setAlarmColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickLabelColor".equals(key)) {
                TILE.setTickLabelColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("tickMarkColor".equals(key)) {
                TILE.setTickMarkColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("hourTickMarksVisible".equals(key)) {
                TILE.setHourTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minuteTickMarksVisible".equals(key)) {
                TILE.setMinuteTickMarksVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("hourColor".equals(key)) {
                TILE.setHourColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minuteColor".equals(key)) {
                TILE.setMinuteColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("secondColor".equals(key)) {
                TILE.setSecondColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onAlarm".equals(key)) {
                TILE.setOnAlarm((AlarmEventListener)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onTimeEvent".equals(key)) {
                TILE.setOnTimeEvent((TimeEventListener)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("onTileEvent".equals(key)) {
                TILE.setOnTileEvent((TileEventListener)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("alarmsEnabled".equals(key)) {
                TILE.setAlarmsEnabled(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("alarmsVisible".equals(key)) {
                TILE.setAlarmsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("running".equals(key)) {
                TILE.setRunning(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("increment".equals(key)) {
                TILE.setIncrement(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("activeColor".equals(key)) {
                TILE.setActiveColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("darkSky".equals(key)) {
                TILE.setDarkSky((DarkSky)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("duration".equals(key)) {
                TILE.setDuration((LocalTime)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("strokeWithGradient".equals(key)) {
                TILE.setStrokeWithGradient(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("fillWithGradient".equals(key)) {
                TILE.setFillWithGradient(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("image".equals(key)) {
                TILE.setImage((Image)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("imageMask".equals(key)) {
                TILE.setImageMask((Tile.ImageMask)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("graphic".equals(key)) {
                TILE.setGraphic((Node)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("svgPath".equals(key)) {
                TILE.setSVGPath((SVGPath)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("roundedCorners".equals(key)) {
                TILE.setRoundedCorners(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("textSize".equals(key)) {
                TILE.setTextSize((Tile.TextSize)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("currentLocation".equals(key)) {
                TILE.setCurrentLocation((Location)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("trackColor".equals(key)) {
                TILE.setTrackColor((Tile.TileColor)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("mapProvider".equals(key)) {
                TILE.setMapProvider((Tile.MapProvider)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("tooltipText".equals(key)) {
                TILE.setTooltipText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("xAxis".equals(key)) {
                TILE.setXAxis((Axis)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("yAxis".equals(key)) {
                TILE.setYAxis((Axis)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("radarChartMode".equals(key)) {
                TILE.setRadarChartMode((RadarChartMode)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("chartGridColor".equals(key)) {
                TILE.setChartGridColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("country".equals(key)) {
                TILE.setCountry((Country)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("countryGroup".equals(key)) {
                TILE.setCountryGroup((CountryGroup)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sortedData".equals(key)) {
                TILE.setSortedData(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("flipTimeInMS".equals(key)) {
                TILE.setFlipTimeInMS(((LongProperty)this.properties.get(key)).get());
                continue;
            }
            if ("flipText".equals(key)) {
                TILE.setFlipText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("dataPointsVisible".equals(key)) {
                TILE.setDataPointsVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstTree".equals(key)) {
                TILE.getSunburstChart().setTree((TreeNode)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstBackgroundColor".equals(key)) {
                TILE.getSunburstChart().setBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstTextColor".equals(key)) {
                TILE.getSunburstChart().setTextColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstUseColorFromParent".equals(key)) {
                TILE.getSunburstChart().setUseColorFromParent(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstTextOrientation".equals(key)) {
                TILE.getSunburstChart().setTextOrientation((SunburstChart.TextOrientation)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("sunburstVisibleData".equals(key)) {
                TILE.getSunburstChart().setVisibleData((SunburstChart.VisibleData)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("sunburstInteractive".equals(key)) {
                TILE.getSunburstChart().setInteractive(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstAutoTextColor".equals(key)) {
                TILE.getSunburstChart().setAutoTextColor(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("sunburstUseChartDataTextColor".equals(key)) {
                TILE.getSunburstChart().setUseChartDataTextColor(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("snapToTicks".equals(key)) {
                TILE.setSnapToTicks(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("minorTickCount".equals(key)) {
                TILE.setMinorTickCount(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("majorTickUnit".equals(key)) {
                TILE.setMajorTickUnit(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("matrixSize".equals(key)) {
                int COLS = ((IntegerProperty)this.properties.get("matrixColumns")).get();
                int ROWS = ((IntegerProperty)this.properties.get("matrixRows")).get();
                TILE.setMatrixSize(COLS, ROWS);
                continue;
            }
            if ("chartType".equals(key)) {
                TILE.setChartType((Tile.ChartType)((Object)((ObjectProperty)this.properties.get(key)).get()));
                continue;
            }
            if ("tooltipTimeout".equals(key)) {
                TILE.setTooltipTimeout(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("notifyRegionBackgroundColor".equals(key)) {
                TILE.setNotifyRegionBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("notifyRegionForegroundColor".equals(key)) {
                TILE.setNotifyRegionForegroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("showNotifyRegion".equals(key)) {
                TILE.showNotifyRegion(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("infoRegionBackgroundColor".equals(key)) {
                TILE.setInfoRegionBackgroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("infoRegionForegroundColor".equals(key)) {
                TILE.setInfoRegionForegroundColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("showInfoRegion".equals(key)) {
                TILE.showInfoRegion(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("leftText".equals(key)) {
                TILE.setLeftText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("middleText".equals(key)) {
                TILE.setMiddleText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("rightText".equals(key)) {
                TILE.setRightText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if ("leftValue".equals(key)) {
                TILE.setLeftValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("middleValue".equals(key)) {
                TILE.setMiddleValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("rightValue".equals(key)) {
                TILE.setRightValue(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("leftGraphics".equals(key)) {
                TILE.setLeftGraphics((Node)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("middleGraphics".equals(key)) {
                TILE.setMiddleGraphics((Node)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("rightGraphics".equals(key)) {
                TILE.setRightGraphics((Node)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("trendVisible".equals(key)) {
                TILE.setTrendVisible(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("timeoutMs".equals(key)) {
                TILE.setTimeoutMs(((LongProperty)this.properties.get(key)).get());
                continue;
            }
            if ("numberOfValuesForTrendCalculation".equals(key)) {
                TILE.setNumberOfValuesForTrendCalculation(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundImage".equals(key)) {
                TILE.setBackgroundImage((Image)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundImageOpacity".equals(key)) {
                TILE.setBackgroundImageOpacity(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("backgroundImageKeepAspect".equals(key)) {
                TILE.setBackgroundImageKeepAspect(((BooleanProperty)this.properties.get(key)).get());
                continue;
            }
            if ("infoRegionEventHandler".equals(key)) {
                TILE.setInfoRegionEventHandler((EventHandler)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("infoRegionTooltipText".equals(key)) {
                TILE.setInfoRegionTooltipText((String)((StringProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"notifyRegionTooltipText".equals(key)) continue;
            TILE.setNotifyRegionTooltipText((String)((StringProperty)this.properties.get(key)).get());
        }
        this.properties.clear();
        return TILE;
    }
}

