/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filmlisten;

import java.util.Objects;
import mediathek.config.Konstanten;
import mediathek.daten.ListeFilme;
import mediathek.filmlisten.FilmListDownloadType;
import mediathek.filmlisten.IAction;
import mediathek.filmlisten.IDownloadAction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class FilmeImportierenAutoThread
extends Thread {
    private static final Logger logger = LogManager.getLogger(FilmeImportierenAutoThread.class);
    private final ListeFilme listeFilme;
    private final ListeFilme listeFilmeDiff;
    private final int days;
    private final IAction onFinished;
    private final IDownloadAction downloadAction;

    public FilmeImportierenAutoThread(ListeFilme listeFilme, ListeFilme listeFilmeDiff, int days, IDownloadAction downloadAction, IAction onFinished) {
        this.listeFilme = listeFilme;
        this.listeFilmeDiff = listeFilmeDiff;
        this.days = days;
        this.onFinished = onFinished;
        this.downloadAction = downloadAction;
        this.setName("FilmeImportierenAutoThread");
    }

    @Override
    public void run() {
        boolean ret;
        if (this.listeFilme.isEmpty() || !this.listeFilme.metaData().canUseDiffList()) {
            this.listeFilme.clear();
            ret = this.downloadAction.performDownload(this.getFilmListUrl(FilmListDownloadType.FULL), this.listeFilme, this.days);
        } else {
            ret = this.downloadAction.performDownload(this.getFilmListUrl(FilmListDownloadType.DIFF_ONLY), this.listeFilmeDiff, this.days);
            if (!ret || this.listeFilmeDiff.isEmpty()) {
                this.listeFilme.clear();
                this.listeFilmeDiff.clear();
                ret = this.downloadAction.performDownload(this.getFilmListUrl(FilmListDownloadType.FULL), this.listeFilme, this.days);
            }
        }
        if (!ret) {
            logger.warn("Es konnten keine Filme geladen werden!");
        }
        this.onFinished.onFinished(ret);
    }

    private String getFilmListUrl(FilmListDownloadType state) {
        String urlStr = null;
        switch (state) {
            case FULL: {
                urlStr = Objects.requireNonNull(Konstanten.ROUTER_BASE_URL.resolve("Filmliste-akt.xz")).toString();
                break;
            }
            case DIFF_ONLY: {
                urlStr = Objects.requireNonNull(Konstanten.ROUTER_BASE_URL.resolve("Filmliste-diff.xz")).toString();
            }
        }
        return urlStr;
    }
}

