/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.gui.messages.ButtonPanelVisibilityChangedEvent;
import mediathek.gui.tabs.tab_film.BeobOpenPlayer;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.Listener;
import net.engio.mbassy.listener.Handler;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;
import org.jetbrains.annotations.NotNull;

public final class SwingButtonPanelController {
    private final GuiFilme guiFilme;
    private final JPanel contentPanel = new JPanel();
    private final JPanel buttonsPanel = new JPanel();
    private final GridBagLayout gridbag = new GridBagLayout();
    private final Insets DEFAULT_INSETS = new Insets(4, 10, 4, 10);
    private final GridBagConstraints c = new GridBagConstraints();
    private final Configuration config = ApplicationConfiguration.getConfiguration();
    private final SpinnerNumberModel columnModel = new SpinnerNumberModel(4, 2, 10, 1);
    private ListePset listeButton;

    public SwingButtonPanelController(@NotNull GuiFilme guiFilme, @NotNull JPanel parent) {
        this.guiFilme = guiFilme;
        this.createContentPanel(parent);
        this.createCloseButton();
        this.createButtonsPanel();
        int initialColumns = this.config.getInt("application.buttons_panel.max_visible", 4);
        this.columnModel.setValue(initialColumns);
        this.columnModel.addChangeListener(e -> {
            int columns = (Integer)this.columnModel.getValue();
            this.config.setProperty("application.buttons_panel.max_visible", columns);
            this.setupButtons();
        });
        this.buttonsPanel.setComponentPopupMenu(this.createPopupMenu());
        this.setupButtons();
        Daten.getInstance().getMessageBus().subscribe(this);
        Listener.addListener(new Listener(2, SwingButtonPanelController.class.getSimpleName()){

            @Override
            public void ping() {
                SwingButtonPanelController.this.setupButtons();
            }
        });
        this.contentPanel.setVisible(this.config.getBoolean("application.buttons_panel.visible", false));
        SwingUtilities.invokeLater(() -> this.contentPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SwingButtonPanelController.this.config.setProperty("application.buttons_panel.visible", true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                SwingButtonPanelController.this.config.setProperty("application.buttons_panel.visible", false);
            }
        }));
    }

    @Handler
    private void handleButtonPanelVisibilityChanged(ButtonPanelVisibilityChangedEvent evt) {
        SwingUtilities.invokeLater(() -> this.contentPanel.setVisible(evt.visible));
    }

    private void createContentPanel(JPanel parent) {
        this.contentPanel.setBorder(new LineBorder(new Color(153, 153, 153)));
        this.contentPanel.setLayout(new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill(), new AC().grow().fill()));
        parent.add((Component)this.contentPanel, new CC().cell(0, 1));
    }

    private void createButtonsPanel() {
        this.buttonsPanel.setLayout(this.gridbag);
        this.contentPanel.add((Component)this.buttonsPanel, new CC().cell(1, 0));
    }

    private void createCloseButton() {
        JButton btnClose = new JButton();
        btnClose.setToolTipText("Buttons ausblenden");
        btnClose.setFocusable(false);
        btnClose.setFocusPainted(false);
        btnClose.setRequestFocusEnabled(false);
        btnClose.setBorderPainted(false);
        btnClose.setIcon(IconFontSwing.buildIcon(FontAwesome.TIMES_CIRCLE_O, 16.0f));
        btnClose.addActionListener(e -> {
            boolean visibility = false;
            this.config.setProperty("application.buttons_panel.visible", false);
            Daten.getInstance().getMessageBus().publishAsync(new ButtonPanelVisibilityChangedEvent(false));
        });
        this.contentPanel.add((Component)btnClose, new CC().pad("5 5 3 3").cell(0, 0).alignX("left").alignY("top").grow(0.0f, 0.0f).width("20:20:20").height("20:20:20"));
    }

    private void initConstraints() {
        this.c.weightx = 0.0;
        this.c.fill = 2;
        this.c.insets = this.DEFAULT_INSETS;
    }

    private JLabel createLabel(@NotNull String psetName, Color psetColor, int row, int col) {
        JLabel label = new JLabel(psetName);
        if (psetColor != null) {
            label.setForeground(psetColor);
        }
        this.c.gridx = col;
        this.c.gridy = row;
        this.gridbag.setConstraints(label, this.c);
        return label;
    }

    private JButton createButton(@NotNull DatenPset pset, @NotNull String psetName, Color psetColor, int row, int col) {
        JButton button = new JButton(psetName);
        button.addActionListener(new BeobOpenPlayer(this.guiFilme, pset));
        if (psetColor != null) {
            button.setBackground(psetColor);
        }
        this.c.gridx = col;
        this.c.gridy = row;
        this.gridbag.setConstraints(button, this.c);
        return button;
    }

    private void addExtraFeld(int i, int spalte, int zeile) {
        DatenPset pset = (DatenPset)this.listeButton.get(i);
        String psetName = pset.arr[0];
        Color psetColor = pset.getFarbe();
        if (pset.isLabel()) {
            this.buttonsPanel.add(this.createLabel(psetName, psetColor, zeile, spalte));
        } else {
            this.buttonsPanel.add(this.createButton(pset, psetName, psetColor, zeile, spalte));
        }
    }

    private void setupButtons() {
        this.buttonsPanel.removeAll();
        int maxColumns = ApplicationConfiguration.getConfiguration().getInt("application.buttons_panel.max_visible", 4);
        this.initConstraints();
        int spalte = 0;
        int zeile = 0;
        this.listeButton = Daten.listePset.getListeButton();
        for (int i = 0; i < this.listeButton.size(); ++i) {
            if (!((DatenPset)this.listeButton.get(i)).isFreeLine()) {
                this.addExtraFeld(i, spalte, zeile);
            }
            if (++spalte <= maxColumns - 1) continue;
            spalte = 0;
            ++zeile;
        }
        JLabel label = new JLabel();
        this.c.weightx = 10.0;
        this.c.gridx = maxColumns + 1;
        this.c.gridy = 0;
        this.gridbag.setConstraints(label, this.c);
        this.buttonsPanel.add(label);
        this.buttonsPanel.updateUI();
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JSpinner jSpinner = new JSpinner(this.columnModel);
        jSpinner.setToolTipText("Damit kann die Anzahl der Button ver\u00e4ndert werden");
        JPanel jPanelAnzahl = new JPanel();
        jPanelAnzahl.setLayout(new BorderLayout());
        jPanelAnzahl.add((Component)new JLabel("Anzahl Button je Zeile: "), "West");
        jPanelAnzahl.add((Component)jSpinner, "East");
        jPopupMenu.add(jPanelAnzahl);
        return jPopupMenu;
    }
}

