/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.beanutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.beanutils.BeanDeclaration;
import org.apache.commons.configuration2.beanutils.ConstructorArg;

public class CombinedBeanDeclaration
implements BeanDeclaration {
    private final List<BeanDeclaration> childDeclarations;

    public CombinedBeanDeclaration(BeanDeclaration ... decl) {
        this.childDeclarations = new ArrayList<BeanDeclaration>(Arrays.asList(decl));
    }

    @Override
    public String getBeanFactoryName() {
        for (BeanDeclaration d : this.childDeclarations) {
            String factoryName = d.getBeanFactoryName();
            if (factoryName == null) continue;
            return factoryName;
        }
        return null;
    }

    @Override
    public Object getBeanFactoryParameter() {
        for (BeanDeclaration d : this.childDeclarations) {
            Object factoryParam = d.getBeanFactoryParameter();
            if (factoryParam == null) continue;
            return factoryParam;
        }
        return null;
    }

    @Override
    public String getBeanClassName() {
        for (BeanDeclaration d : this.childDeclarations) {
            String beanClassName = d.getBeanClassName();
            if (beanClassName == null) continue;
            return beanClassName;
        }
        return null;
    }

    @Override
    public Map<String, Object> getBeanProperties() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = this.childDeclarations.size() - 1; i >= 0; --i) {
            Map<String, Object> props = this.childDeclarations.get(i).getBeanProperties();
            if (props == null) continue;
            result.putAll(props);
        }
        return result;
    }

    @Override
    public Map<String, Object> getNestedBeanDeclarations() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = this.childDeclarations.size() - 1; i >= 0; --i) {
            Map<String, Object> decls = this.childDeclarations.get(i).getNestedBeanDeclarations();
            if (decls == null) continue;
            result.putAll(decls);
        }
        return result;
    }

    @Override
    public Collection<ConstructorArg> getConstructorArgs() {
        for (BeanDeclaration d : this.childDeclarations) {
            Collection<ConstructorArg> args2 = d.getConstructorArgs();
            if (args2 == null || args2.isEmpty()) continue;
            return args2;
        }
        return Collections.emptyList();
    }
}

