/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import cc.arduino.utils.network.HttpConnectionManager;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;

public class BoardCloudResolver {
    private static Logger log = LogManager.getLogger(BoardCloudResolver.class);

    public synchronized void getBoardBy(String vid, String pid) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            URL jsonUrl = new URL(String.format("https://builder.arduino.cc/builder/v1/boards/0x%s/0x%s", vid, pid));
            HttpURLConnection httpConnection = new HttpConnectionManager(jsonUrl).makeConnection();
            int code = httpConnection.getResponseCode();
            if (code == 404) {
                log.warn("Fail to get the Vid Pid information from the builder response code={}", (Object)code);
                return;
            }
            InputStream is = httpConnection.getInputStream();
            BoardCloudAPIid board = (BoardCloudAPIid)mapper.readValue(is, BoardCloudAPIid.class);
            log.info("Board info from the cloud {}", (Object)board);
            String realBoardName = board.getName().replaceAll("\\(.*?\\)", "").trim();
            String boardNameReplaced = realBoardName.replaceAll(" ", "&");
            String message = I18n.format(I18n.tr("{0}Install this package{1} to use your {2} board"), "<a href=\"http://boardsmanager/all#" + boardNameReplaced + "\">", "</a>", realBoardName);
            BaseNoGui.setBoardManagerLink(message);
        }
        catch (Exception e) {
            log.warn("Error during get board information by vid, pid", (Throwable)e);
        }
    }

    public String resolveDeviceByBoardID(Map<String, TargetPackage> packages, String boardId) {
        assert (packages != null);
        assert (boardId != null);
        for (TargetPackage targetPackage : packages.values()) {
            for (TargetPlatform targetPlatform : targetPackage.getPlatforms().values()) {
                for (TargetBoard board : targetPlatform.getBoards().values()) {
                    if (!boardId.equals(board.getId())) continue;
                    return board.getName();
                }
            }
        }
        return null;
    }

    private static class BoardCloudAPIid {
        private String fqbn;
        private String name;
        private String architecture;
        private String id;

        private BoardCloudAPIid() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String tmp) {
            this.name = tmp;
        }

        public String getFqbn() {
            return this.fqbn;
        }

        public void setFqbn(String fqbn) {
            this.fqbn = fqbn;
        }

        public String getArchitecture() {
            return this.architecture;
        }

        public void setArchitecture(String tmp) {
            this.architecture = tmp;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String tmp) {
            this.id = tmp;
        }

        public String toString() {
            return "BoardCloudAPIid{name='" + this.name + '\'' + ", fqbn='" + this.fqbn + '\'' + ", architecture='" + this.architecture + '\'' + ", id='" + this.id + '\'' + '}';
        }
    }
}

