/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.number;

import java.math.MathContext;
import java.math.RoundingMode;
import org.python.icu.impl.number.Format;
import org.python.icu.impl.number.FormatQuantity;
import org.python.icu.impl.number.ModifierHolder;
import org.python.icu.impl.number.Properties;
import org.python.icu.impl.number.RoundingUtils;

public abstract class Rounder
extends Format.BeforeFormat {
    protected final MathContext mathContext;
    protected final int minInt;
    protected final int maxInt;
    protected final int minFrac;
    protected final int maxFrac;

    protected Rounder(IBasicRoundingProperties properties) {
        this.mathContext = RoundingUtils.getMathContextOrUnlimited(properties);
        int _maxInt = properties.getMaximumIntegerDigits();
        int _minInt = properties.getMinimumIntegerDigits();
        int _maxFrac = properties.getMaximumFractionDigits();
        int _minFrac = properties.getMinimumFractionDigits();
        if (_minInt == 0 && _maxFrac != 0) {
            int n = this.minFrac = _minFrac <= 0 ? 1 : _minFrac;
            this.maxFrac = _maxFrac < 0 ? Integer.MAX_VALUE : (_maxFrac < this.minFrac ? this.minFrac : _maxFrac);
            this.minInt = 0;
            this.maxInt = _maxInt < 0 ? Integer.MAX_VALUE : _maxInt;
        } else {
            int n = this.minFrac = _minFrac < 0 ? 0 : _minFrac;
            this.maxFrac = _maxFrac < 0 ? Integer.MAX_VALUE : (_maxFrac < this.minFrac ? this.minFrac : _maxFrac);
            int n2 = this.minInt = _minInt <= 0 ? 1 : _minInt;
            this.maxInt = _maxInt < 0 ? Integer.MAX_VALUE : (_maxInt < this.minInt ? this.minInt : _maxInt);
        }
    }

    public abstract void apply(FormatQuantity var1);

    public int chooseMultiplierAndApply(FormatQuantity input, MultiplierGenerator mg) {
        FormatQuantity copy = input.createCopy();
        int magnitude = input.getMagnitude();
        int multiplier = mg.getMultiplier(magnitude);
        input.adjustMagnitude(multiplier);
        this.apply(input);
        if (input.getMagnitude() == magnitude + multiplier + 1) {
            input.copyFrom(copy);
            multiplier = mg.getMultiplier(++magnitude);
            input.adjustMagnitude(multiplier);
            assert (input.getMagnitude() == magnitude + multiplier - 1);
            this.apply(input);
            assert (input.getMagnitude() == magnitude + multiplier);
        }
        return multiplier;
    }

    protected void applyDefaults(FormatQuantity input) {
        input.setIntegerFractionLength(this.minInt, this.maxInt, this.minFrac, this.maxFrac);
    }

    @Override
    public void before(FormatQuantity input, ModifierHolder mods) {
        this.apply(input);
    }

    @Override
    public void export(Properties properties) {
        properties.setMathContext(this.mathContext);
        properties.setRoundingMode(this.mathContext.getRoundingMode());
        properties.setMinimumFractionDigits(this.minFrac);
        properties.setMinimumIntegerDigits(this.minInt);
        properties.setMaximumFractionDigits(this.maxFrac);
        properties.setMaximumIntegerDigits(this.maxInt);
    }

    public static interface MultiplierGenerator {
        public int getMultiplier(int var1);
    }

    public static interface IBasicRoundingProperties {
        public static final int DEFAULT_MINIMUM_INTEGER_DIGITS = -1;
        public static final int DEFAULT_MAXIMUM_INTEGER_DIGITS = -1;
        public static final int DEFAULT_MINIMUM_FRACTION_DIGITS = -1;
        public static final int DEFAULT_MAXIMUM_FRACTION_DIGITS = -1;
        public static final RoundingMode DEFAULT_ROUNDING_MODE = null;
        public static final MathContext DEFAULT_MATH_CONTEXT = null;

        public int getMinimumIntegerDigits();

        public IBasicRoundingProperties setMinimumIntegerDigits(int var1);

        public int getMaximumIntegerDigits();

        public IBasicRoundingProperties setMaximumIntegerDigits(int var1);

        public int getMinimumFractionDigits();

        public IBasicRoundingProperties setMinimumFractionDigits(int var1);

        public int getMaximumFractionDigits();

        public IBasicRoundingProperties setMaximumFractionDigits(int var1);

        public RoundingMode getRoundingMode();

        public IBasicRoundingProperties setRoundingMode(RoundingMode var1);

        public MathContext getMathContext();

        public IBasicRoundingProperties setMathContext(MathContext var1);
    }
}

