/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.SessionTrackingMode;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyotePrincipal;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.AsyncContextImpl;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.SessionConfig;
import org.apache.catalina.util.URLEncoder;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.res.StringManager;

public class CoyoteAdapter
implements Adapter {
    private static final Log log = LogFactory.getLog(CoyoteAdapter.class);
    private static final String POWERED_BY = "Servlet/3.0 JSP/2.2 (" + ServerInfo.getServerInfo() + " Java/" + System.getProperty("java.vm.vendor") + "/" + System.getProperty("java.runtime.version") + ")";
    private static final EnumSet<SessionTrackingMode> SSL_ONLY = EnumSet.of(SessionTrackingMode.SSL);
    public static final int ADAPTER_NOTES = 1;
    protected static final boolean ALLOW_BACKSLASH = Boolean.parseBoolean(System.getProperty("org.apache.catalina.connector.CoyoteAdapter.ALLOW_BACKSLASH", "false"));
    private static final ThreadLocal<String> THREAD_NAME = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return Thread.currentThread().getName();
        }
    };
    private Connector connector = null;
    protected static final StringManager sm = StringManager.getManager(CoyoteAdapter.class);
    protected static URLEncoder urlEncoder = new URLEncoder();

    public CoyoteAdapter(Connector connector) {
        this.connector = connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean event(org.apache.coyote.Request request, org.apache.coyote.Response response, SocketStatus socketStatus) {
        Request request2 = (Request)request.getNote(1);
        Response response2 = (Response)response.getNote(1);
        if (request2.getWrapper() == null) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (socketStatus == SocketStatus.OPEN_READ) {
                if (response2.isClosed()) {
                    request2.getEvent().setEventType(CometEvent.EventType.END);
                    request2.getEvent().setEventSubType(null);
                } else {
                    try {
                        if (request2.read()) {
                            bl2 = true;
                        }
                    }
                    catch (IOException iOException) {
                        bl = true;
                    }
                    if (bl2) {
                        request2.getEvent().setEventType(CometEvent.EventType.READ);
                        request2.getEvent().setEventSubType(null);
                    } else if (bl) {
                        request2.getEvent().setEventType(CometEvent.EventType.ERROR);
                        request2.getEvent().setEventSubType(CometEvent.EventSubType.CLIENT_DISCONNECT);
                    } else {
                        request2.getEvent().setEventType(CometEvent.EventType.END);
                        request2.getEvent().setEventSubType(null);
                    }
                }
            } else if (socketStatus == SocketStatus.DISCONNECT) {
                request2.getEvent().setEventType(CometEvent.EventType.ERROR);
                request2.getEvent().setEventSubType(CometEvent.EventSubType.CLIENT_DISCONNECT);
                bl = true;
            } else if (socketStatus == SocketStatus.ERROR) {
                request2.getEvent().setEventType(CometEvent.EventType.ERROR);
                request2.getEvent().setEventSubType(CometEvent.EventSubType.IOEXCEPTION);
                bl = true;
            } else if (socketStatus == SocketStatus.STOP) {
                request2.getEvent().setEventType(CometEvent.EventType.END);
                request2.getEvent().setEventSubType(CometEvent.EventSubType.SERVER_SHUTDOWN);
            } else if (socketStatus == SocketStatus.TIMEOUT) {
                if (response2.isClosed()) {
                    request2.getEvent().setEventType(CometEvent.EventType.END);
                    request2.getEvent().setEventSubType(null);
                } else {
                    request2.getEvent().setEventType(CometEvent.EventType.ERROR);
                    request2.getEvent().setEventSubType(CometEvent.EventSubType.TIMEOUT);
                }
            }
            request.getRequestProcessor().setWorkerThreadName(Thread.currentThread().getName());
            this.connector.getService().getContainer().getPipeline().getFirst().event(request2, response2, request2.getEvent());
            if (!bl && !response2.isClosed() && request2.getAttribute("javax.servlet.error.exception") != null) {
                request2.getEvent().setEventType(CometEvent.EventType.ERROR);
                request2.getEvent().setEventSubType(null);
                bl = true;
                this.connector.getService().getContainer().getPipeline().getFirst().event(request2, response2, request2.getEvent());
            }
            if (response2.isClosed() || !request2.isComet()) {
                if (socketStatus == SocketStatus.OPEN_READ && request2.getEvent().getEventType() != CometEvent.EventType.END) {
                    request2.getEvent().setEventType(CometEvent.EventType.END);
                    request2.getEvent().setEventSubType(null);
                    bl = true;
                    this.connector.getService().getContainer().getPipeline().getFirst().event(request2, response2, request2.getEvent());
                }
                response.action(ActionCode.COMET_END, null);
            } else if (!bl && bl2 && request2.getAvailable()) {
                request2.getEvent().setEventType(CometEvent.EventType.ERROR);
                request2.getEvent().setEventSubType(CometEvent.EventSubType.IOEXCEPTION);
                bl = true;
                this.connector.getService().getContainer().getPipeline().getFirst().event(request2, response2, request2.getEvent());
            }
            boolean bl3 = !bl;
            return bl3;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            if (!(throwable instanceof IOException)) {
                log.error((Object)sm.getString("coyoteAdapter.service"), throwable);
            }
            bl = true;
            boolean bl4 = false;
            return bl4;
        }
        finally {
            request.getRequestProcessor().setWorkerThreadName(null);
            if (bl || response2.isClosed() || !request2.isComet()) {
                ((Context)request2.getMappingData().context).logAccess(request2, response2, System.currentTimeMillis() - request.getStartTime(), false);
                request2.recycle();
                request2.setFilterChain(null);
                response2.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean asyncDispatch(org.apache.coyote.Request request, org.apache.coyote.Response response, SocketStatus socketStatus) throws Exception {
        Request request2 = (Request)request.getNote(1);
        Response response2 = (Response)response.getNote(1);
        if (request2 == null) {
            throw new IllegalStateException(sm.getString("coyoteAdapter.nullRequest"));
        }
        boolean bl = false;
        boolean bl2 = true;
        AsyncContextImpl asyncContextImpl = request2.getAsyncContextInternal();
        request.getRequestProcessor().setWorkerThreadName(THREAD_NAME.get());
        try {
            Throwable throwable;
            if (!request2.isAsync() && !bl) {
                response2.setSuspended(false);
            }
            if (socketStatus == SocketStatus.TIMEOUT) {
                if (!asyncContextImpl.timeout()) {
                    asyncContextImpl.setErrorState(null, false);
                }
            } else if (socketStatus == SocketStatus.ERROR) {
                bl2 = false;
                throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
                request.getAttributes().remove("javax.servlet.error.exception");
                if (throwable != null) {
                    asyncContextImpl.setErrorState(throwable, true);
                }
            }
            if (!request2.isAsyncDispatching() && request2.isAsync() && response2.isErrorReportRequired()) {
                this.connector.getService().getContainer().getPipeline().getFirst().invoke(request2, response2);
            }
            if (request2.isAsyncDispatching()) {
                this.connector.getService().getContainer().getPipeline().getFirst().invoke(request2, response2);
                throwable = (Throwable)request2.getAttribute("javax.servlet.error.exception");
                if (throwable != null) {
                    asyncContextImpl.setErrorState(throwable, true);
                }
            }
            if (request2.isComet()) {
                if (!response2.isClosed() && !response2.isError()) {
                    if (request2.getAvailable() || request2.getContentLength() > 0 && !request2.isParametersParsed()) {
                        if (!this.event(request, response, SocketStatus.OPEN_READ)) {
                            boolean bl3 = false;
                            return bl3;
                        }
                        bl = true;
                        response.action(ActionCode.COMET_BEGIN, null);
                    } else {
                        bl = true;
                        response.action(ActionCode.COMET_BEGIN, null);
                    }
                } else {
                    request2.setFilterChain(null);
                }
            }
            if (!request2.isAsync() && !bl) {
                try {
                    request2.finishRequest();
                    response2.finishResponse();
                }
                finally {
                    long l = 0L;
                    if (request.getStartTime() != -1L) {
                        l = System.currentTimeMillis() - request.getStartTime();
                    }
                    if (request2.getMappingData().context != null) {
                        ((Context)request2.getMappingData().context).logAccess(request2, response2, l, false);
                    } else {
                        this.log(request, response, l);
                    }
                    request.action(ActionCode.POST_REQUEST, null);
                }
            }
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            response.action(ActionCode.IS_ERROR, (Object)atomicBoolean);
            if (!atomicBoolean.get()) return bl2;
            if (request2.isAsyncCompleting()) {
                response.action(ActionCode.ASYNC_POST_PROCESS, null);
            }
            bl2 = false;
            return bl2;
        }
        catch (IOException iOException) {
            bl2 = false;
            return bl2;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            bl2 = false;
            log.error((Object)sm.getString("coyoteAdapter.asyncDispatch"), throwable);
            return bl2;
        }
        finally {
            request.getRequestProcessor().setWorkerThreadName(null);
            if (!bl2 || !bl && !request2.isAsync()) {
                request2.recycle();
                response2.recycle();
            } else {
                request2.clearEncoders();
                response2.clearEncoders();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(org.apache.coyote.Request request, org.apache.coyote.Response response) throws Exception {
        Request request2 = (Request)request.getNote(1);
        Response response2 = (Response)response.getNote(1);
        if (request2 == null) {
            request2 = this.connector.createRequest();
            request2.setCoyoteRequest(request);
            response2 = this.connector.createResponse();
            response2.setCoyoteResponse(response);
            request2.setResponse(response2);
            response2.setRequest(request2);
            request.setNote(1, (Object)request2);
            response.setNote(1, (Object)response2);
            request.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        }
        if (this.connector.getXpoweredBy()) {
            response2.addHeader("X-Powered-By", POWERED_BY);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        request.getRequestProcessor().setWorkerThreadName(THREAD_NAME.get());
        try {
            bl3 = this.postParseRequest(request, request2, response, response2);
            if (bl3) {
                request2.setAsyncSupported(this.connector.getService().getContainer().getPipeline().isAsyncSupported());
                this.connector.getService().getContainer().getPipeline().getFirst().invoke(request2, response2);
                if (request2.isComet()) {
                    if (!response2.isClosed() && !response2.isError()) {
                        if (request2.getAvailable() || request2.getContentLength() > 0 && !request2.isParametersParsed()) {
                            if (!this.event(request, response, SocketStatus.OPEN_READ)) return;
                            bl = true;
                            response.action(ActionCode.COMET_BEGIN, null);
                        } else {
                            bl = true;
                            response.action(ActionCode.COMET_BEGIN, null);
                        }
                    } else {
                        request2.setFilterChain(null);
                    }
                }
            }
            if (request2.isAsync()) {
                bl2 = true;
                Serializable serializable = (Throwable)request2.getAttribute("javax.servlet.error.exception");
                if (request2.isAsyncCompleting() || serializable == null) return;
                request2.getAsyncContextInternal().setErrorState((Throwable)serializable, true);
                return;
            }
            if (bl) return;
            try {
                request2.finishRequest();
                response2.finishResponse();
                return;
            }
            finally {
                if (bl3) {
                    ((Context)request2.getMappingData().context).logAccess(request2, response2, System.currentTimeMillis() - request.getStartTime(), false);
                }
                request.action(ActionCode.POST_REQUEST, null);
            }
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            response.action(ActionCode.IS_ERROR, (Object)atomicBoolean);
            if (request2.isAsyncCompleting() && atomicBoolean.get()) {
                response.action(ActionCode.ASYNC_POST_PROCESS, null);
                bl2 = false;
            }
            request.getRequestProcessor().setWorkerThreadName(null);
            if (!bl && !bl2) {
                request2.recycle();
                response2.recycle();
            } else {
                request2.clearEncoders();
                response2.clearEncoders();
            }
        }
    }

    public void errorDispatch(org.apache.coyote.Request request, org.apache.coyote.Response response) {
        Request request2 = (Request)request.getNote(1);
        Response response2 = (Response)response.getNote(1);
        if (request2 != null && request2.getMappingData().context != null) {
            ((Context)request2.getMappingData().context).logAccess(request2, response2, System.currentTimeMillis() - request.getStartTime(), false);
        } else {
            this.log(request, response, System.currentTimeMillis() - request.getStartTime());
        }
        if (request2 != null) {
            request2.recycle();
        }
        if (response2 != null) {
            response2.recycle();
        }
        request.recycle();
        response.recycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(org.apache.coyote.Request request, org.apache.coyote.Response response, long l) {
        Request request2 = (Request)request.getNote(1);
        Response response2 = (Response)response.getNote(1);
        if (request2 == null) {
            request2 = this.connector.createRequest();
            request2.setCoyoteRequest(request);
            response2 = this.connector.createResponse();
            response2.setCoyoteResponse(response);
            request2.setResponse(response2);
            response2.setRequest(request2);
            request.setNote(1, (Object)request2);
            response.setNote(1, (Object)response2);
            request.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        }
        try {
            boolean bl = false;
            if (request2.mappingData != null) {
                if (request2.mappingData.context != null) {
                    bl = true;
                    ((Context)request2.mappingData.context).logAccess(request2, response2, l, true);
                } else if (request2.mappingData.host != null) {
                    bl = true;
                    ((Host)request2.mappingData.host).logAccess(request2, response2, l, true);
                }
            }
            if (!bl) {
                this.connector.getService().getContainer().logAccess(request2, response2, l, true);
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            log.warn((Object)sm.getString("coyoteAdapter.accesslogFail"), throwable);
        }
        finally {
            request2.recycle();
            response2.recycle();
        }
    }

    public void checkRecycled(org.apache.coyote.Request request, org.apache.coyote.Response response) {
        Request request2 = (Request)request.getNote(1);
        Response response2 = (Response)response.getNote(1);
        String string = null;
        if (request2 != null && request2.getHost() != null) {
            string = "coyoteAdapter.checkRecycled.request";
        } else if (response2 != null && response2.getContentWritten() != 0L) {
            string = "coyoteAdapter.checkRecycled.response";
        }
        if (string != null) {
            this.log(request, response, 0L);
            if (this.connector.getState().isAvailable()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)sm.getString(string), (Throwable)new RecycleRequiredException());
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString(string), (Throwable)new RecycleRequiredException());
            }
        }
    }

    public String getDomain() {
        return this.connector.getDomain();
    }

    protected boolean postParseRequest(org.apache.coyote.Request request, Request request2, org.apache.coyote.Response response, Response response2) throws Exception {
        Object object;
        Object[] objectArray;
        Object object2;
        MessageBytes messageBytes;
        if (request.scheme().isNull()) {
            request.scheme().setString(this.connector.getScheme());
            request2.setSecure(this.connector.getSecure());
        } else {
            request2.setSecure(request.scheme().equals("https"));
        }
        String string = this.connector.getProxyName();
        int n = this.connector.getProxyPort();
        if (n != 0) {
            request.setServerPort(n);
        } else if (request.getServerPort() == -1) {
            if (request.scheme().equals("https")) {
                request.setServerPort(443);
            } else {
                request.setServerPort(80);
            }
        }
        if (string != null) {
            request.serverName().setString(string);
        }
        MessageBytes messageBytes2 = request.decodedURI();
        messageBytes2.duplicate(request.requestURI());
        this.parsePathParameters(request, request2);
        try {
            request.getURLDecoder().convert(messageBytes2.getByteChunk(), this.connector.getEncodedSolidusHandlingInternal());
        }
        catch (IOException iOException) {
            response.setStatus(400);
            response.setMessage("Invalid URI: " + iOException.getMessage());
            this.connector.getService().getContainer().logAccess(request2, response2, 0L, true);
            return false;
        }
        if (!CoyoteAdapter.normalize(request.decodedURI())) {
            response.setStatus(400);
            response.setMessage("Invalid URI");
            this.connector.getService().getContainer().logAccess(request2, response2, 0L, true);
            return false;
        }
        this.convertURI(messageBytes2, request2);
        if (!CoyoteAdapter.checkNormalize(request.decodedURI())) {
            response.setStatus(400);
            response.setMessage("Invalid URI character encoding");
            this.connector.getService().getContainer().logAccess(request2, response2, 0L, true);
            return false;
        }
        if (this.connector.getUseIPVHosts()) {
            messageBytes = request.localName();
            if (messageBytes.isNull()) {
                response.action(ActionCode.REQ_LOCAL_NAME_ATTRIBUTE, null);
            }
        } else {
            messageBytes = request.serverName();
        }
        if (request2.isAsyncStarted()) {
            request2.getMappingData().recycle();
        }
        String string2 = null;
        Object object3 = null;
        boolean bl = true;
        while (bl) {
            this.connector.getMapper().map(messageBytes, messageBytes2, string2, request2.getMappingData());
            request2.setContext((Context)request2.getMappingData().context);
            request2.setWrapper((Wrapper)request2.getMappingData().wrapper);
            if (request2.getContext() == null) {
                response.setStatus(404);
                object2 = request2.getHost();
                if (object2 != null) {
                    object2.logAccess(request2, response2, 0L, true);
                }
                return false;
            }
            if (request2.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.URL) && (object2 = request2.getPathParameter(SessionConfig.getSessionUriParamName(request2.getContext()))) != null) {
                request2.setRequestedSessionId((String)object2);
                request2.setRequestedSessionURL(true);
            }
            try {
                this.parseSessionCookiesId(request, request2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!response2.isError()) {
                    response2.setError();
                    response2.sendError(400);
                }
                return false;
            }
            this.parseSessionSslId(request2);
            object2 = request2.getRequestedSessionId();
            bl = false;
            if (string2 == null || request2.getContext() != object3) {
                string2 = null;
                object3 = null;
                objectArray = request2.getMappingData().contexts;
                if (objectArray != null && object2 != null) {
                    for (int i = objectArray.length; i > 0; --i) {
                        object = (Context)objectArray[i - 1];
                        if (object.getManager().findSession((String)object2) == null) continue;
                        if (object.equals(request2.getMappingData().context)) break;
                        string2 = object.getWebappVersion();
                        object3 = object;
                        request2.getMappingData().recycle();
                        bl = true;
                        request2.recycleSessionInfo();
                        break;
                    }
                }
            }
            if (bl || !request2.getContext().getPaused()) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            request2.getMappingData().recycle();
            bl = true;
        }
        object2 = request2.getMappingData().redirectPath;
        if (!object2.isNull()) {
            objectArray = urlEncoder.encode(object2.toString(), "UTF-8");
            String string3 = request2.getQueryString();
            if (request2.isRequestedSessionIdFromURL()) {
                objectArray = (String)objectArray + ";" + SessionConfig.getSessionUriParamName(request2.getContext()) + "=" + request2.getRequestedSessionId();
            }
            if (string3 != null) {
                objectArray = (String)objectArray + "?" + string3;
            }
            response2.sendRedirect((String)objectArray);
            request2.getContext().logAccess(request2, response2, 0L, true);
            return false;
        }
        if (!this.connector.getAllowTrace() && request.method().equalsIgnoreCase("TRACE")) {
            objectArray = request2.getWrapper();
            String string4 = null;
            if (objectArray != null && (object = objectArray.getServletMethods()) != null) {
                for (String string5 : object) {
                    if ("TRACE".equals(string5)) continue;
                    string4 = string4 == null ? string5 : string4 + ", " + string5;
                }
            }
            response.setStatus(405);
            if (string4 != null) {
                response.addHeader("Allow", string4);
            }
            response.setMessage("TRACE method is not allowed");
            request2.getContext().logAccess(request2, response2, 0L, true);
            return false;
        }
        this.doConnectorAuthenticationAuthorization(request, request2);
        return true;
    }

    private void doConnectorAuthenticationAuthorization(org.apache.coyote.Request request, Request request2) {
        Object object;
        String string = request.getRemoteUser().toString();
        if (string != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("coyoteAdapter.authenticate", new Object[]{string}));
            }
            if (request.getRemoteUserNeedsAuthorization()) {
                object = request2.getContext().getAuthenticator();
                if (object == null) {
                    request2.setUserPrincipal(new CoyotePrincipal(string));
                } else if (!(object instanceof AuthenticatorBase)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("coyoteAdapter.authorize", new Object[]{string}));
                    }
                    request2.setUserPrincipal(request2.getContext().getRealm().authenticate(string));
                }
            } else {
                request2.setUserPrincipal(new CoyotePrincipal(string));
            }
        }
        if ((object = request.getAuthType().toString()) != null) {
            request2.setAuthType((String)object);
        }
    }

    protected void parsePathParameters(org.apache.coyote.Request request, Request request2) {
        request.decodedURI().toBytes();
        ByteChunk byteChunk = request.decodedURI().getByteChunk();
        int n = byteChunk.indexOf(';', 0);
        if (n == -1) {
            return;
        }
        String string = this.connector.getURIEncoding();
        if (string == null) {
            string = "ISO-8859-1";
        }
        Charset charset = null;
        try {
            charset = B2CConverter.getCharset((String)string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.warn((Object)sm.getString("coyoteAdapter.parsePathParam", new Object[]{string}));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"uriBC", byteChunk.toString()}));
            log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"semicolon", String.valueOf(n)}));
            log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"enc", string}));
        }
        while (n > -1) {
            int n2;
            int n3 = byteChunk.getStart();
            int n4 = byteChunk.getEnd();
            int n5 = n + 1;
            int n6 = ByteChunk.findBytes((byte[])byteChunk.getBuffer(), (int)(n3 + n5), (int)n4, (byte[])new byte[]{59, 47});
            String string2 = null;
            if (n6 >= 0) {
                if (charset != null) {
                    string2 = new String(byteChunk.getBuffer(), n3 + n5, n6 - n5, charset);
                }
                byte[] byArray = byteChunk.getBuffer();
                for (int i = 0; i < n4 - n3 - n6; ++i) {
                    byArray[n3 + n + i] = byArray[n3 + i + n6];
                }
                byteChunk.setBytes(byArray, n3, n4 - n3 - n6 + n);
            } else {
                if (charset != null) {
                    string2 = new String(byteChunk.getBuffer(), n3 + n5, n4 - n3 - n5, charset);
                }
                byteChunk.setEnd(n3 + n);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"pathParamStart", String.valueOf(n5)}));
                log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"pathParamEnd", String.valueOf(n6)}));
                log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"pv", string2}));
            }
            if (string2 != null && (n2 = string2.indexOf(61)) > -1) {
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1);
                request2.addPathParameter(string3, string4);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"equals", String.valueOf(n2)}));
                    log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"name", string3}));
                    log.debug((Object)sm.getString("coyoteAdapter.debug", new Object[]{"value", string4}));
                }
            }
            n = byteChunk.indexOf(';', n);
        }
    }

    protected void parseSessionSslId(Request request) {
        String string;
        if (request.getRequestedSessionId() == null && SSL_ONLY.equals(request.getServletContext().getEffectiveSessionTrackingModes()) && request.connector.secure && (string = (String)request.getAttribute("javax.servlet.request.ssl_session_id")) != null) {
            request.setRequestedSessionId(string);
            request.setRequestedSessionSSL(true);
        }
    }

    protected void parseSessionCookiesId(org.apache.coyote.Request request, Request request2) {
        Context context = (Context)request2.getMappingData().context;
        if (context != null && !context.getServletContext().getEffectiveSessionTrackingModes().contains(SessionTrackingMode.COOKIE)) {
            return;
        }
        Cookies cookies = request.getCookies();
        int n = cookies.getCookieCount();
        if (n <= 0) {
            return;
        }
        String string = SessionConfig.getSessionCookieName(context);
        for (int i = 0; i < n; ++i) {
            ServerCookie serverCookie = cookies.getCookie(i);
            if (!serverCookie.getName().equals(string)) continue;
            if (!request2.isRequestedSessionIdFromCookie()) {
                this.convertMB(serverCookie.getValue());
                request2.setRequestedSessionId(serverCookie.getValue().toString());
                request2.setRequestedSessionCookie(true);
                request2.setRequestedSessionURL(false);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)(" Requested cookie session id is " + request2.getRequestedSessionId()));
                continue;
            }
            if (request2.isRequestedSessionIdValid()) continue;
            this.convertMB(serverCookie.getValue());
            request2.setRequestedSessionId(serverCookie.getValue().toString());
        }
    }

    protected void convertURI(MessageBytes messageBytes, Request request) throws Exception {
        Object object;
        ByteChunk byteChunk = messageBytes.getByteChunk();
        int n = byteChunk.getLength();
        CharChunk charChunk = messageBytes.getCharChunk();
        charChunk.allocate(n, -1);
        String string = this.connector.getURIEncoding();
        if (string != null) {
            object = request.getURIConverter();
            try {
                if (object == null) {
                    object = new B2CConverter(string, true);
                    request.setURIConverter((B2CConverter)object);
                } else {
                    object.recycle();
                }
            }
            catch (IOException iOException) {
                log.error((Object)"Invalid URI encoding; using HTTP default");
                this.connector.setURIEncoding(null);
            }
            if (object != null) {
                try {
                    object.convert(byteChunk, charChunk, true);
                    messageBytes.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
                    return;
                }
                catch (IOException iOException) {
                    request.getResponse().sendError(400);
                }
            }
        }
        object = byteChunk.getBuffer();
        char[] cArray = charChunk.getBuffer();
        int n2 = byteChunk.getStart();
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(object[i + n2] & 0xFF);
        }
        messageBytes.setChars(cArray, 0, n);
    }

    protected void convertMB(MessageBytes messageBytes) {
        if (messageBytes.getType() != 2) {
            return;
        }
        ByteChunk byteChunk = messageBytes.getByteChunk();
        CharChunk charChunk = messageBytes.getCharChunk();
        int n = byteChunk.getLength();
        charChunk.allocate(n, -1);
        byte[] byArray = byteChunk.getBuffer();
        char[] cArray = charChunk.getBuffer();
        int n2 = byteChunk.getStart();
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(byArray[i + n2] & 0xFF);
        }
        messageBytes.setChars(cArray, 0, n);
    }

    public static boolean normalize(MessageBytes messageBytes) {
        int n;
        ByteChunk byteChunk = messageBytes.getByteChunk();
        byte[] byArray = byteChunk.getBytes();
        int n2 = byteChunk.getStart();
        if (n2 == (n = byteChunk.getEnd())) {
            return false;
        }
        int n3 = 0;
        int n4 = 0;
        if (byArray[n2] != 47 && byArray[n2] != 92) {
            return false;
        }
        for (n3 = n2; n3 < n; ++n3) {
            if (byArray[n3] == 92) {
                if (ALLOW_BACKSLASH) {
                    byArray[n3] = 47;
                    continue;
                }
                return false;
            }
            if (byArray[n3] != 0) continue;
            return false;
        }
        for (n3 = n2; n3 < n - 1; ++n3) {
            if (byArray[n3] != 47) continue;
            while (n3 + 1 < n && byArray[n3 + 1] == 47) {
                CoyoteAdapter.copyBytes(byArray, n3, n3 + 1, n - n3 - 1);
                --n;
            }
        }
        if (n - n2 >= 2 && byArray[n - 1] == 46 && (byArray[n - 2] == 47 || byArray[n - 2] == 46 && byArray[n - 3] == 47)) {
            byArray[n] = 47;
            ++n;
        }
        byteChunk.setEnd(n);
        n4 = 0;
        while ((n4 = byteChunk.indexOf("/./", 0, 3, n4)) >= 0) {
            CoyoteAdapter.copyBytes(byArray, n2 + n4, n2 + n4 + 2, n - n2 - n4 - 2);
            byteChunk.setEnd(n -= 2);
        }
        n4 = 0;
        while ((n4 = byteChunk.indexOf("/../", 0, 4, n4)) >= 0) {
            if (n4 == 0) {
                return false;
            }
            int n5 = -1;
            for (n3 = n2 + n4 - 1; n3 >= 0 && n5 < 0; --n3) {
                if (byArray[n3] != 47) continue;
                n5 = n3;
            }
            CoyoteAdapter.copyBytes(byArray, n2 + n5, n2 + n4 + 3, n - n2 - n4 - 3);
            n = n + n5 - n4 - 3;
            byteChunk.setEnd(n);
            n4 = n5;
        }
        return true;
    }

    public static boolean checkNormalize(MessageBytes messageBytes) {
        CharChunk charChunk = messageBytes.getCharChunk();
        char[] cArray = charChunk.getChars();
        int n = charChunk.getStart();
        int n2 = charChunk.getEnd();
        int n3 = 0;
        for (n3 = n; n3 < n2; ++n3) {
            if (cArray[n3] == '\\') {
                return false;
            }
            if (cArray[n3] != '\u0000') continue;
            return false;
        }
        for (n3 = n; n3 < n2 - 1; ++n3) {
            if (cArray[n3] != '/' || cArray[n3 + 1] != '/') continue;
            return false;
        }
        if (n2 - n >= 2 && cArray[n2 - 1] == '.' && (cArray[n2 - 2] == '/' || cArray[n2 - 2] == '.' && cArray[n2 - 3] == '/')) {
            return false;
        }
        if (charChunk.indexOf("/./", 0, 3, 0) >= 0) {
            return false;
        }
        return charChunk.indexOf("/../", 0, 4, 0) < 0;
    }

    protected static void copyBytes(byte[] byArray, int n, int n2, int n3) {
        System.arraycopy(byArray, n2, byArray, n, n3);
    }

    static {
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
    }

    private static class RecycleRequiredException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private RecycleRequiredException() {
        }
    }
}

