/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.apache.el.lang.ELSupport;
import org.apache.el.util.MessageFactory;

public abstract class ELArithmetic {
    public static final BigDecimalDelegate BIGDECIMAL = new BigDecimalDelegate();
    public static final BigIntegerDelegate BIGINTEGER = new BigIntegerDelegate();
    public static final DoubleDelegate DOUBLE = new DoubleDelegate();
    public static final LongDelegate LONG = new LongDelegate();
    private static final Long ZERO = 0L;

    public static final Number add(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0L;
        }
        ELArithmetic eLArithmetic = BIGDECIMAL.matches(object, object2) ? BIGDECIMAL : (DOUBLE.matches(object, object2) ? (BIGINTEGER.matches(object, object2) ? BIGDECIMAL : DOUBLE) : (BIGINTEGER.matches(object, object2) ? BIGINTEGER : LONG));
        Number number = eLArithmetic.coerce(object);
        Number number2 = eLArithmetic.coerce(object2);
        return ((ELArithmetic)eLArithmetic).add(number, number2);
    }

    public static final Number mod(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0L;
        }
        ELArithmetic eLArithmetic = BIGDECIMAL.matches(object, object2) ? DOUBLE : (DOUBLE.matches(object, object2) ? DOUBLE : (BIGINTEGER.matches(object, object2) ? BIGINTEGER : LONG));
        Number number = eLArithmetic.coerce(object);
        Number number2 = eLArithmetic.coerce(object2);
        return ((ELArithmetic)eLArithmetic).mod(number, number2);
    }

    public static final Number subtract(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0L;
        }
        ELArithmetic eLArithmetic = BIGDECIMAL.matches(object, object2) ? BIGDECIMAL : (DOUBLE.matches(object, object2) ? (BIGINTEGER.matches(object, object2) ? BIGDECIMAL : DOUBLE) : (BIGINTEGER.matches(object, object2) ? BIGINTEGER : LONG));
        Number number = eLArithmetic.coerce(object);
        Number number2 = eLArithmetic.coerce(object2);
        return ((ELArithmetic)eLArithmetic).subtract(number, number2);
    }

    public static final Number divide(Object object, Object object2) {
        if (object == null && object2 == null) {
            return ZERO;
        }
        ELArithmetic eLArithmetic = BIGDECIMAL.matches(object, object2) ? BIGDECIMAL : (BIGINTEGER.matches(object, object2) ? BIGDECIMAL : DOUBLE);
        Number number = eLArithmetic.coerce(object);
        Number number2 = eLArithmetic.coerce(object2);
        return eLArithmetic.divide(number, number2);
    }

    public static final Number multiply(Object object, Object object2) {
        if (object == null && object2 == null) {
            return 0L;
        }
        ELArithmetic eLArithmetic = BIGDECIMAL.matches(object, object2) ? BIGDECIMAL : (DOUBLE.matches(object, object2) ? (BIGINTEGER.matches(object, object2) ? BIGDECIMAL : DOUBLE) : (BIGINTEGER.matches(object, object2) ? BIGINTEGER : LONG));
        Number number = eLArithmetic.coerce(object);
        Number number2 = eLArithmetic.coerce(object2);
        return ((ELArithmetic)eLArithmetic).multiply(number, number2);
    }

    public static final boolean isNumber(Object object) {
        return object != null && ELArithmetic.isNumberType(object.getClass());
    }

    public static final boolean isNumberType(Class<?> clazz) {
        return clazz == Long.TYPE || clazz == Double.TYPE || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Float.TYPE || Number.class.isAssignableFrom(clazz);
    }

    protected ELArithmetic() {
    }

    protected abstract Number add(Number var1, Number var2);

    protected abstract Number multiply(Number var1, Number var2);

    protected abstract Number subtract(Number var1, Number var2);

    protected abstract Number mod(Number var1, Number var2);

    protected abstract Number coerce(Number var1);

    protected final Number coerce(Object object) {
        if (ELArithmetic.isNumber(object)) {
            return this.coerce((Number)object);
        }
        if (object == null || "".equals(object)) {
            return this.coerce(ZERO);
        }
        if (object instanceof String) {
            return this.coerce((String)object);
        }
        if (object instanceof Character) {
            return this.coerce((short)((Character)object).charValue());
        }
        throw new IllegalArgumentException(MessageFactory.get("error.convert", object, object.getClass(), "Number"));
    }

    protected abstract Number coerce(String var1);

    protected abstract Number divide(Number var1, Number var2);

    protected abstract boolean matches(Object var1, Object var2);

    public static final class LongDelegate
    extends ELArithmetic {
        @Override
        protected Number add(Number number, Number number2) {
            return number.longValue() + number2.longValue();
        }

        @Override
        protected Number coerce(Number number) {
            if (number instanceof Long) {
                return number;
            }
            return number.longValue();
        }

        @Override
        protected Number coerce(String string) {
            return Long.valueOf(string);
        }

        @Override
        protected Number divide(Number number, Number number2) {
            return number.longValue() / number2.longValue();
        }

        @Override
        protected Number mod(Number number, Number number2) {
            return number.longValue() % number2.longValue();
        }

        @Override
        protected Number subtract(Number number, Number number2) {
            return number.longValue() - number2.longValue();
        }

        @Override
        protected Number multiply(Number number, Number number2) {
            return number.longValue() * number2.longValue();
        }

        @Override
        public boolean matches(Object object, Object object2) {
            return object instanceof Long || object2 instanceof Long;
        }
    }

    public static final class DoubleDelegate
    extends ELArithmetic {
        @Override
        protected Number add(Number number, Number number2) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).add(new BigDecimal(number2.doubleValue()));
            }
            if (number2 instanceof BigDecimal) {
                return new BigDecimal(number.doubleValue()).add((BigDecimal)number2);
            }
            return number.doubleValue() + number2.doubleValue();
        }

        @Override
        protected Number coerce(Number number) {
            if (number instanceof Double) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return number.doubleValue();
        }

        @Override
        protected Number coerce(String string) {
            return Double.valueOf(string);
        }

        @Override
        protected Number divide(Number number, Number number2) {
            return number.doubleValue() / number2.doubleValue();
        }

        @Override
        protected Number mod(Number number, Number number2) {
            return number.doubleValue() % number2.doubleValue();
        }

        @Override
        protected Number subtract(Number number, Number number2) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).subtract(new BigDecimal(number2.doubleValue()));
            }
            if (number2 instanceof BigDecimal) {
                return new BigDecimal(number.doubleValue()).subtract((BigDecimal)number2);
            }
            return number.doubleValue() - number2.doubleValue();
        }

        @Override
        protected Number multiply(Number number, Number number2) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).multiply(new BigDecimal(number2.doubleValue()));
            }
            if (number2 instanceof BigDecimal) {
                return new BigDecimal(number.doubleValue()).multiply((BigDecimal)number2);
            }
            return number.doubleValue() * number2.doubleValue();
        }

        @Override
        public boolean matches(Object object, Object object2) {
            return object instanceof Double || object2 instanceof Double || object instanceof Float || object2 instanceof Float || object instanceof String && ELSupport.isStringFloat((String)object) || object2 instanceof String && ELSupport.isStringFloat((String)object2);
        }
    }

    public static final class BigIntegerDelegate
    extends ELArithmetic {
        @Override
        protected Number add(Number number, Number number2) {
            return ((BigInteger)number).add((BigInteger)number2);
        }

        @Override
        protected Number coerce(Number number) {
            if (number instanceof BigInteger) {
                return number;
            }
            return new BigInteger(number.toString());
        }

        @Override
        protected Number coerce(String string) {
            return new BigInteger(string);
        }

        @Override
        protected Number divide(Number number, Number number2) {
            return new BigDecimal((BigInteger)number).divide(new BigDecimal((BigInteger)number2), RoundingMode.HALF_UP);
        }

        @Override
        protected Number multiply(Number number, Number number2) {
            return ((BigInteger)number).multiply((BigInteger)number2);
        }

        @Override
        protected Number mod(Number number, Number number2) {
            return ((BigInteger)number).mod((BigInteger)number2);
        }

        @Override
        protected Number subtract(Number number, Number number2) {
            return ((BigInteger)number).subtract((BigInteger)number2);
        }

        @Override
        public boolean matches(Object object, Object object2) {
            return object instanceof BigInteger || object2 instanceof BigInteger;
        }
    }

    public static final class BigDecimalDelegate
    extends ELArithmetic {
        @Override
        protected Number add(Number number, Number number2) {
            return ((BigDecimal)number).add((BigDecimal)number2);
        }

        @Override
        protected Number coerce(Number number) {
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return new BigDecimal(number.doubleValue());
        }

        @Override
        protected Number coerce(String string) {
            return new BigDecimal(string);
        }

        @Override
        protected Number divide(Number number, Number number2) {
            return ((BigDecimal)number).divide((BigDecimal)number2, RoundingMode.HALF_UP);
        }

        @Override
        protected Number subtract(Number number, Number number2) {
            return ((BigDecimal)number).subtract((BigDecimal)number2);
        }

        @Override
        protected Number mod(Number number, Number number2) {
            return number.doubleValue() % number2.doubleValue();
        }

        @Override
        protected Number multiply(Number number, Number number2) {
            return ((BigDecimal)number).multiply((BigDecimal)number2);
        }

        @Override
        public boolean matches(Object object, Object object2) {
            return object instanceof BigDecimal || object2 instanceof BigDecimal;
        }
    }
}

