/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.Context;
import org.apache.catalina.Group;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.Wrapper;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.catalina.users.MemoryUserDatabase;
import org.apache.tomcat.util.ExceptionUtils;

public class UserDatabaseRealm
extends RealmBase {
    protected UserDatabase database = null;
    @Deprecated
    protected static final String name = "UserDatabaseRealm";
    protected String resourceName = "UserDatabase";

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
    }

    @Override
    public boolean hasRole(Wrapper wrapper, Principal principal, String object) {
        Object object2;
        if (wrapper != null && (object2 = wrapper.findSecurityReference((String)object)) != null) {
            object = object2;
        }
        if (principal instanceof GenericPrincipal && ((GenericPrincipal)(object2 = (GenericPrincipal)principal)).getUserPrincipal() instanceof User) {
            principal = ((GenericPrincipal)object2).getUserPrincipal();
        }
        if (!(principal instanceof User)) {
            return super.hasRole(null, principal, (String)object);
        }
        if ("*".equals(object)) {
            return true;
        }
        if (object == null) {
            return false;
        }
        object2 = (User)principal;
        Role role = this.database.findRole((String)object);
        if (role == null) {
            return false;
        }
        if (object2.isInRole(role)) {
            return true;
        }
        Iterator<Group> iterator = object2.getGroups();
        while (iterator.hasNext()) {
            Group group = iterator.next();
            if (!group.isInRole(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    protected String getName() {
        return name;
    }

    @Override
    public void backgroundProcess() {
        if (this.database instanceof MemoryUserDatabase) {
            ((MemoryUserDatabase)this.database).backgroundProcess();
        }
    }

    @Override
    protected String getPassword(String string) {
        User user = this.database.findUser(string);
        if (user == null) {
            return null;
        }
        return user.getPassword();
    }

    @Override
    protected Principal getPrincipal(String string) {
        Object object;
        User user = this.database.findUser(string);
        if (user == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Role> iterator = user.getRoles();
        while (iterator.hasNext()) {
            object = iterator.next();
            arrayList.add(object.getName());
        }
        object = user.getGroups();
        while (object.hasNext()) {
            Group group = (Group)object.next();
            iterator = group.getRoles();
            while (iterator.hasNext()) {
                Role role = iterator.next();
                arrayList.add(role.getName());
            }
        }
        return new GenericPrincipal(string, user.getPassword(), arrayList, user);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        try {
            Context context = this.getServer().getGlobalNamingContext();
            this.database = (UserDatabase)context.lookup(this.resourceName);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.containerLog.error((Object)sm.getString("userDatabaseRealm.lookup", new Object[]{this.resourceName}), throwable);
            this.database = null;
        }
        if (this.database == null) {
            throw new LifecycleException(sm.getString("userDatabaseRealm.noDatabase", new Object[]{this.resourceName}));
        }
        super.startInternal();
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.database = null;
    }
}

