/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import java.awt.Point;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

public class ConvexHull {
    protected int ccw(Point p0, Point p1, Point p2) {
        int dx1 = p1.x - p0.x;
        int dy2 = p2.y - p0.y;
        int dy1 = p1.y - p0.y;
        int dx2 = p2.x - p0.x;
        int comp = dx1 * dy2 - dy1 * dx2;
        if (comp > 0) {
            return 1;
        }
        if (comp < 0) {
            return -1;
        }
        if (dx1 * dx2 < 0 || dy1 * dy2 < 0) {
            return -1;
        }
        if (dx1 * dx1 + dy1 * dy1 >= dx2 * dx2 + dy2 * dy2) {
            return 0;
        }
        return 1;
    }

    Vector doGraham(Vector p) {
        int i;
        int min = 0;
        for (i = 1; i < p.size(); ++i) {
            if (((Point)p.get((int)i)).y >= ((Point)p.get((int)min)).y) continue;
            min = i;
        }
        for (i = 0; i < p.size(); ++i) {
            if (((Point)p.get((int)i)).y != ((Point)p.get((int)min)).y || ((Point)p.get((int)i)).x <= ((Point)p.get((int)min)).x) continue;
            min = i;
        }
        Point t = (Point)p.get(0);
        p.set(0, p.get(min));
        p.set(min, t);
        thetaComparator comp = new thetaComparator((Point)p.get(0));
        Collections.sort(p, comp);
        p.add(0, new Point((Point)p.get(p.size() - 1)));
        int M = 3;
        for (i = 4; i < p.size(); ++i) {
            while (this.ccw((Point)p.get(M), (Point)p.get(M - 1), (Point)p.get(i)) >= 0) {
                --M;
            }
            t = (Point)p.get(++M);
            p.set(M, p.get(i));
            p.set(i, t);
        }
        p.remove(0);
        p.setSize(M);
        return p;
    }

    public Vector calculateHull(LinkedList coordinates) {
        Vector q = new Vector();
        boolean i = false;
        ListIterator coordinates_it = coordinates.listIterator();
        while (coordinates_it.hasNext()) {
            q.add(coordinates_it.next());
        }
        Vector res = this.doGraham(q);
        return res;
    }

    protected class thetaComparator
    implements Comparator {
        Point p0;

        public thetaComparator(Point p0) {
            this.p0 = new Point(p0);
        }

        public int compare(Object p1, Object p2) {
            double comp = this.theta(this.p0, (Point)p1) - this.theta(this.p0, (Point)p2);
            if (((Point)p1).equals(p2)) {
                return 0;
            }
            if (comp > 0.0) {
                return 1;
            }
            if (comp < 0.0) {
                return -1;
            }
            int dx1 = ((Point)p1).x - this.p0.x;
            int dy1 = ((Point)p1).y - this.p0.y;
            int dx2 = ((Point)p2).x - this.p0.x;
            int dy2 = ((Point)p2).y - this.p0.y;
            int comp2 = dx1 * dx1 + dy1 * dy1 - (dx2 * dx2 + dy2 * dy2);
            if (comp2 > 0) {
                return -1;
            }
            if (comp2 < 0) {
                return 1;
            }
            return 0;
        }

        double theta(Point p1, Point p2) {
            int dx = p2.x - p1.x;
            int ax = Math.abs(dx);
            int dy = p2.y - p1.y;
            int ay = Math.abs(dy);
            double t = dx == 0 && dy == 0 ? 0.0 : (double)dy / (double)(ax + ay);
            if (dx < 0) {
                t = 2.0 - t;
            } else if (dy < 0) {
                t = 4.0 + t;
            }
            return t * 90.0;
        }
    }
}

