/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Spotlight {
    public static List<File> find(String query) throws IOException {
        return Spotlight.doSearch(new String[]{"mdfind", query});
    }

    public static List<File> find(String query, File folder) throws IOException {
        return Spotlight.doSearch(new String[]{"mdfind", "-onlyin", folder.getAbsolutePath(), query});
    }

    private static List<File> doSearch(String[] command) throws IOException {
        Process process = Runtime.getRuntime().exec(command);
        ArrayList<File> results = new ArrayList<File>();
        try (InputStream is = process.getInputStream();
             InputStreamReader isr = new InputStreamReader(is);
             BufferedReader out = new BufferedReader(isr);){
            String line;
            while ((line = out.readLine()) != null) {
                results.add(new File(line));
            }
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (process.isAlive()) {
            process.destroy();
        }
        return results;
    }

    public static Map<String, String> getMetadata(File file) throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{"mdls", file.getAbsolutePath()});
        HashMap<String, String> results = new HashMap<String, String>();
        try (InputStream is = process.getInputStream();
             InputStreamReader isr = new InputStreamReader(is);
             BufferedReader out = new BufferedReader(isr);){
            String line;
            while ((line = out.readLine()) != null) {
                int equals = line.indexOf(61);
                if (equals <= -1) continue;
                String key = line.substring(0, equals).trim();
                String value = line.substring(equals + 1).trim();
                results.put(key, value);
            }
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (process.isAlive()) {
            process.destroy();
        }
        return results;
    }
}

