/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotag;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class CommandCreateElementFull
extends SingleLineCommand2<DescriptionDiagram> {
    public static final String ALL_TYPES = "artifact|actor|folder|card|file|package|rectangle|label|node|frame|cloud|database|queue|stack|storage|agent|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout";
    private static final String CODE_CORE = "[\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    public static final String CODE = "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    public static final String CODE_WITH_QUOTE = "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[%g].+?[%g])";
    private static final String DISPLAY_CORE = "[%g].+?[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]";
    public static final String DISPLAY = "([%g].+?[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\])";
    public static final String DISPLAY_WITHOUT_QUOTE = "([%g].+?[%g]|:[^:]+:|\\([^()]+\\)|\\[[^\\[\\]]+\\]|[\\p{L}0-9_.]+)";

    public CommandCreateElementFull() {
        super(CommandCreateElementFull.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateElementFull.class.getName(), RegexLeaf.start(), new RegexLeaf("SYMBOL", "(?:(artifact|actor|folder|card|file|package|rectangle|label|node|frame|cloud|database|queue|stack|storage|agent|usecase|component|boundary|control|entity|interface|circle|collections|port|portin|portout|\\(\\))[%s]+)?"), CommandCreateElementFull.color2().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexLeaf("CODE1", CODE_WITH_QUOTE), new RegexConcat(new RegexLeaf("DISPLAY2", DISPLAY), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE2", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", CODE)), new RegexConcat(new RegexLeaf("CODE3", CODE), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE3", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DISPLAY3", DISPLAY)), new RegexConcat(new RegexLeaf("DISPLAY4", DISPLAY_WITHOUT_QUOTE), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE4", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE4", CODE))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.+\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), RegexLeaf.spaceZeroOrMore(), CommandCreateElementFull.color().getRegex(), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    private static ColorParser color2() {
        return ColorParser.simpleColor(ColorType.BACK, "COLOR2");
    }

    @Override
    protected final boolean isForbidden(CharSequence line) {
        return line.toString().matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, LineLocation location, RegexResult arg) {
        Ident code;
        USymbol usymbol;
        LeafType type;
        String symbol;
        String codeRaw = arg.getLazzy("CODE", 0);
        String displayRaw = arg.getLazzy("DISPLAY", 0);
        char codeChar = this.getCharEncoding(codeRaw);
        char codeDisplay = this.getCharEncoding(displayRaw);
        if (codeRaw.startsWith("()")) {
            symbol = "interface";
            codeRaw = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(codeRaw.substring(2)));
        } else {
            symbol = codeChar == '(' || codeDisplay == '(' ? "usecase" : (codeChar == ':' || codeDisplay == ':' ? "actor" : (codeChar == '[' || codeDisplay == '[' ? "component" : arg.get("SYMBOL", 0)));
        }
        if (symbol == null) {
            type = LeafType.DESCRIPTION;
            usymbol = diagram.getSkinParam().actorStyle().toUSymbol();
        } else if (symbol.equalsIgnoreCase("portin")) {
            type = LeafType.PORTIN;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("portout")) {
            type = LeafType.PORTOUT;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("port")) {
            type = LeafType.PORT;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("usecase")) {
            type = LeafType.USECASE;
            usymbol = null;
        } else if (symbol.equalsIgnoreCase("circle")) {
            type = LeafType.CIRCLE;
            usymbol = null;
        } else {
            type = LeafType.DESCRIPTION;
            usymbol = USymbol.fromString(symbol, diagram.getSkinParam());
            if (usymbol == null) {
                throw new IllegalStateException();
            }
        }
        String idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(codeRaw);
        Ident ident = diagram.buildLeafIdent(idShort);
        Code code2 = code = diagram.V1972() ? ident : diagram.buildCode(idShort);
        if (!diagram.V1972() && diagram.isGroup(code)) {
            return CommandExecutionResult.error("This element (" + code.getName() + ") is already defined");
        }
        if (diagram.V1972() && diagram.isGroupStrict(ident)) {
            return CommandExecutionResult.error("This element (" + ident.getName() + ") is already defined");
        }
        String display = displayRaw;
        if (display == null) {
            display = code.getName();
        }
        display = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(display);
        String stereotype = arg.getLazzy("STEREOTYPE", 0);
        if (CommandCreateElementFull.existsWithBadType3(diagram, code, ident, type, usymbol)) {
            return CommandExecutionResult.error("This element (" + code.getName() + ") is already defined");
        }
        ILeaf entity = diagram.getOrCreateLeaf(ident, code, type, usymbol);
        entity.setDisplay(Display.getWithNewlines(display));
        entity.setUSymbol(usymbol);
        if (stereotype != null) {
            entity.setStereotype(new Stereotype(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        CommandCreateClassMultilines.addTags(entity, arg.get("TAGS", 0));
        String urlString = arg.get("URL", 0);
        if (urlString != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        Colors colors = CommandCreateElementFull.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        HColor lineColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("LINECOLOR", 1));
        if (lineColor != null) {
            colors = colors.add(ColorType.LINE, lineColor);
        }
        entity.setColors(colors);
        return CommandExecutionResult.ok();
    }

    public static boolean existsWithBadType3(AbstractEntityDiagram diagram, Code code, Ident ident, LeafType type, USymbol usymbol) {
        if (diagram.V1972()) {
            if (!diagram.leafExistSmart(ident)) {
                return false;
            }
            ILeaf other = diagram.getLeafSmart(ident);
            if (other.getLeafType() != type) {
                return true;
            }
            return usymbol != null && other.getUSymbol() != usymbol;
        }
        if (!diagram.leafExist(code)) {
            return false;
        }
        ILeaf other = diagram.getLeaf(code);
        if (other.getLeafType() != type) {
            return true;
        }
        return usymbol != null && other.getUSymbol() != usymbol;
    }

    private char getCharEncoding(String codeRaw) {
        return codeRaw != null && codeRaw.length() > 2 ? codeRaw.charAt(0) : (char)'\u0000';
    }
}

