/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import net.sf.json.JSONObject;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.SessionDialog;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.authentication.AbstractAuthenticationMethodOptionsPanel;
import org.zaproxy.zap.authentication.AbstractCredentialsOptionsPanel;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationHelper;
import org.zaproxy.zap.authentication.AuthenticationMethod;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.authentication.UsernamePasswordAuthenticationCredentials;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfToken;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.authentication.ContextAuthenticationPanel;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.NameValuePair;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.NodeSelectDialog;
import org.zaproxy.zap.view.popup.PopupMenuItemContext;
import org.zaproxy.zap.view.popup.PopupMenuItemSiteNodeContextMenuFactory;

public abstract class PostBasedAuthenticationMethodType
extends AuthenticationMethodType {
    private static final String CONTEXT_CONFIG_AUTH_FORM = "context.authentication.form";
    private static final String CONTEXT_CONFIG_AUTH_FORM_LOGINURL = "context.authentication.form.loginurl";
    private static final String CONTEXT_CONFIG_AUTH_FORM_LOGINBODY = "context.authentication.form.loginbody";
    private static final String CONTEXT_CONFIG_AUTH_FORM_LOGINPAGEURL = "context.authentication.form.loginpageurl";
    private static final String POST_DATA_LABEL = Constant.messages.getString("authentication.method.pb.field.label.postData");
    private static final String POST_DATA_REQUIRED_LABEL = Constant.messages.getString("authentication.method.pb.field.label.postDataRequired");
    private static final String USERNAME_PARAM_LABEL = Constant.messages.getString("authentication.method.pb.field.label.usernameParam");
    private static final String PASSWORD_PARAM_LABEL = Constant.messages.getString("authentication.method.pb.field.label.passwordParam");
    private static final String LOGIN_URL_LABEL = Constant.messages.getString("authentication.method.pb.field.label.loginUrl");
    private static final String LOGIN_PAGE_URL_LABEL = Constant.messages.getString("authentication.method.pb.field.label.loginPageUrl");
    private static final String AUTH_DESCRIPTION = Constant.messages.getString("authentication.method.pb.field.label.description");
    private static final Logger LOGGER = Logger.getLogger(PostBasedAuthenticationMethodType.class);
    private final String methodName;
    private final int methodIdentifier;
    private final String apiMethodName;
    private final String labelPopupMenuKey;
    private final boolean postDataRequired;
    private static final String PARAM_LOGIN_URL = "loginUrl";
    private static final String PARAM_LOGIN_REQUEST_DATA = "loginRequestData";
    private static final String PARAM_LOGIN_PAGE_URL = "loginPageUrl";

    protected PostBasedAuthenticationMethodType(String methodName, int methodIdentifier, String apiMethodName, String labelPopupMenuKey, boolean postDataRequired) {
        this.methodName = methodName;
        this.methodIdentifier = methodIdentifier;
        this.apiMethodName = apiMethodName;
        this.labelPopupMenuKey = labelPopupMenuKey;
        this.postDataRequired = postDataRequired;
    }

    private static URI createLoginUrl(String loginData, String username, String password) throws URIException {
        return new URI(PostBasedAuthenticationMethodType.replaceUserData(loginData, username, password, PostBasedAuthenticationMethodType::encodeParameter), true);
    }

    private static String replaceUserData(String loginData, String username, String password, UnaryOperator<String> encoder) {
        return loginData.replace("{%username%}", (CharSequence)encoder.apply(username)).replace("{%password%}", (CharSequence)encoder.apply(password));
    }

    private static String encodeParameter(String parameter) {
        try {
            return URLEncoder.encode(parameter, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static boolean isValidLoginUrl(String loginUrl) {
        if (loginUrl.isEmpty()) {
            return false;
        }
        try {
            PostBasedAuthenticationMethodType.createLoginUrl(loginUrl, "", "");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public abstract PostBasedAuthenticationMethod createAuthenticationMethod(int var1);

    @Override
    public String getName() {
        return this.methodName;
    }

    @Override
    public boolean hasOptionsPanel() {
        return true;
    }

    @Override
    public AbstractCredentialsOptionsPanel<? extends AuthenticationCredentials> buildCredentialsOptionsPanel(AuthenticationCredentials credentials, Context uiSharedContext) {
        return new UsernamePasswordAuthenticationCredentials.UsernamePasswordAuthenticationCredentialsOptionsPanel((UsernamePasswordAuthenticationCredentials)credentials);
    }

    @Override
    public boolean hasCredentialsOptionsPanel() {
        return true;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        if (!View.isInitialised()) {
            return;
        }
        extensionHook.getHookMenu().addPopupMenuItem(this.getPopupFlagLoginRequestMenuFactory());
    }

    private PopupMenuItemSiteNodeContextMenuFactory getPopupFlagLoginRequestMenuFactory() {
        PopupMenuItemSiteNodeContextMenuFactory popupFlagLoginRequestMenuFactory = new PopupMenuItemSiteNodeContextMenuFactory(Constant.messages.getString("context.flag.popup")){
            private static final long serialVersionUID = 8927418764L;

            @Override
            public PopupMenuItemContext getContextMenu(Context context, String parentMenu) {
                return new PopupMenuItemContext(context, parentMenu, Constant.messages.getString(PostBasedAuthenticationMethodType.this.labelPopupMenuKey, context.getName())){
                    private static final long serialVersionUID = 1967885623005183801L;
                    private ExtensionUserManagement usersExtension;
                    private Context uiSharedContext;

                    private boolean confirmUsersDeletion(Context uiSharedContext) {
                        int choice;
                        this.usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
                        return this.usersExtension == null || this.usersExtension.getSharedContextUsers(uiSharedContext).size() <= 0 || (choice = JOptionPane.showConfirmDialog(this, Constant.messages.getString("authentication.dialog.confirmChange.label"), Constant.messages.getString("authentication.dialog.confirmChange.title"), 2)) != 2;
                    }

                    @Override
                    public void performAction(SiteNode sn) {
                        SessionDialog sessionDialog = View.getSingleton().getSessionDialog();
                        sessionDialog.recreateUISharedContexts(Model.getSingleton().getSession());
                        this.uiSharedContext = sessionDialog.getUISharedContext(this.getContext().getId());
                        if (PostBasedAuthenticationMethodType.this.isTypeForMethod(this.getContext().getAuthenticationMethod())) {
                            LOGGER.info((Object)("Selected new login request via PopupMenu. Changing existing " + PostBasedAuthenticationMethodType.this.methodName + " instance for Context " + this.getContext().getId()));
                            PostBasedAuthenticationMethod method = (PostBasedAuthenticationMethod)this.uiSharedContext.getAuthenticationMethod();
                            try {
                                method.setLoginRequest(sn);
                                this.initializeLoginPageUrl(sn, method);
                            }
                            catch (Exception e) {
                                LOGGER.error((Object)("Failed to set login request: " + e.getMessage()), (Throwable)e);
                                return;
                            }
                            View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), ContextAuthenticationPanel.buildName(this.getContext().getId()), false);
                        } else {
                            LOGGER.info((Object)("Selected new login request via PopupMenu. Creating new " + PostBasedAuthenticationMethodType.this.methodName + " instance for Context " + this.getContext().getId()));
                            PostBasedAuthenticationMethod method = PostBasedAuthenticationMethodType.this.createAuthenticationMethod(this.getContext().getId());
                            try {
                                method.setLoginRequest(sn);
                                this.initializeLoginPageUrl(sn, method);
                            }
                            catch (Exception e) {
                                LOGGER.error((Object)("Failed to set login request: " + e.getMessage()), (Throwable)e);
                                return;
                            }
                            if (!this.confirmUsersDeletion(this.uiSharedContext)) {
                                LOGGER.debug((Object)"Cancelled change of authentication type.");
                                return;
                            }
                            this.uiSharedContext.setAuthenticationMethod(method);
                            View.getSingleton().showSessionDialog(Model.getSingleton().getSession(), ContextAuthenticationPanel.buildName(this.getContext().getId()), false, new Runnable(){

                                @Override
                                public void run() {
                                    if (usersExtension != null) {
                                        usersExtension.removeSharedContextUsers(uiSharedContext);
                                    }
                                }
                            });
                        }
                    }

                    private void initializeLoginPageUrl(SiteNode sn, PostBasedAuthenticationMethod method) throws HttpMalformedHeaderException, DatabaseException {
                        if (method.loginPageUrl == null || method.loginPageUrl.isEmpty()) {
                            method.setLoginPageUrl(sn);
                        }
                    }
                };
            }

            @Override
            public int getParentMenuIndex() {
                return 3;
            }
        };
        return popupFlagLoginRequestMenuFactory;
    }

    @Override
    public AuthenticationMethod loadMethodFromSession(Session session, int contextId) throws DatabaseException {
        PostBasedAuthenticationMethod method = this.createAuthenticationMethod(contextId);
        List<String> urls = session.getContextDataStrings(contextId, 201);
        String url = "";
        if (urls != null && urls.size() > 0) {
            url = urls.get(0);
        }
        List<String> postDatas = session.getContextDataStrings(contextId, 202);
        String postData = null;
        if (postDatas != null && postDatas.size() > 0) {
            postData = postDatas.get(0);
        }
        List<String> loginPageUrls = session.getContextDataStrings(contextId, 203);
        String loginPageUrl = null;
        if (loginPageUrls != null && !loginPageUrls.isEmpty()) {
            loginPageUrl = loginPageUrls.get(0);
        }
        try {
            method.setLoginRequest(url, postData);
            method.setLoginPageUrl(loginPageUrl);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load Post based authentication method data:", (Throwable)e);
        }
        return method;
    }

    @Override
    public void persistMethodToSession(Session session, int contextId, AuthenticationMethod authMethod) throws DatabaseException {
        if (!(authMethod instanceof PostBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Post based authentication type only supports: " + PostBasedAuthenticationMethod.class);
        }
        PostBasedAuthenticationMethod method = (PostBasedAuthenticationMethod)authMethod;
        session.setContextData(contextId, 201, method.loginRequestURL);
        session.setContextData(contextId, 202, method.loginRequestBody);
        session.setContextData(contextId, 203, method.loginPageUrl);
    }

    @Override
    public int getUniqueIdentifier() {
        return this.methodIdentifier;
    }

    @Override
    public UsernamePasswordAuthenticationCredentials createAuthenticationCredentials() {
        return new UsernamePasswordAuthenticationCredentials();
    }

    public Class<UsernamePasswordAuthenticationCredentials> getAuthenticationCredentialsType() {
        return UsernamePasswordAuthenticationCredentials.class;
    }

    @Override
    public ApiDynamicActionImplementor getSetMethodForContextApiAction() {
        String[] optionalParamNames;
        String[] mandatoryParamNames;
        if (this.postDataRequired) {
            mandatoryParamNames = new String[]{PARAM_LOGIN_URL, PARAM_LOGIN_REQUEST_DATA};
            optionalParamNames = new String[]{PARAM_LOGIN_PAGE_URL};
        } else {
            mandatoryParamNames = new String[]{PARAM_LOGIN_URL};
            optionalParamNames = new String[]{PARAM_LOGIN_REQUEST_DATA, PARAM_LOGIN_PAGE_URL};
        }
        return new ApiDynamicActionImplementor(this.apiMethodName, mandatoryParamNames, optionalParamNames){

            @Override
            public void handleAction(JSONObject params) throws ApiException {
                Context context = ApiUtils.getContextByParamId(params, "contextId");
                String loginUrl = ApiUtils.getNonEmptyStringParam(params, PostBasedAuthenticationMethodType.PARAM_LOGIN_URL);
                if (!PostBasedAuthenticationMethodType.isValidLoginUrl(loginUrl)) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PostBasedAuthenticationMethodType.PARAM_LOGIN_URL);
                }
                String loginPageUrl = ApiUtils.getOptionalStringParam(params, PostBasedAuthenticationMethodType.PARAM_LOGIN_PAGE_URL);
                if (loginPageUrl == null || loginPageUrl.isEmpty()) {
                    loginPageUrl = loginUrl;
                } else if (!PostBasedAuthenticationMethodType.isValidLoginUrl(loginPageUrl)) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, PostBasedAuthenticationMethodType.PARAM_LOGIN_PAGE_URL);
                }
                String postData = "";
                if (PostBasedAuthenticationMethodType.this.postDataRequired) {
                    postData = ApiUtils.getNonEmptyStringParam(params, PostBasedAuthenticationMethodType.PARAM_LOGIN_REQUEST_DATA);
                } else if (params.containsKey((Object)PostBasedAuthenticationMethodType.PARAM_LOGIN_REQUEST_DATA)) {
                    postData = params.getString(PostBasedAuthenticationMethodType.PARAM_LOGIN_REQUEST_DATA);
                }
                PostBasedAuthenticationMethod method = PostBasedAuthenticationMethodType.this.createAuthenticationMethod(context.getId());
                try {
                    method.setLoginRequest(loginUrl, postData);
                    method.setLoginPageUrl(loginPageUrl);
                }
                catch (Exception e) {
                    throw new ApiException(ApiException.Type.INTERNAL_ERROR, e.getMessage());
                }
                context.setAuthenticationMethod(method);
            }
        };
    }

    @Override
    public ApiDynamicActionImplementor getSetCredentialsForUserApiAction() {
        return UsernamePasswordAuthenticationCredentials.getSetCredentialsForUserApiAction(this);
    }

    @Override
    public void exportData(Configuration config, AuthenticationMethod authMethod) {
        if (!(authMethod instanceof PostBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Post based authentication type only supports: " + PostBasedAuthenticationMethod.class.getName());
        }
        PostBasedAuthenticationMethod method = (PostBasedAuthenticationMethod)authMethod;
        config.setProperty(CONTEXT_CONFIG_AUTH_FORM_LOGINURL, (Object)method.loginRequestURL);
        config.setProperty(CONTEXT_CONFIG_AUTH_FORM_LOGINBODY, (Object)method.loginRequestBody);
        config.setProperty(CONTEXT_CONFIG_AUTH_FORM_LOGINPAGEURL, (Object)method.loginPageUrl);
    }

    @Override
    public void importData(Configuration config, AuthenticationMethod authMethod) throws ConfigurationException {
        if (!(authMethod instanceof PostBasedAuthenticationMethod)) {
            throw new AuthenticationMethodType.UnsupportedAuthenticationMethodException("Post based authentication type only supports: " + PostBasedAuthenticationMethod.class.getName());
        }
        PostBasedAuthenticationMethod method = (PostBasedAuthenticationMethod)authMethod;
        try {
            method.setLoginRequest(config.getString(CONTEXT_CONFIG_AUTH_FORM_LOGINURL), config.getString(CONTEXT_CONFIG_AUTH_FORM_LOGINBODY));
            method.setLoginPageUrl(config.getString(CONTEXT_CONFIG_AUTH_FORM_LOGINPAGEURL));
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    private static class NameValuePairRenderer
    extends BasicComboBoxRenderer {
        public static final NameValuePairRenderer INSTANCE = new NameValuePairRenderer();
        private static final long serialVersionUID = 3654541772447187317L;
        private static final Border BORDER = new EmptyBorder(2, 3, 3, 3);

        private NameValuePairRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                this.setBorder(BORDER);
                NameValuePair item = (NameValuePair)value;
                this.setText(item.getName());
            }
            return this;
        }
    }

    protected abstract class PostBasedAuthenticationMethodOptionsPanel
    extends AbstractAuthenticationMethodOptionsPanel {
        private static final long serialVersionUID = 1L;
        private ZapTextField loginUrlField;
        private ZapTextField loginPageUrlField;
        private ZapTextField postDataField;
        private JComboBox<NameValuePair> usernameParameterCombo;
        private JComboBox<NameValuePair> passwordParameterCombo;
        private PostBasedAuthenticationMethod authenticationMethod;
        private Context context;
        private ExtensionUserManagement userExt = null;
        private final UnaryOperator<String> paramDecoder;

        public PostBasedAuthenticationMethodOptionsPanel(Context context, UnaryOperator<String> paramDecoder) {
            this.initialize();
            this.context = context;
            this.paramDecoder = paramDecoder;
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(LOGIN_URL_LABEL), LayoutHelper.getGBC(0, 0, 2, 1.0, 0.0));
            JPanel urlSelectPanel = new JPanel(new GridBagLayout());
            this.loginUrlField = new ZapTextField();
            this.loginPageUrlField = new ZapTextField();
            this.postDataField = new ZapTextField();
            JButton selectButton = new JButton(Constant.messages.getString("all.button.select"));
            selectButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
            JButton loginPageUrlSelectButton = new JButton(Constant.messages.getString("all.button.select"));
            loginPageUrlSelectButton.setIcon(new ImageIcon(View.class.getResource("/resource/icon/16/094.png")));
            selectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NodeSelectDialog nsd = new NodeSelectDialog((Window)View.getSingleton().getMainFrame());
                    SiteNode node = null;
                    if (PostBasedAuthenticationMethodOptionsPanel.this.loginUrlField.getText().trim().length() > 0) {
                        try {
                            node = PostBasedAuthenticationMethodOptionsPanel.this.postDataField.getText().trim().length() > 0 ? Model.getSingleton().getSession().getSiteTree().findNode(new URI(PostBasedAuthenticationMethodOptionsPanel.this.loginUrlField.getText(), false), "POST", PostBasedAuthenticationMethodOptionsPanel.this.postDataField.getText()) : Model.getSingleton().getSession().getSiteTree().findNode(new URI(PostBasedAuthenticationMethodOptionsPanel.this.loginUrlField.getText(), false));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if ((node = nsd.showDialog(node)) != null && node.getHistoryReference() != null) {
                        try {
                            if (LOGGER.isInfoEnabled()) {
                                LOGGER.info((Object)("Selected Post Based Auth Login URL via dialog: " + node.getHistoryReference().getURI().toString()));
                            }
                            PostBasedAuthenticationMethodOptionsPanel.this.loginUrlField.setText(node.getHistoryReference().getURI().toString());
                            PostBasedAuthenticationMethodOptionsPanel.this.postDataField.setText(node.getHistoryReference().getHttpMessage().getRequestBody().toString());
                            PostBasedAuthenticationMethodOptionsPanel.this.updateParameters();
                            if (StringUtils.isBlank((CharSequence)PostBasedAuthenticationMethodOptionsPanel.this.loginPageUrlField.getText())) {
                                PostBasedAuthenticationMethodOptionsPanel.this.loginPageUrlField.setText(PostBasedAuthenticationMethodOptionsPanel.this.loginUrlField.getText());
                            }
                        }
                        catch (Exception e1) {
                            LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
                        }
                    }
                }
            });
            loginPageUrlSelectButton.addActionListener(e -> {
                NodeSelectDialog nsd = new NodeSelectDialog((Window)View.getSingleton().getMainFrame());
                SiteNode node = null;
                if (!StringUtils.isBlank((CharSequence)this.loginPageUrlField.getText())) {
                    try {
                        node = Model.getSingleton().getSession().getSiteTree().findNode(new URI(this.loginPageUrlField.getText(), false));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((node = nsd.showDialog(node)) != null && node.getHistoryReference() != null) {
                    try {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info((Object)("Selected URL of the login page via dialog: " + node.getHistoryReference().getURI().toString()));
                        }
                        this.loginPageUrlField.setText(node.getHistoryReference().getURI().toString());
                    }
                    catch (Exception e1) {
                        LOGGER.error((Object)e1.getMessage(), (Throwable)e1);
                    }
                }
            });
            urlSelectPanel.add((Component)this.loginUrlField, LayoutHelper.getGBC(0, 0, 1, 1.0));
            urlSelectPanel.add((Component)selectButton, LayoutHelper.getGBC(1, 0, 1, 0.0));
            urlSelectPanel.add((Component)new JLabel(LOGIN_PAGE_URL_LABEL), LayoutHelper.getGBC(0, 1, 2, 1.0, 0.0));
            urlSelectPanel.add((Component)this.loginPageUrlField, LayoutHelper.getGBC(0, 2, 1, 1.0));
            urlSelectPanel.add((Component)loginPageUrlSelectButton, LayoutHelper.getGBC(1, 2, 1, 0.0));
            this.add((Component)urlSelectPanel, LayoutHelper.getGBC(0, 1, 2, 1.0, 0.0));
            this.add((Component)new JLabel(PostBasedAuthenticationMethodType.this.postDataRequired ? POST_DATA_REQUIRED_LABEL : POST_DATA_LABEL), LayoutHelper.getGBC(0, 2, 2, 1.0, 0.0));
            this.add((Component)this.postDataField, LayoutHelper.getGBC(0, 3, 2, 1.0, 0.0));
            this.add((Component)new JLabel(USERNAME_PARAM_LABEL), LayoutHelper.getGBC(0, 4, 1, 1.0, 0.0));
            this.usernameParameterCombo = new JComboBox();
            this.usernameParameterCombo.setRenderer(NameValuePairRenderer.INSTANCE);
            this.add(this.usernameParameterCombo, LayoutHelper.getGBC(0, 5, 1, 1.0, 0.0));
            this.add((Component)new JLabel(PASSWORD_PARAM_LABEL), LayoutHelper.getGBC(1, 4, 1, 1.0, 0.0));
            this.passwordParameterCombo = new JComboBox();
            this.passwordParameterCombo.setRenderer(NameValuePairRenderer.INSTANCE);
            this.add(this.passwordParameterCombo, LayoutHelper.getGBC(1, 5, 1, 1.0, 0.0));
            this.add((Component)new JLabel(AUTH_DESCRIPTION), LayoutHelper.getGBC(0, 8, 2, 1.0, 0.0));
            this.postDataField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PostBasedAuthenticationMethodOptionsPanel.this.updateParameters();
                }
            });
        }

        protected Context getContext() {
            return this.context;
        }

        @Override
        public void validateFields() {
            if (!PostBasedAuthenticationMethodType.isValidLoginUrl(this.loginUrlField.getText())) {
                this.loginUrlField.requestFocusInWindow();
                throw new IllegalStateException(Constant.messages.getString("authentication.method.pb.dialog.error.url.text"));
            }
            if (PostBasedAuthenticationMethodType.this.postDataRequired && this.postDataField.getText().isEmpty()) {
                this.postDataField.requestFocusInWindow();
                throw new IllegalStateException(Constant.messages.getString("authentication.method.pb.dialog.error.postData.text"));
            }
        }

        protected abstract String replaceParameterValue(String var1, NameValuePair var2, String var3);

        private ExtensionUserManagement getUserExt() {
            if (this.userExt == null) {
                this.userExt = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
            }
            return this.userExt;
        }

        @Override
        public void saveMethod() {
            try {
                String postData = this.postDataField.getText();
                if (!postData.isEmpty()) {
                    NameValuePair userParam = (NameValuePair)this.usernameParameterCombo.getSelectedItem();
                    NameValuePair passwdParam = (NameValuePair)this.passwordParameterCombo.getSelectedItem();
                    ExtensionUserManagement userExt = this.getUserExt();
                    if (userExt != null && userExt.getUIConfiguredUsers(this.context.getId()).size() == 0) {
                        String username = userParam.getValue();
                        String password = passwdParam.getValue();
                        if (!(username.isEmpty() || username.contains("{%username%}") || password.contains("{%password%}"))) {
                            String userStr = (String)this.paramDecoder.apply(username);
                            String passwdStr = (String)this.paramDecoder.apply(password);
                            if (!userStr.isEmpty() && !passwdStr.isEmpty()) {
                                User user = new User(this.context.getId(), userStr);
                                UsernamePasswordAuthenticationCredentials upac = new UsernamePasswordAuthenticationCredentials(userStr, passwdStr);
                                user.setAuthenticationCredentials(upac);
                                this.getUserExt().getContextUserAuthManager(this.context.getId()).addUser(user);
                            }
                        }
                    }
                    postData = this.replaceParameterValue(postData, userParam, "{%username%}");
                    postData = this.replaceParameterValue(postData, passwdParam, "{%password%}");
                }
                this.getMethod().setLoginRequest(this.loginUrlField.getText(), postData);
                this.getMethod().setLoginPageUrl(this.loginPageUrlField.getText());
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        @Override
        public void bindMethod(AuthenticationMethod method) {
            this.authenticationMethod = (PostBasedAuthenticationMethod)method;
            this.loginUrlField.setText(this.authenticationMethod.loginRequestURL);
            this.postDataField.setText(this.authenticationMethod.loginRequestBody);
            this.loginPageUrlField.setText(this.authenticationMethod.loginPageUrl);
            this.updateParameters();
        }

        private int getIndexOfParamWithValue(NameValuePair[] params, String value) {
            for (int i = 0; i < params.length; ++i) {
                if (!value.equals(params[i].getValue())) continue;
                return i;
            }
            return -1;
        }

        private void updateParameters() {
            try {
                List<NameValuePair> params = this.extractParameters(this.postDataField.getText());
                NameValuePair[] paramsArray = params.toArray(new NameValuePair[params.size()]);
                this.usernameParameterCombo.setModel(new DefaultComboBoxModel<NameValuePair>(paramsArray));
                this.passwordParameterCombo.setModel(new DefaultComboBoxModel<NameValuePair>(paramsArray));
                int index = this.getIndexOfParamWithValue(paramsArray, "{%username%}");
                if (index >= 0) {
                    this.usernameParameterCombo.setSelectedIndex(index);
                }
                if ((index = this.getIndexOfParamWithValue(paramsArray, "{%password%}")) >= 0) {
                    this.passwordParameterCombo.setSelectedIndex(index);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }

        protected abstract List<NameValuePair> extractParameters(String var1);

        @Override
        public PostBasedAuthenticationMethod getMethod() {
            return this.authenticationMethod;
        }
    }

    public abstract class PostBasedAuthenticationMethod
    extends AuthenticationMethod {
        private static final String LOGIN_ICON_RESOURCE = "/resource/icon/fugue/door-open-green-arrow.png";
        public static final String MSG_USER_PATTERN = "{%username%}";
        public static final String MSG_PASS_PATTERN = "{%password%}";
        private final String contentType;
        private final UnaryOperator<String> paramEncoder;
        private HttpSender httpSender;
        private SiteNode markedLoginSiteNode;
        private SiteNode loginSiteNode = null;
        private String loginRequestURL;
        private String loginPageUrl;
        private String loginRequestBody;
        private ExtensionAntiCSRF extAntiCsrf;

        protected PostBasedAuthenticationMethod(String contentType, UnaryOperator<String> paramEncoder, PostBasedAuthenticationMethod authenticationMethod) {
            this.contentType = contentType + "; charset=utf-8";
            this.paramEncoder = paramEncoder;
            if (authenticationMethod != null) {
                this.loginRequestURL = authenticationMethod.loginRequestURL;
                this.loginRequestBody = authenticationMethod.loginRequestBody;
                this.loginSiteNode = authenticationMethod.loginSiteNode;
                this.markedLoginSiteNode = authenticationMethod.markedLoginSiteNode;
                this.loginPageUrl = authenticationMethod.loginPageUrl;
            }
        }

        @Override
        public boolean isConfigured() {
            if (PostBasedAuthenticationMethodType.this.postDataRequired && (this.loginRequestBody == null || this.loginRequestBody.isEmpty())) {
                return false;
            }
            return this.loginRequestURL != null && !this.loginRequestURL.isEmpty();
        }

        @Override
        public AuthenticationCredentials createAuthenticationCredentials() {
            return new UsernamePasswordAuthenticationCredentials();
        }

        protected HttpSender getHttpSender() {
            if (this.httpSender == null) {
                this.httpSender = new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), true, 5);
            }
            return this.httpSender;
        }

        protected HttpMessage prepareRequestMessage(UsernamePasswordAuthenticationCredentials credentials) throws URIException, HttpMalformedHeaderException, DatabaseException {
            HttpMessage requestMessage;
            URI requestURI = PostBasedAuthenticationMethodType.createLoginUrl(this.loginRequestURL, credentials.getUsername(), credentials.getPassword());
            String requestBody = null;
            if (this.loginRequestBody != null && !this.loginRequestBody.isEmpty()) {
                requestBody = PostBasedAuthenticationMethodType.replaceUserData(this.loginRequestBody, credentials.getUsername(), credentials.getPassword(), this.paramEncoder);
            }
            if (this.loginSiteNode != null) {
                requestMessage = this.loginSiteNode.getHistoryReference().getHttpMessage().cloneRequest();
                requestMessage.getRequestHeader().setURI(requestURI);
                if (requestBody != null) {
                    requestMessage.getRequestBody().setBody(requestBody);
                    requestMessage.getRequestHeader().setHeader("Content-Length", null);
                }
            } else {
                String method = requestBody != null ? "POST" : "GET";
                requestMessage = new HttpMessage();
                requestMessage.setRequestHeader(new HttpRequestHeader(method, requestURI, "HTTP/1.0"));
                if (requestBody != null) {
                    requestMessage.getRequestHeader().setHeader("Content-Type", this.contentType);
                    requestMessage.getRequestBody().setBody(requestBody);
                }
            }
            return requestMessage;
        }

        @Override
        public WebSession authenticate(SessionManagementMethod sessionManagementMethod, AuthenticationCredentials credentials, User user) throws AuthenticationMethod.UnsupportedAuthenticationCredentialsException {
            HttpMessage msg;
            if (!(credentials instanceof UsernamePasswordAuthenticationCredentials)) {
                throw new AuthenticationMethod.UnsupportedAuthenticationCredentialsException("Post based authentication method only supports " + UsernamePasswordAuthenticationCredentials.class.getSimpleName() + ". Received: " + credentials.getClass());
            }
            UsernamePasswordAuthenticationCredentials cred = (UsernamePasswordAuthenticationCredentials)credentials;
            if (!cred.isConfigured()) {
                LOGGER.warn((Object)("No credentials to authenticate user: " + user.getName()));
                return null;
            }
            try {
                if (user.getAuthenticatedSession() == null) {
                    user.setAuthenticatedSession(sessionManagementMethod.createEmptyWebSession());
                }
                String requestUri = StringUtils.isBlank((CharSequence)this.loginPageUrl) ? this.loginRequestURL : this.loginPageUrl;
                HttpMessage loginMsgToRenewCookie = new HttpMessage(new URI(requestUri, true));
                loginMsgToRenewCookie.setRequestingUser(user);
                this.getHttpSender().sendAndReceive(loginMsgToRenewCookie);
                AuthenticationHelper.addAuthMessageToHistory(loginMsgToRenewCookie);
                msg = this.prepareRequestMessage(cred);
                msg.setRequestingUser(user);
                this.replaceAntiCsrfTokenValueIfRequired(msg, loginMsgToRenewCookie);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Unable to prepare authentication message: " + e.getMessage()), (Throwable)e);
                return null;
            }
            msg.getRequestHeader().setHeader("Cookie", null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Authentication request header: \n" + msg.getRequestHeader()));
                if (!msg.getRequestHeader().getMethod().equals("GET")) {
                    LOGGER.debug((Object)("Authentication request body: \n" + msg.getRequestBody()));
                }
            }
            try {
                this.getHttpSender().sendAndReceive(msg);
            }
            catch (IOException e) {
                LOGGER.error((Object)("Unable to send authentication message: " + e.getMessage()));
                return null;
            }
            if (this.isAuthenticated(msg)) {
                AuthenticationHelper.notifyOutputAuthSuccessful(msg);
            } else {
                AuthenticationHelper.notifyOutputAuthFailure(msg);
            }
            AuthenticationHelper.addAuthMessageToHistory(msg);
            return sessionManagementMethod.extractWebSession(msg);
        }

        private void replaceAntiCsrfTokenValueIfRequired(HttpMessage requestMessage, HttpMessage loginMsgWithFreshAcsrfToken) {
            String postRequestBody;
            Map<String, String> parameters;
            if (this.extAntiCsrf == null) {
                this.extAntiCsrf = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAntiCSRF.class);
            }
            List<AntiCsrfToken> freshAcsrfTokens = null;
            if (this.extAntiCsrf == null) {
                LOGGER.debug((Object)"ExtensionAntiCSRF is not available, skipping ACSRF replacing task");
                return;
            }
            freshAcsrfTokens = this.extAntiCsrf.getTokensFromResponse(loginMsgWithFreshAcsrfToken);
            if (freshAcsrfTokens == null || freshAcsrfTokens.size() == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("No ACSRF token found in the response of " + loginMsgWithFreshAcsrfToken.getRequestHeader()));
                }
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("The login page has " + freshAcsrfTokens.size() + " ACSRF token(s)"));
            }
            if ((parameters = this.extractParametersFromPostData(postRequestBody = requestMessage.getRequestBody().toString())) != null) {
                String oldAcsrfTokenValue = null;
                String replacedPostData = postRequestBody;
                for (AntiCsrfToken antiCsrfToken : freshAcsrfTokens) {
                    oldAcsrfTokenValue = parameters.get(antiCsrfToken.getName());
                    if (oldAcsrfTokenValue == null) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug((Object)("ACSRF token " + antiCsrfToken.getName() + " not found in the POST data: " + postRequestBody));
                        continue;
                    }
                    replacedPostData = replacedPostData.replace(oldAcsrfTokenValue, (CharSequence)this.paramEncoder.apply(antiCsrfToken.getValue()));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("replaced " + oldAcsrfTokenValue + " old ACSRF token value with " + antiCsrfToken.getValue()));
                }
                requestMessage.getRequestBody().setBody(replacedPostData);
            } else {
                LOGGER.debug((Object)"ACSRF token found but could not replace old value with fresh value");
            }
        }

        private Map<String, String> extractParametersFromPostData(String postRequestBody) {
            Context context = Model.getSingleton().getSession().getContextsForUrl(this.loginRequestURL).get(0);
            if (context != null) {
                return context.getPostParamParser().parse(postRequestBody);
            }
            return null;
        }

        public void setLoginRequest(SiteNode loginSiteNode) throws Exception {
            this.loginSiteNode = loginSiteNode;
            HttpMessage requestMessage = loginSiteNode.getHistoryReference().getHttpMessage();
            this.loginRequestURL = requestMessage.getRequestHeader().getURI().toString();
            this.loginRequestBody = !requestMessage.getRequestHeader().getMethod().equalsIgnoreCase("GET") ? requestMessage.getRequestBody().toString() : null;
        }

        public String getLoginRequestURL() {
            return this.loginRequestURL;
        }

        private void markLoginSiteNode(SiteNode sn) {
            if (this.markedLoginSiteNode == sn) {
                return;
            }
            if (this.markedLoginSiteNode != null) {
                this.markedLoginSiteNode.removeCustomIcon(LOGIN_ICON_RESOURCE);
            }
            this.markedLoginSiteNode = sn;
            if (sn == null) {
                return;
            }
            sn.addCustomIcon(LOGIN_ICON_RESOURCE, false);
        }

        protected void setLoginRequest(String url, String postData) throws Exception {
            if (url == null || url.length() == 0) {
                this.loginRequestURL = null;
                this.loginRequestBody = null;
                this.loginSiteNode = null;
            } else {
                String method = "GET";
                if (postData != null && postData.length() > 0) {
                    method = "POST";
                }
                this.loginRequestURL = url;
                this.loginRequestBody = postData;
                URI uri = PostBasedAuthenticationMethodType.createLoginUrl(this.loginRequestURL, "", "");
                this.loginSiteNode = Model.getSingleton().getSession().getSiteTree().findNode(uri, method, postData);
            }
        }

        protected void setLoginPageUrl(String loginPageUrl) {
            this.loginPageUrl = loginPageUrl;
        }

        protected void setLoginPageUrl(SiteNode loginFormSiteNode) throws HttpMalformedHeaderException, DatabaseException {
            this.loginPageUrl = loginFormSiteNode.getHistoryReference().getHttpMessage().getRequestHeader().getURI().toString();
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [loginURI=" + this.loginRequestURL + "]";
        }

        @Override
        public void onMethodPersisted() {
            this.markLoginSiteNode(this.loginSiteNode);
        }

        @Override
        public void onMethodDiscarded() {
            this.markLoginSiteNode(null);
        }

        @Override
        public ApiResponse getApiResponseRepresentation() {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("methodName", PostBasedAuthenticationMethodType.this.apiMethodName);
            values.put(PostBasedAuthenticationMethodType.PARAM_LOGIN_URL, this.loginRequestURL);
            values.put(PostBasedAuthenticationMethodType.PARAM_LOGIN_PAGE_URL, this.loginPageUrl);
            values.put(PostBasedAuthenticationMethodType.PARAM_LOGIN_REQUEST_DATA, this.loginRequestBody);
            return new AuthenticationMethod.AuthMethodApiResponseRepresentation(values);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.loginRequestBody == null ? 0 : this.loginRequestBody.hashCode());
            result = 31 * result + (this.loginRequestURL == null ? 0 : this.loginRequestURL.hashCode());
            result = 31 * result + (this.loginPageUrl == null ? 0 : this.loginPageUrl.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PostBasedAuthenticationMethod other = (PostBasedAuthenticationMethod)obj;
            if (this.loginRequestBody == null ? other.loginRequestBody != null : !this.loginRequestBody.equals(other.loginRequestBody)) {
                return false;
            }
            if (this.loginRequestURL == null ? other.loginRequestURL != null : !this.loginRequestURL.equals(other.loginRequestURL)) {
                return false;
            }
            return !(this.loginPageUrl == null ? other.loginPageUrl != null : !this.loginPageUrl.equals(other.loginPageUrl));
        }
    }
}

