/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import com.headius.invokebinder.Binder;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.AbstractRubyMethod;
import org.jruby.CompatVersion;
import org.jruby.EvalType;
import org.jruby.IncludedModule;
import org.jruby.IncludedModuleWrapper;
import org.jruby.MetaClass;
import org.jruby.ObjectFlags;
import org.jruby.PrependedModule;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyMethod;
import org.jruby.RubyNameError;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyUnboundMethod;
import org.jruby.anno.AnnotationHelper;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.anno.TypePopulator;
import org.jruby.common.IRubyWarnings;
import org.jruby.embed.Extension;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.AliasMethod;
import org.jruby.internal.runtime.methods.AttrReaderMethod;
import org.jruby.internal.runtime.methods.AttrWriterMethod;
import org.jruby.internal.runtime.methods.DefineMethodMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.internal.runtime.methods.NativeCallMethod;
import org.jruby.internal.runtime.methods.PartialDelegatingMethod;
import org.jruby.internal.runtime.methods.ProcMethod;
import org.jruby.internal.runtime.methods.RefinedMarker;
import org.jruby.internal.runtime.methods.RefinedWrapper;
import org.jruby.internal.runtime.methods.SynchronizedDynamicMethod;
import org.jruby.internal.runtime.methods.UndefinedMethod;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRMethod;
import org.jruby.ir.targets.Bootstrap;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.binding.MethodGatherer;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.IRBlockBody;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.Variable;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.runtime.opto.OptoFactory;
import org.jruby.runtime.profile.MethodEnhancer;
import org.jruby.util.ByteListHelper;
import org.jruby.util.ClassProvider;
import org.jruby.util.CommonByteLists;
import org.jruby.util.IdUtil;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.WeakHashSet;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyClass(name={"Module"})
public class RubyModule
extends RubyObject {
    private static final Logger LOG;
    public static final int CACHEPROXY_F;
    public static final int NEEDSIMPL_F;
    public static final int REFINED_MODULE_F;
    public static final int IS_OVERLAID_F;
    public static final int OMOD_SHARED;
    public static final int INCLUDED_INTO_REFINEMENT;
    public static final ObjectAllocator MODULE_ALLOCATOR;
    protected static final CacheEntryFactory NormalCacheEntryFactory;
    private volatile CacheEntryFactory cacheEntryFactory;
    public KindOf kindOf = KindOf.DEFAULT_KIND_OF;
    public final int id;
    private MethodHandle idTest;
    public RubyModule parent;
    protected String baseName;
    private transient String cachedName;
    private transient RubyString cachedRubyName;
    private volatile Map<String, ConstantEntry> constants = Collections.EMPTY_MAP;
    private volatile Map<String, Autoload> autoloads = Collections.EMPTY_MAP;
    protected volatile Map<String, DynamicMethod> methods = Collections.EMPTY_MAP;
    protected Map<String, CacheEntry> cachedMethods = Collections.EMPTY_MAP;
    protected int generation;
    protected Integer generationObject;
    protected volatile Set<RubyClass> includingHierarchies = Collections.EMPTY_SET;
    protected volatile RubyModule methodLocation = this;
    private volatile transient Set<ClassProvider> classProviders = Collections.EMPTY_SET;
    protected RubyClass superClass;
    @Deprecated
    public int index;
    @Deprecated
    public static final Set<String> SCOPE_CAPTURING_METHODS;
    protected ClassIndex classIndex = ClassIndex.NO_INDEX;
    private volatile Map<String, IRubyObject> classVariables = Collections.EMPTY_MAP;
    private volatile Map<RubyModule, RubyModule> refinements = Collections.EMPTY_MAP;
    private volatile Map<RubyModule, IncludedModule> activatedRefinements = Collections.EMPTY_MAP;
    volatile RubyModule refinedClass = null;
    private volatile RubyModule definedAt = null;
    private static final AtomicReferenceFieldUpdater<RubyModule, Map> CLASSVARS_UPDATER;
    protected final Invalidator methodInvalidator;
    private boolean javaProxy = false;
    private static final MethodHandles.Lookup LOOKUP;
    private static final MethodHandle testModuleMatch;

    public static RubyClass createModuleClass(Ruby runtime2, RubyClass moduleClass) {
        moduleClass.setClassIndex(ClassIndex.MODULE);
        moduleClass.setReifiedClass(RubyModule.class);
        moduleClass.kindOf = new JavaClassKindOf(RubyModule.class);
        moduleClass.defineAnnotatedMethods(RubyModule.class);
        moduleClass.defineAnnotatedMethods(ModuleKernelMethods.class);
        return moduleClass;
    }

    public void checkValidBindTargetFrom(ThreadContext context, RubyModule originModule) throws RaiseException {
        if (!originModule.isModule() && !this.hasModuleInHierarchy(originModule)) {
            if (originModule instanceof MetaClass) {
                throw context.runtime.newTypeError("can't bind singleton method to a different class");
            }
            throw context.runtime.newTypeError("bind argument must be an instance of " + originModule.getName());
        }
    }

    public ClassIndex getClassIndex() {
        return this.classIndex;
    }

    void setClassIndex(ClassIndex classIndex) {
        this.classIndex = classIndex;
        this.index = classIndex.ordinal();
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.MODULE;
    }

    @Override
    public boolean isModule() {
        return true;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isInstance(IRubyObject object) {
        return this.kindOf.isKindOf(object, this);
    }

    public Map<String, ConstantEntry> getConstantMap() {
        return this.constants;
    }

    public synchronized Map<String, ConstantEntry> getConstantMapForWrite() {
        return this.constants == Collections.EMPTY_MAP ? (this.constants = new ConcurrentHashMap<String, ConstantEntry>(4, 0.9f, 1)) : this.constants;
    }

    private Map<String, Autoload> getAutoloadMap() {
        return this.autoloads;
    }

    private synchronized Map<String, Autoload> getAutoloadMapForWrite() {
        return this.autoloads == Collections.EMPTY_MAP ? (this.autoloads = new ConcurrentHashMap<String, Autoload>(4, 0.9f, 1)) : this.autoloads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncludingHierarchy(IncludedModule hierarchy) {
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            Set<RubyClass> including = this.includingHierarchies;
            if (including == Collections.EMPTY_SET) {
                including = this.includingHierarchies = new WeakHashSet<RubyClass>(4);
            }
            including.add(hierarchy);
        }
    }

    public final MethodHandle getIdTest() {
        MethodHandle idTest = this.idTest;
        if (idTest != null) {
            return idTest;
        }
        this.idTest = this.newIdTest();
        return this.idTest;
    }

    protected final MethodHandle newIdTest() {
        return Binder.from(Boolean.TYPE, ThreadContext.class, IRubyObject.class).insert(2, this.id).invoke(testModuleMatch);
    }

    protected RubyModule(Ruby runtime2, RubyClass metaClass, boolean objectSpace) {
        super(runtime2, metaClass, objectSpace);
        this.id = runtime2.allocModuleId();
        runtime2.addModule(this);
        this.setFlag(NEEDSIMPL_F, !this.isClass());
        this.updateGeneration(runtime2);
        this.cacheEntryFactory = runtime2.getInstanceConfig().isProfiling() ? new ProfilingCacheEntryFactory(runtime2, NormalCacheEntryFactory) : NormalCacheEntryFactory;
        this.methodInvalidator = OptoFactory.newMethodInvalidator(this);
    }

    protected RubyModule(Ruby runtime2, RubyClass metaClass) {
        this(runtime2, metaClass, runtime2.isObjectSpaceEnabled());
    }

    protected RubyModule(Ruby runtime2) {
        this(runtime2, runtime2.getModule());
    }

    public boolean needsImplementer() {
        return this.getFlag(NEEDSIMPL_F);
    }

    public static RubyModule newModule(Ruby runtime2) {
        return new RubyModule(runtime2);
    }

    public static RubyModule newModule(Ruby runtime2, String name2, RubyModule parent, boolean setParent) {
        RubyModule module = RubyModule.newModule(runtime2);
        module.setBaseName(name2);
        if (setParent) {
            module.setParent(parent);
        }
        parent.setConstant(name2, module);
        return module;
    }

    public final synchronized void addClassProvider(ClassProvider provider) {
        Set<ClassProvider> classProviders = this.classProviders;
        if (!classProviders.contains(provider)) {
            HashSet<ClassProvider> cp = new HashSet<ClassProvider>(classProviders.size() + 1);
            cp.addAll(classProviders);
            cp.add(provider);
            this.classProviders = cp;
        }
    }

    public final synchronized void removeClassProvider(ClassProvider provider) {
        HashSet<ClassProvider> cp = new HashSet<ClassProvider>(this.classProviders);
        cp.remove(provider);
        this.classProviders = cp;
    }

    private void checkForCyclicInclude(RubyModule m) throws RaiseException {
        if (this.getNonIncludedClass() == m.getNonIncludedClass()) {
            throw this.getRuntime().newArgumentError("cyclic include detected");
        }
    }

    protected void checkForCyclicPrepend(RubyModule m) throws RaiseException {
        if (this.getNonIncludedClass() == m.getNonIncludedClass()) {
            throw this.getRuntime().newArgumentError(this.getName() + " cyclic prepend detected " + m.getName());
        }
    }

    private RubyClass searchProvidersForClass(String name2, RubyClass superClazz) {
        Set<ClassProvider> classProviders = this.classProviders;
        if (classProviders == Collections.EMPTY_SET) {
            return null;
        }
        for (ClassProvider classProvider : classProviders) {
            RubyClass clazz = classProvider.defineClassUnder(this, name2, superClazz);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    private RubyModule searchProvidersForModule(String name2) {
        Set<ClassProvider> classProviders = this.classProviders;
        if (classProviders == Collections.EMPTY_SET) {
            return null;
        }
        for (ClassProvider classProvider : classProviders) {
            RubyModule module = classProvider.defineModuleUnder(this, name2);
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(RubyClass superClass) {
        this.superClass = superClass;
        if (superClass != null && superClass.isSynchronized()) {
            this.becomeSynchronized();
        }
    }

    public RubyModule getParent() {
        return this.parent;
    }

    public void setParent(RubyModule parent) {
        this.parent = parent;
    }

    public RubyModule getMethodLocation() {
        return this.methodLocation;
    }

    public void setMethodLocation(RubyModule module) {
        this.methodLocation = module;
    }

    public Map<String, DynamicMethod> getMethods() {
        return this.methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DynamicMethod> getMethodsForWrite() {
        Map<String, DynamicMethod> methods2 = this.methods;
        if (methods2 != Collections.EMPTY_MAP) {
            return methods2;
        }
        RubyModule rubyModule = this;
        synchronized (rubyModule) {
            methods2 = this.methods;
            return methods2 == Collections.EMPTY_MAP ? (this.methods = new ConcurrentHashMap<String, DynamicMethod>(0, 0.9f, 1)) : methods2;
        }
    }

    public DynamicMethod putMethod(Ruby runtime2, String id2, DynamicMethod method2) {
        DynamicMethod oldMethod;
        if (this.hasPrepends()) {
            method2 = method2.dup();
            method2.setImplementationClass(this.methodLocation);
        }
        if ((oldMethod = this.methodLocation.getMethodsForWrite().put(id2, method2)) != null && oldMethod.isRefined()) {
            this.methodLocation.getMethodsForWrite().put(id2, new RefinedWrapper(method2.getImplementationClass(), method2.getVisibility(), id2, method2));
        }
        runtime2.addProfiledMethod(id2, method2);
        return method2;
    }

    public boolean isIncluded() {
        return false;
    }

    public boolean isPrepended() {
        return false;
    }

    public RubyModule getNonIncludedClass() {
        return this;
    }

    public RubyModule getDelegate() {
        return this;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String name2) {
        this.baseName = name2;
        this.cachedName = null;
    }

    public String getName() {
        if (this.cachedName != null) {
            return this.cachedName;
        }
        return this.calculateName();
    }

    public RubyString rubyName() {
        return this.cachedRubyName != null ? this.cachedRubyName : this.calculateRubyName();
    }

    public RubyString rubyBaseName() {
        String baseName = this.getBaseName();
        Ruby runtime2 = this.metaClass.runtime;
        return baseName == null ? null : runtime2.newSymbol(baseName).to_s(runtime2);
    }

    private RubyString calculateAnonymousRubyName() {
        Ruby runtime2 = this.getRuntime();
        RubyString anonBase = runtime2.newString("#<");
        anonBase.append(this.metaClass.getRealClass().rubyName()).append(runtime2.newString(":0x"));
        anonBase.append(runtime2.newString(Integer.toHexString(System.identityHashCode(this)))).append(runtime2.newString(">"));
        return anonBase;
    }

    private RubyString calculateRubyName() {
        boolean cache = true;
        if (this.getBaseName() == null) {
            return this.calculateAnonymousRubyName();
        }
        Ruby runtime2 = this.getRuntime();
        RubyClass objectClass = runtime2.getObject();
        ArrayList<RubyString> parents = new ArrayList<RubyString>();
        for (RubyModule p2 = this.getParent(); p2 != null && p2 != objectClass && p2 != this; p2 = p2.getParent()) {
            RubyString name2 = p2.rubyBaseName();
            if (name2 == null) {
                cache = false;
                name2 = p2.rubyName();
            }
            parents.add(name2);
        }
        Collections.reverse(parents);
        RubyString colons = runtime2.newString("::");
        RubyString fullName = runtime2.newString();
        fullName.setEncoding(USASCIIEncoding.INSTANCE);
        for (RubyString parent : parents) {
            fullName.cat19(parent).cat19(colons);
        }
        fullName.cat19(this.rubyBaseName());
        fullName.setFrozen(true);
        if (cache) {
            this.cachedRubyName = fullName;
        }
        return fullName;
    }

    public String getSimpleName() {
        if (this.baseName != null) {
            return this.baseName;
        }
        return this.calculateAnonymousName();
    }

    private String calculateName() {
        boolean cache = true;
        if (this.getBaseName() == null) {
            return this.calculateAnonymousName();
        }
        Ruby runtime2 = this.getRuntime();
        String name2 = this.getBaseName();
        RubyClass objectClass = runtime2.getObject();
        int parentCount = 0;
        for (RubyModule p2 = this.getParent(); p2 != null && p2 != objectClass && p2 != this; p2 = p2.getParent()) {
            ++parentCount;
        }
        String[] parentNames = new String[parentCount];
        int i2 = parentCount - 1;
        int totalLength = name2.length() + parentCount * 2;
        RubyModule p3 = this.getParent();
        while (p3 != null && p3 != objectClass && p3 != this) {
            Object pName = p3.getBaseName();
            if (pName == null) {
                cache = false;
                pName = p3.getName();
            }
            parentNames[i2] = pName;
            totalLength += ((String)pName).length();
            p3 = p3.getParent();
            --i2;
        }
        StringBuilder builder = new StringBuilder(totalLength);
        for (String parentName : parentNames) {
            builder.append(parentName).append("::");
        }
        builder.append(name2);
        String fullName = builder.toString();
        if (cache) {
            this.cachedName = fullName;
        }
        return fullName;
    }

    private String calculateAnonymousName() {
        String cachedName = this.cachedName;
        if (cachedName == null) {
            StringBuilder anonBase = new StringBuilder(24);
            anonBase.append("#<").append(this.metaClass.getRealClass().getName()).append(":0x");
            anonBase.append(Integer.toHexString(System.identityHashCode(this))).append('>');
            cachedName = this.cachedName = anonBase.toString();
        }
        return cachedName;
    }

    @JRubyMethod(name={"refine"}, required=1, reads={FrameField.SCOPE})
    public IRubyObject refine(ThreadContext context, IRubyObject klass, Block block) {
        RubyModule moduleToRefine;
        RubyModule refinement;
        if (!block.isGiven()) {
            throw context.runtime.newArgumentError("no block given");
        }
        if (block.isEscaped()) {
            throw context.runtime.newArgumentError("can't pass a Proc as a block to Module#refine");
        }
        if (!(klass instanceof RubyModule)) {
            throw context.runtime.newTypeError("wrong argument type " + klass.getType() + "(expected Class or Module)");
        }
        if (this.refinements == Collections.EMPTY_MAP) {
            this.refinements = RubyModule.newRefinementsMap();
        }
        if (this.activatedRefinements == Collections.EMPTY_MAP) {
            this.activatedRefinements = RubyModule.newActivatedRefinementsMap();
        }
        if ((refinement = this.refinements.get(moduleToRefine = (RubyModule)klass)) == null) {
            refinement = this.createNewRefinedModule(context, moduleToRefine);
            this.addActivatedRefinement(context, moduleToRefine, refinement);
        }
        this.yieldRefineBlock(context, refinement, block);
        return refinement;
    }

    private RubyModule createNewRefinedModule(ThreadContext context, RubyModule klass) {
        Ruby runtime2 = context.runtime;
        RubyModule newRefinement = new RubyModule(runtime2);
        RubyClass superClass = RubyModule.refinementSuperclass(runtime2, klass);
        newRefinement.setSuperClass(superClass);
        newRefinement.setFlag(REFINED_MODULE_F, true);
        newRefinement.setFlag(NEEDSIMPL_F, false);
        newRefinement.refinedClass = klass;
        newRefinement.definedAt = this;
        this.refinements.put(klass, newRefinement);
        return newRefinement;
    }

    private static RubyClass refinementSuperclass(Ruby runtime2, RubyModule superClass) {
        if (superClass.isModule()) {
            return new IncludedModuleWrapper(runtime2, runtime2.getBasicObject(), superClass);
        }
        return (RubyClass)superClass;
    }

    private void yieldRefineBlock(ThreadContext context, RubyModule refinement, Block block) {
        block = block.cloneBlockAndFrame(EvalType.MODULE_EVAL);
        block.getBinding().setSelf(refinement);
        RubyModule overlayModule = block.getBody().getStaticScope().getOverlayModuleForWrite(context);
        overlayModule.refinements = this.refinements;
        block.yieldSpecific(context);
    }

    private RubyClass getAlreadyActivatedRefinementWrapper(RubyClass classWeAreRefining, RubyModule refinement) {
        RubyClass moduleWrapperForRefinement = this.activatedRefinements.get(classWeAreRefining);
        if (moduleWrapperForRefinement == null) {
            return classWeAreRefining;
        }
        for (RubyClass c = moduleWrapperForRefinement; c != null && c.isIncluded(); c = c.getSuperClass()) {
            if (c.getNonIncludedClass() != refinement) continue;
            return null;
        }
        return moduleWrapperForRefinement;
    }

    private void addActivatedRefinement(ThreadContext context, RubyModule moduleToRefine, RubyModule refinement) {
        RubyClass superClass = null;
        RubyClass c = this.activatedRefinements.get(moduleToRefine);
        if (c != null) {
            superClass = c;
            while (c != null && c.isIncluded()) {
                if (((IncludedModuleWrapper)c).getNonIncludedClass() == refinement) {
                    return;
                }
                c = c.getSuperClass();
            }
        }
        refinement.setFlag(IS_OVERLAID_F, true);
        IncludedModuleWrapper iclass = new IncludedModuleWrapper(context.runtime, superClass, refinement);
        c = iclass;
        c.refinedClass = moduleToRefine;
        for (refinement = refinement.getSuperClass(); refinement != null; refinement = refinement.getSuperClass()) {
            refinement.setFlag(IS_OVERLAID_F, true);
            c.setSuperClass(new IncludedModuleWrapper(context.runtime, c.getSuperClass(), refinement));
            c = c.getSuperClass();
            c.refinedClass = moduleToRefine;
        }
        this.activatedRefinements.put(moduleToRefine, iclass);
    }

    @JRubyMethod(name={"using"}, required=1, visibility=Visibility.PRIVATE, reads={FrameField.SELF, FrameField.SCOPE})
    public IRubyObject using(ThreadContext context, IRubyObject refinedModule) {
        if (context.getFrameSelf() != this) {
            throw context.runtime.newRuntimeError("Module#using is not called on self");
        }
        if (context.getCurrentStaticScope().getIRScope() instanceof IRMethod) {
            throw context.runtime.newRuntimeError("Module#using is not permitted in methods");
        }
        StaticScope staticScope = context.getCurrentStaticScope();
        RubyModule overlayModule = staticScope.getOverlayModuleForWrite(context);
        RubyModule.usingModule(context, overlayModule, refinedModule);
        return this;
    }

    public static void usingModule(ThreadContext context, RubyModule cref, IRubyObject refinedModule) {
        if (!(refinedModule instanceof RubyModule)) {
            throw context.runtime.newTypeError(refinedModule, context.runtime.getModule());
        }
        RubyModule.usingModuleRecursive(cref, (RubyModule)refinedModule);
    }

    private static void usingModuleRecursive(RubyModule cref, RubyModule module) {
        Ruby runtime2 = cref.getRuntime();
        RubyClass superClass = module.getSuperClass();
        if (superClass != null) {
            RubyModule.usingModuleRecursive(cref, superClass);
        }
        if (module instanceof IncludedModule) {
            module = module.getDelegate();
        } else if (!module.isModule()) {
            throw runtime2.newTypeError("wrong argument type " + module.getName() + " (expected Module)");
        }
        Map<RubyModule, RubyModule> refinements = module.refinements;
        if (refinements == null) {
            return;
        }
        for (Map.Entry<RubyModule, RubyModule> entry : refinements.entrySet()) {
            RubyModule.usingRefinement(runtime2, cref, entry.getKey(), entry.getValue());
        }
    }

    private static void usingRefinement(Ruby runtime2, RubyModule cref, RubyModule klass, RubyModule module) {
        RubyModule c;
        RubyModule superclass2 = klass;
        if (cref.refinements == Collections.EMPTY_MAP) {
            cref.refinements = RubyModule.newRefinementsMap();
        } else {
            if (cref.getFlag(OMOD_SHARED)) {
                cref.refinements = RubyModule.newRefinementsMap(cref.refinements);
                cref.setFlag(OMOD_SHARED, false);
            }
            if ((c = cref.refinements.get(klass)) != null) {
                superclass2 = c;
                while (c != null && c instanceof IncludedModule) {
                    if (c.getNonIncludedClass() == module) {
                        return;
                    }
                    c = c.getSuperClass();
                }
            }
        }
        module.setFlag(IS_OVERLAID_F, true);
        superclass2 = RubyModule.refinementSuperclass(runtime2, superclass2);
        IncludedModuleWrapper iclass = new IncludedModuleWrapper(runtime2, (RubyClass)superclass2, module);
        c = iclass;
        c.refinedClass = klass;
        for (module = module.getSuperClass(); module != null && module != klass; module = module.getSuperClass()) {
            module.setFlag(IS_OVERLAID_F, true);
            c.setSuperClass(new IncludedModuleWrapper(cref.getRuntime(), c.getSuperClass(), module));
            c = c.getSuperClass();
            c.refinedClass = klass;
        }
        cref.refinements.put(klass, iclass);
    }

    public static Map<RubyModule, RubyModule> newRefinementsMap(Map<RubyModule, RubyModule> refinements) {
        return Collections.synchronizedMap(new IdentityHashMap<RubyModule, RubyModule>(refinements));
    }

    public static Map<RubyModule, RubyModule> newRefinementsMap() {
        return Collections.synchronizedMap(new IdentityHashMap());
    }

    public static Map<RubyModule, IncludedModule> newActivatedRefinementsMap() {
        return Collections.synchronizedMap(new IdentityHashMap());
    }

    @JRubyMethod(name={"used_modules"}, reads={FrameField.SCOPE})
    public IRubyObject used_modules(ThreadContext context) {
        RubyArray ary = context.runtime.newArray();
        for (StaticScope cref = context.getCurrentStaticScope(); cref != null; cref = cref.getPreviousCRefScope()) {
            RubyModule overlay = cref.getOverlayModuleForRead();
            if (overlay == null || overlay.refinements.isEmpty()) continue;
            overlay.refinements.entrySet().stream().forEach(entry -> {
                for (RubyModule mod = (RubyModule)entry.getValue(); mod != null && mod.getNonIncludedClass().isRefinement(); mod = mod.getSuperClass()) {
                    ary.push(mod.getNonIncludedClass().definedAt);
                }
            });
        }
        return ary;
    }

    @Deprecated
    public IncludedModuleWrapper newIncludeClass(RubyClass superClazz) {
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(this.getRuntime(), superClazz, this);
        if (this.getSuperClass() != null) {
            includedModule.includeModule(this.getSuperClass());
        }
        return includedModule;
    }

    public RubyModule getModule(String name2) {
        return (RubyModule)this.getConstantAt(name2);
    }

    public RubyClass getClass(String name2) {
        return (RubyClass)this.getConstantAt(name2);
    }

    @Deprecated
    public RubyClass fastGetClass(String internedName) {
        return this.getClass(internedName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prependModule(RubyModule module) {
        this.testFrozen("module");
        if (module.refinedClass != null) {
            throw this.getRuntime().newArgumentError("refinement module is not allowed");
        }
        this.checkForCyclicInclude(module);
        RubyModule rubyModule = this;
        synchronized (rubyModule) {
            if (this.hasModuleInPrepends(module)) {
                this.invalidateCacheDescendants();
                return;
            }
            this.infectBy(module);
            this.doPrependModule(module);
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
            this.invalidateConstantCacheForModuleInclusion(module);
        }
    }

    @Deprecated
    public void prependModule(IRubyObject arg2) {
        assert (arg2 != null);
        if (!(arg2 instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("Wrong argument type " + arg2.getMetaClass().getName() + " (expected Module).");
        }
        this.prependModule((RubyModule)arg2);
    }

    public synchronized void includeModule(IRubyObject arg2) {
        assert (arg2 != null);
        this.testFrozen("module");
        if (!(arg2 instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("Wrong argument type " + arg2.getMetaClass().getName() + " (expected Module).");
        }
        RubyModule module = (RubyModule)arg2;
        if (module.refinedClass != null) {
            throw this.getRuntime().newArgumentError("refinement module is not allowed");
        }
        this.checkForCyclicInclude(module);
        this.infectBy(module);
        this.doIncludeModule(module);
        this.invalidateCoreClasses();
        this.invalidateCacheDescendants();
        this.invalidateConstantCacheForModuleInclusion(module);
    }

    public void defineAnnotatedMethod(Class clazz, String name2) {
        boolean foundMethod = false;
        for (Method method2 : clazz.getDeclaredMethods()) {
            if (!method2.getName().equals(name2) || !this.defineAnnotatedMethod(method2, MethodFactory.createFactory(this.getRuntime().getJRubyClassLoader()))) continue;
            foundMethod = true;
        }
        if (!foundMethod) {
            throw new RuntimeException("No JRubyMethod present for method " + name2 + "on class " + clazz.getName());
        }
    }

    public final void defineAnnotatedConstants(Class clazz) {
        for (Field field2 : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field2.getModifiers())) continue;
            this.defineAnnotatedConstant(field2);
        }
    }

    public final boolean defineAnnotatedConstant(Field field2) {
        IRubyObject realVal;
        JRubyConstant jrubyConstant = field2.getAnnotation(JRubyConstant.class);
        if (jrubyConstant == null) {
            return false;
        }
        Ruby runtime2 = this.getRuntime();
        Class<?> tp = field2.getType();
        try {
            realVal = tp == Integer.class || tp == Integer.TYPE || tp == Short.class || tp == Short.TYPE || tp == Byte.class || tp == Byte.TYPE ? RubyNumeric.int2fix(runtime2, field2.getInt(null)) : (tp == Boolean.class || tp == Boolean.TYPE ? (field2.getBoolean(null) ? runtime2.getTrue() : runtime2.getFalse()) : runtime2.getNil());
        }
        catch (Exception e) {
            realVal = runtime2.getNil();
        }
        String[] names2 = jrubyConstant.value();
        if (names2.length == 0) {
            this.setConstant(field2.getName(), realVal);
        } else {
            for (String name2 : names2) {
                this.setConstant(name2, realVal);
            }
        }
        return true;
    }

    @Extension
    public void defineAnnotatedMethods(Class clazz) {
        this.defineAnnotatedMethodsIndividually(clazz);
    }

    public static TypePopulator loadPopulatorFor(Class<?> type2) {
        block6: {
            if (Options.DEBUG_FULLTRACE.load().booleanValue() || Options.REFLECTED_HANDLES.load().booleanValue()) {
                LOG.debug("trace mode, using default populator", new Object[0]);
            } else {
                try {
                    String qualifiedName = "org.jruby.gen." + type2.getCanonicalName().replace('.', '$');
                    String fullName = qualifiedName + "$POPULATOR";
                    String fullPath = fullName.replace('.', '/') + ".class";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("looking for populator " + fullName, new Object[0]);
                    }
                    if (Ruby.getClassLoader().getResource(fullPath) != null) {
                        return (TypePopulator)Class.forName(fullName).newInstance();
                    }
                    LOG.debug("could not find it, using default populator", new Object[0]);
                }
                catch (Throwable ex) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("could not find populator, using default (" + ex + ')', new Object[0]);
                }
            }
        }
        return new TypePopulator.ReflectiveTypePopulator(type2);
    }

    public final void defineAnnotatedMethodsIndividually(Class clazz) {
        this.getRuntime().POPULATORS.get(clazz).populate(this, clazz);
    }

    public final boolean defineAnnotatedMethod(String name2, List<JavaMethodDescriptor> methods2, MethodFactory methodFactory) {
        JavaMethodDescriptor desc = methods2.get(0);
        if (methods2.size() == 1) {
            return this.defineAnnotatedMethod(name2, desc, methodFactory);
        }
        DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, methods2, name2);
        RubyModule.define(this, desc, name2, dynamicMethod);
        return true;
    }

    public final boolean defineAnnotatedMethod(Method method2, MethodFactory methodFactory) {
        JRubyMethod jrubyMethod = method2.getAnnotation(JRubyMethod.class);
        if (jrubyMethod == null) {
            return false;
        }
        JavaMethodDescriptor desc = new JavaMethodDescriptor(method2);
        DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc, method2.getName());
        RubyModule.define(this, desc, method2.getName(), dynamicMethod);
        return true;
    }

    public final boolean defineAnnotatedMethod(String name2, JavaMethodDescriptor desc, MethodFactory methodFactory) {
        JRubyMethod jrubyMethod = desc.anno;
        if (jrubyMethod == null) {
            return false;
        }
        DynamicMethod dynamicMethod = methodFactory.getAnnotatedMethod(this, desc, name2);
        RubyModule.define(this, desc, name2, dynamicMethod);
        return true;
    }

    public void undefineMethod(String name2) {
        this.methodLocation.addMethod(name2, UndefinedMethod.getInstance());
    }

    public void undef(ThreadContext context, String name2) {
        Ruby runtime2 = context.runtime;
        this.testFrozen("module");
        if (name2.equals("__send__") || name2.equals("object_id") || name2.equals("initialize")) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.UNDEFINING_BAD, "undefining `" + name2 + "' may cause serious problems");
        }
        if (name2.equals("method_missing")) {
            IRubyObject oldExc = runtime2.getGlobalVariables().get("$!");
            try {
                this.removeMethod(context, name2);
            }
            catch (RaiseException t) {
                if (!(t.getException() instanceof RubyNameError)) {
                    throw t;
                }
                runtime2.getGlobalVariables().set("$!", oldExc);
            }
            return;
        }
        DynamicMethod method2 = this.searchMethod(name2);
        if (method2.isUndefined()) {
            String s0 = " class";
            RubyModule c = this;
            if (c.isSingleton()) {
                RubyBasicObject obj = ((MetaClass)c).getAttached();
                if (obj instanceof RubyModule) {
                    c = (RubyModule)obj;
                    s0 = "";
                }
            } else if (c.isModule()) {
                s0 = " module";
            }
            throw runtime2.newNameError("Undefined method " + name2 + " for" + s0 + " '" + c.getName() + "'", name2);
        }
        this.methodLocation.addMethod(name2, UndefinedMethod.getInstance());
        if (this.isSingleton()) {
            ((MetaClass)this).getAttached().callMethod(context, "singleton_method_undefined", (IRubyObject)runtime2.newSymbol(name2));
        } else {
            this.callMethod(context, "method_undefined", (IRubyObject)runtime2.newSymbol(name2));
        }
    }

    @JRubyMethod(name={"include?"}, required=1)
    public IRubyObject include_p(ThreadContext context, IRubyObject arg2) {
        if (!arg2.isModule()) {
            throw context.runtime.newTypeError(arg2, context.runtime.getModule());
        }
        RubyModule moduleToCompare = (RubyModule)arg2;
        for (RubyClass p2 = this.getSuperClass(); p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isSame(moduleToCompare)) continue;
            return context.tru;
        }
        return context.fals;
    }

    @JRubyMethod(name={"singleton_class?"})
    public IRubyObject singleton_class_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.isSingleton());
    }

    public void addMethod(String id2, DynamicMethod method2) {
        this.testFrozen("class/module");
        RubyModule location = this;
        if (this.methodLocation != this) {
            this.methodLocation.addMethod(id2, method2);
            return;
        }
        if (this instanceof MetaClass) {
            ((MetaClass)this).getAttached().testFrozen();
        }
        if (this.isRefinement()) {
            this.addRefinedMethodEntry(id2, method2);
        }
        this.addMethodInternal(id2, method2);
    }

    private void addRefinedMethodEntry(String id2, DynamicMethod method2) {
        RubyModule methodLocation = this.refinedClass.getMethodLocation();
        DynamicMethod orig = methodLocation.searchMethodCommon(id2);
        if (orig == null) {
            this.refinedClass.addMethod(id2, new RefinedMarker(methodLocation, method2.getVisibility(), id2));
        } else {
            if (orig.isRefined()) {
                return;
            }
            this.refinedClass.addMethod(id2, new RefinedWrapper(methodLocation, method2.getVisibility(), id2, orig));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMethodInternal(String name2, DynamicMethod method2) {
        Map<String, DynamicMethod> map2 = this.methodLocation.getMethodsForWrite();
        synchronized (map2) {
            this.putMethod(this.getRuntime(), name2, method2);
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
    }

    public final void addMethodAtBootTimeOnly(String id2, DynamicMethod method2) {
        this.putMethod(this.getRuntime(), id2, method2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMethod(ThreadContext context, String id2) {
        Map<String, DynamicMethod> methodsForWrite;
        this.testFrozen("class/module");
        switch (id2) {
            case "object_id": {
                RubyModule.warnMethodRemoval(context, id2);
                break;
            }
            case "__send__": {
                RubyModule.warnMethodRemoval(context, id2);
                break;
            }
            case "initialize": {
                RubyModule.warnMethodRemoval(context, id2);
            }
        }
        RubySymbol name2 = context.runtime.newSymbol(id2);
        Map<String, DynamicMethod> map2 = methodsForWrite = this.methodLocation.getMethodsForWrite();
        synchronized (map2) {
            DynamicMethod method2 = methodsForWrite.get(id2);
            if (method2 == null || method2.isUndefined() || method2 instanceof RefinedMarker) {
                throw context.runtime.newNameError(RubyStringBuilder.str(context.runtime, "method '", name2, "' not defined in ", this.rubyName()), id2);
            }
            method2 = methodsForWrite.remove(id2);
            if (method2.isRefined()) {
                methodsForWrite.put(id2, new RefinedMarker(method2.getImplementationClass(), method2.getVisibility(), id2));
            }
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
        if (this.isSingleton()) {
            ((MetaClass)this).getAttached().callMethod(context, "singleton_method_removed", (IRubyObject)name2);
        } else {
            this.callMethod(context, "method_removed", (IRubyObject)name2);
        }
    }

    private static void warnMethodRemoval(ThreadContext context, String id2) {
        context.runtime.getWarnings().warn(IRubyWarnings.ID.UNDEFINING_BAD, RubyStringBuilder.str(context.runtime, "removing `", RubyStringBuilder.ids(context.runtime, id2), "' may cause serious problems"));
    }

    public final DynamicMethod searchMethod(String name2) {
        return this.searchWithCache((String)name2).method;
    }

    public CacheEntry searchWithCache(String name2) {
        return this.searchWithCacheAndRefinements(name2, true, null);
    }

    public CacheEntry searchWithRefinements(String name2, StaticScope refinedScope) {
        return this.searchWithCacheAndRefinements(name2, true, refinedScope);
    }

    public final CacheEntry searchWithCache(String id2, boolean cacheUndef) {
        CacheEntry entry = this.cacheHit(id2);
        return entry != null ? entry : this.searchWithCacheMiss(this.getRuntime(), id2, cacheUndef);
    }

    private final CacheEntry searchWithCacheAndRefinements(String id2, boolean cacheUndef, StaticScope refinedScope) {
        CacheEntry entry = this.searchWithCache(id2, cacheUndef);
        if (entry.method.isRefined()) {
            while (refinedScope != null) {
                RubyModule overlay = refinedScope.getOverlayModuleForRead();
                if (overlay != null) {
                    CacheEntry maybeEntry = this.resolveRefinedMethod(overlay.refinements, entry, id2, cacheUndef);
                    if (!maybeEntry.method.isUndefined()) {
                        return maybeEntry;
                    }
                }
                refinedScope = refinedScope.getEnclosingScope();
            }
            return this.resolveRefinedMethod(null, entry, id2, cacheUndef);
        }
        return entry;
    }

    private CacheEntry refinedMethodOriginalMethodEntry(Map<RubyModule, RubyModule> refinements, String id2, boolean cacheUndef, CacheEntry entry) {
        DynamicMethod method2 = entry.method;
        if (method2 instanceof RefinedWrapper) {
            return this.cacheEntryFactory.newCacheEntry(id2, ((RefinedWrapper)method2).getWrapped(), entry.sourceModule, entry.token);
        }
        RubyClass superClass = entry.sourceModule.getSuperClass();
        if (superClass == null) {
            return CacheEntry.NULL_CACHE;
        }
        return this.resolveRefinedMethod(refinements, superClass.searchWithCache(id2, cacheUndef), id2, cacheUndef);
    }

    private CacheEntry searchWithCacheMiss(Ruby runtime2, String id2, boolean cacheUndef) {
        int token = this.generation;
        CacheEntry methodEntry = this.searchMethodEntryInner(id2);
        if (methodEntry == null) {
            if (cacheUndef) {
                return this.addToCache(id2, UndefinedMethod.getInstance(), this, token);
            }
            return this.cacheEntryFactory.newCacheEntry(id2, UndefinedMethod.getInstance(), methodEntry.sourceModule, token);
        }
        if (!runtime2.isBooting()) {
            this.addToCache(id2, methodEntry);
        }
        return methodEntry;
    }

    @Deprecated
    public final int getCacheToken() {
        return this.generation;
    }

    public final int getGeneration() {
        return this.generation;
    }

    public final Integer getGenerationObject() {
        return this.generationObject;
    }

    private final Map<String, CacheEntry> getCachedMethods() {
        return this.cachedMethods;
    }

    private final Map<String, CacheEntry> getCachedMethodsForWrite() {
        Map<String, CacheEntry> myCachedMethods = this.cachedMethods;
        return myCachedMethods == Collections.EMPTY_MAP ? (this.cachedMethods = new ConcurrentHashMap<String, CacheEntry>(0, 0.75f, 1)) : myCachedMethods;
    }

    private CacheEntry cacheHit(String name2) {
        CacheEntry cacheEntry = this.methodLocation.getCachedMethods().get(name2);
        if (cacheEntry != null && cacheEntry.token == this.getGeneration()) {
            return cacheEntry;
        }
        return null;
    }

    private void invalidateConstantCacheForModuleInclusion(RubyModule module) {
        HashMap<String, Invalidator> invalidators = null;
        for (RubyModule mod : this.gatherModules(module)) {
            for (String name2 : mod.getConstantMap().keySet()) {
                if (invalidators == null) {
                    invalidators = new HashMap<String, Invalidator>();
                }
                invalidators.put(name2, this.getRuntime().getConstantInvalidator(name2));
            }
        }
        if (invalidators != null) {
            ArrayList<Invalidator> values2 = new ArrayList<Invalidator>(invalidators.values());
            ((Invalidator)values2.get(0)).invalidateAll(values2);
        }
    }

    public void becomeSynchronized() {
        this.cacheEntryFactory = new SynchronizedCacheEntryFactory(this.cacheEntryFactory);
    }

    public boolean isSynchronized() {
        return this.cacheEntryFactory.hasCacheEntryFactory(SynchronizedCacheEntryFactory.class);
    }

    protected CacheEntry addToCache(String id2, DynamicMethod method2, RubyModule sourceModule, int token) {
        CacheEntry entry = this.cacheEntryFactory.newCacheEntry(id2, method2, sourceModule, token);
        this.methodLocation.getCachedMethodsForWrite().put(id2, entry);
        return entry;
    }

    protected CacheEntry addToCache(String id2, CacheEntry entry) {
        this.methodLocation.getCachedMethodsForWrite().put(id2, entry);
        return entry;
    }

    public DynamicMethod searchMethodInner(String id2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            DynamicMethod method2 = module.searchMethodCommon(id2);
            if (method2 == null) continue;
            return method2.isNull() ? null : method2;
        }
        return null;
    }

    public CacheEntry searchMethodEntryInner(String id2) {
        int token = this.generation;
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            DynamicMethod method2 = module.searchMethodCommon(id2);
            if (method2 == null) continue;
            return method2.isNull() ? null : this.cacheEntryFactory.newCacheEntry(id2, method2, module, token);
        }
        return null;
    }

    public CacheEntry resolveRefinedMethod(Map<RubyModule, RubyModule> refinements, CacheEntry entry, String id2, boolean cacheUndef) {
        if (entry != null && entry.method.isRefined()) {
            RubyModule refinement = RubyModule.findRefinement(refinements, entry.method.getDefinedClass());
            if (refinement == null) {
                return this.refinedMethodOriginalMethodEntry(refinements, id2, cacheUndef, entry);
            }
            CacheEntry tmpEntry = refinement.searchWithCache(id2);
            if (!tmpEntry.method.isRefined()) {
                return tmpEntry;
            }
            return this.refinedMethodOriginalMethodEntry(refinements, id2, cacheUndef, entry);
        }
        return entry;
    }

    private static RubyModule findRefinement(Map<RubyModule, RubyModule> refinements, RubyModule target) {
        if (refinements == null) {
            return null;
        }
        return refinements.get(target);
    }

    protected DynamicMethod searchMethodCommon(String id2) {
        return this.getMethods().get(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCacheDescendants() {
        LOG.debug("{} invalidating descendants", this.baseName);
        this.getRuntime().getCaches().incrementMethodInvalidations();
        if (this.includingHierarchies.isEmpty()) {
            this.methodInvalidator.invalidate();
            return;
        }
        ArrayList<Invalidator> invalidators = new ArrayList<Invalidator>();
        invalidators.add(this.methodInvalidator);
        Object object = this.getRuntime().getHierarchyLock();
        synchronized (object) {
            for (RubyClass includingHierarchy : this.includingHierarchies) {
                includingHierarchy.addInvalidatorsAndFlush(invalidators);
            }
        }
        this.methodInvalidator.invalidateAll(invalidators);
    }

    protected void invalidateCoreClasses() {
        if (!this.getRuntime().isBootingCore()) {
            if (this == this.getRuntime().getFixnum()) {
                this.getRuntime().reopenFixnum();
            } else if (this == this.getRuntime().getFloat()) {
                this.getRuntime().reopenFloat();
            }
        }
    }

    public Invalidator getInvalidator() {
        return this.methodInvalidator;
    }

    public void updateGeneration() {
        this.updateGeneration(this.getRuntime());
    }

    private void updateGeneration(Ruby runtime2) {
        this.generation = runtime2.getNextModuleGeneration();
        this.generationObject = this.generation;
    }

    @Deprecated
    protected void invalidateCacheDescendantsInner() {
        this.methodInvalidator.invalidate();
    }

    protected void invalidateConstantCache(String constantName) {
        this.getRuntime().getConstantInvalidator(constantName).invalidate();
    }

    protected void invalidateConstantCaches(Set<String> constantNames) {
        if (constantNames.size() > 0) {
            Ruby runtime2 = this.getRuntime();
            ArrayList<Invalidator> constantInvalidators = new ArrayList<Invalidator>(constantNames.size());
            for (String name2 : constantNames) {
                constantInvalidators.add(runtime2.getConstantInvalidator(name2));
            }
            ((Invalidator)constantInvalidators.get(0)).invalidateAll(constantInvalidators);
        }
    }

    public DynamicMethod retrieveMethod(String name2) {
        return this.getMethods().get(name2);
    }

    public RubyModule findImplementer(RubyModule clazz) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.isSame(clazz)) continue;
            return module;
        }
        return null;
    }

    public void addModuleFunction(String name2, DynamicMethod method2) {
        this.addMethod(name2, method2);
        this.getSingletonClass().addMethod(name2, method2);
    }

    public synchronized void defineAlias(String name2, String oldName) {
        this.testFrozen("module");
        this.putAlias(name2, this.searchForAliasMethod(this.getRuntime(), oldName), oldName);
        this.methodLocation.invalidateCoreClasses();
        this.methodLocation.invalidateCacheDescendants();
    }

    public void putAlias(String id2, DynamicMethod method2, String oldName) {
        if (id2.equals(oldName)) {
            return;
        }
        this.putMethod(this.getRuntime(), id2, new AliasMethod(this, new CacheEntry(method2, method2.getImplementationClass(), this.generation), oldName));
        if (this.isRefinement()) {
            this.addRefinedMethodEntry(id2, method2);
        }
    }

    public void putAlias(String id2, CacheEntry entry, String oldName) {
        if (id2.equals(oldName)) {
            return;
        }
        this.putMethod(this.getRuntime(), id2, new AliasMethod(this, entry, oldName));
        if (this.isRefinement()) {
            this.addRefinedMethodEntry(id2, entry.method);
        }
    }

    public synchronized void defineAliases(List<String> aliases2, String oldId) {
        this.testFrozen("module");
        Ruby runtime2 = this.getRuntime();
        CacheEntry entry = this.searchForAliasMethod(runtime2, oldId);
        for (String name2 : aliases2) {
            this.putAlias(name2, entry, oldId);
        }
        this.methodLocation.invalidateCoreClasses();
        this.methodLocation.invalidateCacheDescendants();
    }

    private CacheEntry searchForAliasMethod(Ruby runtime2, String id2) {
        CacheEntry entry = this.deepMethodSearch(id2, runtime2);
        DynamicMethod method2 = entry.method;
        if (method2 instanceof NativeCallMethod) {
            DynamicMethod.NativeCall nativeCall = ((NativeCallMethod)((Object)method2)).getNativeCall();
            if (nativeCall == null) {
                return entry;
            }
            Method javaMethod = nativeCall.getMethod();
            JRubyMethod anno = javaMethod.getAnnotation(JRubyMethod.class);
            if (anno == null) {
                return entry;
            }
            if (anno.reads().length > 0 || anno.writes().length > 0) {
                MethodIndex.addMethodReadFields(id2, anno.reads());
                MethodIndex.addMethodWriteFields(id2, anno.writes());
                if (runtime2.isVerbose()) {
                    RubyBasicObject attached;
                    String baseName = this.getBaseName();
                    int refChar = 35;
                    String simpleName = this.getSimpleName();
                    if (baseName == null && this instanceof MetaClass && (attached = ((MetaClass)this).getAttached()) instanceof RubyModule) {
                        simpleName = ((RubyModule)attached).getSimpleName();
                        refChar = 46;
                    }
                    runtime2.getWarnings().warning(simpleName + (char)refChar + id2 + " accesses caller method's state and should not be aliased");
                }
            }
        }
        return entry;
    }

    public RubyClass defineOrGetClassUnder(String name2, RubyClass superClazz) {
        return this.defineOrGetClassUnder(name2, superClazz, null);
    }

    public RubyClass defineOrGetClassUnder(String name2, RubyClass superClazz, ObjectAllocator allocator) {
        RubyClass clazz;
        Ruby runtime2 = this.getRuntime();
        IRubyObject classObj = this.getConstantAtSpecial(name2);
        if (classObj != null) {
            if (!(classObj instanceof RubyClass)) {
                throw runtime2.newTypeError(name2 + " is not a class");
            }
            clazz = (RubyClass)classObj;
            if (superClazz != null) {
                RubyClass tmp;
                for (tmp = clazz.getSuperClass(); tmp != null && tmp.isIncluded(); tmp = tmp.getSuperClass()) {
                }
                if (tmp != null) {
                    tmp = tmp.getRealClass();
                }
                if (tmp != superClazz) {
                    throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, "superclass mismatch for class ", RubyStringBuilder.ids(runtime2, name2)));
                }
            }
        } else {
            clazz = this.searchProvidersForClass(name2, superClazz);
            if (clazz == null) {
                if (superClazz == null) {
                    superClazz = runtime2.getObject();
                }
                if (allocator == null) {
                    allocator = this.isReifiable(runtime2, superClazz) ? (Options.REIFY_CLASSES.load().booleanValue() ? REIFYING_OBJECT_ALLOCATOR : (Options.REIFY_VARIABLES.load().booleanValue() ? IVAR_INSPECTING_OBJECT_ALLOCATOR : OBJECT_ALLOCATOR)) : superClazz.getAllocator();
                }
                clazz = RubyClass.newClass(runtime2, superClazz, name2, allocator, this, true);
            }
        }
        return clazz;
    }

    private boolean isReifiable(Ruby runtime2, RubyClass superClass) {
        if (superClass == runtime2.getObject()) {
            return true;
        }
        return superClass.getAllocator() == IVAR_INSPECTING_OBJECT_ALLOCATOR;
    }

    public RubyModule defineOrGetModuleUnder(String name2) {
        RubyModule module;
        Ruby runtime2 = this.getRuntime();
        IRubyObject moduleObj = this.getConstantAtSpecial(name2);
        if (moduleObj != null) {
            if (!moduleObj.isModule()) {
                throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, RubyStringBuilder.ids(runtime2, name2), " is not a module"));
            }
            module = (RubyModule)moduleObj;
        } else {
            module = this.searchProvidersForModule(name2);
            if (module == null) {
                module = RubyModule.newModule(runtime2, name2, this, true);
            }
        }
        return module;
    }

    public RubyClass defineClassUnder(String name2, RubyClass superClass, ObjectAllocator allocator) {
        return superClass.runtime.defineClassUnder(name2, superClass, allocator, this);
    }

    public RubyModule defineModuleUnder(String name2) {
        return this.metaClass.runtime.defineModuleUnder(name2, this);
    }

    private void addAccessor(ThreadContext context, RubySymbol identifier, Visibility visibility, boolean readable, boolean writeable) {
        String internedIdentifier = identifier.idString();
        Ruby runtime2 = context.runtime;
        if (visibility == Visibility.MODULE_FUNCTION) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.ACCESSOR_MODULE_FUNCTION, "attribute accessor as module_function");
            visibility = Visibility.PRIVATE;
        }
        if (!IdUtil.isLocal(internedIdentifier) && !IdUtil.isConstant(internedIdentifier)) {
            throw runtime2.newNameError("invalid attribute name", internedIdentifier);
        }
        String variableName = identifier.asInstanceVariable().idString();
        if (readable) {
            this.addMethod(internedIdentifier, new AttrReaderMethod(this.methodLocation, visibility, variableName));
            this.callMethod(context, "method_added", (IRubyObject)identifier);
        }
        if (writeable) {
            identifier = identifier.asWriter();
            this.addMethod(identifier.idString(), new AttrWriterMethod(this.methodLocation, visibility, variableName));
            this.callMethod(context, "method_added", (IRubyObject)identifier);
        }
    }

    public void setMethodVisibility(IRubyObject[] methods2, Visibility visibility) {
        for (int i2 = 0; i2 < methods2.length; ++i2) {
            this.exportMethod(TypeConverter.checkID(methods2[i2]).idString(), visibility);
        }
    }

    public void exportMethod(String name2, Visibility visibility) {
        Ruby runtime2 = this.getRuntime();
        CacheEntry entry = this.deepMethodSearch(name2, runtime2);
        DynamicMethod method2 = entry.method;
        if (method2.getVisibility() != visibility) {
            if (this == method2.getImplementationClass()) {
                method2.setVisibility(visibility);
            } else {
                PartialDelegatingMethod newMethod = new PartialDelegatingMethod(this, method2, visibility);
                this.methodLocation.addMethod(name2, newMethod);
            }
            this.invalidateCoreClasses();
            this.invalidateCacheDescendants();
        }
    }

    private CacheEntry deepMethodSearch(String id2, Ruby runtime2) {
        CacheEntry orig;
        block4: {
            block5: {
                orig = this.searchWithCache(id2);
                if (orig.method.isRefined()) {
                    orig = this.resolveRefinedMethod(null, orig, id2, true);
                }
                if (!orig.method.isUndefined() && !orig.method.isRefined()) break block4;
                if (!this.isModule()) break block5;
                orig = runtime2.getObject().searchWithCache(id2);
                if (!orig.method.isUndefined()) break block4;
            }
            RubySymbol name2 = runtime2.newSymbol(id2);
            throw runtime2.newNameError(RubyModule.undefinedMethodMessage(runtime2, name2, this.rubyName(), this.isModule()), id2);
        }
        return orig;
    }

    public static String undefinedMethodMessage(Ruby runtime2, IRubyObject name2, IRubyObject modName, boolean isModule) {
        return RubyStringBuilder.str(runtime2, "undefined method `", name2, "' for " + (isModule ? "module" : "class") + " `", modName, "'");
    }

    public boolean isMethodBound(String name2, boolean checkVisibility) {
        DynamicMethod method2 = this.searchMethod(name2);
        return !method2.isUndefined() && (!checkVisibility || method2.getVisibility() != Visibility.PRIVATE);
    }

    public boolean respondsToMethod(String name2, boolean checkVisibility) {
        return Helpers.respondsToMethod(this.searchMethod(name2), checkVisibility);
    }

    @Deprecated
    public boolean isMethodBound(String name2, boolean checkVisibility, boolean checkRespondTo) {
        return checkRespondTo ? this.respondsToMethod(name2, checkVisibility) : this.isMethodBound(name2, checkVisibility);
    }

    public final IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility) {
        return this.newMethod(receiver2, methodName, bound, visibility, false, true);
    }

    public final IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility, boolean respondToMissing) {
        return this.newMethod(receiver2, methodName, bound, visibility, respondToMissing, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRubyObject newMethod(IRubyObject receiver2, String methodName, boolean bound, Visibility visibility, boolean respondToMissing, boolean priv) {
        RubyModule originModule;
        CacheEntry entry = this.searchWithCache(methodName);
        if (entry.method.isUndefined() || visibility != null && entry.method.getVisibility() != visibility) {
            if (!respondToMissing) throw this.getRuntime().newNameError("undefined method `" + methodName + "' for class `" + this.getName() + '\'', methodName);
            if (!receiver2.respondsToMissing(methodName, priv)) throw this.getRuntime().newNameError("undefined method `" + methodName + "' for class `" + this.getName() + '\'', methodName);
            entry = new CacheEntry(new RespondToMissingMethod(this, Visibility.PUBLIC, methodName), entry.sourceModule, entry.token);
        }
        RubyModule implementationModule = entry.method.getDefinedClass();
        for (originModule = this; originModule != implementationModule && (originModule.isSingleton() || originModule.isIncluded()); originModule = originModule.getSuperClass()) {
        }
        AbstractRubyMethod newMethod = bound ? RubyMethod.newMethod(implementationModule, methodName, originModule, methodName, entry, receiver2) : RubyUnboundMethod.newUnboundMethod(implementationModule, methodName, originModule, methodName, entry);
        newMethod.infectBy(this);
        return newMethod;
    }

    @JRubyMethod(name={"define_method"}, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, Block block) {
        Visibility visibility = this.getCurrentVisibilityForDefineMethod(context);
        return this.defineMethodFromBlock(context, arg0, block, visibility);
    }

    private Visibility getCurrentVisibilityForDefineMethod(ThreadContext context) {
        return context.getCurrentFrame().getSelf() == this ? context.getCurrentVisibility() : Visibility.PUBLIC;
    }

    public IRubyObject defineMethodFromBlock(ThreadContext context, IRubyObject arg0, Block block, Visibility visibility) {
        IRBlockBody body;
        IRClosure closure;
        IRMethod method2;
        Ruby runtime2 = context.runtime;
        RubySymbol name2 = TypeConverter.checkID(arg0);
        if (!block.isGiven()) {
            throw runtime2.newArgumentError("tried to create Proc object without a block");
        }
        if (block.getBody() instanceof IRBlockBody && runtime2.getInstanceConfig().getCompileMode().shouldJIT() && (method2 = (closure = (body = (IRBlockBody)block.getBody()).getScope()).convertToMethod(name2.getBytes())) != null) {
            DefineMethodMethod newMethod = new DefineMethodMethod(method2, visibility, this, context.getFrameBlock());
            Helpers.addInstanceMethod(this, name2, (DynamicMethod)newMethod, visibility, context, runtime2);
            return name2;
        }
        DynamicMethod newMethod = this.createProcMethod(runtime2, name2.idString(), visibility, block);
        Helpers.addInstanceMethod(this, name2, newMethod, visibility, context, runtime2);
        return name2;
    }

    @JRubyMethod(name={"define_method"}, reads={FrameField.VISIBILITY})
    public IRubyObject define_method(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        Visibility visibility = this.getCurrentVisibilityForDefineMethod(context);
        return this.defineMethodFromCallable(context, arg0, arg1, visibility);
    }

    public IRubyObject defineMethodFromCallable(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Visibility visibility) {
        DynamicMethod newMethod;
        Ruby runtime2 = context.runtime;
        RubySymbol name2 = TypeConverter.checkID(arg0);
        if (runtime2.getProc().isInstance(arg1)) {
            RubyProc proc2 = (RubyProc)arg1;
            newMethod = this.createProcMethod(runtime2, name2.idString(), visibility, proc2.getBlock());
        } else if (arg1 instanceof AbstractRubyMethod) {
            AbstractRubyMethod method2 = (AbstractRubyMethod)arg1;
            this.checkValidBindTargetFrom(context, (RubyModule)method2.owner(context));
            newMethod = method2.getMethod().dup();
            newMethod.setImplementationClass(this);
            newMethod.setVisibility(visibility);
        } else {
            throw runtime2.newTypeError("wrong argument type " + arg1.getType().getName() + " (expected Proc/Method)");
        }
        Helpers.addInstanceMethod(this, name2, newMethod, visibility, context, runtime2);
        return name2;
    }

    @Deprecated
    public IRubyObject define_method(ThreadContext context, IRubyObject[] args2, Block block) {
        switch (args2.length) {
            case 1: {
                return this.define_method(context, args2[0], block);
            }
            case 2: {
                return this.define_method(context, args2[0], args2[1], block);
            }
        }
        throw context.runtime.newArgumentError("wrong number of arguments (" + args2.length + " for 2)");
    }

    private DynamicMethod createProcMethod(Ruby runtime2, String name2, Visibility visibility, Block block) {
        block = block.cloneBlockAndFrame();
        block.getBinding().getFrame().setKlazz(this);
        block.getBinding().getFrame().setName(name2);
        block.getBinding().setMethod(name2);
        RubyProc proc2 = runtime2.newProc(Block.Type.LAMBDA, block);
        block.getBody().getStaticScope().makeArgumentScope();
        return new ProcMethod(this, proc2, visibility, name2);
    }

    public IRubyObject name() {
        return this.name(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name(ThreadContext context) {
        return this.getBaseName() == null ? context.nil : this.rubyName().strDup(context.runtime);
    }

    @Deprecated
    public IRubyObject name19() {
        return this.getBaseName() == null ? this.getRuntime().getNil() : this.rubyName().strDup(this.getRuntime());
    }

    protected final IRubyObject cloneMethods(RubyModule clone2) {
        Ruby runtime2 = this.getRuntime();
        RubyModule realType = this.getNonIncludedClass();
        for (Map.Entry<String, DynamicMethod> entry : this.getMethods().entrySet()) {
            DynamicMethod method2 = entry.getValue();
            if (!method2.isImplementedBy(realType) && !method2.isUndefined()) continue;
            DynamicMethod clonedMethod = method2.dup();
            clonedMethod.setImplementationClass(clone2);
            clone2.putMethod(runtime2, entry.getKey(), clonedMethod);
        }
        return clone2;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this instanceof RubyClass) {
            this.checkSafeTypeToCopy((RubyClass)original);
        }
        super.initialize_copy(original);
        RubyModule originalModule = (RubyModule)original;
        if (!this.getMetaClass().isSingleton()) {
            this.setMetaClass(originalModule.getSingletonClassCloneAndAttach(this));
        }
        this.setSuperClass(originalModule.getSuperClass());
        if (originalModule.hasVariables()) {
            this.syncVariables(originalModule);
        }
        this.syncConstants(originalModule);
        originalModule.cloneMethods(this);
        return this;
    }

    private void checkSafeTypeToCopy(RubyClass original) {
        Ruby runtime2 = this.getRuntime();
        if (original == runtime2.getBasicObject()) {
            throw runtime2.newTypeError("can't copy the root class");
        }
        if (this.getSuperClass() == runtime2.getBasicObject()) {
            throw runtime2.newTypeError("already initialized class");
        }
        if (original.isSingleton()) {
            throw runtime2.newTypeError("can't copy singleton class");
        }
    }

    public void syncConstants(RubyModule other) {
        if (other.getConstantMap() != Collections.EMPTY_MAP) {
            this.getConstantMapForWrite().putAll(other.getConstantMap());
        }
    }

    public void syncClassVariables(RubyModule other) {
        if (other.getClassVariablesForRead() != Collections.EMPTY_MAP) {
            this.getClassVariables().putAll(other.getClassVariablesForRead());
        }
    }

    @JRubyMethod(name={"included_modules"})
    public RubyArray included_modules(ThreadContext context) {
        RubyArray ary = context.runtime.newArray();
        for (RubyClass p2 = this.getSuperClass(); p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.isIncluded()) continue;
            ary.append(p2.getNonIncludedClass());
        }
        return ary;
    }

    public boolean hasPrepends() {
        return this.methodLocation != this;
    }

    @JRubyMethod(name={"ancestors"})
    public RubyArray ancestors(ThreadContext context) {
        return context.runtime.newArray(this.getAncestorList());
    }

    @Deprecated
    public RubyArray ancestors() {
        return this.getRuntime().newArray(this.getAncestorList());
    }

    public List<IRubyObject> getAncestorList() {
        ArrayList<IRubyObject> list2 = new ArrayList<IRubyObject>();
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (module.methodLocation != module) continue;
            list2.add(module.getDelegate().getNonIncludedClass());
        }
        return list2;
    }

    public boolean hasModuleInPrepends(RubyModule type2) {
        RubyModule stopClass = this.getPrependCeiling();
        for (RubyModule module = this; module != stopClass; module = module.getSuperClass()) {
            if (type2 != module.getNonIncludedClass()) continue;
            return true;
        }
        return false;
    }

    private RubyModule getPrependCeiling() {
        RubyClass mlSuper = this.methodLocation.getSuperClass();
        return mlSuper == null ? this.methodLocation : mlSuper.getRealClass();
    }

    public boolean hasModuleInHierarchy(RubyModule type2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (module.getNonIncludedClass() != type2) continue;
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.id);
    }

    @Override
    @JRubyMethod(name={"to_s"}, alias={"inspect"})
    public RubyString to_s() {
        Ruby runtime2 = this.getRuntime();
        if (this.isSingleton()) {
            RubyBasicObject attached = ((MetaClass)this).getAttached();
            RubyString buffer = runtime2.newString("#<Class:");
            if (attached instanceof RubyModule) {
                buffer.cat19(attached.inspect().convertToString());
            } else if (attached != null) {
                buffer.cat19((RubyString)attached.anyToString());
            }
            buffer.cat(62, buffer.getEncoding());
            return buffer;
        }
        RubyModule refinedClass = this.refinedClass;
        if (refinedClass != null) {
            RubyString buffer = runtime2.newString("#<refinement:");
            buffer.cat19(refinedClass.inspect().convertToString());
            buffer.cat(64, buffer.getEncoding());
            buffer.cat19(this.definedAt.inspect().convertToString());
            buffer.cat(62, buffer.getEncoding());
            return buffer;
        }
        return this.rubyName().strDup(runtime2);
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public RubyBoolean op_eqq(ThreadContext context, IRubyObject obj) {
        return RubyBoolean.newBoolean(context, this.isInstance(obj));
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @Override
    @JRubyMethod(name={"=="}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (!(other instanceof RubyModule)) {
            return context.fals;
        }
        RubyModule otherModule = (RubyModule)other;
        if (otherModule.isIncluded()) {
            return RubyBoolean.newBoolean(context, otherModule.isSame(this));
        }
        return RubyBoolean.newBoolean(context, this.isSame(otherModule));
    }

    @Override
    @JRubyMethod(name={"freeze"})
    public final IRubyObject freeze(ThreadContext context) {
        this.to_s();
        return super.freeze(context);
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(IRubyObject arg2) {
        Ruby runtime2 = this.getRuntime();
        if (!(arg2 instanceof RubyModule)) {
            throw runtime2.newTypeError("compared with non class/module");
        }
        RubyModule argMod = (RubyModule)arg2;
        if (this.searchAncestor(argMod.getMethodLocation()) != null) {
            return runtime2.getTrue();
        }
        if (argMod.searchAncestor(this) != null) {
            return runtime2.getFalse();
        }
        return runtime2.getNil();
    }

    protected RubyModule searchAncestor(RubyModule c) {
        for (RubyModule cl = this; cl != null; cl = cl.getSuperClass()) {
            if (cl != c && !cl.isSame(c) && cl.getDelegate().getNonIncludedClass() != c) continue;
            return cl;
        }
        return null;
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(IRubyObject obj) {
        return obj == this ? this.getRuntime().getFalse() : this.op_le(obj);
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(IRubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw this.getRuntime().newTypeError("compared with non class/module");
        }
        return ((RubyModule)obj).op_le(this);
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(IRubyObject obj) {
        return this == obj ? this.getRuntime().getFalse() : this.op_ge(obj);
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().newFixnum(0);
        }
        if (!(obj instanceof RubyModule)) {
            return this.getRuntime().getNil();
        }
        RubyModule module = (RubyModule)obj;
        if (module.isKindOfModule(this)) {
            return this.getRuntime().newFixnum(1);
        }
        if (this.isKindOfModule(module)) {
            return this.getRuntime().newFixnum(-1);
        }
        return this.getRuntime().getNil();
    }

    public boolean isKindOfModule(RubyModule type2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.isSame(type2)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSame(RubyModule module) {
        return this == module;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        if (block.isGiven()) {
            this.module_exec(context, new IRubyObject[]{this}, block);
        }
        return context.nil;
    }

    public void addReadWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, TypeConverter.checkID(context.runtime, name2), Visibility.PUBLIC, true, true);
    }

    public void addReadAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, TypeConverter.checkID(context.runtime, name2), Visibility.PUBLIC, true, false);
    }

    public void addWriteAttribute(ThreadContext context, String name2) {
        this.addAccessor(context, TypeConverter.checkID(context.runtime, name2), Visibility.PUBLIC, false, true);
    }

    @JRubyMethod(name={"attr"}, rest=true, reads={FrameField.VISIBILITY})
    public IRubyObject attr(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        if (args2.length == 2 && (args2[1] == runtime2.getTrue() || args2[1] == runtime2.getFalse())) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.OBSOLETE_ARGUMENT, "optional boolean argument is obsoleted");
            this.addAccessor(context, TypeConverter.checkID(args2[0]), context.getCurrentVisibility(), args2[0].isTrue(), args2[1].isTrue());
            return runtime2.getNil();
        }
        return this.attr_reader(context, args2);
    }

    @Deprecated
    public IRubyObject attr19(ThreadContext context, IRubyObject[] args2) {
        return this.attr(context, args2);
    }

    @Deprecated
    public IRubyObject attr_reader(IRubyObject[] args2) {
        return this.attr_reader(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_reader"}, rest=true, reads={FrameField.VISIBILITY})
    public IRubyObject attr_reader(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, TypeConverter.checkID(args2[i2]), visibility, true, false);
        }
        return context.nil;
    }

    @JRubyMethod(name={"attr_writer"}, rest=true, reads={FrameField.VISIBILITY})
    public IRubyObject attr_writer(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, TypeConverter.checkID(args2[i2]), visibility, false, true);
        }
        return context.nil;
    }

    @Deprecated
    public IRubyObject attr_accessor(IRubyObject[] args2) {
        return this.attr_accessor(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"attr_accessor"}, rest=true, reads={FrameField.VISIBILITY})
    public IRubyObject attr_accessor(ThreadContext context, IRubyObject[] args2) {
        Visibility visibility = context.getCurrentVisibility();
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.addAccessor(context, TypeConverter.checkID(args2[i2]), visibility, true, true);
        }
        return context.nil;
    }

    private RubyArray instance_methods(IRubyObject[] args2, Visibility visibility, boolean not) {
        boolean includeSuper = args2.length > 0 ? args2[0].isTrue() : true;
        return this.instanceMethods(visibility, includeSuper, true, not);
    }

    public RubyArray instanceMethods(IRubyObject[] args2, Visibility visibility, boolean obj, boolean not) {
        boolean includeSuper = args2.length > 0 ? args2[0].isTrue() : true;
        return this.instanceMethods(visibility, includeSuper, obj, not);
    }

    public RubyArray instanceMethods(Visibility visibility, boolean includeSuper, boolean obj, boolean not) {
        RubyArray ary = this.getRuntime().newArray();
        this.populateInstanceMethodNames(new HashSet<String>(), ary, visibility, obj, not, includeSuper);
        return ary;
    }

    final void populateInstanceMethodNames(Set<String> seen, RubyArray ary, Visibility visibility, boolean obj, boolean not, boolean recur) {
        Ruby runtime2 = this.getRuntime();
        RubyModule mod = this;
        boolean prepended2 = false;
        if (!recur && this.methodLocation != this) {
            mod = this.methodLocation;
            prepended2 = true;
        }
        while (mod != null) {
            mod.addMethodSymbols(runtime2, seen, ary, not, visibility);
            if (!(!prepended2 && mod.isIncluded() || obj && mod.isSingleton() || recur)) break;
            mod = mod.getSuperClass();
        }
    }

    protected void addMethodSymbols(Ruby runtime2, Set<String> seen, RubyArray ary, boolean not, Visibility visibility) {
        this.getMethods().forEach((id2, method2) -> {
            if (method2 instanceof RefinedMarker) {
                return;
            }
            if (seen.add((String)id2) && (!not && method2.getVisibility() == visibility || not && method2.getVisibility() != visibility) && !method2.isUndefined()) {
                ary.append(runtime2.newSymbol((String)id2));
            }
        });
    }

    public RubyArray instance_methods(IRubyObject[] args2) {
        return this.instance_methods19(args2);
    }

    @JRubyMethod(name={"instance_methods"}, optional=1)
    public RubyArray instance_methods19(IRubyObject[] args2) {
        return this.instanceMethods(args2, Visibility.PRIVATE, false, true);
    }

    public RubyArray public_instance_methods(IRubyObject[] args2) {
        return this.public_instance_methods19(args2);
    }

    @JRubyMethod(name={"public_instance_methods"}, optional=1)
    public RubyArray public_instance_methods19(IRubyObject[] args2) {
        return this.instanceMethods(args2, Visibility.PUBLIC, false, false);
    }

    @JRubyMethod(name={"instance_method"}, required=1)
    public IRubyObject instance_method(IRubyObject symbol) {
        return this.newMethod(null, TypeConverter.checkID(symbol).idString(), false, null);
    }

    @JRubyMethod(name={"public_instance_method"}, required=1)
    public IRubyObject public_instance_method(IRubyObject symbol) {
        return this.newMethod(null, TypeConverter.checkID(symbol).idString(), false, Visibility.PUBLIC);
    }

    @JRubyMethod(name={"protected_instance_methods"}, optional=1)
    public RubyArray protected_instance_methods(IRubyObject[] args2) {
        return this.instanceMethods(args2, Visibility.PROTECTED, false, false);
    }

    @Deprecated
    public RubyArray protected_instance_methods19(IRubyObject[] args2) {
        return this.protected_instance_methods(args2);
    }

    @JRubyMethod(name={"private_instance_methods"}, optional=1)
    public RubyArray private_instance_methods(IRubyObject[] args2) {
        return this.instanceMethods(args2, Visibility.PRIVATE, false, false);
    }

    @Deprecated
    public RubyArray private_instance_methods19(IRubyObject[] args2) {
        return this.private_instance_methods(args2);
    }

    @JRubyMethod(name={"prepend_features"}, required=1, visibility=Visibility.PRIVATE)
    public RubyModule prepend_features(IRubyObject include2) {
        if (!this.isModule()) {
            throw this.getRuntime().newTypeError((IRubyObject)this, this.getRuntime().getModule());
        }
        if (!(include2 instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(include2, this.getRuntime().getModule());
        }
        if (!include2.isModule() && !include2.isClass()) {
            throw this.getRuntime().newTypeError(include2, this.getRuntime().getModule());
        }
        ((RubyModule)include2).prependModule(this);
        return this;
    }

    @JRubyMethod(name={"append_features"}, required=1, visibility=Visibility.PRIVATE)
    public RubyModule append_features(IRubyObject include2) {
        if (!this.isModule()) {
            throw this.getRuntime().newTypeError((IRubyObject)this, this.getRuntime().getModule());
        }
        if (!(include2 instanceof RubyModule)) {
            throw this.getRuntime().newTypeError(include2, this.getRuntime().getModule());
        }
        if (!include2.isModule() && !include2.isClass()) {
            throw this.getRuntime().newTypeError(include2, this.getRuntime().getModule());
        }
        ((RubyModule)include2).includeModule(this);
        return this;
    }

    @JRubyMethod(name={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject extend_object(IRubyObject obj) {
        if (!this.isModule()) {
            throw this.getRuntime().newTypeError((IRubyObject)this, this.getRuntime().getModule());
        }
        obj.getSingletonClass().includeModule(this);
        return obj;
    }

    @JRubyMethod(name={"include"}, required=1, rest=true)
    public RubyModule include(IRubyObject[] modules) {
        IRubyObject module;
        ThreadContext context = this.metaClass.runtime.getCurrentContext();
        int i2 = modules.length;
        while (--i2 >= 0) {
            module = modules[i2];
            if (module.isModule()) continue;
            throw context.runtime.newTypeError(module, context.runtime.getModule());
        }
        for (i2 = modules.length - 1; i2 >= 0; --i2) {
            module = modules[i2];
            module.callMethod(context, "append_features", this);
            module.callMethod(context, "included", this);
        }
        return this;
    }

    @JRubyMethod(name={"include"}, required=1)
    public RubyModule include(ThreadContext context, IRubyObject module) {
        if (!module.isModule()) {
            throw context.runtime.newTypeError(module, context.runtime.getModule());
        }
        module.callMethod(context, "append_features", this);
        module.callMethod(context, "included", this);
        return this;
    }

    @JRubyMethod(name={"included"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject included(ThreadContext context, IRubyObject other) {
        return context.nil;
    }

    @JRubyMethod(name={"extended"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject extended(ThreadContext context, IRubyObject other, Block block) {
        return context.nil;
    }

    @JRubyMethod(name={"mix"}, visibility=Visibility.PRIVATE)
    public IRubyObject mix(ThreadContext context, IRubyObject mod) {
        Ruby runtime2 = context.runtime;
        if (!mod.isModule()) {
            throw runtime2.newTypeError(mod, runtime2.getModule());
        }
        for (Map.Entry<String, DynamicMethod> entry : ((RubyModule)mod).methods.entrySet()) {
            if (!this.methodLocation.getMethods().containsKey(entry.getKey())) continue;
            throw runtime2.newArgumentError("method would conflict - " + entry.getKey());
        }
        for (Map.Entry<String, DynamicMethod> entry : ((RubyModule)mod).methods.entrySet()) {
            this.methodLocation.getMethodsForWrite().put(entry.getKey(), entry.getValue().dup());
        }
        return mod;
    }

    @JRubyMethod(name={"mix"}, visibility=Visibility.PRIVATE)
    public IRubyObject mix(ThreadContext context, IRubyObject mod, IRubyObject hash0) {
        Ruby runtime2 = context.runtime;
        if (!mod.isModule()) {
            throw runtime2.newTypeError(mod, runtime2.getModule());
        }
        if (!(hash0 instanceof RubyHash)) {
            throw runtime2.newTypeError(hash0, runtime2.getHash());
        }
        RubyHash methodNames = (RubyHash)hash0;
        for (Map.Entry entry : methodNames.directEntrySet()) {
            String name2 = ((IRubyObject)entry.getValue()).toString();
            if (!this.methods.containsKey(((IRubyObject)entry.getValue()).toString())) continue;
            throw runtime2.newArgumentError("constant would conflict - " + name2);
        }
        for (Map.Entry entry : ((RubyModule)mod).methods.entrySet()) {
            if (!this.methods.containsKey(entry.getKey())) continue;
            throw runtime2.newArgumentError("method would conflict - " + (String)entry.getKey());
        }
        for (Map.Entry entry : ((RubyModule)mod).methods.entrySet()) {
            String id2 = (String)entry.getKey();
            IRubyObject mapped = methodNames.fastARef(runtime2.newSymbol(id2));
            if (mapped != NEVER) {
                if (mapped == context.nil) continue;
                id2 = TypeConverter.checkID(mapped).idString();
            }
            this.methodLocation.getMethodsForWrite().put(id2, ((DynamicMethod)entry.getValue()).dup());
        }
        return mod;
    }

    private void setVisibility(ThreadContext context, IRubyObject[] args2, Visibility visibility) {
        if (args2.length == 0) {
            context.setCurrentVisibility(visibility);
        } else {
            this.setMethodVisibility(args2, visibility);
        }
    }

    @JRubyMethod(name={"public"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbPublic(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.setVisibility(context, args2, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"protected"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbProtected(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.setVisibility(context, args2, Visibility.PROTECTED);
        return this;
    }

    @JRubyMethod(name={"private"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule rbPrivate(ThreadContext context, IRubyObject[] args2) {
        this.checkFrozen();
        this.setVisibility(context, args2, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"module_function"}, rest=true, visibility=Visibility.PRIVATE, writes={FrameField.VISIBILITY})
    public RubyModule module_function(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.runtime;
        if (!this.isModule()) {
            throw context.runtime.newTypeError("module_function must be called for modules");
        }
        if (args2.length == 0) {
            context.setCurrentVisibility(Visibility.MODULE_FUNCTION);
        } else {
            this.setMethodVisibility(args2, Visibility.PRIVATE);
            for (int i2 = 0; i2 < args2.length; ++i2) {
                RubySymbol name2 = TypeConverter.checkID(args2[i2]);
                DynamicMethod newMethod = this.deepMethodSearch((String)name2.idString(), (Ruby)runtime2).method.dup();
                newMethod.setImplementationClass(this.getSingletonClass());
                newMethod.setVisibility(Visibility.PUBLIC);
                this.getSingletonClass().addMethod(name2.idString(), newMethod);
                this.callMethod(context, "singleton_method_added", (IRubyObject)name2);
            }
        }
        return this;
    }

    @JRubyMethod(name={"method_added"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_added(ThreadContext context, IRubyObject nothing) {
        return context.nil;
    }

    @JRubyMethod(name={"method_removed"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_removed(ThreadContext context, IRubyObject nothing) {
        return context.nil;
    }

    @JRubyMethod(name={"method_undefined"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject method_undefined(ThreadContext context, IRubyObject nothing) {
        return context.nil;
    }

    @JRubyMethod(name={"method_defined?"}, required=1)
    public RubyBoolean method_defined_p(ThreadContext context, IRubyObject symbol) {
        return this.isMethodBound(TypeConverter.checkID(symbol).idString(), true) ? context.tru : context.fals;
    }

    @JRubyMethod(name={"public_method_defined?"}, required=1)
    public IRubyObject public_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(TypeConverter.checkID(symbol).idString());
        return RubyBoolean.newBoolean(context, !method2.isUndefined() && method2.getVisibility() == Visibility.PUBLIC);
    }

    @JRubyMethod(name={"protected_method_defined?"}, required=1)
    public IRubyObject protected_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(TypeConverter.checkID(symbol).idString());
        return RubyBoolean.newBoolean(context, !method2.isUndefined() && method2.getVisibility() == Visibility.PROTECTED);
    }

    @JRubyMethod(name={"private_method_defined?"}, required=1)
    public IRubyObject private_method_defined(ThreadContext context, IRubyObject symbol) {
        DynamicMethod method2 = this.searchMethod(TypeConverter.checkID(symbol).idString());
        return RubyBoolean.newBoolean(context, !method2.isUndefined() && method2.getVisibility() == Visibility.PRIVATE);
    }

    @JRubyMethod(name={"public_class_method"}, rest=true)
    public RubyModule public_class_method(IRubyObject[] args2) {
        this.checkFrozen();
        this.getSingletonClass().setMethodVisibility(args2, Visibility.PUBLIC);
        return this;
    }

    @JRubyMethod(name={"private_class_method"}, rest=true)
    public RubyModule private_class_method(IRubyObject[] args2) {
        this.checkFrozen();
        this.getSingletonClass().setMethodVisibility(args2, Visibility.PRIVATE);
        return this;
    }

    @JRubyMethod(name={"alias_method"}, required=2)
    public RubyModule alias_method(ThreadContext context, IRubyObject newId, IRubyObject oldId) {
        RubySymbol newSym = TypeConverter.checkID(newId);
        RubySymbol oldSym = TypeConverter.checkID(oldId);
        this.defineAlias(newSym.idString(), oldSym.idString());
        if (this.isSingleton()) {
            ((MetaClass)this).getAttached().callMethod(context, "singleton_method_added", (IRubyObject)newSym);
        } else {
            this.callMethod(context, "method_added", (IRubyObject)newSym);
        }
        return this;
    }

    @JRubyMethod(name={"undef_method"}, rest=true)
    public RubyModule undef_method(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            RubySymbol name2 = TypeConverter.checkID(args2[i2]);
            this.undef(context, name2.idString());
        }
        return this;
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_eval(ThreadContext context, Block block) {
        return this.specificEval(context, this, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, Block block) {
        return this.specificEval(context, this, arg0, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Block block) {
        return this.specificEval(context, this, arg0, arg1, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_eval", "class_eval"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_eval(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return this.specificEval(context, this, arg0, arg1, arg2, block, EvalType.MODULE_EVAL);
    }

    @Deprecated
    public IRubyObject module_eval(ThreadContext context, IRubyObject[] args2, Block block) {
        return this.specificEval(context, this, args2, block, EvalType.MODULE_EVAL);
    }

    @JRubyMethod(name={"module_exec", "class_exec"}, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_exec(ThreadContext context, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, this, IRubyObject.NULL_ARRAY, block.cloneBlockAndFrame(), EvalType.MODULE_EVAL);
        }
        throw context.runtime.newLocalJumpErrorNoBlock();
    }

    @JRubyMethod(name={"module_exec", "class_exec"}, rest=true, reads={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE}, writes={FrameField.LASTLINE, FrameField.BACKREF, FrameField.VISIBILITY, FrameField.BLOCK, FrameField.SELF, FrameField.METHODNAME, FrameField.LINE, FrameField.CLASS, FrameField.FILENAME, FrameField.SCOPE})
    public IRubyObject module_exec(ThreadContext context, IRubyObject[] args2, Block block) {
        if (block.isGiven()) {
            return this.yieldUnder(context, this, args2, block.cloneBlockAndFrame(), EvalType.MODULE_EVAL);
        }
        throw context.runtime.newLocalJumpErrorNoBlock();
    }

    @JRubyMethod(name={"remove_method"}, rest=true)
    public RubyModule remove_method(ThreadContext context, IRubyObject[] args2) {
        for (int i2 = 0; i2 < args2.length; ++i2) {
            this.removeMethod(context, TypeConverter.checkID(args2[i2]).idString());
        }
        return this;
    }

    public static void marshalTo(RubyModule module, MarshalStream output) throws IOException {
        output.registerLinkTarget(module);
        output.writeString(MarshalStream.getPathFromClass(module));
    }

    public static RubyModule unmarshalFrom(UnmarshalStream input) throws IOException {
        String name2 = RubyString.byteListToString(input.unmarshalString());
        RubyModule result2 = UnmarshalStream.getModuleFromPath(input.getRuntime(), name2);
        input.registerLinkTarget(result2);
        return result2;
    }

    @JRubyMethod(name={"nesting"}, reads={FrameField.SCOPE}, meta=true)
    public static RubyArray nesting(ThreadContext context, IRubyObject recv2, Block block) {
        Ruby runtime2 = context.runtime;
        RubyClass object = runtime2.getObject();
        StaticScope scope = context.getCurrentStaticScope();
        RubyArray result2 = runtime2.newArray();
        StaticScope current2 = scope;
        while (current2.getModule() != object) {
            result2.append(current2.getModule());
            current2 = current2.getPreviousCRefScope();
        }
        return result2;
    }

    private void doIncludeModule(RubyModule baseModule) {
        List<RubyModule> modulesToInclude = this.gatherModules(baseModule);
        RubyModule currentInclusionPoint = this.methodLocation;
        block0: for (RubyModule nextModule : modulesToInclude) {
            this.checkForCyclicInclude(nextModule);
            boolean superclassSeen = false;
            for (RubyClass nextClass = this.getSuperClass(); nextClass != null; nextClass = nextClass.getSuperClass()) {
                if (nextClass.isIncluded()) {
                    if (nextClass.getDelegate() != nextModule.getDelegate()) continue;
                    if (superclassSeen) continue block0;
                    currentInclusionPoint = nextClass;
                    continue block0;
                }
                superclassSeen = true;
            }
            currentInclusionPoint = this.proceedWithInclude(currentInclusionPoint, nextModule.getDelegate());
        }
    }

    private void doPrependModule(RubyModule baseModule) {
        List<RubyModule> modulesToInclude = this.gatherModules(baseModule);
        if (this.methodLocation == this) {
            PrependedModule origin = new PrependedModule(this.getRuntime(), this.getSuperClass(), this);
            if (this instanceof RubyClass) {
                RubyClass insertBelowClass = (RubyClass)this;
                if (insertBelowClass.getSuperClass() != null) {
                    insertBelowClass.getSuperClass().replaceSubclass(insertBelowClass, origin);
                }
                origin.addSubclass(insertBelowClass);
            }
            this.setSuperClass(origin);
        }
        RubyModule currentInclusionPoint = this;
        block0: for (RubyModule nextModule : modulesToInclude) {
            this.checkForCyclicInclude(nextModule);
            boolean superclassSeen = false;
            RubyModule stopClass = this.getPrependCeiling();
            for (RubyClass nextClass = this.getSuperClass(); nextClass != stopClass; nextClass = nextClass.getSuperClass()) {
                if (nextClass.isIncluded()) {
                    if (nextClass.getDelegate() != nextModule.getDelegate()) continue;
                    if (superclassSeen) continue block0;
                    currentInclusionPoint = nextClass;
                    continue block0;
                }
                superclassSeen = true;
            }
            currentInclusionPoint = this.proceedWithPrepend(currentInclusionPoint, nextModule.getDelegate());
        }
    }

    private List<RubyModule> gatherModules(RubyModule baseModule) {
        ArrayList<RubyModule> modulesToInclude = new ArrayList<RubyModule>();
        while (baseModule != null) {
            if (baseModule == baseModule.getMethodLocation()) {
                modulesToInclude.add(baseModule.getDelegate());
            }
            baseModule = baseModule.superClass;
        }
        return modulesToInclude;
    }

    private RubyModule proceedWithInclude(RubyModule insertAbove, RubyModule moduleToInclude) {
        IncludedModuleWrapper wrapper = new IncludedModuleWrapper(this.getRuntime(), insertAbove.getSuperClass(), moduleToInclude);
        if (insertAbove instanceof RubyClass) {
            RubyClass insertAboveClass = (RubyClass)insertAbove;
            if (insertAboveClass.getSuperClass() != null) {
                insertAboveClass.getSuperClass().replaceSubclass(insertAboveClass, wrapper);
            }
            wrapper.addSubclass(insertAboveClass);
        }
        insertAbove.setSuperClass(wrapper);
        insertAbove = insertAbove.getSuperClass();
        if (this.isRefinement()) {
            moduleToInclude.getMethods().forEach((name2, method2) -> this.addRefinedMethodEntry((String)name2, (DynamicMethod)method2));
            wrapper.setFlag(INCLUDED_INTO_REFINEMENT, true);
        }
        return insertAbove;
    }

    private RubyModule proceedWithPrepend(RubyModule insertBelow, RubyModule moduleToPrepend) {
        if (!moduleToPrepend.isPrepended()) {
            moduleToPrepend = moduleToPrepend.getNonIncludedClass();
        }
        return this.proceedWithInclude(insertBelow, moduleToPrepend);
    }

    @JRubyMethod(name={"class_variable_defined?"}, required=1)
    public IRubyObject class_variable_defined_p(ThreadContext context, IRubyObject var) {
        String id2 = this.validateClassVariable(context.runtime, var);
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasClassVariable(id2)) continue;
            return context.tru;
        }
        return context.fals;
    }

    public IRubyObject class_variable_get(IRubyObject name2) {
        return this.getClassVar(name2, this.validateClassVariable(this.getRuntime(), name2));
    }

    @JRubyMethod(name={"class_variable_get"})
    public IRubyObject class_variable_get19(IRubyObject name2) {
        return this.class_variable_get(name2);
    }

    public IRubyObject class_variable_set(IRubyObject name2, IRubyObject value2) {
        return this.setClassVar(this.validateClassVariable(this.getRuntime(), name2), value2);
    }

    @JRubyMethod(name={"class_variable_set"})
    public IRubyObject class_variable_set19(IRubyObject name2, IRubyObject value2) {
        return this.class_variable_set(name2, value2);
    }

    public IRubyObject remove_class_variable(ThreadContext context, IRubyObject name2) {
        return this.removeClassVariable(this.validateClassVariable(context.runtime, name2));
    }

    @JRubyMethod(name={"remove_class_variable"})
    public IRubyObject remove_class_variable19(ThreadContext context, IRubyObject name2) {
        return this.remove_class_variable(context, name2);
    }

    @Deprecated
    public RubyArray class_variables19(ThreadContext context) {
        return this.class_variables(context);
    }

    @JRubyMethod(name={"class_variables"})
    public RubyArray class_variables(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        RubyArray ary = runtime2.newArray();
        Collection<String> names2 = this.classVariablesCommon(true);
        for (String name2 : names2) {
            ary.add(runtime2.newSymbol(name2));
        }
        return ary;
    }

    @JRubyMethod(name={"class_variables"})
    public RubyArray class_variables(ThreadContext context, IRubyObject inherit) {
        Ruby runtime2 = context.runtime;
        RubyArray ary = runtime2.newArray();
        Collection<String> names2 = this.classVariablesCommon(inherit.isTrue());
        for (String name2 : names2) {
            ary.add(runtime2.newSymbol(name2));
        }
        return ary;
    }

    private Collection<String> classVariablesCommon(boolean inherit) {
        HashSet<String> names2 = new HashSet<String>();
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            names2.addAll(p2.getClassVariableNameList());
            if (!inherit) break;
        }
        return names2;
    }

    public RubyBoolean const_defined_p(ThreadContext context, IRubyObject symbol) {
        return this.const_defined_p19(context, new IRubyObject[]{symbol});
    }

    private RubyBoolean constantDefined(Ruby runtime2, RubySymbol symbol, boolean inherit) {
        if (symbol.validConstantName()) {
            return runtime2.newBoolean(this.getConstantSkipAutoload(symbol.idString(), inherit, inherit) != null);
        }
        throw runtime2.newNameError(RubyStringBuilder.str(runtime2, "wrong constant name", RubyStringBuilder.ids(runtime2, symbol)), symbol.idString());
    }

    @JRubyMethod(name={"const_defined?"}, required=1, optional=1)
    public RubyBoolean const_defined_p19(ThreadContext context, IRubyObject[] args2) {
        boolean inherit;
        Ruby runtime2 = context.runtime;
        boolean bl = inherit = args2.length == 1 || !args2[1].isNil() && args2[1].isTrue();
        if (args2[0] instanceof RubySymbol) {
            return this.constantDefined(runtime2, (RubySymbol)args2[0], inherit);
        }
        RubyString fullName = args2[0].convertToString();
        IRubyObject value2 = ByteListHelper.split(fullName.getByteList(), CommonByteLists.COLON_COLON, (index2, segment, module) -> {
            String id2;
            IRubyObject obj;
            if (index2 == 0) {
                if (segment.realSize() == 0) {
                    return runtime2.getObject();
                }
                module = this;
            }
            if ((obj = ((RubyModule)module).getConstantNoConstMissing(id2 = RubySymbol.newConstantSymbol(runtime2, fullName, segment).idString(), inherit, inherit)) == null) {
                return null;
            }
            if (!(obj instanceof RubyModule)) {
                throw runtime2.newTypeError(segment + " does not refer to class/module");
            }
            return obj;
        }, (index2, segment, module) -> {
            if (module == null) {
                module = this;
            }
            String id2 = RubySymbol.newConstantSymbol(runtime2, fullName, segment).idString();
            return ((RubyModule)module).getConstantSkipAutoload(id2, inherit, inherit);
        });
        return runtime2.newBoolean(value2 != null);
    }

    public IRubyObject const_get(IRubyObject symbol) {
        return this.const_get(this.getRuntime().getCurrentContext(), symbol);
    }

    @Deprecated
    public IRubyObject const_get_1_9(ThreadContext context, IRubyObject[] args2) {
        return this.const_get(context, args2);
    }

    @Deprecated
    public IRubyObject const_get_2_0(ThreadContext context, IRubyObject[] args2) {
        return this.const_get(context, args2);
    }

    @JRubyMethod(name={"const_get"}, required=1, optional=1)
    public IRubyObject const_get(ThreadContext context, IRubyObject ... args2) {
        Ruby runtime2 = context.runtime;
        boolean inherit = args2.length == 1 || !args2[1].isNil() && args2[1].isTrue();
        IRubyObject symbol = args2[0];
        RubySymbol fullName = TypeConverter.checkID(symbol);
        String name2 = fullName.idString();
        int sep = name2.indexOf("::");
        if (symbol instanceof RubySymbol && sep != -1) {
            throw runtime2.newNameError("wrong constant name", name2);
        }
        RubyModule mod = this;
        if (sep == 0) {
            mod = runtime2.getObject();
            name2 = name2.substring(2);
        }
        if (name2.length() == 0) {
            throw runtime2.newNameError("wrong constant name ", fullName.idString());
        }
        while ((sep = name2.indexOf("::")) != -1) {
            String segment = name2.substring(0, sep);
            IRubyObject obj = mod.getConstant(this.validateConstant(segment, symbol), inherit, inherit);
            if (!(obj instanceof RubyModule)) {
                throw runtime2.newTypeError(segment + " does not refer to class/module");
            }
            mod = (RubyModule)obj;
            name2 = name2.substring(sep + 2);
        }
        return mod.getConstant(this.validateConstant(name2, symbol), inherit, inherit);
    }

    @JRubyMethod(name={"const_set"}, required=2)
    public IRubyObject const_set(IRubyObject name2, IRubyObject value2) {
        return this.setConstant(this.validateConstant(name2), value2);
    }

    @JRubyMethod(name={"remove_const"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject remove_const(ThreadContext context, IRubyObject rubyName) {
        String id2 = this.validateConstant(rubyName);
        IRubyObject value2 = this.deleteConstant(id2);
        if (value2 != null) {
            this.invalidateConstantCache(id2);
            if (value2 != UNDEF) {
                return value2;
            }
            this.removeAutoload(id2);
            return context.nil;
        }
        if (this.hasConstantInHierarchy(id2)) {
            throw this.cannotRemoveError(id2);
        }
        throw context.runtime.newNameError("constant " + id2 + " not defined for " + this.getName(), id2);
    }

    private boolean hasConstantInHierarchy(String name2) {
        for (RubyModule p2 = this; p2 != null; p2 = p2.getSuperClass()) {
            if (!p2.hasConstant(name2)) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod(name={"const_missing"}, required=1)
    public IRubyObject const_missing(ThreadContext context, IRubyObject rubyName, Block block) {
        Ruby runtime2 = context.runtime;
        if (this != runtime2.getObject()) {
            throw runtime2.newNameError("uninitialized constant %2$s::%1$s", (IRubyObject)this, rubyName);
        }
        throw runtime2.newNameError("uninitialized constant %1$s", (IRubyObject)this, rubyName);
    }

    @JRubyMethod(name={"constants"})
    public RubyArray constants(ThreadContext context) {
        return this.constantsCommon(context, true, true);
    }

    @JRubyMethod(name={"constants"})
    public RubyArray constants(ThreadContext context, IRubyObject allConstants) {
        return this.constantsCommon(context, false, allConstants.isTrue());
    }

    @Deprecated
    public RubyArray constants19(ThreadContext context) {
        return this.constants(context);
    }

    @Deprecated
    public RubyArray constants19(ThreadContext context, IRubyObject allConstants) {
        return this.constants(context, allConstants);
    }

    @Deprecated
    public RubyArray constantsCommon19(ThreadContext context, boolean replaceModule, boolean allConstants) {
        return this.constantsCommon(context, replaceModule, allConstants);
    }

    private RubyArray constantsCommon(ThreadContext context, boolean replaceModule, boolean allConstants) {
        Ruby runtime2 = context.runtime;
        Collection<String> constantNames = this.constantsCommon(runtime2, replaceModule, allConstants, false);
        RubyArray array2 = RubyArray.newBlankArrayInternal(runtime2, constantNames.size());
        int i2 = 0;
        for (String name2 : constantNames) {
            array2.storeInternal(i2++, runtime2.newSymbol(name2));
        }
        array2.realLength = i2;
        return array2;
    }

    public Collection<String> constantsCommon(Ruby runtime2, boolean replaceModule, boolean allConstants) {
        return this.constantsCommon(runtime2, replaceModule, allConstants, true);
    }

    public Collection<String> constantsCommon(Ruby runtime2, boolean replaceModule, boolean allConstants, boolean includePrivate) {
        Collection<String> constantNames;
        RubyClass objectClass = runtime2.getObject();
        if (allConstants) {
            if (replaceModule && runtime2.getModule() == this || objectClass == this) {
                constantNames = objectClass.getConstantNames(includePrivate);
            } else {
                HashSet<String> names2 = new HashSet<String>();
                for (RubyModule module = this; module != null && module != objectClass; module = module.getSuperClass()) {
                    names2.addAll(module.getConstantNames(includePrivate));
                }
                constantNames = names2;
            }
        } else {
            constantNames = replaceModule && runtime2.getModule() == this || objectClass == this ? objectClass.getConstantNames(includePrivate) : this.getConstantNames(includePrivate);
        }
        return constantNames;
    }

    public void deprecateConstant(Ruby runtime2, String name2) {
        ConstantEntry entry = this.getConstantMap().get(name2);
        if (entry == null) {
            throw runtime2.newNameError(RubyStringBuilder.str(runtime2, "constant ", RubyStringBuilder.types(runtime2, this), "::", RubyStringBuilder.ids(runtime2, name2), " not defined"), name2);
        }
        this.storeConstant(name2, entry.value, entry.hidden, true);
        this.invalidateConstantCache(name2);
    }

    @JRubyMethod
    public IRubyObject deprecate_constant(ThreadContext context, IRubyObject name2) {
        this.checkFrozen();
        this.deprecateConstant(context.runtime, this.validateConstant(name2));
        return this;
    }

    @JRubyMethod(rest=true)
    public IRubyObject deprecate_constant(ThreadContext context, IRubyObject[] names2) {
        for (IRubyObject name2 : names2) {
            this.deprecate_constant(context, name2);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject private_constant(ThreadContext context, IRubyObject name2) {
        this.checkFrozen();
        String id2 = this.validateConstant(name2);
        this.setConstantVisibility(context.runtime, id2, true);
        this.invalidateConstantCache(id2);
        return this;
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject private_constant(ThreadContext context, IRubyObject[] rubyNames) {
        for (IRubyObject rubyName : rubyNames) {
            this.private_constant(context, rubyName);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject public_constant(ThreadContext context, IRubyObject name2) {
        this.checkFrozen();
        String id2 = this.validateConstant(name2);
        this.setConstantVisibility(context.runtime, id2, false);
        this.invalidateConstantCache(id2);
        return this;
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject public_constant(ThreadContext context, IRubyObject[] rubyNames) {
        for (IRubyObject rubyName : rubyNames) {
            this.public_constant(context, rubyName);
        }
        return this;
    }

    @JRubyMethod(name={"prepend"}, required=1, rest=true)
    public IRubyObject prepend(ThreadContext context, IRubyObject[] modules) {
        int i2 = modules.length;
        while (--i2 >= 0) {
            IRubyObject obj = modules[i2];
            if (obj.isModule()) continue;
            throw context.runtime.newTypeError(obj, context.runtime.getModule());
        }
        for (i2 = modules.length - 1; i2 >= 0; --i2) {
            modules[i2].callMethod(context, "prepend_features", this);
            modules[i2].callMethod(context, "prepended", this);
        }
        return this;
    }

    @JRubyMethod(name={"prepended"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject prepended(ThreadContext context, IRubyObject other) {
        return context.nil;
    }

    public final void setConstantVisibility(Ruby runtime2, String name2, boolean hidden) {
        ConstantEntry entry = this.getConstantMap().get(name2);
        if (entry == null) {
            throw runtime2.newNameError("constant " + this.getName() + "::" + name2 + " not defined", name2);
        }
        this.storeConstant(name2, entry.value, hidden);
    }

    public IRubyObject setClassVar(String name2, IRubyObject value2) {
        RubyModule module = this;
        RubyModule highest = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            highest = module;
        } while ((module = module.getSuperClass()) != null);
        return highest.storeClassVariable(name2, value2);
    }

    @Deprecated
    public IRubyObject fastSetClassVar(String internedName, IRubyObject value2) {
        return this.setClassVar(internedName, value2);
    }

    public IRubyObject getClassVar(String name2) {
        IRubyObject value2 = this.getClassVarQuiet(name2);
        if (value2 == null) {
            throw this.getRuntime().newNameError("uninitialized class variable %1$s in %2$s", (IRubyObject)this, name2);
        }
        return value2;
    }

    public IRubyObject getClassVar(IRubyObject nameObject, String name2) {
        IRubyObject value2 = this.getClassVarQuiet(name2);
        if (value2 == null) {
            throw this.getRuntime().newNameError("uninitialized class variable %1$s in %2$s", (IRubyObject)this, nameObject);
        }
        return value2;
    }

    public IRubyObject getClassVarQuiet(String name2) {
        assert (IdUtil.isClassVariable(name2));
        RubyModule module = this;
        RubyModule highest = null;
        do {
            if (!module.hasClassVariable(name2)) continue;
            highest = module;
        } while ((module = module.getSuperClass()) != null);
        if (highest != null) {
            return highest.fetchClassVariable(name2);
        }
        return null;
    }

    @Deprecated
    public IRubyObject fastGetClassVar(String internedName) {
        return this.getClassVar(internedName);
    }

    public boolean isClassVarDefined(String name2) {
        RubyModule module = this;
        do {
            if (!module.hasClassVariable(name2)) continue;
            return true;
        } while ((module = module.getSuperClass()) != null);
        return false;
    }

    @Deprecated
    public boolean fastIsClassVarDefined(String internedName) {
        return this.isClassVarDefined(internedName);
    }

    public IRubyObject removeClassVariable(String name2) {
        String javaName = this.validateClassVariable(name2);
        IRubyObject value2 = this.deleteClassVariable(javaName);
        if (value2 != null) {
            return value2;
        }
        if (this.isClassVarDefined(javaName)) {
            throw this.cannotRemoveError(javaName);
        }
        throw this.getRuntime().newNameError("class variable " + javaName + " not defined for " + this.getName(), javaName);
    }

    public IRubyObject getConstantAtSpecial(String name2) {
        IRubyObject value2 = this == this.getRuntime().getObject() ? this.getConstantNoConstMissing(name2) : this.fetchConstant(name2);
        return value2 == UNDEF ? this.resolveUndefConstant(name2) : value2;
    }

    public IRubyObject getConstantAt(String name2) {
        return this.getConstantAt(name2, true);
    }

    public IRubyObject getConstantAt(String name2, boolean includePrivate) {
        IRubyObject value2 = this.fetchConstant(name2, includePrivate);
        return value2 == UNDEF ? this.resolveUndefConstant(name2) : value2;
    }

    @Deprecated
    public IRubyObject fastGetConstantAt(String internedName) {
        return this.getConstantAt(internedName);
    }

    public IRubyObject getConstant(String name2) {
        return this.getConstant(name2, true);
    }

    public IRubyObject getConstant(String name2, boolean inherit) {
        return this.getConstant(name2, inherit, true);
    }

    public IRubyObject getConstant(String name2, boolean inherit, boolean includeObject) {
        assert (name2 != null) : "null name";
        IRubyObject value2 = this.getConstantNoConstMissing(name2, inherit, includeObject);
        Ruby runtime2 = this.metaClass.runtime;
        return value2 != null ? value2 : this.callMethod(runtime2.getCurrentContext(), "const_missing", (IRubyObject)runtime2.newSymbol(name2));
    }

    @Deprecated
    public IRubyObject fastGetConstant(String internedName) {
        return this.getConstant(internedName);
    }

    @Deprecated
    public IRubyObject fastGetConstant(String internedName, boolean inherit) {
        return this.getConstant(internedName, inherit);
    }

    public IRubyObject getConstantNoConstMissing(String name2) {
        return this.getConstantNoConstMissing(name2, true);
    }

    public IRubyObject getConstantNoConstMissing(String name2, boolean inherit) {
        return this.getConstantNoConstMissing(name2, inherit, true);
    }

    public IRubyObject getConstantNoConstMissing(String name2, boolean inherit, boolean includeObject) {
        IRubyObject constant = RubyModule.iterateConstantNoConstMissing(name2, this, inherit, true);
        if (constant == null && !this.isClass() && includeObject) {
            constant = RubyModule.iterateConstantNoConstMissing(name2, this.getRuntime().getObject(), inherit, true);
        }
        return constant;
    }

    public final IRubyObject getConstantNoConstMissingSkipAutoload(String name2) {
        return this.getConstantSkipAutoload(name2, true, true);
    }

    @Deprecated
    public IRubyObject getConstantNoConstMissingSKipAutoload(String name2) {
        return this.getConstantSkipAutoload(name2, true, true);
    }

    private IRubyObject getConstantSkipAutoload(String name2, boolean inherit, boolean includeObject) {
        IRubyObject constant = RubyModule.iterateConstantNoConstMissing(name2, this, inherit, false);
        if (constant == null && !this.isClass() && includeObject) {
            constant = RubyModule.iterateConstantNoConstMissing(name2, this.getRuntime().getObject(), inherit, false);
        }
        return constant;
    }

    private static IRubyObject iterateConstantNoConstMissing(String name2, RubyModule init, boolean inherit, boolean loadConstant) {
        for (RubyModule mod = init; mod != null; mod = mod.getSuperClass()) {
            IRubyObject value2 = mod.fetchConstant(name2, true);
            if (value2 == UNDEF) {
                return mod.getAutoloadConstant(name2, loadConstant);
            }
            if (value2 != null) {
                return value2;
            }
            if (!inherit) break;
        }
        return null;
    }

    public IRubyObject getConstantFrom(String name2) {
        IRubyObject value2 = this.getConstantFromNoConstMissing(name2);
        return value2 != null ? value2 : this.getConstantFromConstMissing(name2);
    }

    @Deprecated
    public IRubyObject fastGetConstantFrom(String internedName) {
        return this.getConstantFrom(internedName);
    }

    public IRubyObject getConstantFromNoConstMissing(String name2) {
        return this.getConstantFromNoConstMissing(name2, true);
    }

    public IRubyObject getConstantFromNoConstMissing(String name2, boolean includePrivate) {
        Ruby runtime2 = this.getRuntime();
        RubyClass objectClass = runtime2.getObject();
        for (RubyModule mod = this; mod != null; mod = mod.getSuperClass()) {
            IRubyObject value2 = mod.fetchConstant(name2, includePrivate);
            if (value2 == null) continue;
            if (value2 == UNDEF) {
                return mod.resolveUndefConstant(name2);
            }
            if (mod == objectClass && this != objectClass) {
                return null;
            }
            return value2;
        }
        return null;
    }

    @Deprecated
    public IRubyObject fastGetConstantFromNoConstMissing(String internedName) {
        return this.getConstantFromNoConstMissing(internedName);
    }

    public IRubyObject getConstantFromConstMissing(String name2) {
        Ruby runtime2 = this.metaClass.runtime;
        return this.callMethod(runtime2.getCurrentContext(), "const_missing", (IRubyObject)runtime2.fastNewSymbol(name2));
    }

    @Deprecated
    public IRubyObject fastGetConstantFromConstMissing(String internedName) {
        return this.getConstantFromConstMissing(internedName);
    }

    public final IRubyObject resolveUndefConstant(String name2) {
        return this.getAutoloadConstant(name2);
    }

    public IRubyObject setConstantQuiet(String name2, IRubyObject value2) {
        return this.setConstantCommon(name2, value2, false, false);
    }

    public IRubyObject setConstant(String name2, IRubyObject value2) {
        return this.setConstantCommon(name2, value2, false, true);
    }

    public IRubyObject setConstant(String name2, IRubyObject value2, boolean hidden) {
        return this.setConstantCommon(name2, value2, hidden, true);
    }

    private IRubyObject setConstantCommon(String name2, IRubyObject value2, boolean hidden, boolean warn2) {
        IRubyObject oldValue = this.fetchConstant(name2);
        this.setParentForModule(name2, value2);
        if (oldValue != null) {
            boolean notAutoload;
            boolean bl = notAutoload = oldValue != UNDEF;
            if (notAutoload || !this.setAutoloadConstant(name2, value2)) {
                if (warn2 && notAutoload) {
                    this.getRuntime().getWarnings().warn(IRubyWarnings.ID.CONSTANT_ALREADY_INITIALIZED, "already initialized constant " + name2);
                }
                if (hidden) {
                    this.storeConstant(name2, value2, true);
                } else {
                    this.storeConstant(name2, value2);
                }
            }
        } else if (hidden) {
            this.storeConstant(name2, value2, true);
        } else {
            this.storeConstant(name2, value2);
        }
        this.invalidateConstantCache(name2);
        return value2;
    }

    private void setParentForModule(String name2, IRubyObject value2) {
        if (value2 instanceof RubyModule) {
            RubyModule module = (RubyModule)value2;
            if (module != this && module.getBaseName() == null) {
                module.setBaseName(name2);
                module.setParent(this);
            }
            module.calculateName();
        }
    }

    @Deprecated
    public IRubyObject fastSetConstant(String internedName, IRubyObject value2) {
        return this.setConstant(internedName, value2);
    }

    @Extension
    public void defineConstant(String name2, IRubyObject value2) {
        assert (value2 != null);
        if (!IdUtil.isValidConstantName(name2)) {
            throw this.getRuntime().newNameError("bad constant name " + name2, name2);
        }
        this.setConstant(name2, value2);
    }

    public boolean isConstantDefined(String name2) {
        assert (IdUtil.isConstant(name2));
        boolean isObject = this == this.getRuntime().getObject();
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.constantTableFetch(name2)) == null) continue;
            if (value2 != UNDEF) {
                return true;
            }
            return this.getAutoloadMap().get(name2) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsConstantDefined(String internedName) {
        assert (internedName.equals(internedName.intern())) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        boolean isObject = this == this.getRuntime().getObject();
        RubyModule module = this;
        do {
            IRubyObject value2;
            if ((value2 = module.constantTableFetch(internedName)) == null) continue;
            if (value2 != UNDEF) {
                return true;
            }
            return this.getAutoloadMap().get(internedName) != null;
        } while (isObject && (module = module.getSuperClass()) != null);
        return false;
    }

    public boolean fastIsConstantDefined19(String internedName) {
        return this.fastIsConstantDefined19(internedName, true);
    }

    public boolean fastIsConstantDefined19(String internedName, boolean inherit) {
        assert (internedName.equals(internedName.intern())) : internedName + " is not interned";
        assert (IdUtil.isConstant(internedName));
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            IRubyObject value2 = module.constantTableFetch(internedName);
            if (value2 != null) {
                if (value2 != UNDEF) {
                    return true;
                }
                return this.getAutoloadMap().get(internedName) != null;
            }
            if (!inherit) break;
        }
        return false;
    }

    private RaiseException cannotRemoveError(String id2) {
        Ruby runtime2 = this.getRuntime();
        return this.getRuntime().newNameError(RubyStringBuilder.str(runtime2, "cannot remove ", RubyStringBuilder.ids(runtime2, id2), " for ", RubyStringBuilder.types(runtime2, this)), id2);
    }

    public boolean hasInternalModuleVariable(String name2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasInternalVariable(name2)) continue;
            return true;
        }
        return false;
    }

    public IRubyObject searchInternalModuleVariable(String name2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            IRubyObject value2 = (IRubyObject)module.getInternalVariable(name2);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    public void setInternalModuleVariable(String name2, IRubyObject value2) {
        for (RubyModule module = this; module != null; module = module.getSuperClass()) {
            if (!module.hasInternalVariable(name2)) continue;
            module.setInternalVariable(name2, value2);
            return;
        }
        this.setInternalVariable(name2, value2);
    }

    protected Map<String, IRubyObject> getClassVariables() {
        if (CLASSVARS_UPDATER == null) {
            return this.getClassVariablesForWriteSynchronized();
        }
        return this.getClassVariablesForWriteAtomic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, IRubyObject> getClassVariablesForWriteSynchronized() {
        Map<String, IRubyObject> myClassVars = this.classVariables;
        if (myClassVars == Collections.EMPTY_MAP) {
            RubyModule rubyModule = this;
            synchronized (rubyModule) {
                myClassVars = this.classVariables;
                if (myClassVars == Collections.EMPTY_MAP) {
                    this.classVariables = new ConcurrentHashMap<String, IRubyObject>(4, 0.75f, 2);
                    return this.classVariables;
                }
                return myClassVars;
            }
        }
        return myClassVars;
    }

    private Map<String, IRubyObject> getClassVariablesForWriteAtomic() {
        ConcurrentHashMap<String, IRubyObject> newClassVars;
        Map<String, IRubyObject> myClassVars;
        do {
            if ((myClassVars = this.classVariables) == Collections.EMPTY_MAP) continue;
            return myClassVars;
        } while (!CLASSVARS_UPDATER.compareAndSet(this, myClassVars, newClassVars = new ConcurrentHashMap<String, IRubyObject>(4, 0.75f, 2)));
        return newClassVars;
    }

    protected Map<String, IRubyObject> getClassVariablesForRead() {
        return this.classVariables;
    }

    public boolean hasClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.getClassVariablesForRead().containsKey(name2);
    }

    @Deprecated
    public boolean fastHasClassVariable(String internedName) {
        return this.hasClassVariable(internedName);
    }

    public IRubyObject fetchClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        return this.getClassVariablesForRead().get(name2);
    }

    @Deprecated
    public IRubyObject fastFetchClassVariable(String internedName) {
        return this.fetchClassVariable(internedName);
    }

    public IRubyObject storeClassVariable(String name2, IRubyObject value2) {
        assert (IdUtil.isClassVariable(name2) && value2 != null);
        this.ensureClassVariablesSettable();
        this.getClassVariables().put(name2, value2);
        return value2;
    }

    @Deprecated
    public IRubyObject fastStoreClassVariable(String internedName, IRubyObject value2) {
        return this.storeClassVariable(internedName, value2);
    }

    public IRubyObject deleteClassVariable(String name2) {
        assert (IdUtil.isClassVariable(name2));
        this.ensureClassVariablesSettable();
        return this.getClassVariablesForRead().remove(name2);
    }

    public List<String> getClassVariableNameList() {
        return new ArrayList<String>(this.getClassVariablesForRead().keySet());
    }

    protected final String validateClassVariable(String name2) {
        if (IdUtil.isValidClassVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`%1$s' is not allowed as a class variable name", (IRubyObject)this, name2);
    }

    protected final String validateClassVariable(IRubyObject nameObj, String name2) {
        if (IdUtil.isValidClassVariableName(name2)) {
            return name2;
        }
        throw this.getRuntime().newNameError("`%1$s' is not allowed as a class variable name", (IRubyObject)this, nameObj);
    }

    protected String validateClassVariable(Ruby runtime2, IRubyObject object) {
        RubySymbol name2 = TypeConverter.checkID(object);
        if (!name2.validClassVariableName()) {
            throw this.getRuntime().newNameError(RubyStringBuilder.str(runtime2, "`", RubyStringBuilder.ids(runtime2, name2), "' is not allowed as a class variable name"), (IRubyObject)this, object);
        }
        return name2.idString();
    }

    protected final void ensureClassVariablesSettable() {
        this.checkAndRaiseIfFrozen();
    }

    public boolean hasConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        return this.constantTableContains(name2);
    }

    @Deprecated
    public boolean fastHasConstant(String internedName) {
        return this.hasConstant(internedName);
    }

    public IRubyObject fetchConstant(String name2) {
        return this.fetchConstant(name2, true);
    }

    public IRubyObject fetchConstant(String name2, boolean includePrivate) {
        ConstantEntry entry = this.constantEntryFetch(name2);
        if (entry == null) {
            return null;
        }
        if (entry.hidden && !includePrivate) {
            RubyModule recv2 = this;
            if (recv2.isIncluded()) {
                recv2 = recv2.getNonIncludedClass();
            }
            throw this.getRuntime().newNameError("private constant " + this.getName() + "::" + name2 + " referenced", (IRubyObject)recv2, name2);
        }
        if (entry.deprecated) {
            Ruby runtime2 = this.getRuntime();
            if ("Object".equals(this.getName())) {
                runtime2.getWarnings().warn(IRubyWarnings.ID.CONSTANT_DEPRECATED, "constant ::" + name2 + " is deprecated");
            } else {
                runtime2.getWarnings().warn(IRubyWarnings.ID.CONSTANT_DEPRECATED, "constant " + this.getName() + "::" + name2 + " is deprecated");
            }
        }
        return entry.value;
    }

    @Deprecated
    public IRubyObject fastFetchConstant(String internedName) {
        return this.fetchConstant(internedName);
    }

    public IRubyObject storeConstant(String name2, IRubyObject value2) {
        assert (value2 != null) : "value is null";
        assert (IdUtil.isConstant(name2)) : "invalid constant name: " + name2;
        this.ensureConstantsSettable();
        return this.constantTableStore(name2, value2);
    }

    public IRubyObject storeConstant(String name2, IRubyObject value2, boolean hidden) {
        assert (value2 != null) : "value is null";
        this.ensureConstantsSettable();
        return this.constantTableStore(name2, value2, hidden);
    }

    private IRubyObject storeConstant(String name2, IRubyObject value2, boolean hidden, boolean deprecated) {
        assert (value2 != null) : "value is null";
        assert (IdUtil.isConstant(name2)) : "invalid constant name: " + name2;
        this.ensureConstantsSettable();
        return this.constantTableStore(name2, value2, hidden, deprecated);
    }

    @Deprecated
    public IRubyObject fastStoreConstant(String internedName, IRubyObject value2) {
        return this.storeConstant(internedName, value2);
    }

    public IRubyObject deleteConstant(String name2) {
        assert (IdUtil.isConstant(name2));
        this.ensureConstantsSettable();
        return this.constantTableRemove(name2);
    }

    @Deprecated
    public List<Variable<IRubyObject>> getStoredConstantList() {
        return null;
    }

    @Deprecated
    public List<String> getStoredConstantNameList() {
        return new ArrayList<String>(this.getConstantMap().keySet());
    }

    public Collection<String> getConstantNames() {
        return this.getConstantMap().keySet();
    }

    public Collection<String> getConstantNames(boolean includePrivate) {
        if (includePrivate) {
            return this.getConstantNames();
        }
        if (this.getConstantMap().size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> publicNames = new HashSet<String>(this.getConstantMap().size());
        for (Map.Entry<String, ConstantEntry> entry : this.getConstantMap().entrySet()) {
            if (entry.getValue().hidden) continue;
            publicNames.add(entry.getKey());
        }
        return publicNames;
    }

    protected final String validateConstant(IRubyObject name2) {
        return RubySymbol.retrieveIDSymbol(name2, (sym, newSym) -> {
            if (!sym.validConstantName()) {
                throw this.getRuntime().newNameError(RubyStringBuilder.str(this.getRuntime(), "wrong constant name ", name2), sym.idString());
            }
        }).idString();
    }

    protected final String validateConstant(String name2, IRubyObject errorName) {
        RubyString nameString;
        if (IdUtil.isValidConstantName(name2)) {
            return name2;
        }
        Ruby runtime2 = this.getRuntime();
        Encoding resultEncoding = runtime2.getDefaultInternalEncoding();
        if (resultEncoding == null) {
            resultEncoding = runtime2.getDefaultExternalEncoding();
        }
        if ((nameString = errorName.asString()).getEncoding() != resultEncoding && !nameString.isAsciiOnly() || nameString.toString().indexOf(0) > -1) {
            nameString = nameString.inspect();
        }
        throw this.getRuntime().newNameError("wrong constant name " + nameString, name2);
    }

    protected final void ensureConstantsSettable() {
        this.checkAndRaiseIfFrozen();
    }

    private void checkAndRaiseIfFrozen() throws RaiseException {
        if (this.isFrozen()) {
            if (this instanceof RubyClass) {
                if (this.getBaseName() == null) {
                    throw this.getRuntime().newFrozenError(this.getName());
                }
                throw this.getRuntime().newFrozenError("#<Class:" + this.getName() + '>');
            }
            throw this.getRuntime().newFrozenError("Module");
        }
    }

    @Override
    public final void checkFrozen() {
        if (this.isFrozen()) {
            throw this.getRuntime().newFrozenError(this.isClass() ? "class" : "module");
        }
    }

    protected boolean constantTableContains(String name2) {
        return this.getConstantMap().containsKey(name2);
    }

    protected IRubyObject constantTableFetch(String name2) {
        ConstantEntry entry = this.getConstantMap().get(name2);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    protected ConstantEntry constantEntryFetch(String name2) {
        return this.getConstantMap().get(name2);
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2) {
        Map<String, ConstantEntry> constMap = this.getConstantMapForWrite();
        boolean hidden = false;
        ConstantEntry entry = constMap.get(name2);
        if (entry != null) {
            hidden = entry.hidden;
        }
        constMap.put(name2, new ConstantEntry(value2, hidden));
        return value2;
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2, boolean hidden) {
        return this.constantTableStore(name2, value2, hidden, false);
    }

    protected IRubyObject constantTableStore(String name2, IRubyObject value2, boolean hidden, boolean deprecated) {
        Map<String, ConstantEntry> constMap = this.getConstantMapForWrite();
        constMap.put(name2, new ConstantEntry(value2, hidden, deprecated));
        return value2;
    }

    protected IRubyObject constantTableRemove(String name2) {
        ConstantEntry entry = this.getConstantMapForWrite().remove(name2);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    protected final void defineAutoload(String name2, AutoloadMethod loadMethod) {
        Autoload existingAutoload = this.getAutoloadMap().get(name2);
        if (existingAutoload == null || existingAutoload.getValue() == null) {
            this.storeConstant(name2, RubyObject.UNDEF);
            this.getAutoloadMapForWrite().put(name2, new Autoload(loadMethod));
        }
    }

    protected final IRubyObject finishAutoload(String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 == null) {
            return null;
        }
        IRubyObject value2 = autoload2.getValue();
        if (value2 != null) {
            this.storeConstant(name2, value2);
        }
        this.removeAutoload(name2);
        this.invalidateConstantCache(name2);
        return value2;
    }

    public final IRubyObject getAutoloadConstant(String name2) {
        return this.getAutoloadConstant(name2, true);
    }

    protected IRubyObject getAutoloadConstant(String name2, boolean loadConstant) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 == null) {
            return null;
        }
        if (!loadConstant) {
            return RubyObject.UNDEF;
        }
        return autoload2.getConstant(this.getRuntime().getCurrentContext());
    }

    private boolean setAutoloadConstant(String name2, IRubyObject value2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        if (autoload2 != null) {
            boolean set2 = autoload2.setConstant(this.getRuntime().getCurrentContext(), value2);
            if (!set2) {
                this.removeAutoload(name2);
            }
            return set2;
        }
        return false;
    }

    private void removeAutoload(String name2) {
        this.getAutoloadMapForWrite().remove(name2);
    }

    protected RubyString getAutoloadFile(String name2) {
        Autoload autoload2 = this.getAutoloadMap().get(name2);
        return autoload2 == null ? null : autoload2.getFile();
    }

    private static void define(RubyModule module, JavaMethodDescriptor desc, String simpleName, DynamicMethod dynamicMethod) {
        block16: {
            String baseName;
            String[] aliases2;
            String[] names2;
            JRubyMethod jrubyMethod;
            block15: {
                String baseName2;
                jrubyMethod = desc.anno;
                names2 = jrubyMethod.name();
                aliases2 = jrubyMethod.alias();
                if (!jrubyMethod.meta()) break block15;
                RubyClass singletonClass = module.getSingletonClass();
                dynamicMethod.setImplementationClass(singletonClass);
                if (names2.length == 0) {
                    baseName2 = desc.name;
                    singletonClass.addMethod(baseName2, dynamicMethod);
                } else {
                    baseName2 = names2[0];
                    for (String name2 : names2) {
                        singletonClass.addMethod(name2, dynamicMethod);
                    }
                }
                if (aliases2.length <= 0) break block16;
                for (String alias : aliases2) {
                    singletonClass.defineAlias(alias, baseName2);
                }
                break block16;
            }
            if (names2.length == 0) {
                baseName = desc.name;
                module.getMethodLocation().addMethod(baseName, dynamicMethod);
            } else {
                baseName = names2[0];
                for (String name3 : names2) {
                    module.getMethodLocation().addMethod(name3, dynamicMethod);
                }
            }
            if (aliases2.length > 0) {
                for (String alias : aliases2) {
                    module.defineAlias(alias, baseName);
                }
            }
            if (jrubyMethod.module()) {
                RubyClass singletonClass = module.getSingletonClass();
                DynamicMethod moduleMethod = dynamicMethod.dup();
                moduleMethod.setImplementationClass(singletonClass);
                moduleMethod.setVisibility(Visibility.PUBLIC);
                if (names2.length == 0) {
                    baseName = desc.name;
                    singletonClass.addMethod(desc.name, moduleMethod);
                } else {
                    baseName = names2[0];
                    for (String name4 : names2) {
                        singletonClass.addMethod(name4, moduleMethod);
                    }
                }
                if (aliases2.length > 0) {
                    for (String alias : aliases2) {
                        singletonClass.defineAlias(alias, baseName);
                    }
                }
            }
        }
    }

    @Deprecated
    public IRubyObject initialize(Block block) {
        return this.initialize(this.getRuntime().getCurrentContext());
    }

    public void setJavaProxy(boolean javaProxy) {
        this.javaProxy = javaProxy;
    }

    public boolean getJavaProxy() {
        return this.javaProxy;
    }

    public boolean getCacheProxy() {
        return this.getFlag(CACHEPROXY_F);
    }

    public void setCacheProxy(boolean cacheProxy) {
        this.setFlag(CACHEPROXY_F, cacheProxy);
    }

    @Override
    public <T> T toJava(Class<T> target) {
        ThreadContext context;
        IRubyObject javaClass;
        if (target == Class.class && !(javaClass = JavaClass.java_class(context = this.metaClass.runtime.getCurrentContext(), this)).isNil()) {
            return javaClass.toJava(target);
        }
        return super.toJava(target);
    }

    public Set<String> discoverInstanceVariables() {
        HashSet<String> set2 = new HashSet<String>();
        for (RubyModule cls = this; cls != null; cls = cls.getSuperClass()) {
            Map<String, DynamicMethod> methods2 = cls.getNonIncludedClass().getMethodLocation().getMethods();
            methods2.forEach((name2, method2) -> set2.addAll(method2.getMethodData().getIvarNames()));
        }
        return set2;
    }

    public boolean isRefinement() {
        return this.getFlag(REFINED_MODULE_F);
    }

    public boolean isIncludedIntoRefinement() {
        return this.getFlag(INCLUDED_INTO_REFINEMENT);
    }

    public boolean isMethodBuiltin(String methodName) {
        DynamicMethod method2 = this.searchMethod(methodName);
        return method2 != null && method2.isBuiltin();
    }

    public Map<RubyModule, RubyModule> getRefinements() {
        return this.refinements;
    }

    public Map<RubyModule, RubyModule> getRefinementsForWrite() {
        Map<RubyModule, RubyModule> refinements = this.refinements;
        return !refinements.isEmpty() ? refinements : (this.refinements = RubyModule.newRefinementsMap());
    }

    public void setRefinements(Map<RubyModule, RubyModule> refinements) {
        this.refinements = refinements;
    }

    static {
        AtomicReferenceFieldUpdater<RubyModule, Map> updater;
        block2: {
            LOG = LoggerFactory.getLogger(RubyModule.class);
            CACHEPROXY_F = ObjectFlags.CACHEPROXY_F;
            NEEDSIMPL_F = ObjectFlags.NEEDSIMPL_F;
            REFINED_MODULE_F = ObjectFlags.REFINED_MODULE_F;
            IS_OVERLAID_F = ObjectFlags.IS_OVERLAID_F;
            OMOD_SHARED = ObjectFlags.OMOD_SHARED;
            INCLUDED_INTO_REFINEMENT = ObjectFlags.INCLUDED_INTO_REFINEMENT;
            MODULE_ALLOCATOR = new ObjectAllocator(){

                @Override
                public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
                    return new RubyModule(runtime2, klass);
                }
            };
            NormalCacheEntryFactory = new CacheEntryFactory(){

                @Override
                public CacheEntry newCacheEntry(String id2, DynamicMethod method2, RubyModule sourceModule, int token) {
                    return new CacheEntry(method2, sourceModule, token);
                }
            };
            SCOPE_CAPTURING_METHODS = new HashSet<String>(Arrays.asList("eval", "module_eval", "class_eval", "instance_eval", "module_exec", "class_exec", "instance_exec", "binding", "local_variables"));
            updater = null;
            try {
                updater = AtomicReferenceFieldUpdater.newUpdater(RubyModule.class, Map.class, "classVariables");
            }
            catch (RuntimeException ex) {
                if (ex.getCause() instanceof AccessControlException) break block2;
                throw ex;
            }
        }
        CLASSVARS_UPDATER = updater;
        LOOKUP = MethodHandles.lookup();
        testModuleMatch = Binder.from(Boolean.TYPE, ThreadContext.class, IRubyObject.class, Integer.TYPE).invokeStaticQuiet(LOOKUP, Bootstrap.class, "testModuleMatch");
    }

    private static final class Autoload {
        private volatile ThreadContext ctx = null;
        private final Object ctxLock = new Object();
        private volatile IRubyObject value = null;
        private final AutoloadMethod loadMethod;

        Autoload(AutoloadMethod loadMethod) {
            this.loadMethod = loadMethod;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        IRubyObject getConstant(ThreadContext ctx) {
            Object object = this.ctxLock;
            synchronized (object) {
                if (this.ctx == null) {
                    this.ctx = ctx;
                } else if (this.isSelf(ctx)) {
                    return this.getValue();
                }
                this.loadMethod.load(ctx.runtime);
            }
            return this.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean setConstant(ThreadContext ctx, IRubyObject newValue) {
            Object object = this.ctxLock;
            synchronized (object) {
                boolean isSelf = this.isSelf(ctx);
                if (isSelf) {
                    this.value = newValue;
                }
                return isSelf;
            }
        }

        IRubyObject getValue() {
            return this.value;
        }

        RubyString getFile() {
            return this.loadMethod.getFile();
        }

        private boolean isSelf(ThreadContext rhs) {
            return this.ctx != null && this.ctx.getThread() == rhs.getThread();
        }
    }

    public static interface AutoloadMethod {
        public void load(Ruby var1);

        public RubyString getFile();
    }

    public static class ConstantEntry {
        public final IRubyObject value;
        public final boolean hidden;
        final boolean deprecated;

        public ConstantEntry(IRubyObject value2, boolean hidden) {
            this.value = value2;
            this.hidden = hidden;
            this.deprecated = false;
        }

        ConstantEntry(IRubyObject value2, boolean hidden, boolean deprecated) {
            this.value = value2;
            this.hidden = hidden;
            this.deprecated = deprecated;
        }

        public ConstantEntry dup() {
            return new ConstantEntry(this.value, this.hidden, this.deprecated);
        }
    }

    public static class RespondToMissingMethod
    extends JavaMethod.JavaMethodNBlock {
        final String methodName;

        public RespondToMissingMethod(RubyModule implClass, Visibility visibility, String methodName) {
            super(implClass, visibility, methodName);
            this.setParameterList(REST);
            this.methodName = methodName;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            return Helpers.callMethodMissing(context, self2, this.getVisibility(), name2, CallType.UNKNOWN, args2, block);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof RespondToMissingMethod && ((RespondToMissingMethod)other).methodName.equals(this.methodName);
        }

        public int hashCode() {
            return this.methodName.hashCode();
        }
    }

    protected static class ProfilingCacheEntryFactory
    extends WrapperCacheEntryFactory {
        private final MethodEnhancer enhancer;

        public ProfilingCacheEntryFactory(Ruby runtime2, CacheEntryFactory previous) {
            super(previous);
            this.enhancer = runtime2.getProfilingService().newMethodEnhancer(runtime2);
        }

        private MethodEnhancer getMethodEnhancer() {
            return this.enhancer;
        }

        @Override
        public CacheEntry newCacheEntry(String id2, DynamicMethod method2, RubyModule sourceModule, int token) {
            if (method2.isUndefined()) {
                return new CacheEntry(method2, token);
            }
            CacheEntry delegated = this.previous.newCacheEntry(id2, method2, sourceModule, token);
            DynamicMethod enhancedMethod = this.getMethodEnhancer().enhance(id2, delegated.method);
            return new CacheEntry(enhancedMethod, delegated.sourceModule, delegated.token);
        }
    }

    protected static class SynchronizedCacheEntryFactory
    extends WrapperCacheEntryFactory {
        public SynchronizedCacheEntryFactory(CacheEntryFactory previous) {
            super(previous);
        }

        @Override
        public CacheEntry newCacheEntry(String id2, DynamicMethod method2, RubyModule sourceModule, int token) {
            if (method2.isUndefined()) {
                return new CacheEntry(method2, token);
            }
            CacheEntry delegated = this.previous.newCacheEntry(id2, method2, sourceModule, token);
            return new CacheEntry(new SynchronizedDynamicMethod(delegated.method), delegated.sourceModule, delegated.token);
        }
    }

    protected static abstract class WrapperCacheEntryFactory
    extends CacheEntryFactory {
        protected final CacheEntryFactory previous;

        public WrapperCacheEntryFactory(CacheEntryFactory previous) {
            this.previous = previous;
        }

        public CacheEntryFactory getPrevious() {
            return this.previous;
        }
    }

    protected static abstract class CacheEntryFactory {
        protected CacheEntryFactory() {
        }

        public abstract CacheEntry newCacheEntry(String var1, DynamicMethod var2, RubyModule var3, int var4);

        public boolean hasCacheEntryFactory(Class cacheEntryFactoryClass) {
            CacheEntryFactory current2 = this;
            while (current2 instanceof WrapperCacheEntryFactory) {
                if (cacheEntryFactoryClass.isAssignableFrom(current2.getClass())) {
                    return true;
                }
                current2 = ((WrapperCacheEntryFactory)current2).getPrevious();
            }
            return cacheEntryFactoryClass.isAssignableFrom(current2.getClass());
        }
    }

    public static final class MethodClumper {
        private HashMap<String, List<JavaMethodDescriptor>> annotatedMethods;
        private HashMap<String, List<JavaMethodDescriptor>> staticAnnotatedMethods;
        public Map<Set<FrameField>, List<String>> readGroups = Collections.EMPTY_MAP;
        public Map<Set<FrameField>, List<String>> writeGroups = Collections.EMPTY_MAP;

        public void clump(Class klass) {
            Method[] declaredMethods;
            for (Method method2 : declaredMethods = MethodGatherer.DECLARED_METHODS.get(klass)) {
                ArrayList<JavaMethodDescriptor> methodDescs;
                HashMap<String, List<JavaMethodDescriptor>> methodsHash;
                String name2;
                JRubyMethod anno = method2.getAnnotation(JRubyMethod.class);
                if (anno == null || anno.compat() == CompatVersion.RUBY1_8 || method2.isBridge()) continue;
                JavaMethodDescriptor desc = new JavaMethodDescriptor(method2);
                String[] names2 = anno.name();
                String string2 = name2 = names2.length == 0 ? method2.getName() : names2[0];
                if (desc.isStatic) {
                    methodsHash = this.staticAnnotatedMethods;
                    if (methodsHash == null) {
                        this.staticAnnotatedMethods = new HashMap();
                        methodsHash = this.staticAnnotatedMethods;
                    }
                } else {
                    methodsHash = this.annotatedMethods;
                    if (methodsHash == null) {
                        this.annotatedMethods = new HashMap();
                        methodsHash = this.annotatedMethods;
                    }
                }
                if ((methodDescs = (ArrayList<JavaMethodDescriptor>)methodsHash.get(name2)) == null) {
                    methodDescs = new ArrayList<JavaMethodDescriptor>(4);
                    methodsHash.put(name2, methodDescs);
                }
                methodDescs.add(desc);
                if (anno.reads().length > 0 && this.readGroups == Collections.EMPTY_MAP) {
                    this.readGroups = new HashMap<Set<FrameField>, List<String>>();
                }
                if (anno.writes().length > 0 && this.writeGroups == Collections.EMPTY_MAP) {
                    this.writeGroups = new HashMap<Set<FrameField>, List<String>>();
                }
                AnnotationHelper.groupFrameFields(this.readGroups, this.writeGroups, anno, method2.getName());
            }
        }

        @Deprecated
        public Map<String, List<JavaMethodDescriptor>> getAllAnnotatedMethods() {
            return null;
        }

        public final Map<String, List<JavaMethodDescriptor>> getAnnotatedMethods() {
            return this.annotatedMethods == null ? Collections.EMPTY_MAP : this.annotatedMethods;
        }

        public final Map<String, List<JavaMethodDescriptor>> getStaticAnnotatedMethods() {
            return this.staticAnnotatedMethods == null ? Collections.EMPTY_MAP : this.staticAnnotatedMethods;
        }
    }

    public static final class JavaClassKindOf
    extends KindOf {
        private final Class klass;

        public JavaClassKindOf(Class klass) {
            this.klass = klass;
        }

        @Override
        public boolean isKindOf(IRubyObject obj, RubyModule type2) {
            return this.klass.isInstance(obj);
        }
    }

    public static class KindOf {
        public static final KindOf DEFAULT_KIND_OF = new KindOf();

        public boolean isKindOf(IRubyObject obj, RubyModule type2) {
            RubyClass cl = obj.getMetaClass();
            return cl.searchAncestor(type2.getDelegate().getNonIncludedClass()) != null;
        }
    }

    public static class ModuleKernelMethods {
        @JRubyMethod
        public static IRubyObject autoload(ThreadContext context, IRubyObject self2, IRubyObject symbol, IRubyObject file2) {
            return RubyKernel.autoload(context, self2, symbol, file2);
        }

        @JRubyMethod(name={"autoload?"})
        public static IRubyObject autoload_p(ThreadContext context, IRubyObject self2, IRubyObject symbol) {
            Ruby runtime2 = context.runtime;
            String name2 = TypeConverter.checkID(symbol).idString();
            for (RubyModule mod = RubyKernel.getModuleForAutoload(runtime2, self2); mod != null; mod = mod.getSuperClass()) {
                IRubyObject loadedValue = mod.fetchConstant(name2);
                if (loadedValue != null && loadedValue != RubyBasicObject.UNDEF) {
                    return context.nil;
                }
                RubyString file2 = mod.isIncluded() ? mod.getNonIncludedClass().getAutoloadFile(name2) : mod.getAutoloadFile(name2);
                if (file2 == null) continue;
                if (runtime2.getLoadService().featureAlreadyLoaded(file2.asJavaString())) {
                    return context.nil;
                }
                return file2;
            }
            return context.nil;
        }
    }
}

