"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DebugAPI = void 0;
const inspector_1 = __importDefault(require("inspector"));
const express_1 = __importDefault(require("express"));
/**
 * A HTTP based Debug API for bridging
 */
class DebugAPI {
    constructor(opts) {
        this.opts = opts;
        this.app = express_1.default();
        this.app.post("/inspector/start", this.onInspectorStart);
        this.app.post("/inspector/stop", this.onInspectorStop);
    }
    async start() {
        return new Promise((res, rej) => {
            this.app.once("error", rej);
            this.app.listen(this.opts.port, this.opts.host, res);
        });
    }
    addRoute(method, path, callback) {
        this.app[method](path, callback);
    }
    onInspectorStart(_, res) {
        if (!this.opts.inspector) {
            res.status(500).send({ "error": "Inspector not configured" });
            return;
        }
        inspector_1.default.open(this.opts.inspector.port, this.opts.inspector.host || this.opts.host);
        res.status(200).send({});
    }
    onInspectorStop(_, res) {
        if (!this.opts.inspector) {
            res.status(500).send({ "error": "Inspector not configured" });
            return;
        }
        inspector_1.default.close();
        res.status(200).send({});
    }
}
exports.DebugAPI = DebugAPI;
//# sourceMappingURL=debug-api.js.map