# NormalizInterface, chapter 3
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST( "normalizinterface02.tst");

# doc/_Chunks.xml:2-15
gap> C := NmzCone(["integral_closure",[[2,1],[1,3]]]);
<a Normaliz cone>
gap> NmzHasConeProperty(C,"HilbertBasis");
false
gap> NmzHasConeProperty(C,"SupportHyperplanes");
false
gap> NmzConeProperty(C,"HilbertBasis");
[ [ 1, 1 ], [ 1, 2 ], [ 1, 3 ], [ 2, 1 ] ]
gap> NmzHasConeProperty(C,"SupportHyperplanes");
true
gap> NmzConeProperty(C,"SupportHyperplanes");
[ [ -1, 2 ], [ 3, -1 ] ]

# doc/_Chunks.xml:21-36
gap> D := NmzCone(["equations",[[1,2,-3]], "grading",[[0,-1,3]]]);
<a Normaliz cone>
gap> NmzCompute(D,["DualMode","HilbertSeries"]);
true
gap> NmzHilbertBasis(D);
[ [ 1, 1, 1 ], [ 0, 3, 2 ], [ 3, 0, 1 ] ]
gap> NmzHilbertSeries(D);
[ t^2-t+1, [ [ 1, 1 ], [ 3, 1 ] ] ]
gap> NmzHasConeProperty(D,"SupportHyperplanes");
true
gap> NmzSupportHyperplanes(D);
[ [ 1, 0, 0 ], [ 1, 3, -3 ] ]
gap> NmzEquations(D);
[ [ 1, 2, -3 ] ]

# doc/_Chunks.xml:42-53
gap> P := NmzCone(["inhom_equations",[[1,2,-3,1]], "grading", [[1,1,1]]]);
<a Normaliz cone>
gap> NmzIsInhomogeneous(C);
false
gap> NmzIsInhomogeneous(P);
true
gap> NmzHilbertBasis(P);
[ [ 1, 1, 1, 0 ], [ 3, 0, 1, 0 ], [ 0, 3, 2, 0 ] ]
gap> NmzModuleGenerators(P);
[ [ 0, 1, 1, 1 ], [ 2, 0, 1, 1 ] ]

# doc/_Chunks.xml:59-86
gap> Magic3x3even := NmzCone(["equations",
> [ [1, 1, 1,  -1, -1, -1,   0,  0,  0],
>   [1, 1, 1,   0,  0,  0,  -1, -1, -1],
>   [0, 1, 1,  -1,  0,  0,  -1,  0,  0],
>   [1, 0, 1,   0, -1,  0,   0, -1,  0],
>   [1, 1, 0,   0,  0, -1,   0,  0, -1],
>   [0, 1, 1,   0, -1,  0,   0,  0, -1],
>   [1, 1, 0,   0, -1,  0,  -1,  0,  0] ],
> "congruences",
> [ [1, 0, 0,   0, 0, 0,   0, 0, 0,  2],
>   [0, 0, 1,   0, 0, 0,   0, 0, 0,  2],
>   [0, 0, 0,   0, 0, 0,   1, 0, 0,  2],
>   [0, 0, 0,   0, 0, 0,   0, 0, 1,  2] ],
> "grading",
> [ [1, 1, 1,   0, 0, 0,   0, 0, 0] ] ] );
<a Normaliz cone>
gap> NmzHilbertBasis(Magic3x3even);
[ [ 0, 4, 2, 4, 2, 0, 2, 0, 4 ], [ 2, 0, 4, 4, 2, 0, 0, 4, 2 ], 
  [ 2, 2, 2, 2, 2, 2, 2, 2, 2 ], [ 2, 4, 0, 0, 2, 4, 4, 0, 2 ], 
  [ 4, 0, 2, 0, 2, 4, 2, 4, 0 ], [ 2, 3, 4, 5, 3, 1, 2, 3, 4 ], 
  [ 2, 5, 2, 3, 3, 3, 4, 1, 4 ], [ 4, 1, 4, 3, 3, 3, 2, 5, 2 ], 
  [ 4, 3, 2, 1, 3, 5, 4, 3, 2 ] ]
gap> NmzHilbertSeries(Magic3x3even);
[ t^3+3*t^2-t+1, [ [ 1, 1 ], [ 2, 2 ] ] ]
gap> NmzHilbertQuasiPolynomial(Magic3x3even);
[ 1/2*t^2+t+1, 1/2*t^2-1/2 ]

# doc/_Chunks.xml:92-114
gap> M := [
>  [ 8,  8,  8,  7 ],
>  [ 0,  4,  0,  1 ],
>  [ 0,  1,  0,  7 ],
>  [ 0, -2,  0,  7 ],
>  [ 0, -2,  0,  1 ],
>  [ 8, 48,  8, 17 ],
>  [ 1,  6,  1, 34 ],
>  [ 2,-12, -2, 37 ],
>  [ 4,-24, -4, 14 ]
> ];;
gap> D := NmzCone(["inhom_inequalities", M,
>               "signs", [[1,1,1]],
>               "grading", [[1,1,1]]]);
<a Normaliz cone>
gap> NmzCompute(D,["DualMode","HilbertBasis","ModuleGenerators"]);
true
gap> NmzHilbertBasis(D);
[ [ 1, 0, 0, 0 ], [ 1, 0, 1, 0 ] ]
gap> NmzModuleGenerators(D);
[ [ 0, 0, 0, 1 ], [ 0, 0, 1, 1 ], [ 0, 0, 2, 1 ], [ 0, 0, 3, 1 ] ]

#
gap> STOP_TEST("normalizinterface02.tst", 1 );
