/*
 * Decompiled with CFR 0.152.
 */
package naga.packetreader;

import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import naga.PacketReader;
import naga.exception.ProtocolViolationException;

public class StreamCipherPacketReader
implements PacketReader {
    private final Cipher m_cipher;
    private ByteBuffer m_internalBuffer;
    private PacketReader m_reader;

    public StreamCipherPacketReader(Cipher cipher, PacketReader packetReader) {
        this.m_cipher = cipher;
        this.m_reader = packetReader;
    }

    @Override
    public byte[] nextPacket(ByteBuffer byteBuffer) throws ProtocolViolationException {
        if (this.m_internalBuffer == null) {
            this.m_internalBuffer = ByteBuffer.allocate(this.m_cipher.getOutputSize(byteBuffer.remaining()));
        } else {
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(this.m_cipher.getOutputSize(byteBuffer.remaining()) + this.m_internalBuffer.remaining());
            byteBuffer2.put(this.m_internalBuffer);
            this.m_internalBuffer = byteBuffer2;
        }
        try {
            int n = this.m_cipher.update(byteBuffer, this.m_internalBuffer);
        }
        catch (ShortBufferException shortBufferException) {
            throw new ProtocolViolationException("Short buffer");
        }
        this.m_internalBuffer.flip();
        byte[] byArray = this.m_reader.nextPacket(this.m_internalBuffer);
        if (this.m_internalBuffer.remaining() == 0) {
            this.m_internalBuffer = null;
        }
        return byArray;
    }
}

