/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.linux;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.util.ExecutingCommand;
import oshi.util.tuples.Pair;

public class LinuxUserGroupInfo {
    private final Map<String, Pair<String, String>> usersIdMap = LinuxUserGroupInfo.getUserMap();
    private final Map<String, String> groupsIdMap = LinuxUserGroupInfo.getGroupMap();

    public Pair<String, String> getUser(String userId) {
        return this.usersIdMap.getOrDefault(userId, new Pair<String, String>(userId, "unknown"));
    }

    public String getGroupName(String groupId) {
        return this.groupsIdMap.getOrDefault(groupId, "unknown");
    }

    private static Map<String, Pair<String, String>> getUserMap() {
        HashMap<String, Pair<String, String>> userMap = new HashMap<String, Pair<String, String>>();
        List<String> passwd = ExecutingCommand.runNative("getent passwd");
        for (String entry : passwd) {
            String[] split = entry.split(":");
            if (split.length < 3) continue;
            String userName = split[0];
            String uid = split[2];
            userMap.putIfAbsent(uid, new Pair<String, String>(uid, userName));
        }
        return userMap;
    }

    private static Map<String, String> getGroupMap() {
        HashMap<String, String> groupMap = new HashMap<String, String>();
        List<String> group = ExecutingCommand.runNative("getent group");
        for (String entry : group) {
            String[] split = entry.split(":");
            if (split.length <= 2) continue;
            String groupName = split[0];
            String gid = split[2];
            groupMap.putIfAbsent(gid, groupName);
        }
        return groupMap;
    }
}

