/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.ILabelFilter;

public abstract class SingleLabelFilterBase
implements ILabelFilter {
    @Override
    public void filter(PreprocessingContext context, boolean[] acceptedStems, boolean[] acceptedPhrases) {
        if (!this.isEnabled()) {
            return;
        }
        int[] mostFrequentOriginalWordIndex = context.allStems.mostFrequentOriginalWordIndex;
        for (int stemIndex = 0; stemIndex < acceptedStems.length; ++stemIndex) {
            if (!acceptedStems[stemIndex]) continue;
            acceptedStems[stemIndex] = this.acceptWord(context, mostFrequentOriginalWordIndex[stemIndex]);
        }
        for (int phraseIndex = 0; phraseIndex < acceptedPhrases.length; ++phraseIndex) {
            if (!acceptedPhrases[phraseIndex]) continue;
            acceptedPhrases[phraseIndex] = this.acceptPhrase(context, phraseIndex);
        }
    }

    public abstract boolean acceptWord(PreprocessingContext var1, int var2);

    public abstract boolean acceptPhrase(PreprocessingContext var1, int var2);
}

