/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.httpclient;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultHttpClient;

public final class HttpClientFactory {
    private static final String PROPERTY_NAME_PROXY_HOST = "http.proxyhost";
    private static final String PROPERTY_NAME_PROXY_PORT = "http.proxyport";
    public static final int DEFAULT_TIMEOUT = 8000;

    private HttpClientFactory() {
    }

    public static DefaultHttpClient getTimeoutingClient(int timeout) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpClientFactory.configureProxy((HttpClient)httpClient);
        httpClient.setReuseStrategy((ConnectionReuseStrategy)new NoConnectionReuseStrategy());
        httpClient.getParams().setIntParameter("http.socket.timeout", timeout);
        httpClient.getParams().setIntParameter("http.connection.timeout", timeout);
        httpClient.getParams().setIntParameter("http.socket.linger", 0);
        return httpClient;
    }

    private static void configureProxy(HttpClient httpClient) {
        String proxyHost = System.getProperty(PROPERTY_NAME_PROXY_HOST);
        String proxyPort = System.getProperty(PROPERTY_NAME_PROXY_PORT);
        if (!StringUtils.isEmpty((CharSequence)proxyHost) && !StringUtils.isEmpty((CharSequence)proxyPort)) {
            try {
                int port = Integer.parseInt(proxyPort);
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, port));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static HttpClient getTimeoutingClient() {
        return HttpClientFactory.getTimeoutingClient(8000);
    }
}

