/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.simplexml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.shaded.guava.common.collect.Maps;
import org.carrot2.util.simplexml.DefaultConstructorSimpleXmlWrapper;
import org.carrot2.util.simplexml.ISimpleXmlWrapper;
import org.carrot2.util.simplexml.ListSimpleXmlWrapper;
import org.carrot2.util.simplexml.MapSimpleXmlWrapper;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;

public class SimpleXmlWrappers {
    static Map<Class<?>, Class<? extends ISimpleXmlWrapper<?>>> wrappers = Maps.newHashMap();
    static Map<Class<?>, Boolean> strict = Maps.newHashMap();

    public static synchronized <T> void addWrapper(Class<T> wrappedClass, Class<? extends ISimpleXmlWrapper<? super T>> wrapperClass) {
        SimpleXmlWrappers.addWrapper(wrappedClass, wrapperClass, true);
    }

    public static synchronized <T> void addWrapper(Class<T> wrappedClass, Class<? extends ISimpleXmlWrapper<? super T>> wrapperClass, boolean strict) {
        wrappers.put(wrappedClass, wrapperClass);
        SimpleXmlWrappers.strict.put(wrappedClass, strict);
    }

    public static <K> Map<K, SimpleXmlWrapperValue> wrap(Map<K, ?> toWrap) {
        HashMap wrapped = Maps.newHashMap();
        for (Map.Entry<K, ?> entry : toWrap.entrySet()) {
            wrapped.put(entry.getKey(), SimpleXmlWrapperValue.wrap(entry.getValue()));
        }
        return wrapped;
    }

    public static <K> Map<K, Object> unwrap(Map<K, SimpleXmlWrapperValue> wrapped) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<K, SimpleXmlWrapperValue> entry : wrapped.entrySet()) {
            result.put(entry.getKey(), SimpleXmlWrappers.unwrap(entry.getValue()));
        }
        return result;
    }

    public static List<SimpleXmlWrapperValue> wrap(List<?> toWrap) {
        return (List)SimpleXmlWrappers.wrap(toWrap, new ArrayList<SimpleXmlWrapperValue>());
    }

    public static List<Object> unwrap(List<SimpleXmlWrapperValue> wrapped) {
        return (List)SimpleXmlWrappers.unwrap(wrapped, new ArrayList<Object>());
    }

    public static Set<SimpleXmlWrapperValue> wrap(Set<?> toWrap) {
        return (Set)SimpleXmlWrappers.wrap(toWrap, new HashSet<SimpleXmlWrapperValue>());
    }

    public static Set<Object> unwrap(Set<SimpleXmlWrapperValue> wrapped) {
        return (Set)SimpleXmlWrappers.unwrap(wrapped, new HashSet<Object>());
    }

    public static Collection<SimpleXmlWrapperValue> wrap(Collection<?> toWrap, Collection<SimpleXmlWrapperValue> wrapped) {
        for (Object value : toWrap) {
            wrapped.add(SimpleXmlWrapperValue.wrap(value));
        }
        return wrapped;
    }

    public static Collection<Object> unwrap(Collection<SimpleXmlWrapperValue> wrapped, Collection<Object> unwrapped) {
        for (SimpleXmlWrapperValue wrappedValue : wrapped) {
            unwrapped.add(SimpleXmlWrappers.unwrap(wrappedValue));
        }
        return unwrapped;
    }

    public static SimpleXmlWrapperValue wrap(Object value) {
        return SimpleXmlWrapperValue.wrap(value);
    }

    public static <T> T unwrap(SimpleXmlWrapperValue value) {
        if (value != null) {
            return (T)value.unwrap();
        }
        return null;
    }

    static synchronized <T> Class<? extends ISimpleXmlWrapper<?>> getWrapper(T value) {
        Class<?> valueClass = value.getClass();
        Class<? extends ISimpleXmlWrapper<?>> clazz = wrappers.get(valueClass);
        if (clazz == null) {
            for (Map.Entry<Class<?>, Class<ISimpleXmlWrapper<?>>> entry : wrappers.entrySet()) {
                if (strict.get(entry.getKey()).booleanValue() || !entry.getKey().isAssignableFrom(valueClass)) continue;
                return entry.getValue();
            }
            if (List.class.isInstance(value)) {
                return ListSimpleXmlWrapper.class;
            }
            if (Map.class.isInstance(value)) {
                return MapSimpleXmlWrapper.class;
            }
            try {
                value.getClass().getConstructor(new Class[0]);
                return DefaultConstructorSimpleXmlWrapper.class;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return clazz;
    }
}

