/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.value.constant;

import java.util.function.Consumer;
import org.apache.solr.analytics.facet.compare.ConstantComparator;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.constant.ConstantValue;

public class ConstantStringValue
extends ConstantValue
implements StringValue.CastingStringValue {
    String value;
    public static final String name = "const_str";
    private final String exprStr;

    public ConstantStringValue(String value) {
        this.value = value;
        this.exprStr = ConstantValue.createExpressionString(this, value);
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        cons.accept(this.value);
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        cons.accept(this.value);
    }

    @Override
    public ConstantComparator getObjectComparator(String expression) {
        return new ConstantComparator();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return AnalyticsValueStream.ExpressionType.CONST;
    }
}

