/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ClassUtils;
import org.apache.velocity.util.ExtProperties;

public class ClasspathResourceLoader
extends ResourceLoader {
    @Override
    public void init(ExtProperties extProperties) {
        this.log.trace("ClasspathResourceLoader: initialization complete.");
    }

    @Override
    public Reader getResourceReader(String string, String string2) throws ResourceNotFoundException {
        Reader reader = null;
        if (StringUtils.isEmpty((CharSequence)string)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        InputStream inputStream = null;
        try {
            inputStream = ClassUtils.getResourceAsStream(this.getClass(), string);
            if (inputStream != null) {
                reader = this.buildReader(inputStream, string2);
            }
        }
        catch (Exception exception) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ResourceNotFoundException("ClasspathResourceLoader problem with template: " + string, exception);
        }
        if (reader == null) {
            String string3 = "ClasspathResourceLoader Error: cannot find resource " + string;
            throw new ResourceNotFoundException(string3);
        }
        return reader;
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        return false;
    }

    @Override
    public long getLastModified(Resource resource) {
        return 0L;
    }
}

