/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.solr.common.util.Cache;
import org.apache.solr.common.util.TimeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentLFUCache<K, V>
implements Cache<K, V>,
Accountable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConcurrentLFUCache.class) + new Stats().ramBytesUsed() + RamUsageEstimator.shallowSizeOfInstance(ConcurrentHashMap.class);
    private final ConcurrentHashMap<Object, CacheEntry<K, V>> map;
    private int upperWaterMark;
    private int lowerWaterMark;
    private final ReentrantLock markAndSweepLock = new ReentrantLock(true);
    private boolean isCleaning = false;
    private boolean newThreadForCleanup;
    private boolean runCleanupThread;
    private volatile boolean islive = true;
    private final Stats stats = new Stats();
    private int acceptableWaterMark;
    private long lowHitCount = 0L;
    private final EvictionListener<K, V> evictionListener;
    private CleanupThread cleanupThread;
    private boolean timeDecay;
    private long maxIdleTimeNs;
    private final TimeSource timeSource = TimeSource.NANO_TIME;
    private final AtomicLong oldestEntry = new AtomicLong(0L);
    private final LongAdder ramBytes = new LongAdder();
    private boolean isDestroyed = false;

    public ConcurrentLFUCache(int upperWaterMark, int lowerWaterMark, int acceptableSize, int initialSize, boolean runCleanupThread, boolean runNewThreadForCleanup, EvictionListener<K, V> evictionListener, boolean timeDecay) {
        this(upperWaterMark, lowerWaterMark, acceptableSize, initialSize, runCleanupThread, runNewThreadForCleanup, evictionListener, timeDecay, -1);
    }

    public ConcurrentLFUCache(int upperWaterMark, int lowerWaterMark, int acceptableSize, int initialSize, boolean runCleanupThread, boolean runNewThreadForCleanup, EvictionListener<K, V> evictionListener, boolean timeDecay, int maxIdleTimeSec) {
        this.setUpperWaterMark(upperWaterMark);
        this.setLowerWaterMark(lowerWaterMark);
        this.setAcceptableWaterMark(acceptableSize);
        this.map = new ConcurrentHashMap(initialSize);
        this.evictionListener = evictionListener;
        this.setNewThreadForCleanup(runNewThreadForCleanup);
        this.setTimeDecay(timeDecay);
        this.setMaxIdleTime(maxIdleTimeSec);
        this.setRunCleanupThread(runCleanupThread);
    }

    public ConcurrentLFUCache(int size, int lowerWatermark) {
        this(size, lowerWatermark, (int)Math.floor((lowerWatermark + size) / 2), (int)Math.ceil(0.75 * (double)size), false, false, null, true, -1);
    }

    public void setAlive(boolean live) {
        this.islive = live;
    }

    public void setUpperWaterMark(int upperWaterMark) {
        if (upperWaterMark < 1) {
            throw new IllegalArgumentException("upperWaterMark must be > 0");
        }
        this.upperWaterMark = upperWaterMark;
    }

    public void setLowerWaterMark(int lowerWaterMark) {
        if (lowerWaterMark >= this.upperWaterMark) {
            throw new IllegalArgumentException("lowerWaterMark must be  < upperWaterMark");
        }
        this.lowerWaterMark = lowerWaterMark;
    }

    public void setAcceptableWaterMark(int acceptableWaterMark) {
        this.acceptableWaterMark = acceptableWaterMark;
    }

    public void setTimeDecay(boolean timeDecay) {
        this.timeDecay = timeDecay;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        long oldMaxIdleTimeNs = this.maxIdleTimeNs;
        long l = this.maxIdleTimeNs = maxIdleTime > 0 ? TimeUnit.NANOSECONDS.convert(maxIdleTime, TimeUnit.SECONDS) : Long.MAX_VALUE;
        if (this.cleanupThread != null && this.maxIdleTimeNs < oldMaxIdleTimeNs) {
            this.cleanupThread.wakeThread();
        }
    }

    public synchronized void setNewThreadForCleanup(boolean newThreadForCleanup) {
        this.newThreadForCleanup = newThreadForCleanup;
        if (newThreadForCleanup) {
            this.setRunCleanupThread(false);
        }
    }

    public synchronized void setRunCleanupThread(boolean runCleanupThread) {
        this.runCleanupThread = runCleanupThread;
        if (this.runCleanupThread) {
            this.newThreadForCleanup = false;
            if (this.cleanupThread == null) {
                this.cleanupThread = new CleanupThread(this);
                this.cleanupThread.start();
            }
        } else if (this.cleanupThread != null) {
            this.cleanupThread.stopThread();
            this.cleanupThread = null;
        }
    }

    public V get(K key) {
        CacheEntry<K, V> e = this.map.get(key);
        if (e == null) {
            if (this.islive) {
                this.stats.missCounter.increment();
            }
        } else if (this.islive) {
            e.lastAccessed = this.timeSource.getEpochTimeNs();
            this.stats.accessCounter.increment();
            e.hits.increment();
        }
        return e != null ? (V)e.value : null;
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V val = this.get(key);
        if (val != null) {
            return val;
        }
        AtomicBoolean newValue = new AtomicBoolean();
        if (this.islive) {
            this.stats.accessCounter.increment();
        }
        CacheEntry entry = this.map.computeIfAbsent(key, k -> {
            Object value = mappingFunction.apply((K)key);
            if (value == null) {
                return null;
            }
            CacheEntry e = new CacheEntry(key, value, this.timeSource.getEpochTimeNs());
            newValue.set(true);
            this.oldestEntry.updateAndGet(x -> x > e.lastAccessed || x == 0L ? e.lastAccessed : x);
            this.stats.size.increment();
            this.ramBytes.add(e.ramBytesUsed() + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
            if (this.islive) {
                this.stats.putCounter.increment();
            } else {
                this.stats.nonLivePutCounter.increment();
            }
            return e;
        });
        if (newValue.get()) {
            this.maybeMarkAndSweep();
        } else if (this.islive && entry != null) {
            entry.lastAccessed = this.timeSource.getEpochTimeNs();
            entry.hits.increment();
        }
        return entry != null ? (V)entry.value : null;
    }

    public V remove(K key) {
        CacheEntry<K, V> cacheEntry = this.map.remove(key);
        if (cacheEntry != null) {
            this.stats.size.decrement();
            this.ramBytes.add(-cacheEntry.ramBytesUsed() - RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
            return cacheEntry.value;
        }
        return null;
    }

    public V put(K key, V val) {
        if (val == null) {
            return null;
        }
        CacheEntry<K, V> e = new CacheEntry<K, V>(key, val, this.timeSource.getEpochTimeNs());
        return this.putCacheEntry(e);
    }

    public V putCacheEntry(CacheEntry<K, V> e) {
        this.stats.accessCounter.increment();
        this.oldestEntry.updateAndGet(x -> x > e.lastAccessed || x == 0L ? e.lastAccessed : x);
        CacheEntry<K, V> oldCacheEntry = this.map.put(e.key, e);
        if (oldCacheEntry == null) {
            this.stats.size.increment();
            this.ramBytes.add(e.ramBytesUsed() + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY);
        } else {
            this.ramBytes.add(-oldCacheEntry.ramBytesUsed());
            this.ramBytes.add(e.ramBytesUsed());
        }
        if (this.islive) {
            this.stats.putCounter.increment();
        } else {
            this.stats.nonLivePutCounter.increment();
        }
        this.maybeMarkAndSweep();
        return oldCacheEntry == null ? null : (V)oldCacheEntry.value;
    }

    private void maybeMarkAndSweep() {
        long idleCutoff;
        boolean evictByIdleTime = this.maxIdleTimeNs != Long.MAX_VALUE;
        int currentSize = this.stats.size.intValue();
        long l = idleCutoff = evictByIdleTime ? this.timeSource.getEpochTimeNs() - this.maxIdleTimeNs : -1L;
        if ((currentSize > this.upperWaterMark || evictByIdleTime && this.oldestEntry.get() < idleCutoff) && !this.isCleaning) {
            if (this.newThreadForCleanup) {
                new Thread(this::markAndSweep).start();
            } else if (this.cleanupThread != null) {
                this.cleanupThread.wakeThread();
            } else {
                this.markAndSweep();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAndSweep() {
        if (!this.markAndSweepLock.tryLock()) {
            return;
        }
        try {
            long idleCutoff;
            long lowHitCount = this.lowHitCount;
            this.isCleaning = true;
            this.lowHitCount = lowHitCount;
            int sz = this.stats.size.intValue();
            boolean evictByIdleTime = this.maxIdleTimeNs != Long.MAX_VALUE;
            long l = idleCutoff = evictByIdleTime ? this.timeSource.getEpochTimeNs() - this.maxIdleTimeNs : -1L;
            if (sz <= this.upperWaterMark && evictByIdleTime && this.oldestEntry.get() > idleCutoff) {
                return;
            }
            if (evictByIdleTime) {
                long currentOldestEntry = Long.MAX_VALUE;
                Iterator<Object> iterator = this.map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, CacheEntry<K, V>> entry = iterator.next();
                    entry.getValue().lastAccessedCopy = entry.getValue().lastAccessed;
                    if (entry.getValue().lastAccessedCopy < idleCutoff) {
                        iterator.remove();
                        this.postRemoveEntry(entry.getValue());
                        this.stats.evictionIdleCounter.increment();
                        continue;
                    }
                    if (entry.getValue().lastAccessedCopy >= currentOldestEntry) continue;
                    currentOldestEntry = entry.getValue().lastAccessedCopy;
                }
                if (currentOldestEntry != Long.MAX_VALUE) {
                    this.oldestEntry.set(currentOldestEntry);
                }
                if ((sz = this.stats.size.intValue()) <= this.upperWaterMark) {
                    return;
                }
            }
            int wantToRemove = sz - this.lowerWaterMark;
            TreeSet<CacheEntry> tree = new TreeSet<CacheEntry>();
            for (CacheEntry cacheEntry : this.map.values()) {
                cacheEntry.hitsCopy = cacheEntry.hits.longValue();
                cacheEntry.lastAccessedCopy = cacheEntry.lastAccessed;
                if (this.timeDecay) {
                    cacheEntry.hits.reset();
                    cacheEntry.hits.add(cacheEntry.hitsCopy >>> 1);
                }
                if (tree.size() < wantToRemove) {
                    tree.add(cacheEntry);
                    continue;
                }
                if (tree.size() <= 0) continue;
                if (cacheEntry.hitsCopy < ((CacheEntry)tree.first()).hitsCopy) {
                    tree.remove(tree.first());
                    tree.add(cacheEntry);
                    continue;
                }
                if (cacheEntry.hitsCopy != ((CacheEntry)tree.first()).hitsCopy) continue;
                tree.add(cacheEntry);
                tree.remove(tree.first());
            }
            for (CacheEntry cacheEntry : tree) {
                this.evictEntry(cacheEntry.key);
            }
            if (evictByIdleTime) {
                long currentOldestEntry = Long.MAX_VALUE;
                for (CacheEntry<K, V> e : this.map.values()) {
                    if (e.lastAccessedCopy >= currentOldestEntry) continue;
                    currentOldestEntry = e.lastAccessedCopy;
                }
                if (currentOldestEntry != Long.MAX_VALUE) {
                    this.oldestEntry.set(currentOldestEntry);
                }
            }
        }
        finally {
            this.isCleaning = false;
            this.markAndSweepLock.unlock();
        }
    }

    private void evictEntry(K key) {
        CacheEntry<K, V> o = this.map.remove(key);
        this.postRemoveEntry(o);
    }

    private void postRemoveEntry(CacheEntry<K, V> o) {
        if (o == null) {
            return;
        }
        this.ramBytes.add(-(o.ramBytesUsed() + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY));
        this.stats.size.decrement();
        this.stats.evictionCounter.increment();
        if (this.evictionListener != null) {
            this.evictionListener.evictedEntry(o.key, o.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getLeastUsedItems(int n) {
        LinkedHashMap result = new LinkedHashMap();
        if (n <= 0) {
            return result;
        }
        TreeSet<CacheEntry<K, V>> tree = new TreeSet<CacheEntry<K, V>>();
        this.markAndSweepLock.lock();
        try {
            for (Map.Entry<Object, CacheEntry<K, V>> entry : this.map.entrySet()) {
                CacheEntry<K, V> ce = entry.getValue();
                ce.hitsCopy = ce.hits.longValue();
                ce.lastAccessedCopy = ce.lastAccessed;
                if (tree.size() < n) {
                    tree.add(ce);
                    continue;
                }
                if (ce.hitsCopy < ((CacheEntry)tree.first()).hitsCopy) {
                    tree.remove(tree.first());
                    tree.add(ce);
                    continue;
                }
                if (ce.hitsCopy != ((CacheEntry)tree.first()).hitsCopy) continue;
                tree.add(ce);
                tree.remove(tree.first());
            }
        }
        finally {
            this.markAndSweepLock.unlock();
        }
        for (CacheEntry cacheEntry : tree) {
            result.put(cacheEntry.key, cacheEntry.value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> getMostUsedItems(int n) {
        LinkedHashMap result = new LinkedHashMap();
        if (n <= 0) {
            return result;
        }
        TreeSet<CacheEntry<K, V>> tree = new TreeSet<CacheEntry<K, V>>();
        this.markAndSweepLock.lock();
        try {
            for (Map.Entry<Object, CacheEntry<K, V>> entry : this.map.entrySet()) {
                CacheEntry<K, V> ce = entry.getValue();
                ce.hitsCopy = ce.hits.longValue();
                ce.lastAccessedCopy = ce.lastAccessed;
                if (tree.size() < n) {
                    tree.add(ce);
                    continue;
                }
                if (ce.hitsCopy > ((CacheEntry)tree.last()).hitsCopy) {
                    tree.remove(tree.last());
                    tree.add(ce);
                    continue;
                }
                if (ce.hitsCopy != ((CacheEntry)tree.last()).hitsCopy) continue;
                tree.add(ce);
                tree.remove(tree.last());
            }
        }
        finally {
            this.markAndSweepLock.unlock();
        }
        for (CacheEntry cacheEntry : tree) {
            result.put(cacheEntry.key, cacheEntry.value);
        }
        return result;
    }

    public int size() {
        return this.stats.size.intValue();
    }

    public void clear() {
        this.map.clear();
        this.ramBytes.reset();
    }

    public Map<Object, CacheEntry<K, V>> getMap() {
        return this.map;
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.ramBytes.sum();
    }

    public void destroy() {
        try {
            if (this.cleanupThread != null) {
                this.cleanupThread.stopThread();
            }
        }
        finally {
            this.isDestroyed = true;
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.isDestroyed) {
                log.error("ConcurrentLFUCache was not destroyed prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!");
                this.destroy();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static interface EvictionListener<K, V> {
        public void evictedEntry(K var1, V var2);
    }

    public static class Stats
    implements Accountable {
        private static final long RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Stats.class) + (long)(7 * (RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (Integer)RamUsageEstimator.primitiveSizes.get(Long.TYPE) + 2 * (RamUsageEstimator.NUM_BYTES_OBJECT_REF + (Integer)RamUsageEstimator.primitiveSizes.get(Long.TYPE))));
        private final LongAdder accessCounter = new LongAdder();
        private final LongAdder putCounter = new LongAdder();
        private final LongAdder nonLivePutCounter = new LongAdder();
        private final LongAdder missCounter = new LongAdder();
        private final LongAdder size = new LongAdder();
        private LongAdder evictionCounter = new LongAdder();
        private LongAdder evictionIdleCounter = new LongAdder();

        public long getCumulativeLookups() {
            return this.accessCounter.longValue() - this.putCounter.longValue() - this.nonLivePutCounter.longValue() + this.missCounter.longValue();
        }

        public long getCumulativeHits() {
            return this.accessCounter.longValue() - this.putCounter.longValue() - this.nonLivePutCounter.longValue();
        }

        public long getCumulativePuts() {
            return this.putCounter.longValue();
        }

        public long getCumulativeEvictions() {
            return this.evictionCounter.longValue();
        }

        public long getCumulativeIdleEvictions() {
            return this.evictionIdleCounter.longValue();
        }

        public int getCurrentSize() {
            return this.size.intValue();
        }

        public long getCumulativeNonLivePuts() {
            return this.nonLivePutCounter.longValue();
        }

        public long getCumulativeMisses() {
            return this.missCounter.longValue();
        }

        public void add(Stats other) {
            this.accessCounter.add(other.accessCounter.longValue());
            this.putCounter.add(other.putCounter.longValue());
            this.nonLivePutCounter.add(other.nonLivePutCounter.longValue());
            this.missCounter.add(other.missCounter.longValue());
            this.evictionCounter.add(other.evictionCounter.longValue());
            this.evictionIdleCounter.add(other.evictionIdleCounter.longValue());
            long maxSize = Math.max(this.size.longValue(), other.size.longValue());
            this.size.reset();
            this.size.add(maxSize);
        }

        public long ramBytesUsed() {
            return RAM_BYTES_USED;
        }
    }

    private static class CleanupThread
    extends Thread {
        private WeakReference<ConcurrentLFUCache> cache;
        private boolean stop = false;

        public CleanupThread(ConcurrentLFUCache c) {
            this.cache = new WeakReference<ConcurrentLFUCache>(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConcurrentLFUCache c;
            while ((c = (ConcurrentLFUCache)this.cache.get()) != null) {
                CleanupThread cleanupThread = this;
                synchronized (cleanupThread) {
                    if (this.stop) {
                        break;
                    }
                    long waitTimeMs = c.maxIdleTimeNs != Long.MAX_VALUE ? TimeUnit.MILLISECONDS.convert(c.maxIdleTimeNs, TimeUnit.NANOSECONDS) : 0L;
                    try {
                        this.wait(waitTimeMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.stop || (c = (ConcurrentLFUCache)this.cache.get()) == null) break;
                c.markAndSweep();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeThread() {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopThread() {
            CleanupThread cleanupThread = this;
            synchronized (cleanupThread) {
                this.stop = true;
                this.notify();
            }
        }
    }

    public static class CacheEntry<K, V>
    implements Comparable<CacheEntry<K, V>>,
    Accountable {
        public static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CacheEntry.class) + (long)((Integer)RamUsageEstimator.primitiveSizes.get(Long.TYPE)).intValue();
        final K key;
        final V value;
        final long ramBytesUsed;
        final LongAdder hits = new LongAdder();
        long hitsCopy = 0L;
        volatile long lastAccessed = 0L;
        long lastAccessedCopy = 0L;

        public CacheEntry(K key, V value, long lastAccessed) {
            this.key = key;
            this.value = value;
            this.lastAccessed = lastAccessed;
            this.ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOfObject(key, (long)1024L) + RamUsageEstimator.sizeOfObject(value, (long)1024L);
        }

        @Override
        public int compareTo(CacheEntry<K, V> that) {
            if (this.hitsCopy == that.hitsCopy) {
                if (this.lastAccessedCopy == that.lastAccessedCopy) {
                    return 0;
                }
                return this.lastAccessedCopy < that.lastAccessedCopy ? 1 : -1;
            }
            return this.hitsCopy < that.hitsCopy ? 1 : -1;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object obj) {
            return this.value.equals(obj);
        }

        public String toString() {
            return "key: " + this.key + " value: " + this.value + " hits:" + this.hits.longValue();
        }

        public long ramBytesUsed() {
            return this.ramBytesUsed;
        }
    }
}

