/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.FacetStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;

public class ScoreNodesStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    protected String zkHost;
    private TupleStream stream;
    private transient SolrClientCache clientCache;
    private Map<String, Tuple> nodes = new HashMap<String, Tuple>();
    private Iterator<Tuple> tuples;
    private String termFreq;
    private boolean facet;
    private String bucket;
    private String facetCollection;

    public ScoreNodesStream(TupleStream tupleStream, String nodeFreqField) throws IOException {
        this.init(tupleStream, nodeFreqField);
    }

    public ScoreNodesStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter nodeFreqParam = factory.getNamedOperand(expression, "termFreq");
        String docFreqField = "count(*)";
        if (nodeFreqParam != null) {
            docFreqField = nodeFreqParam.getParameter().toString();
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        this.zkHost = factory.getDefaultZkHost();
        if (null == this.zkHost) {
            throw new IOException("zkHost not found");
        }
        TupleStream stream = factory.constructStream(streamExpressions.get(0));
        this.init(stream, docFreqField);
    }

    private void init(TupleStream tupleStream, String termFreq) throws IOException {
        this.stream = tupleStream;
        this.termFreq = termFreq;
        if (this.stream instanceof FacetStream) {
            FacetStream facetStream = (FacetStream)this.stream;
            if (facetStream.getBuckets().length != 1) {
                throw new IOException("scoreNodes operates over a single bucket. Num buckets:" + facetStream.getBuckets().length);
            }
            this.bucket = facetStream.getBuckets()[0].toString();
            this.facetCollection = facetStream.getCollection();
            this.facet = true;
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(new StreamExpressionNamedParameter("termFreq", this.termFreq));
        if (includeStreams) {
            if (!(this.stream instanceof Expressible)) throw new IOException("This ScoreNodesStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
            return expression;
        } else {
            expression.addParameter("<stream>");
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.clientCache = context.getSolrClientCache();
        this.stream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.stream.open();
        Tuple node = null;
        StringBuilder builder = new StringBuilder();
        String field = null;
        String collection = null;
        while (true) {
            String nodeId;
            node = this.stream.read();
            if (node.EOF) break;
            if (this.facet) {
                nodeId = node.getString(this.bucket);
                node.put("node", nodeId);
                node.remove(this.bucket);
                node.put("collection", this.facetCollection);
                node.put("field", this.bucket);
            }
            if (!node.getFields().containsKey("node")) {
                throw new IOException("node field not present in the Tuple");
            }
            nodeId = node.getString("node");
            this.nodes.put(nodeId, node);
            if (builder.length() > 0) {
                builder.append(",");
                field = node.getString("field");
                collection = node.getString("collection");
            }
            builder.append(nodeId);
        }
        CloudSolrClient client = this.clientCache.getCloudSolrClient(this.zkHost);
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("qt", "/terms");
        params.add("terms", "true");
        params.add("terms.fl", field);
        params.add("terms.stats", "true");
        params.add("terms.list", builder.toString());
        params.add("terms.limit", Integer.toString(this.nodes.size()));
        params.add("distrib", "true");
        QueryRequest request = new QueryRequest(params);
        try {
            NamedList<Object> response = client.request(request, collection);
            NamedList stats = (NamedList)response.get("indexstats");
            long numDocs = ((Number)stats.get("numDocs")).longValue();
            NamedList fields = (NamedList)response.get("terms");
            int size = fields.size();
            for (int i = 0; i < size; ++i) {
                String fieldName = fields.getName(i);
                NamedList terms = (NamedList)fields.get(fieldName);
                int tsize = terms.size();
                for (int t = 0; t < tsize; ++t) {
                    String term = terms.getName(t);
                    Number docFreq = (Number)terms.get(term);
                    Tuple tuple = this.nodes.get(term);
                    if (!tuple.getFields().containsKey(this.termFreq)) {
                        throw new Exception("termFreq field not present in the Tuple");
                    }
                    Number termFreqValue = (Number)tuple.get(this.termFreq);
                    float score = (float)(Math.log(termFreqValue.floatValue()) + 1.0) * (float)(Math.log((double)(numDocs + 1L) / (docFreq.doubleValue() + 1.0)) + 1.0);
                    tuple.put("nodeScore", Float.valueOf(score));
                    tuple.put("docFreq", docFreq);
                    tuple.put("numDocs", numDocs);
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.tuples = this.nodes.values().iterator();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public StreamComparator getComparator() {
        return null;
    }

    @Override
    public Tuple read() throws IOException {
        if (this.tuples.hasNext()) {
            return this.tuples.next();
        }
        return Tuple.EOF();
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

