/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class GetCacheEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public GetCacheEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 3 values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        ConcurrentMap objectCache = this.streamContext.getObjectCache();
        if (values.length == 2) {
            String space = (String)values[0];
            String key = (String)values[1];
            space = space.replace("\"", "");
            key = key.replace("\"", "");
            ConcurrentMap spaceCache = (ConcurrentMap)objectCache.get(space);
            if (spaceCache != null) {
                return spaceCache.get(key);
            }
            return null;
        }
        throw new IOException("The getCache function requires two parameters: workspace and key");
    }
}

