/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class XAttrHelper {
    public static XAttr buildXAttr(String name) {
        return XAttrHelper.buildXAttr(name, null);
    }

    public static XAttr buildXAttr(String name, byte[] value) {
        XAttr.NameSpace ns;
        Preconditions.checkNotNull((Object)name, (Object)"XAttr name cannot be null.");
        int prefixIndex = name.indexOf(".");
        if (prefixIndex < 3) {
            throw new HadoopIllegalArgumentException("An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'");
        }
        if (prefixIndex == name.length() - 1) {
            throw new HadoopIllegalArgumentException("XAttr name cannot be empty.");
        }
        String prefix = name.substring(0, prefixIndex);
        if (StringUtils.equalsIgnoreCase((String)prefix, (String)XAttr.NameSpace.USER.toString())) {
            ns = XAttr.NameSpace.USER;
        } else if (StringUtils.equalsIgnoreCase((String)prefix, (String)XAttr.NameSpace.TRUSTED.toString())) {
            ns = XAttr.NameSpace.TRUSTED;
        } else if (StringUtils.equalsIgnoreCase((String)prefix, (String)XAttr.NameSpace.SYSTEM.toString())) {
            ns = XAttr.NameSpace.SYSTEM;
        } else if (StringUtils.equalsIgnoreCase((String)prefix, (String)XAttr.NameSpace.SECURITY.toString())) {
            ns = XAttr.NameSpace.SECURITY;
        } else if (StringUtils.equalsIgnoreCase((String)prefix, (String)XAttr.NameSpace.RAW.toString())) {
            ns = XAttr.NameSpace.RAW;
        } else {
            throw new HadoopIllegalArgumentException("An XAttr name must be prefixed with user/trusted/security/system/raw, followed by a '.'");
        }
        return new XAttr.Builder().setNameSpace(ns).setName(name.substring(prefixIndex + 1)).setValue(value).build();
    }

    public static List<XAttr> buildXAttrAsList(String name) {
        XAttr xAttr = XAttrHelper.buildXAttr(name);
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)1);
        xAttrs.add(xAttr);
        return xAttrs;
    }

    public static byte[] getFirstXAttrValue(List<XAttr> xAttrs) {
        byte[] value = null;
        XAttr xAttr = XAttrHelper.getFirstXAttr(xAttrs);
        if (xAttr != null && (value = xAttr.getValue()) == null) {
            value = new byte[]{};
        }
        return value;
    }

    public static XAttr getFirstXAttr(List<XAttr> xAttrs) {
        if (xAttrs != null && !xAttrs.isEmpty()) {
            return xAttrs.get(0);
        }
        return null;
    }

    public static Map<String, byte[]> buildXAttrMap(List<XAttr> xAttrs) {
        if (xAttrs == null) {
            return null;
        }
        HashMap xAttrMap = Maps.newHashMap();
        for (XAttr xAttr : xAttrs) {
            String name = XAttrHelper.getPrefixedName(xAttr);
            byte[] value = xAttr.getValue();
            if (value == null) {
                value = new byte[]{};
            }
            xAttrMap.put(name, value);
        }
        return xAttrMap;
    }

    public static String getPrefixedName(XAttr xAttr) {
        if (xAttr == null) {
            return null;
        }
        return XAttrHelper.getPrefixedName(xAttr.getNameSpace(), xAttr.getName());
    }

    public static String getPrefixedName(XAttr.NameSpace ns, String name) {
        return StringUtils.toLowerCase((String)ns.toString()) + "." + name;
    }

    public static List<XAttr> buildXAttrs(List<String> names) {
        if (names == null || names.isEmpty()) {
            throw new HadoopIllegalArgumentException("XAttr names can not be null or empty.");
        }
        ArrayList xAttrs = Lists.newArrayListWithCapacity((int)names.size());
        for (String name : names) {
            xAttrs.add(XAttrHelper.buildXAttr(name, null));
        }
        return xAttrs;
    }
}

