/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

public class SortedSetSelector {
    public static SortedDocValues wrap(SortedSetDocValues sortedSet, Type selector) {
        if (sortedSet.getValueCount() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("fields containing more than 2147483646 unique terms are unsupported");
        }
        SortedDocValues singleton = DocValues.unwrapSingleton(sortedSet);
        if (singleton != null) {
            return singleton;
        }
        switch (selector) {
            case MIN: {
                return new MinValue(sortedSet);
            }
            case MAX: {
                return new MaxValue(sortedSet);
            }
            case MIDDLE_MIN: {
                return new MiddleMinValue(sortedSet);
            }
            case MIDDLE_MAX: {
                return new MiddleMaxValue(sortedSet);
            }
        }
        throw new AssertionError();
    }

    public static enum Type {
        MIN,
        MAX,
        MIDDLE_MIN,
        MIDDLE_MAX;

    }

    static class MinValue
    extends SortedDocValues {
        final SortedSetDocValues in;
        private int ord;

        MinValue(SortedSetDocValues in) {
            this.in = in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            return (int)this.in.lookupTerm(key);
        }

        private void setOrd() throws IOException {
            this.ord = this.docID() != Integer.MAX_VALUE ? (int)this.in.nextOrd() : -1;
        }
    }

    static class MaxValue
    extends SortedDocValues {
        final SortedSetDocValues in;
        private int ord;

        MaxValue(SortedSetDocValues in) {
            this.in = in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            return (int)this.in.lookupTerm(key);
        }

        private void setOrd() throws IOException {
            if (this.docID() != Integer.MAX_VALUE) {
                long nextOrd;
                while ((nextOrd = this.in.nextOrd()) != -1L) {
                    this.ord = (int)nextOrd;
                }
            } else {
                this.ord = -1;
            }
        }
    }

    static class MiddleMinValue
    extends SortedDocValues {
        final SortedSetDocValues in;
        private int ord;
        private int[] ords = new int[8];

        MiddleMinValue(SortedSetDocValues in) {
            this.in = in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            return (int)this.in.lookupTerm(key);
        }

        private void setOrd() throws IOException {
            if (this.docID() != Integer.MAX_VALUE) {
                long nextOrd;
                int upto = 0;
                while ((nextOrd = this.in.nextOrd()) != -1L) {
                    if (upto == this.ords.length) {
                        this.ords = ArrayUtil.grow(this.ords);
                    }
                    this.ords[upto++] = (int)nextOrd;
                }
                if (upto == 0) {
                    assert (false);
                    this.ord = -1;
                } else {
                    this.ord = this.ords[upto - 1 >>> 1];
                }
            } else {
                this.ord = -1;
            }
        }
    }

    static class MiddleMaxValue
    extends SortedDocValues {
        final SortedSetDocValues in;
        private int ord;
        private int[] ords = new int[8];

        MiddleMaxValue(SortedSetDocValues in) {
            this.in = in;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            this.in.nextDoc();
            this.setOrd();
            return this.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            this.in.advance(target);
            this.setOrd();
            return this.docID();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            if (this.in.advanceExact(target)) {
                this.setOrd();
                return true;
            }
            return false;
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) throws IOException {
            return (int)this.in.lookupTerm(key);
        }

        private void setOrd() throws IOException {
            if (this.docID() != Integer.MAX_VALUE) {
                long nextOrd;
                int upto = 0;
                while ((nextOrd = this.in.nextOrd()) != -1L) {
                    if (upto == this.ords.length) {
                        this.ords = ArrayUtil.grow(this.ords);
                    }
                    this.ords[upto++] = (int)nextOrd;
                }
                if (upto == 0) {
                    assert (false);
                    this.ord = -1;
                } else {
                    this.ord = this.ords[upto >>> 1];
                }
            } else {
                this.ord = -1;
            }
        }
    }
}

