/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Stopwatch;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.CacheLoader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$LoadingValueReference$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.LocalCache$ValueReference;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.cache.ReferenceEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.Futures;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ListenableFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.MoreExecutors;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.SettableFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.Uninterruptibles;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

class LocalCache$LoadingValueReference
implements LocalCache$ValueReference {
    volatile LocalCache$ValueReference oldValue;
    final SettableFuture futureValue = SettableFuture.create();
    final Stopwatch stopwatch = Stopwatch.createUnstarted();

    public LocalCache$LoadingValueReference() {
        this(null);
    }

    public LocalCache$LoadingValueReference(LocalCache$ValueReference localCache$ValueReference) {
        this.oldValue = localCache$ValueReference == null ? LocalCache.unset() : localCache$ValueReference;
    }

    @Override
    public boolean isLoading() {
        return true;
    }

    @Override
    public boolean isActive() {
        return this.oldValue.isActive();
    }

    @Override
    public int getWeight() {
        return this.oldValue.getWeight();
    }

    public boolean set(@NullableDecl Object object) {
        return this.futureValue.set(object);
    }

    public boolean setException(Throwable throwable) {
        return this.futureValue.setException(throwable);
    }

    private ListenableFuture fullyFailedFuture(Throwable throwable) {
        return Futures.immediateFailedFuture(throwable);
    }

    @Override
    public void notifyNewValue(@NullableDecl Object object) {
        if (object != null) {
            this.set(object);
        } else {
            this.oldValue = LocalCache.unset();
        }
    }

    public ListenableFuture loadFuture(Object object, CacheLoader cacheLoader) {
        try {
            this.stopwatch.start();
            Object object2 = this.oldValue.get();
            if (object2 == null) {
                Object object3 = cacheLoader.load(object);
                return this.set(object3) ? this.futureValue : Futures.immediateFuture(object3);
            }
            ListenableFuture listenableFuture = cacheLoader.reload(object, object2);
            if (listenableFuture == null) {
                return Futures.immediateFuture(null);
            }
            return Futures.transform(listenableFuture, new LocalCache$LoadingValueReference$1(this), MoreExecutors.directExecutor());
        }
        catch (Throwable throwable) {
            ListenableFuture listenableFuture;
            ListenableFuture listenableFuture2 = listenableFuture = this.setException(throwable) ? this.futureValue : this.fullyFailedFuture(throwable);
            if (throwable instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return listenableFuture;
        }
    }

    public Object compute(Object object, BiFunction biFunction) {
        Object object2;
        this.stopwatch.start();
        try {
            object2 = this.oldValue.waitForValue();
        }
        catch (ExecutionException executionException) {
            object2 = null;
        }
        Object r = biFunction.apply(object, object2);
        this.set(r);
        return r;
    }

    public long elapsedNanos() {
        return this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
    }

    @Override
    public Object waitForValue() {
        return Uninterruptibles.getUninterruptibly(this.futureValue);
    }

    @Override
    public Object get() {
        return this.oldValue.get();
    }

    public LocalCache$ValueReference getOldValue() {
        return this.oldValue;
    }

    @Override
    public ReferenceEntry getEntry() {
        return null;
    }

    @Override
    public LocalCache$ValueReference copyFor(ReferenceQueue referenceQueue, @NullableDecl Object object, ReferenceEntry referenceEntry) {
        return this;
    }
}

