/*
 Copyright Disney Enterprises, Inc.  All rights reserved.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License
 and the following modification to it: Section 6 Trademarks.
 deleted and replaced with:

 6. Trademarks. This License does not grant permission to use the
 trade names, trademarks, service marks, or product names of the
 Licensor and its affiliates, except as required for reproducing
 the content of the NOTICE file.

 You may obtain a copy of the License at
 http://www.apache.org/licenses/LICENSE-2.0
*/
#ifndef _NoiseTables_h_
#define _NoiseTables_h_

static const int p[514] = {
    37,  197, 187, 204, 20,  12,  242, 79,  52,  48,  160, 53,  142, 209, 166, 1,   198, 49,  233, 114, 230, 141, 155,
    198, 74,  135, 218, 123, 208, 166, 216, 182, 131, 149, 173, 42,  180, 12,  56,  159, 191, 85,  29,  134, 53,  239,
    182, 168, 139, 41,  223, 50,  24,  164, 17,  102, 121, 116, 148, 37,  105, 153, 102, 181, 255, 69,  77,  253, 59,
    20,  164, 218, 90,  113, 47,  5,   90,  36,  0,   180, 44,  114, 41,  140, 160, 34,  149, 77,  148, 100, 181, 22,
    113, 39,  22,  24,  247, 194, 43,  188, 227, 213, 29,  200, 72,  199, 8,   129, 32,  13,  130, 12,  218, 7,   246,
    176, 148, 252, 57,  30,  78,  178, 49,  87,  158, 182, 80,  68,  113, 4,   41,  216, 138, 1,   108, 49,  68,  75,
    242, 7,   219, 169, 90,  157, 198, 103, 214, 127, 202, 238, 148, 184, 101, 235, 87,  158, 127, 54,  20,  212, 56,
    85,  152, 176, 178, 220, 95,  103, 246, 137, 178, 203, 247, 71,  141, 10,  232, 23,  167, 135, 181, 129, 248, 144,
    202, 174, 247, 108, 183, 50,  162, 223, 52,  99,  102, 163, 187, 36,  195, 121, 79,  99,  182, 29,  199, 191, 109,
    5,   171, 132, 157, 192, 245, 71,  252, 74,  162, 181, 105, 251, 194, 2,   133, 53,  12,  135, 221, 203, 233, 229,
    255, 208, 191, 132, 73,  239, 40,  113, 59,  37,  36,  44,  158, 255, 232, 143, 148, 202, 143, 72,  188, 254, 253,
    70,  109, 222, 37,  197, 187, 204, 20,  12,  242, 79,  52,  48,  160, 53,  142, 209, 166, 1,   198, 49,  233, 114,
    230, 141, 155, 198, 74,  135, 218, 123, 208, 166, 216, 182, 131, 149, 173, 42,  180, 12,  56,  159, 191, 85,  29,
    134, 53,  239, 182, 168, 139, 41,  223, 50,  24,  164, 17,  102, 121, 116, 148, 37,  105, 153, 102, 181, 255, 69,
    77,  253, 59,  20,  164, 218, 90,  113, 47,  5,   90,  36,  0,   180, 44,  114, 41,  140, 160, 34,  149, 77,  148,
    100, 181, 22,  113, 39,  22,  24,  247, 194, 43,  188, 227, 213, 29,  200, 72,  199, 8,   129, 32,  13,  130, 12,
    218, 7,   246, 176, 148, 252, 57,  30,  78,  178, 49,  87,  158, 182, 80,  68,  113, 4,   41,  216, 138, 1,   108,
    49,  68,  75,  242, 7,   219, 169, 90,  157, 198, 103, 214, 127, 202, 238, 148, 184, 101, 235, 87,  158, 127, 54,
    20,  212, 56,  85,  152, 176, 178, 220, 95,  103, 246, 137, 178, 203, 247, 71,  141, 10,  232, 23,  167, 135, 181,
    129, 248, 144, 202, 174, 247, 108, 183, 50,  162, 223, 52,  99,  102, 163, 187, 36,  195, 121, 79,  99,  182, 29,
    199, 191, 109, 5,   171, 132, 157, 192, 245, 71,  252, 74,  162, 181, 105, 251, 194, 2,   133, 53,  12,  135, 221,
    203, 233, 229, 255, 208, 191, 132, 73,  239, 40,  113, 59,  37,  36,  44,  158, 255, 232, 143, 148, 202, 143, 72,
    188, 254, 253, 70,  109, 222, 37,  197};

template <int d>
struct NOISE_TABLES {};
template <>
struct NOISE_TABLES<1> {
    static double g[514][1];
};
template <>
struct NOISE_TABLES<2> {
    static double g[514][2];
};
template <>
struct NOISE_TABLES<3> {
    static double g[514][3];
};
template <>
struct NOISE_TABLES<4> {
    static double g[514][4];
};

double NOISE_TABLES<1>::g[514][1] = {{-0.090145990972},
                                     {0.411026453868},
                                     {-0.132971130209},
                                     {0.0658028292851},
                                     {-0.0881082376329},
                                     {0.86592480015},
                                     {-0.32929844812},
                                     {0.53603629749},
                                     {-0.643078474092},
                                     {-0.30599109277},
                                     {0.926631567402},
                                     {0.912201292233},
                                     {0.802304085975},
                                     {-0.67915638005},
                                     {-0.751813438823},
                                     {-0.208967638797},
                                     {0.132315414586},
                                     {0.682349428924},
                                     {-0.525549874155},
                                     {0.275599612628},
                                     {-0.74676958287},
                                     {0.937047988958},
                                     {0.43460815577},
                                     {0.0142260747245},
                                     {0.180749138277},
                                     {-0.313463441395},
                                     {-0.274002283835},
                                     {0.523003236382},
                                     {0.780913908778},
                                     {-0.494934167865},
                                     {0.818593572183},
                                     {0.533915816067},
                                     {-0.0130361482251},
                                     {-0.705622687068},
                                     {0.722682123285},
                                     {0.507754061746},
                                     {-0.757993627819},
                                     {0.190727068281},
                                     {-0.380282707147},
                                     {0.301661041443},
                                     {0.136426856476},
                                     {-0.974945445514},
                                     {-0.614343303113},
                                     {0.44021261626},
                                     {-0.22030993216},
                                     {-0.198781048086},
                                     {0.236968770351},
                                     {-0.0465780655332},
                                     {0.401668674428},
                                     {0.597507722287},
                                     {-0.905798733301},
                                     {-0.502411080041},
                                     {-0.72004154009},
                                     {-0.753980111307},
                                     {0.891663443047},
                                     {0.081057763492},
                                     {-0.312669535049},
                                     {-0.611594876551},
                                     {-0.497563251588},
                                     {-0.582638042743},
                                     {0.860701680181},
                                     {0.961532428698},
                                     {-0.479053663586},
                                     {-0.619041737502},
                                     {-0.218915686691},
                                     {-0.457452315145},
                                     {0.873417690785},
                                     {0.116833303787},
                                     {-0.980519135986},
                                     {-0.404040133296},
                                     {0.252722546802},
                                     {0.642103114503},
                                     {0.34763654904},
                                     {0.456416335261},
                                     {0.953028024491},
                                     {0.235275936909},
                                     {0.601498060731},
                                     {0.781827877417},
                                     {0.470419079269},
                                     {0.0146950691393},
                                     {-0.235694665784},
                                     {-0.574844704427},
                                     {0.684892633207},
                                     {-0.458411945802},
                                     {0.265911694559},
                                     {0.169202280876},
                                     {-0.777909790703},
                                     {0.726384224166},
                                     {-0.553828089727},
                                     {-0.0832123692333},
                                     {0.721487611045},
                                     {-0.906675489131},
                                     {-0.960026196153},
                                     {-0.78755654858},
                                     {0.250631178512},
                                     {0.13332056756},
                                     {-0.719064191516},
                                     {0.168404894273},
                                     {0.899696787568},
                                     {-0.241155077287},
                                     {-0.791726996813},
                                     {0.68490416293},
                                     {0.830729929906},
                                     {0.829245788371},
                                     {0.476796832217},
                                     {-0.30340629475},
                                     {-0.97160859071},
                                     {0.0960159613032},
                                     {0.261892913066},
                                     {-0.043841341881},
                                     {-0.592923976594},
                                     {0.806058029402},
                                     {0.176253456712},
                                     {0.0506651479611},
                                     {0.534088270467},
                                     {-0.920834855247},
                                     {-0.534653045788},
                                     {-0.978110639545},
                                     {0.759932895317},
                                     {-0.399887306932},
                                     {0.763288749264},
                                     {0.867870667884},
                                     {-0.823463631323},
                                     {0.532253707161},
                                     {0.870235490679},
                                     {-0.836201428062},
                                     {-0.592575962626},
                                     {0.333064244848},
                                     {0.513161315099},
                                     {0.817530148018},
                                     {0.485314750665},
                                     {-0.915658953288},
                                     {0.950090890385},
                                     {-0.00565229265779},
                                     {-0.2369852937},
                                     {-0.639252510593},
                                     {-0.564966485607},
                                     {0.803662909711},
                                     {-0.480365971715},
                                     {-0.467749219524},
                                     {-0.647923617773},
                                     {-0.814307872654},
                                     {-0.660981673188},
                                     {-0.259482410343},
                                     {0.0363703852677},
                                     {-0.957017459476},
                                     {-0.921870853532},
                                     {0.975689516208},
                                     {-0.288951336719},
                                     {-0.483533013229},
                                     {0.15064861802},
                                     {-0.422837651762},
                                     {-0.350912002365},
                                     {0.475871327275},
                                     {0.547622776027},
                                     {-0.506213996343},
                                     {-0.804770566067},
                                     {-0.845954101597},
                                     {0.23097978224},
                                     {0.66933952991},
                                     {0.895522370029},
                                     {0.38271924921},
                                     {-0.047671968577},
                                     {0.781721975093},
                                     {0.0182365072946},
                                     {0.492118301366},
                                     {0.957992423079},
                                     {-0.920838951996},
                                     {0.88530095043},
                                     {0.50074425311},
                                     {-0.802729743362},
                                     {0.255851096265},
                                     {-0.0417193094939},
                                     {0.539403492592},
                                     {0.745108632462},
                                     {0.368877509679},
                                     {-0.635294033791},
                                     {-0.0187516717085},
                                     {0.262703079115},
                                     {-0.32231529635},
                                     {0.976310199589},
                                     {-0.209039698068},
                                     {-0.645023155102},
                                     {0.67912494015},
                                     {0.495622450157},
                                     {-0.100251892683},
                                     {-0.996848817347},
                                     {-0.0987236675542},
                                     {-0.425090747899},
                                     {-0.104203365904},
                                     {0.0573246754207},
                                     {-0.0544615962989},
                                     {0.284179140426},
                                     {-0.949997917006},
                                     {-0.778489146074},
                                     {0.806684595133},
                                     {0.914782453223},
                                     {0.671023546212},
                                     {-0.519537764358},
                                     {-0.654052862376},
                                     {0.0488377191846},
                                     {-0.221751204501},
                                     {0.354255608828},
                                     {0.141263067657},
                                     {-0.935591719894},
                                     {-0.959165803959},
                                     {-0.235671934167},
                                     {-0.851174410829},
                                     {-0.465661863837},
                                     {-0.674442248127},
                                     {0.870089018545},
                                     {-0.266588007415},
                                     {-0.299569719915},
                                     {-0.155664768335},
                                     {-0.22595161199},
                                     {0.0859028106026},
                                     {0.517376331039},
                                     {0.34541393042},
                                     {-0.123476696938},
                                     {-0.0112102981913},
                                     {-0.281653772416},
                                     {-0.217051444608},
                                     {-0.202052714191},
                                     {-0.677372779399},
                                     {0.412327454875},
                                     {0.63177679019},
                                     {0.505127108848},
                                     {0.805814803029},
                                     {0.640261350475},
                                     {-0.303699827338},
                                     {0.786067593123},
                                     {0.6986625095},
                                     {0.148519758809},
                                     {0.862348270656},
                                     {0.289668520104},
                                     {-0.468991456892},
                                     {-0.3788574345},
                                     {0.015087748091},
                                     {-0.51623334978},
                                     {-0.0584277738908},
                                     {-0.294675787398},
                                     {0.266100261255},
                                     {-0.540560801096},
                                     {-0.431404190759},
                                     {-0.400578990802},
                                     {0.180171166068},
                                     {-0.32280133619},
                                     {0.245608171607},
                                     {-0.0360762501108},
                                     {-0.18418033835},
                                     {0.419723697381},
                                     {0.455768661817},
                                     {-0.343602991191},
                                     {0.994294798001},
                                     {0.159996929507},
                                     {-0.749944765734},
                                     {-0.090145990972},
                                     {0.411026453868},
                                     {-0.132971130209},
                                     {0.0658028292851},
                                     {-0.0881082376329},
                                     {0.86592480015},
                                     {-0.32929844812},
                                     {0.53603629749},
                                     {-0.643078474092},
                                     {-0.30599109277},
                                     {0.926631567402},
                                     {0.912201292233},
                                     {0.802304085975},
                                     {-0.67915638005},
                                     {-0.751813438823},
                                     {-0.208967638797},
                                     {0.132315414586},
                                     {0.682349428924},
                                     {-0.525549874155},
                                     {0.275599612628},
                                     {-0.74676958287},
                                     {0.937047988958},
                                     {0.43460815577},
                                     {0.0142260747245},
                                     {0.180749138277},
                                     {-0.313463441395},
                                     {-0.274002283835},
                                     {0.523003236382},
                                     {0.780913908778},
                                     {-0.494934167865},
                                     {0.818593572183},
                                     {0.533915816067},
                                     {-0.0130361482251},
                                     {-0.705622687068},
                                     {0.722682123285},
                                     {0.507754061746},
                                     {-0.757993627819},
                                     {0.190727068281},
                                     {-0.380282707147},
                                     {0.301661041443},
                                     {0.136426856476},
                                     {-0.974945445514},
                                     {-0.614343303113},
                                     {0.44021261626},
                                     {-0.22030993216},
                                     {-0.198781048086},
                                     {0.236968770351},
                                     {-0.0465780655332},
                                     {0.401668674428},
                                     {0.597507722287},
                                     {-0.905798733301},
                                     {-0.502411080041},
                                     {-0.72004154009},
                                     {-0.753980111307},
                                     {0.891663443047},
                                     {0.081057763492},
                                     {-0.312669535049},
                                     {-0.611594876551},
                                     {-0.497563251588},
                                     {-0.582638042743},
                                     {0.860701680181},
                                     {0.961532428698},
                                     {-0.479053663586},
                                     {-0.619041737502},
                                     {-0.218915686691},
                                     {-0.457452315145},
                                     {0.873417690785},
                                     {0.116833303787},
                                     {-0.980519135986},
                                     {-0.404040133296},
                                     {0.252722546802},
                                     {0.642103114503},
                                     {0.34763654904},
                                     {0.456416335261},
                                     {0.953028024491},
                                     {0.235275936909},
                                     {0.601498060731},
                                     {0.781827877417},
                                     {0.470419079269},
                                     {0.0146950691393},
                                     {-0.235694665784},
                                     {-0.574844704427},
                                     {0.684892633207},
                                     {-0.458411945802},
                                     {0.265911694559},
                                     {0.169202280876},
                                     {-0.777909790703},
                                     {0.726384224166},
                                     {-0.553828089727},
                                     {-0.0832123692333},
                                     {0.721487611045},
                                     {-0.906675489131},
                                     {-0.960026196153},
                                     {-0.78755654858},
                                     {0.250631178512},
                                     {0.13332056756},
                                     {-0.719064191516},
                                     {0.168404894273},
                                     {0.899696787568},
                                     {-0.241155077287},
                                     {-0.791726996813},
                                     {0.68490416293},
                                     {0.830729929906},
                                     {0.829245788371},
                                     {0.476796832217},
                                     {-0.30340629475},
                                     {-0.97160859071},
                                     {0.0960159613032},
                                     {0.261892913066},
                                     {-0.043841341881},
                                     {-0.592923976594},
                                     {0.806058029402},
                                     {0.176253456712},
                                     {0.0506651479611},
                                     {0.534088270467},
                                     {-0.920834855247},
                                     {-0.534653045788},
                                     {-0.978110639545},
                                     {0.759932895317},
                                     {-0.399887306932},
                                     {0.763288749264},
                                     {0.867870667884},
                                     {-0.823463631323},
                                     {0.532253707161},
                                     {0.870235490679},
                                     {-0.836201428062},
                                     {-0.592575962626},
                                     {0.333064244848},
                                     {0.513161315099},
                                     {0.817530148018},
                                     {0.485314750665},
                                     {-0.915658953288},
                                     {0.950090890385},
                                     {-0.00565229265779},
                                     {-0.2369852937},
                                     {-0.639252510593},
                                     {-0.564966485607},
                                     {0.803662909711},
                                     {-0.480365971715},
                                     {-0.467749219524},
                                     {-0.647923617773},
                                     {-0.814307872654},
                                     {-0.660981673188},
                                     {-0.259482410343},
                                     {0.0363703852677},
                                     {-0.957017459476},
                                     {-0.921870853532},
                                     {0.975689516208},
                                     {-0.288951336719},
                                     {-0.483533013229},
                                     {0.15064861802},
                                     {-0.422837651762},
                                     {-0.350912002365},
                                     {0.475871327275},
                                     {0.547622776027},
                                     {-0.506213996343},
                                     {-0.804770566067},
                                     {-0.845954101597},
                                     {0.23097978224},
                                     {0.66933952991},
                                     {0.895522370029},
                                     {0.38271924921},
                                     {-0.047671968577},
                                     {0.781721975093},
                                     {0.0182365072946},
                                     {0.492118301366},
                                     {0.957992423079},
                                     {-0.920838951996},
                                     {0.88530095043},
                                     {0.50074425311},
                                     {-0.802729743362},
                                     {0.255851096265},
                                     {-0.0417193094939},
                                     {0.539403492592},
                                     {0.745108632462},
                                     {0.368877509679},
                                     {-0.635294033791},
                                     {-0.0187516717085},
                                     {0.262703079115},
                                     {-0.32231529635},
                                     {0.976310199589},
                                     {-0.209039698068},
                                     {-0.645023155102},
                                     {0.67912494015},
                                     {0.495622450157},
                                     {-0.100251892683},
                                     {-0.996848817347},
                                     {-0.0987236675542},
                                     {-0.425090747899},
                                     {-0.104203365904},
                                     {0.0573246754207},
                                     {-0.0544615962989},
                                     {0.284179140426},
                                     {-0.949997917006},
                                     {-0.778489146074},
                                     {0.806684595133},
                                     {0.914782453223},
                                     {0.671023546212},
                                     {-0.519537764358},
                                     {-0.654052862376},
                                     {0.0488377191846},
                                     {-0.221751204501},
                                     {0.354255608828},
                                     {0.141263067657},
                                     {-0.935591719894},
                                     {-0.959165803959},
                                     {-0.235671934167},
                                     {-0.851174410829},
                                     {-0.465661863837},
                                     {-0.674442248127},
                                     {0.870089018545},
                                     {-0.266588007415},
                                     {-0.299569719915},
                                     {-0.155664768335},
                                     {-0.22595161199},
                                     {0.0859028106026},
                                     {0.517376331039},
                                     {0.34541393042},
                                     {-0.123476696938},
                                     {-0.0112102981913},
                                     {-0.281653772416},
                                     {-0.217051444608},
                                     {-0.202052714191},
                                     {-0.677372779399},
                                     {0.412327454875},
                                     {0.63177679019},
                                     {0.505127108848},
                                     {0.805814803029},
                                     {0.640261350475},
                                     {-0.303699827338},
                                     {0.786067593123},
                                     {0.6986625095},
                                     {0.148519758809},
                                     {0.862348270656},
                                     {0.289668520104},
                                     {-0.468991456892},
                                     {-0.3788574345},
                                     {0.015087748091},
                                     {-0.51623334978},
                                     {-0.0584277738908},
                                     {-0.294675787398},
                                     {0.266100261255},
                                     {-0.540560801096},
                                     {-0.431404190759},
                                     {-0.400578990802},
                                     {0.180171166068},
                                     {-0.32280133619},
                                     {0.245608171607},
                                     {-0.0360762501108},
                                     {-0.18418033835},
                                     {0.419723697381},
                                     {0.455768661817},
                                     {-0.343602991191},
                                     {0.994294798001},
                                     {0.159996929507},
                                     {-0.749944765734},
                                     {-0.090145990972},
                                     {0.411026453868}};

double NOISE_TABLES<2>::g[514][2] = {{-0.151629, 0.988438},
                                     {-0.965502, 0.260395},
                                     {0.423502, 0.905895},
                                     {0.592141, 0.805834},
                                     {-0.387536, 0.921855},
                                     {-0.961849, -0.27358},
                                     {0.92593, -0.377695},
                                     {-0.776778, 0.629775},
                                     {0.922126, 0.38689},
                                     {0.847856, -0.530226},
                                     {0.249481, -0.96838},
                                     {0.296638, -0.95499},
                                     {-0.476145, 0.879367},
                                     {0.939988, 0.341208},
                                     {0.0559883, -0.998432},
                                     {0.820859, -0.571131},
                                     {-0.761065, 0.648676},
                                     {0.560754, -0.827983},
                                     {0.309366, 0.950943},
                                     {0.986137, -0.165934},
                                     {-0.947255, -0.320481},
                                     {-0.580349, 0.814368},
                                     {-0.35311, -0.935582},
                                     {0.600649, -0.799513},
                                     {0.0688496, 0.997627},
                                     {0.639101, -0.769123},
                                     {0.142116, 0.98985},
                                     {0.693872, -0.720099},
                                     {-0.95484, -0.29712},
                                     {0.620061, -0.784554},
                                     {0.855417, 0.51794},
                                     {-0.999843, 0.0176931},
                                     {0.981774, -0.190054},
                                     {0.711309, -0.702879},
                                     {-0.752388, -0.658721},
                                     {0.611741, 0.791058},
                                     {-0.719155, -0.69485},
                                     {0.884515, -0.466511},
                                     {0.201722, -0.979443},
                                     {-0.259763, -0.965673},
                                     {0.828983, 0.559273},
                                     {-0.999976, -0.00687675},
                                     {0.934908, -0.35489},
                                     {-0.600188, 0.799859},
                                     {0.999026, -0.0441183},
                                     {-0.72827, 0.685291},
                                     {-0.2121, -0.977248},
                                     {0.744893, -0.667184},
                                     {0.477018, -0.878893},
                                     {-0.247895, 0.968787},
                                     {-0.486511, -0.873674},
                                     {0.411162, -0.911562},
                                     {-0.638767, 0.7694},
                                     {0.401133, 0.91602},
                                     {-0.115368, -0.993323},
                                     {-0.988121, -0.153677},
                                     {-0.998432, -0.0559873},
                                     {0.433379, -0.901212},
                                     {0.676017, -0.736886},
                                     {0.867865, 0.4968},
                                     {-0.647582, -0.761996},
                                     {0.0443233, 0.999017},
                                     {0.776688, -0.629886},
                                     {0.455336, -0.89032},
                                     {-0.993282, 0.115723},
                                     {0.974665, 0.22367},
                                     {-0.827382, -0.561639},
                                     {-0.89603, 0.443993},
                                     {-0.744892, 0.667185},
                                     {-0.821064, 0.570837},
                                     {0.842454, 0.538768},
                                     {0.984458, 0.175618},
                                     {-0.853954, -0.520348},
                                     {0.177653, -0.984093},
                                     {0.22567, -0.974204},
                                     {-0.443072, -0.896486},
                                     {-0.984048, -0.177903},
                                     {0.800552, 0.599263},
                                     {-0.958812, 0.284042},
                                     {-0.848122, 0.529801},
                                     {0.668281, 0.743909},
                                     {0.703976, 0.710224},
                                     {-0.127298, 0.991865},
                                     {-0.0909771, -0.995853},
                                     {-0.968279, -0.249873},
                                     {0.51951, -0.854464},
                                     {-0.410073, 0.912053},
                                     {0.35568, 0.934608},
                                     {0.761019, -0.64873},
                                     {-0.364766, 0.931099},
                                     {0.129207, -0.991618},
                                     {0.10486, -0.994487},
                                     {0.895682, -0.444695},
                                     {-0.735993, -0.676989},
                                     {-0.926304, 0.376778},
                                     {-0.834845, 0.550485},
                                     {0.467459, 0.884015},
                                     {0.97682, -0.214061},
                                     {-0.991598, -0.129358},
                                     {0.948073, 0.318053},
                                     {-0.398569, -0.917139},
                                     {-0.906671, 0.421838},
                                     {0.498414, -0.866939},
                                     {0.968887, 0.247502},
                                     {-0.693715, 0.72025},
                                     {0.998546, 0.0539088},
                                     {0.993084, -0.117406},
                                     {0.958454, -0.285248},
                                     {0.48902, 0.872272},
                                     {-0.589776, -0.807567},
                                     {-0.78381, -0.621001},
                                     {0.540294, -0.841476},
                                     {0.388698, -0.921365},
                                     {-0.675803, 0.737082},
                                     {-0.840922, -0.541157},
                                     {0.965157, -0.261672},
                                     {0.72832, -0.685237},
                                     {-0.974124, -0.226015},
                                     {0.996924, 0.078373},
                                     {-0.916764, 0.399428},
                                     {-0.188071, -0.982156},
                                     {0.999988, 0.00489994},
                                     {-0.921093, -0.389343},
                                     {-0.283368, -0.959011},
                                     {-0.628687, -0.777658},
                                     {-0.995825, 0.0912825},
                                     {-0.997767, 0.0667875},
                                     {-0.341775, 0.939782},
                                     {-0.996755, -0.0804983},
                                     {-0.711207, 0.702983},
                                     {-0.330056, -0.943962},
                                     {-0.139691, -0.990195},
                                     {-0.569783, -0.821795},
                                     {-0.999107, 0.0422528},
                                     {-0.200002, 0.979796},
                                     {0.378521, 0.925593},
                                     {0.0933337, 0.995635},
                                     {-0.236002, -0.971753},
                                     {0.91236, 0.40939},
                                     {-0.0175388, -0.999846},
                                     {0.860595, -0.50929},
                                     {-0.806786, 0.590844},
                                     {-0.986397, 0.164381},
                                     {-0.999506, -0.0314418},
                                     {0.365999, -0.930615},
                                     {-0.860887, 0.508797},
                                     {0.891185, 0.453639},
                                     {0.117761, 0.993042},
                                     {0.979856, 0.199704},
                                     {0.962527, 0.271186},
                                     {-0.684191, -0.729303},
                                     {0.721192, 0.692735},
                                     {0.238526, 0.971136},
                                     {0.00697998, -0.999976},
                                     {-0.930376, -0.366607},
                                     {0.815014, 0.579442},
                                     {-0.528782, -0.848757},
                                     {-0.900866, -0.434097},
                                     {-0.884848, 0.46588},
                                     {0.902044, 0.431644},
                                     {-0.979381, -0.20202},
                                     {0.262303, 0.964986},
                                     {-0.224016, 0.974586},
                                     {-0.295191, 0.955438},
                                     {-0.464931, -0.885347},
                                     {-0.45439, 0.890803},
                                     {0.343081, -0.939306},
                                     {0.989908, -0.141713},
                                     {0.97128, -0.237938},
                                     {0.737974, 0.674829},
                                     {-0.866472, -0.499225},
                                     {0.580876, -0.813992},
                                     {-0.318579, 0.947896},
                                     {0.770191, 0.637813},
                                     {0.87979, 0.475362},
                                     {0.332624, 0.94306},
                                     {-0.0665321, -0.997784},
                                     {0.75431, 0.656519},
                                     {0.931337, 0.364158},
                                     {0.951175, -0.308652},
                                     {-0.0784228, 0.99692},
                                     {-0.657484, 0.753469},
                                     {-0.701884, -0.712291},
                                     {-0.994476, -0.10496},
                                     {-0.00479666, 0.999989},
                                     {0.190552, 0.981677},
                                     {0.153476, -0.988152},
                                     {-0.666087, -0.745874},
                                     {-0.0293607, 0.999569},
                                     {-0.990138, 0.140094},
                                     {0.285921, 0.958253},
                                     {-0.539632, 0.841901},
                                     {-0.306804, -0.951773},
                                     {0.806616, -0.591075},
                                     {0.994703, 0.102791},
                                     {0.943325, -0.331871},
                                     {-0.0539077, 0.998546},
                                     {-0.939099, -0.343648},
                                     {0.916396, -0.400274},
                                     {-0.873131, 0.487485},
                                     {-0.76833, -0.640054},
                                     {-0.889936, -0.456086},
                                     {-0.943698, 0.330809},
                                     {0.166385, 0.986061},
                                     {0.657757, -0.753231},
                                     {-0.16393, -0.986472},
                                     {-0.813345, -0.581782},
                                     {0.686335, 0.727285},
                                     {-0.375952, -0.926639},
                                     {0.531244, 0.847219},
                                     {0.997645, -0.0685942},
                                     {-0.507799, -0.861475},
                                     {0.510286, 0.860005},
                                     {0.319956, -0.947433},
                                     {-0.497612, 0.8674},
                                     {0.445615, 0.895225},
                                     {-0.97713, 0.212644},
                                     {0.785609, 0.618724},
                                     {-0.951542, 0.307518},
                                     {0.991884, 0.127147},
                                     {-0.935283, 0.3539},
                                     {-0.518778, 0.854909},
                                     {0.214604, 0.976701},
                                     {0.906311, -0.422611},
                                     {-0.878469, -0.4778},
                                     {-0.420947, -0.907085},
                                     {0.649823, 0.760086},
                                     {-0.549448, -0.835528},
                                     {-0.619665, 0.784867},
                                     {0.630972, 0.775805},
                                     {-0.175868, 0.984414},
                                     {-0.911254, -0.411844},
                                     {0.55188, 0.833923},
                                     {0.988468, 0.151428},
                                     {0.834608, -0.550844},
                                     {-0.98206, 0.188569},
                                     {-0.271624, 0.962403},
                                     {0.0314939, -0.999504},
                                     {0.0197696, 0.999805},
                                     {-0.102891, 0.994693},
                                     {0.995664, -0.0930283},
                                     {0.273142, -0.961974},
                                     {-0.609415, -0.792851},
                                     {-0.971609, 0.23659},
                                     {-0.798818, -0.601573},
                                     {0.79189, -0.610664},
                                     {0.872817, -0.488047},
                                     {0.572183, 0.820126},
                                     {-0.0420478, -0.999116},
                                     {0.999567, 0.0294129},
                                     {0.0804485, -0.996759},
                                     {0.955587, 0.294708},
                                     {-0.432362, 0.9017},
                                     {-0.56016, 0.828385},
                                     {0.999808, -0.0196154},
                                     {-0.792021, 0.610494},
                                     {-0.151629, 0.988438},
                                     {-0.965502, 0.260395},
                                     {0.423502, 0.905895},
                                     {0.592141, 0.805834},
                                     {-0.387536, 0.921855},
                                     {-0.961849, -0.27358},
                                     {0.92593, -0.377695},
                                     {-0.776778, 0.629775},
                                     {0.922126, 0.38689},
                                     {0.847856, -0.530226},
                                     {0.249481, -0.96838},
                                     {0.296638, -0.95499},
                                     {-0.476145, 0.879367},
                                     {0.939988, 0.341208},
                                     {0.0559883, -0.998432},
                                     {0.820859, -0.571131},
                                     {-0.761065, 0.648676},
                                     {0.560754, -0.827983},
                                     {0.309366, 0.950943},
                                     {0.986137, -0.165934},
                                     {-0.947255, -0.320481},
                                     {-0.580349, 0.814368},
                                     {-0.35311, -0.935582},
                                     {0.600649, -0.799513},
                                     {0.0688496, 0.997627},
                                     {0.639101, -0.769123},
                                     {0.142116, 0.98985},
                                     {0.693872, -0.720099},
                                     {-0.95484, -0.29712},
                                     {0.620061, -0.784554},
                                     {0.855417, 0.51794},
                                     {-0.999843, 0.0176931},
                                     {0.981774, -0.190054},
                                     {0.711309, -0.702879},
                                     {-0.752388, -0.658721},
                                     {0.611741, 0.791058},
                                     {-0.719155, -0.69485},
                                     {0.884515, -0.466511},
                                     {0.201722, -0.979443},
                                     {-0.259763, -0.965673},
                                     {0.828983, 0.559273},
                                     {-0.999976, -0.00687675},
                                     {0.934908, -0.35489},
                                     {-0.600188, 0.799859},
                                     {0.999026, -0.0441183},
                                     {-0.72827, 0.685291},
                                     {-0.2121, -0.977248},
                                     {0.744893, -0.667184},
                                     {0.477018, -0.878893},
                                     {-0.247895, 0.968787},
                                     {-0.486511, -0.873674},
                                     {0.411162, -0.911562},
                                     {-0.638767, 0.7694},
                                     {0.401133, 0.91602},
                                     {-0.115368, -0.993323},
                                     {-0.988121, -0.153677},
                                     {-0.998432, -0.0559873},
                                     {0.433379, -0.901212},
                                     {0.676017, -0.736886},
                                     {0.867865, 0.4968},
                                     {-0.647582, -0.761996},
                                     {0.0443233, 0.999017},
                                     {0.776688, -0.629886},
                                     {0.455336, -0.89032},
                                     {-0.993282, 0.115723},
                                     {0.974665, 0.22367},
                                     {-0.827382, -0.561639},
                                     {-0.89603, 0.443993},
                                     {-0.744892, 0.667185},
                                     {-0.821064, 0.570837},
                                     {0.842454, 0.538768},
                                     {0.984458, 0.175618},
                                     {-0.853954, -0.520348},
                                     {0.177653, -0.984093},
                                     {0.22567, -0.974204},
                                     {-0.443072, -0.896486},
                                     {-0.984048, -0.177903},
                                     {0.800552, 0.599263},
                                     {-0.958812, 0.284042},
                                     {-0.848122, 0.529801},
                                     {0.668281, 0.743909},
                                     {0.703976, 0.710224},
                                     {-0.127298, 0.991865},
                                     {-0.0909771, -0.995853},
                                     {-0.968279, -0.249873},
                                     {0.51951, -0.854464},
                                     {-0.410073, 0.912053},
                                     {0.35568, 0.934608},
                                     {0.761019, -0.64873},
                                     {-0.364766, 0.931099},
                                     {0.129207, -0.991618},
                                     {0.10486, -0.994487},
                                     {0.895682, -0.444695},
                                     {-0.735993, -0.676989},
                                     {-0.926304, 0.376778},
                                     {-0.834845, 0.550485},
                                     {0.467459, 0.884015},
                                     {0.97682, -0.214061},
                                     {-0.991598, -0.129358},
                                     {0.948073, 0.318053},
                                     {-0.398569, -0.917139},
                                     {-0.906671, 0.421838},
                                     {0.498414, -0.866939},
                                     {0.968887, 0.247502},
                                     {-0.693715, 0.72025},
                                     {0.998546, 0.0539088},
                                     {0.993084, -0.117406},
                                     {0.958454, -0.285248},
                                     {0.48902, 0.872272},
                                     {-0.589776, -0.807567},
                                     {-0.78381, -0.621001},
                                     {0.540294, -0.841476},
                                     {0.388698, -0.921365},
                                     {-0.675803, 0.737082},
                                     {-0.840922, -0.541157},
                                     {0.965157, -0.261672},
                                     {0.72832, -0.685237},
                                     {-0.974124, -0.226015},
                                     {0.996924, 0.078373},
                                     {-0.916764, 0.399428},
                                     {-0.188071, -0.982156},
                                     {0.999988, 0.00489994},
                                     {-0.921093, -0.389343},
                                     {-0.283368, -0.959011},
                                     {-0.628687, -0.777658},
                                     {-0.995825, 0.0912825},
                                     {-0.997767, 0.0667875},
                                     {-0.341775, 0.939782},
                                     {-0.996755, -0.0804983},
                                     {-0.711207, 0.702983},
                                     {-0.330056, -0.943962},
                                     {-0.139691, -0.990195},
                                     {-0.569783, -0.821795},
                                     {-0.999107, 0.0422528},
                                     {-0.200002, 0.979796},
                                     {0.378521, 0.925593},
                                     {0.0933337, 0.995635},
                                     {-0.236002, -0.971753},
                                     {0.91236, 0.40939},
                                     {-0.0175388, -0.999846},
                                     {0.860595, -0.50929},
                                     {-0.806786, 0.590844},
                                     {-0.986397, 0.164381},
                                     {-0.999506, -0.0314418},
                                     {0.365999, -0.930615},
                                     {-0.860887, 0.508797},
                                     {0.891185, 0.453639},
                                     {0.117761, 0.993042},
                                     {0.979856, 0.199704},
                                     {0.962527, 0.271186},
                                     {-0.684191, -0.729303},
                                     {0.721192, 0.692735},
                                     {0.238526, 0.971136},
                                     {0.00697998, -0.999976},
                                     {-0.930376, -0.366607},
                                     {0.815014, 0.579442},
                                     {-0.528782, -0.848757},
                                     {-0.900866, -0.434097},
                                     {-0.884848, 0.46588},
                                     {0.902044, 0.431644},
                                     {-0.979381, -0.20202},
                                     {0.262303, 0.964986},
                                     {-0.224016, 0.974586},
                                     {-0.295191, 0.955438},
                                     {-0.464931, -0.885347},
                                     {-0.45439, 0.890803},
                                     {0.343081, -0.939306},
                                     {0.989908, -0.141713},
                                     {0.97128, -0.237938},
                                     {0.737974, 0.674829},
                                     {-0.866472, -0.499225},
                                     {0.580876, -0.813992},
                                     {-0.318579, 0.947896},
                                     {0.770191, 0.637813},
                                     {0.87979, 0.475362},
                                     {0.332624, 0.94306},
                                     {-0.0665321, -0.997784},
                                     {0.75431, 0.656519},
                                     {0.931337, 0.364158},
                                     {0.951175, -0.308652},
                                     {-0.0784228, 0.99692},
                                     {-0.657484, 0.753469},
                                     {-0.701884, -0.712291},
                                     {-0.994476, -0.10496},
                                     {-0.00479666, 0.999989},
                                     {0.190552, 0.981677},
                                     {0.153476, -0.988152},
                                     {-0.666087, -0.745874},
                                     {-0.0293607, 0.999569},
                                     {-0.990138, 0.140094},
                                     {0.285921, 0.958253},
                                     {-0.539632, 0.841901},
                                     {-0.306804, -0.951773},
                                     {0.806616, -0.591075},
                                     {0.994703, 0.102791},
                                     {0.943325, -0.331871},
                                     {-0.0539077, 0.998546},
                                     {-0.939099, -0.343648},
                                     {0.916396, -0.400274},
                                     {-0.873131, 0.487485},
                                     {-0.76833, -0.640054},
                                     {-0.889936, -0.456086},
                                     {-0.943698, 0.330809},
                                     {0.166385, 0.986061},
                                     {0.657757, -0.753231},
                                     {-0.16393, -0.986472},
                                     {-0.813345, -0.581782},
                                     {0.686335, 0.727285},
                                     {-0.375952, -0.926639},
                                     {0.531244, 0.847219},
                                     {0.997645, -0.0685942},
                                     {-0.507799, -0.861475},
                                     {0.510286, 0.860005},
                                     {0.319956, -0.947433},
                                     {-0.497612, 0.8674},
                                     {0.445615, 0.895225},
                                     {-0.97713, 0.212644},
                                     {0.785609, 0.618724},
                                     {-0.951542, 0.307518},
                                     {0.991884, 0.127147},
                                     {-0.935283, 0.3539},
                                     {-0.518778, 0.854909},
                                     {0.214604, 0.976701},
                                     {0.906311, -0.422611},
                                     {-0.878469, -0.4778},
                                     {-0.420947, -0.907085},
                                     {0.649823, 0.760086},
                                     {-0.549448, -0.835528},
                                     {-0.619665, 0.784867},
                                     {0.630972, 0.775805},
                                     {-0.175868, 0.984414},
                                     {-0.911254, -0.411844},
                                     {0.55188, 0.833923},
                                     {0.988468, 0.151428},
                                     {0.834608, -0.550844},
                                     {-0.98206, 0.188569},
                                     {-0.271624, 0.962403},
                                     {0.0314939, -0.999504},
                                     {0.0197696, 0.999805},
                                     {-0.102891, 0.994693},
                                     {0.995664, -0.0930283},
                                     {0.273142, -0.961974},
                                     {-0.609415, -0.792851},
                                     {-0.971609, 0.23659},
                                     {-0.798818, -0.601573},
                                     {0.79189, -0.610664},
                                     {0.872817, -0.488047},
                                     {0.572183, 0.820126},
                                     {-0.0420478, -0.999116},
                                     {0.999567, 0.0294129},
                                     {0.0804485, -0.996759},
                                     {0.955587, 0.294708},
                                     {-0.432362, 0.9017},
                                     {-0.56016, 0.828385},
                                     {0.999808, -0.0196154},
                                     {-0.792021, 0.610494},
                                     {-0.151629, 0.988438},
                                     {-0.965502, 0.260395}};

double NOISE_TABLES<3>::g[514][3] = {{0.703937, 0.671213, 0.232264},
                                     {0.244363, 0.69386, -0.677381},
                                     {-0.331423, 0.848405, -0.412756},
                                     {0.126499, 0.962872, 0.238487},
                                     {0.466958, -0.483874, 0.740146},
                                     {0.176755, 0.860964, 0.476969},
                                     {0.886366, 0.406782, -0.221099},
                                     {0.0185006, 0.775828, 0.630673},
                                     {-0.470088, 0.0605037, 0.880543},
                                     {-0.773492, 0.626673, -0.0948238},
                                     {-0.857512, 0.288094, -0.426232},
                                     {0.150081, 0.415784, 0.896995},
                                     {-0.872249, -0.218042, 0.437766},
                                     {-0.0861065, -0.839216, -0.536938},
                                     {0.349644, -0.0680964, -0.934405},
                                     {-0.0398576, 0.898367, 0.437433},
                                     {0.468223, -0.875571, -0.118926},
                                     {-0.103358, 0.963883, 0.24545},
                                     {0.337089, -0.875548, 0.346102},
                                     {-0.0221145, 0.424378, -0.905215},
                                     {0.0437806, 0.910029, -0.412227},
                                     {-0.708037, 0.621613, -0.335084},
                                     {-0.582809, 0.409583, -0.701837},
                                     {0.449608, -0.880991, 0.147335},
                                     {0.894835, -0.444366, 0.0425467},
                                     {0.612009, -0.290472, -0.735576},
                                     {0.327684, 0.528202, 0.783343},
                                     {-0.954306, -0.0592497, 0.292897},
                                     {-0.787289, -0.592354, 0.17115},
                                     {-0.532847, 0.754446, -0.383257},
                                     {0.967865, 0.202682, -0.148851},
                                     {-0.154359, 0.666301, 0.729532},
                                     {0.815913, -0.378909, 0.436708},
                                     {-0.33297, -0.903445, -0.270035},
                                     {0.473239, -0.483413, -0.736449},
                                     {-0.575346, 0.601649, -0.554071},
                                     {-0.0318239, 0.27278, 0.96155},
                                     {0.265315, 0.13551, -0.954591},
                                     {-0.631428, -0.24433, -0.735935},
                                     {0.660881, -0.728335, -0.181008},
                                     {0.213022, 0.525664, -0.823589},
                                     {-0.584948, -0.498582, 0.639729},
                                     {0.326382, 0.886109, 0.329069},
                                     {-0.639737, -0.0281372, 0.768078},
                                     {0.0488475, 0.780061, -0.623793},
                                     {-0.162389, 0.939152, -0.302694},
                                     {0.743029, 0.329622, -0.582459},
                                     {-0.0392915, 0.998263, 0.0438991},
                                     {-0.184122, 0.684116, -0.705751},
                                     {0.649173, -0.486517, -0.584701},
                                     {-0.797453, -0.508998, -0.324021},
                                     {-0.692277, 0.00421333, -0.721619},
                                     {0.736423, -0.0850594, -0.671153},
                                     {0.185898, 0.982543, -0.00722356},
                                     {0.0127172, 0.618041, -0.786043},
                                     {0.552496, 0.831102, 0.0633782},
                                     {0.931649, 0.086932, 0.352808},
                                     {0.16589, 0.183359, 0.968948},
                                     {-0.563792, -0.466113, -0.681819},
                                     {-0.227157, 0.970054, -0.0859935},
                                     {0.143632, -0.772967, -0.617973},
                                     {0.80845, -0.55899, -0.184227},
                                     {-0.259797, -0.315267, 0.91275},
                                     {-0.210642, -0.9083, 0.361416},
                                     {0.111219, -0.900813, -0.419723},
                                     {0.271668, -0.442262, -0.854752},
                                     {-0.82864, 0.0821824, -0.553717},
                                     {-0.375708, 0.718987, -0.584723},
                                     {-0.280864, -0.0848669, 0.955988},
                                     {0.40012, 0.909678, -0.111309},
                                     {0.982483, 0.139306, 0.123782},
                                     {-0.945762, -0.253865, 0.2027},
                                     {-0.980597, -0.195914, -0.0068499},
                                     {0.35892, 0.311644, 0.879804},
                                     {-0.150533, 0.0281254, -0.988205},
                                     {0.942365, 0.333462, 0.0274149},
                                     {0.0915656, -0.977007, -0.192542},
                                     {0.482284, 0.138992, -0.864918},
                                     {0.910838, 0.310947, 0.271452},
                                     {0.621993, 0.639092, 0.452422},
                                     {-0.847242, -0.424279, 0.319637},
                                     {0.491705, 0.587825, 0.642408},
                                     {-0.892862, 0.392122, 0.221445},
                                     {0.604611, -0.268798, 0.749796},
                                     {-0.750032, -0.369835, 0.548338},
                                     {0.832349, 0.0323993, 0.553304},
                                     {0.768444, 0.48877, -0.413035},
                                     {0.520619, -0.0862026, 0.849426},
                                     {0.0382017, -0.5973, 0.801108},
                                     {-0.462935, 0.762886, 0.451326},
                                     {0.847687, 0.528653, -0.0441998},
                                     {-0.379082, -0.618955, 0.687889},
                                     {-0.405669, 0.550519, -0.729631},
                                     {-0.221196, -0.34563, -0.911928},
                                     {0.431557, 0.83464, -0.342248},
                                     {-0.648354, -0.596692, -0.472859},
                                     {-0.370907, 0.105338, -0.922677},
                                     {-0.0718653, -0.849552, 0.522587},
                                     {-0.347969, -0.919283, 0.183948},
                                     {-0.271436, 0.146575, 0.95123},
                                     {0.809606, -0.531526, 0.249035},
                                     {0.354965, 0.926855, 0.122231},
                                     {0.11355, -0.586723, -0.801787},
                                     {0.428599, 0.539449, -0.724774},
                                     {0.671071, 0.133191, -0.729331},
                                     {-0.691673, -0.722188, 0.00581921},
                                     {0.210179, -0.958281, 0.193709},
                                     {-0.902243, -0.426146, 0.0660138},
                                     {-0.404368, 0.338777, -0.849539},
                                     {0.795005, -0.464171, -0.390528},
                                     {-0.608185, 0.590394, 0.530609},
                                     {0.398167, -0.316797, 0.860873},
                                     {-0.652399, 0.754199, 0.0745617},
                                     {0.692765, -0.0251959, 0.720723},
                                     {-0.111766, -0.935697, -0.334633},
                                     {-0.0339944, -0.412959, 0.910115},
                                     {0.534409, 0.379982, 0.754997},
                                     {0.77425, -0.632123, 0.0309428},
                                     {-0.707191, -0.566922, 0.42247},
                                     {-0.212727, -0.529147, 0.821432},
                                     {0.296734, -0.914603, -0.274681},
                                     {-0.218053, 0.496506, -0.840199},
                                     {0.422297, -0.273784, -0.864122},
                                     {0.591333, 0.787304, -0.17458},
                                     {-0.443239, -0.305043, -0.842904},
                                     {0.661367, -0.639136, -0.392553},
                                     {-0.468663, -0.182573, 0.864305},
                                     {-0.516925, -0.0670702, -0.853399},
                                     {-0.710741, 0.375331, 0.594957},
                                     {0.423102, 0.759161, 0.494631},
                                     {0.247216, 0.839627, -0.483643},
                                     {-0.916356, -0.364994, -0.164534},
                                     {-0.970304, 0.237044, 0.0481746},
                                     {-0.508056, -0.773006, -0.379922},
                                     {0.717762, 0.696189, 0.0117958},
                                     {-0.879854, 0.0374545, 0.473766},
                                     {-0.141238, -0.706546, 0.69343},
                                     {-0.302912, -0.8224, -0.481563},
                                     {-0.52973, -0.679401, 0.507741},
                                     {-0.995612, 0.00112916, 0.0935721},
                                     {0.770279, -0.290515, -0.567689},
                                     {0.831609, 0.267528, 0.486678},
                                     {0.145521, -0.277545, 0.949628},
                                     {0.507867, -0.636986, 0.579931},
                                     {0.890254, -0.268962, -0.367569},
                                     {0.0181128, 0.983902, -0.177786},
                                     {0.967931, -0.127579, -0.216412},
                                     {-0.868754, -0.306667, -0.388872},
                                     {0.102164, -0.0286481, -0.994355},
                                     {-0.67944, -0.692457, -0.24262},
                                     {0.899886, -0.148992, 0.409886},
                                     {0.824701, 0.114807, -0.553794},
                                     {-0.223681, 0.35753, 0.906719},
                                     {-0.735341, 0.453771, -0.503355},
                                     {-0.319217, 0.519664, 0.792496},
                                     {0.360392, 0.0842246, 0.928991},
                                     {0.0285471, -0.397916, -0.916978},
                                     {0.748567, 0.623001, -0.226975},
                                     {-0.938623, 0.104478, -0.328743},
                                     {0.439054, 0.708447, -0.552571},
                                     {-0.138696, -0.983299, -0.117838},
                                     {0.102764, -0.75416, 0.648601},
                                     {-0.792884, 0.589741, 0.15343},
                                     {-0.614839, 0.222451, 0.75663},
                                     {0.662237, -0.437329, 0.608429},
                                     {-0.435869, -0.413395, 0.799451},
                                     {-0.290422, 0.886642, 0.359889},
                                     {-0.628215, -0.27459, 0.727974},
                                     {0.783055, 0.483628, 0.391061},
                                     {-0.46599, -0.659429, -0.589921},
                                     {-0.96489, -0.139979, -0.222248},
                                     {-0.262613, -0.693507, -0.670882},
                                     {-0.941807, 0.283267, -0.180997},
                                     {0.517647, -0.766618, 0.379919},
                                     {0.91527, -0.365825, -0.168683},
                                     {0.880251, 0.267538, -0.391894},
                                     {0.497402, -0.797527, -0.341384},
                                     {-0.201279, 0.268824, -0.941924},
                                     {-0.36178, -0.513064, -0.778383},
                                     {-0.0622299, -0.190018, -0.979806},
                                     {0.920058, -0.313354, 0.235163},
                                     {0.611315, 0.534067, -0.584009},
                                     {-0.900076, -0.0891747, -0.42651},
                                     {-0.488622, 0.841614, 0.230075},
                                     {-0.765284, 0.132044, 0.630004},
                                     {0.0566041, -0.997883, 0.032038},
                                     {0.221663, -0.463196, 0.858088},
                                     {-0.136397, -0.537233, -0.832332},
                                     {0.188996, -0.239227, -0.952392},
                                     {-0.0692875, -0.184642, 0.98036},
                                     {0.324608, -0.767909, 0.552218},
                                     {0.561478, -0.0737953, -0.824195},
                                     {-0.818049, -0.567854, -0.0913143},
                                     {0.977631, -0.0847148, 0.192515},
                                     {0.00137412, -0.957845, 0.287284},
                                     {-0.650958, 0.691099, 0.314063},
                                     {-0.223262, 0.801023, 0.555442},
                                     {-0.773378, 0.500316, 0.38932},
                                     {0.578787, 0.345454, -0.738693},
                                     {0.610163, 0.684089, -0.399654},
                                     {0.32642, -0.806744, -0.492559},
                                     {0.228387, 0.93919, -0.25644},
                                     {0.54976, 0.152703, 0.821246},
                                     {0.678923, 0.438401, 0.588955},
                                     {-0.850488, 0.279179, 0.44579},
                                     {0.0130521, 0.183984, -0.982843},
                                     {-0.566217, 0.17794, -0.804821},
                                     {0.709054, 0.21427, 0.671812},
                                     {0.49716, -0.664111, -0.55838},
                                     {-0.347565, -0.936701, -0.0423009},
                                     {0.17422, 0.333029, -0.926682},
                                     {-0.776182, -0.123523, 0.618291},
                                     {-0.308091, -0.131397, -0.942239},
                                     {-0.530185, -0.835661, -0.14344},
                                     {-0.448458, -0.820814, 0.353766},
                                     {0.26657, 0.717597, 0.643425},
                                     {-0.533719, -0.839756, 0.0997717},
                                     {0.386265, 0.345329, -0.855305},
                                     {-0.0646575, 0.505187, 0.860585},
                                     {0.975145, -0.221327, 0.0103059},
                                     {-0.785106, -0.170651, -0.595388},
                                     {-0.991786, 0.0543184, -0.115802},
                                     {0.94534, 0.0632803, -0.319889},
                                     {0.683011, -0.587613, 0.433828},
                                     {-0.634975, -0.724176, 0.269027},
                                     {0.876185, -0.0834622, -0.474694},
                                     {0.287078, -0.625462, 0.725523},
                                     {-0.395736, 0.661196, 0.637348},
                                     {0.843124, 0.509441, 0.172079},
                                     {-0.468808, 0.8833, -0.000465431},
                                     {-0.947066, 0.172266, 0.270906},
                                     {0.531331, 0.798747, 0.282294},
                                     {-0.0477147, -0.703516, -0.709076},
                                     {-0.435629, 0.300855, 0.848359},
                                     {-0.293093, 0.947852, 0.12519},
                                     {0.609435, -0.792271, 0.029926},
                                     {-0.40416, 0.89042, -0.209302},
                                     {0.104886, 0.622757, 0.775353},
                                     {0.13811, -0.884292, 0.446042},
                                     {-0.531316, 0.462603, 0.709719},
                                     {-0.0749454, 0.0546115, 0.995691},
                                     {-0.307886, -0.782869, 0.540668},
                                     {-0.145564, 0.832899, -0.533938},
                                     {-0.734822, -0.395011, -0.551364},
                                     {-0.892592, 0.45057, -0.0163148},
                                     {-0.611459, 0.774063, -0.164148},
                                     {0.313613, -0.644045, -0.697749},
                                     {0.286015, -0.957831, -0.0274987},
                                     {-0.149122, -0.981781, 0.117763},
                                     {0.656373, -0.718632, 0.229658},
                                     {-0.844891, 0.464422, -0.265466},
                                     {0.316523, -0.132894, 0.93923},
                                     {0.998767, 0.00915237, -0.0487939},
                                     {-0.724761, 0.251606, -0.641417},
                                     {0.773361, -0.209935, 0.598197},
                                     {0.124979, -0.0345928, 0.991556},
                                     {0.703937, 0.671213, 0.232264},
                                     {0.244363, 0.69386, -0.677381},
                                     {-0.331423, 0.848405, -0.412756},
                                     {0.126499, 0.962872, 0.238487},
                                     {0.466958, -0.483874, 0.740146},
                                     {0.176755, 0.860964, 0.476969},
                                     {0.886366, 0.406782, -0.221099},
                                     {0.0185006, 0.775828, 0.630673},
                                     {-0.470088, 0.0605037, 0.880543},
                                     {-0.773492, 0.626673, -0.0948238},
                                     {-0.857512, 0.288094, -0.426232},
                                     {0.150081, 0.415784, 0.896995},
                                     {-0.872249, -0.218042, 0.437766},
                                     {-0.0861065, -0.839216, -0.536938},
                                     {0.349644, -0.0680964, -0.934405},
                                     {-0.0398576, 0.898367, 0.437433},
                                     {0.468223, -0.875571, -0.118926},
                                     {-0.103358, 0.963883, 0.24545},
                                     {0.337089, -0.875548, 0.346102},
                                     {-0.0221145, 0.424378, -0.905215},
                                     {0.0437806, 0.910029, -0.412227},
                                     {-0.708037, 0.621613, -0.335084},
                                     {-0.582809, 0.409583, -0.701837},
                                     {0.449608, -0.880991, 0.147335},
                                     {0.894835, -0.444366, 0.0425467},
                                     {0.612009, -0.290472, -0.735576},
                                     {0.327684, 0.528202, 0.783343},
                                     {-0.954306, -0.0592497, 0.292897},
                                     {-0.787289, -0.592354, 0.17115},
                                     {-0.532847, 0.754446, -0.383257},
                                     {0.967865, 0.202682, -0.148851},
                                     {-0.154359, 0.666301, 0.729532},
                                     {0.815913, -0.378909, 0.436708},
                                     {-0.33297, -0.903445, -0.270035},
                                     {0.473239, -0.483413, -0.736449},
                                     {-0.575346, 0.601649, -0.554071},
                                     {-0.0318239, 0.27278, 0.96155},
                                     {0.265315, 0.13551, -0.954591},
                                     {-0.631428, -0.24433, -0.735935},
                                     {0.660881, -0.728335, -0.181008},
                                     {0.213022, 0.525664, -0.823589},
                                     {-0.584948, -0.498582, 0.639729},
                                     {0.326382, 0.886109, 0.329069},
                                     {-0.639737, -0.0281372, 0.768078},
                                     {0.0488475, 0.780061, -0.623793},
                                     {-0.162389, 0.939152, -0.302694},
                                     {0.743029, 0.329622, -0.582459},
                                     {-0.0392915, 0.998263, 0.0438991},
                                     {-0.184122, 0.684116, -0.705751},
                                     {0.649173, -0.486517, -0.584701},
                                     {-0.797453, -0.508998, -0.324021},
                                     {-0.692277, 0.00421333, -0.721619},
                                     {0.736423, -0.0850594, -0.671153},
                                     {0.185898, 0.982543, -0.00722356},
                                     {0.0127172, 0.618041, -0.786043},
                                     {0.552496, 0.831102, 0.0633782},
                                     {0.931649, 0.086932, 0.352808},
                                     {0.16589, 0.183359, 0.968948},
                                     {-0.563792, -0.466113, -0.681819},
                                     {-0.227157, 0.970054, -0.0859935},
                                     {0.143632, -0.772967, -0.617973},
                                     {0.80845, -0.55899, -0.184227},
                                     {-0.259797, -0.315267, 0.91275},
                                     {-0.210642, -0.9083, 0.361416},
                                     {0.111219, -0.900813, -0.419723},
                                     {0.271668, -0.442262, -0.854752},
                                     {-0.82864, 0.0821824, -0.553717},
                                     {-0.375708, 0.718987, -0.584723},
                                     {-0.280864, -0.0848669, 0.955988},
                                     {0.40012, 0.909678, -0.111309},
                                     {0.982483, 0.139306, 0.123782},
                                     {-0.945762, -0.253865, 0.2027},
                                     {-0.980597, -0.195914, -0.0068499},
                                     {0.35892, 0.311644, 0.879804},
                                     {-0.150533, 0.0281254, -0.988205},
                                     {0.942365, 0.333462, 0.0274149},
                                     {0.0915656, -0.977007, -0.192542},
                                     {0.482284, 0.138992, -0.864918},
                                     {0.910838, 0.310947, 0.271452},
                                     {0.621993, 0.639092, 0.452422},
                                     {-0.847242, -0.424279, 0.319637},
                                     {0.491705, 0.587825, 0.642408},
                                     {-0.892862, 0.392122, 0.221445},
                                     {0.604611, -0.268798, 0.749796},
                                     {-0.750032, -0.369835, 0.548338},
                                     {0.832349, 0.0323993, 0.553304},
                                     {0.768444, 0.48877, -0.413035},
                                     {0.520619, -0.0862026, 0.849426},
                                     {0.0382017, -0.5973, 0.801108},
                                     {-0.462935, 0.762886, 0.451326},
                                     {0.847687, 0.528653, -0.0441998},
                                     {-0.379082, -0.618955, 0.687889},
                                     {-0.405669, 0.550519, -0.729631},
                                     {-0.221196, -0.34563, -0.911928},
                                     {0.431557, 0.83464, -0.342248},
                                     {-0.648354, -0.596692, -0.472859},
                                     {-0.370907, 0.105338, -0.922677},
                                     {-0.0718653, -0.849552, 0.522587},
                                     {-0.347969, -0.919283, 0.183948},
                                     {-0.271436, 0.146575, 0.95123},
                                     {0.809606, -0.531526, 0.249035},
                                     {0.354965, 0.926855, 0.122231},
                                     {0.11355, -0.586723, -0.801787},
                                     {0.428599, 0.539449, -0.724774},
                                     {0.671071, 0.133191, -0.729331},
                                     {-0.691673, -0.722188, 0.00581921},
                                     {0.210179, -0.958281, 0.193709},
                                     {-0.902243, -0.426146, 0.0660138},
                                     {-0.404368, 0.338777, -0.849539},
                                     {0.795005, -0.464171, -0.390528},
                                     {-0.608185, 0.590394, 0.530609},
                                     {0.398167, -0.316797, 0.860873},
                                     {-0.652399, 0.754199, 0.0745617},
                                     {0.692765, -0.0251959, 0.720723},
                                     {-0.111766, -0.935697, -0.334633},
                                     {-0.0339944, -0.412959, 0.910115},
                                     {0.534409, 0.379982, 0.754997},
                                     {0.77425, -0.632123, 0.0309428},
                                     {-0.707191, -0.566922, 0.42247},
                                     {-0.212727, -0.529147, 0.821432},
                                     {0.296734, -0.914603, -0.274681},
                                     {-0.218053, 0.496506, -0.840199},
                                     {0.422297, -0.273784, -0.864122},
                                     {0.591333, 0.787304, -0.17458},
                                     {-0.443239, -0.305043, -0.842904},
                                     {0.661367, -0.639136, -0.392553},
                                     {-0.468663, -0.182573, 0.864305},
                                     {-0.516925, -0.0670702, -0.853399},
                                     {-0.710741, 0.375331, 0.594957},
                                     {0.423102, 0.759161, 0.494631},
                                     {0.247216, 0.839627, -0.483643},
                                     {-0.916356, -0.364994, -0.164534},
                                     {-0.970304, 0.237044, 0.0481746},
                                     {-0.508056, -0.773006, -0.379922},
                                     {0.717762, 0.696189, 0.0117958},
                                     {-0.879854, 0.0374545, 0.473766},
                                     {-0.141238, -0.706546, 0.69343},
                                     {-0.302912, -0.8224, -0.481563},
                                     {-0.52973, -0.679401, 0.507741},
                                     {-0.995612, 0.00112916, 0.0935721},
                                     {0.770279, -0.290515, -0.567689},
                                     {0.831609, 0.267528, 0.486678},
                                     {0.145521, -0.277545, 0.949628},
                                     {0.507867, -0.636986, 0.579931},
                                     {0.890254, -0.268962, -0.367569},
                                     {0.0181128, 0.983902, -0.177786},
                                     {0.967931, -0.127579, -0.216412},
                                     {-0.868754, -0.306667, -0.388872},
                                     {0.102164, -0.0286481, -0.994355},
                                     {-0.67944, -0.692457, -0.24262},
                                     {0.899886, -0.148992, 0.409886},
                                     {0.824701, 0.114807, -0.553794},
                                     {-0.223681, 0.35753, 0.906719},
                                     {-0.735341, 0.453771, -0.503355},
                                     {-0.319217, 0.519664, 0.792496},
                                     {0.360392, 0.0842246, 0.928991},
                                     {0.0285471, -0.397916, -0.916978},
                                     {0.748567, 0.623001, -0.226975},
                                     {-0.938623, 0.104478, -0.328743},
                                     {0.439054, 0.708447, -0.552571},
                                     {-0.138696, -0.983299, -0.117838},
                                     {0.102764, -0.75416, 0.648601},
                                     {-0.792884, 0.589741, 0.15343},
                                     {-0.614839, 0.222451, 0.75663},
                                     {0.662237, -0.437329, 0.608429},
                                     {-0.435869, -0.413395, 0.799451},
                                     {-0.290422, 0.886642, 0.359889},
                                     {-0.628215, -0.27459, 0.727974},
                                     {0.783055, 0.483628, 0.391061},
                                     {-0.46599, -0.659429, -0.589921},
                                     {-0.96489, -0.139979, -0.222248},
                                     {-0.262613, -0.693507, -0.670882},
                                     {-0.941807, 0.283267, -0.180997},
                                     {0.517647, -0.766618, 0.379919},
                                     {0.91527, -0.365825, -0.168683},
                                     {0.880251, 0.267538, -0.391894},
                                     {0.497402, -0.797527, -0.341384},
                                     {-0.201279, 0.268824, -0.941924},
                                     {-0.36178, -0.513064, -0.778383},
                                     {-0.0622299, -0.190018, -0.979806},
                                     {0.920058, -0.313354, 0.235163},
                                     {0.611315, 0.534067, -0.584009},
                                     {-0.900076, -0.0891747, -0.42651},
                                     {-0.488622, 0.841614, 0.230075},
                                     {-0.765284, 0.132044, 0.630004},
                                     {0.0566041, -0.997883, 0.032038},
                                     {0.221663, -0.463196, 0.858088},
                                     {-0.136397, -0.537233, -0.832332},
                                     {0.188996, -0.239227, -0.952392},
                                     {-0.0692875, -0.184642, 0.98036},
                                     {0.324608, -0.767909, 0.552218},
                                     {0.561478, -0.0737953, -0.824195},
                                     {-0.818049, -0.567854, -0.0913143},
                                     {0.977631, -0.0847148, 0.192515},
                                     {0.00137412, -0.957845, 0.287284},
                                     {-0.650958, 0.691099, 0.314063},
                                     {-0.223262, 0.801023, 0.555442},
                                     {-0.773378, 0.500316, 0.38932},
                                     {0.578787, 0.345454, -0.738693},
                                     {0.610163, 0.684089, -0.399654},
                                     {0.32642, -0.806744, -0.492559},
                                     {0.228387, 0.93919, -0.25644},
                                     {0.54976, 0.152703, 0.821246},
                                     {0.678923, 0.438401, 0.588955},
                                     {-0.850488, 0.279179, 0.44579},
                                     {0.0130521, 0.183984, -0.982843},
                                     {-0.566217, 0.17794, -0.804821},
                                     {0.709054, 0.21427, 0.671812},
                                     {0.49716, -0.664111, -0.55838},
                                     {-0.347565, -0.936701, -0.0423009},
                                     {0.17422, 0.333029, -0.926682},
                                     {-0.776182, -0.123523, 0.618291},
                                     {-0.308091, -0.131397, -0.942239},
                                     {-0.530185, -0.835661, -0.14344},
                                     {-0.448458, -0.820814, 0.353766},
                                     {0.26657, 0.717597, 0.643425},
                                     {-0.533719, -0.839756, 0.0997717},
                                     {0.386265, 0.345329, -0.855305},
                                     {-0.0646575, 0.505187, 0.860585},
                                     {0.975145, -0.221327, 0.0103059},
                                     {-0.785106, -0.170651, -0.595388},
                                     {-0.991786, 0.0543184, -0.115802},
                                     {0.94534, 0.0632803, -0.319889},
                                     {0.683011, -0.587613, 0.433828},
                                     {-0.634975, -0.724176, 0.269027},
                                     {0.876185, -0.0834622, -0.474694},
                                     {0.287078, -0.625462, 0.725523},
                                     {-0.395736, 0.661196, 0.637348},
                                     {0.843124, 0.509441, 0.172079},
                                     {-0.468808, 0.8833, -0.000465431},
                                     {-0.947066, 0.172266, 0.270906},
                                     {0.531331, 0.798747, 0.282294},
                                     {-0.0477147, -0.703516, -0.709076},
                                     {-0.435629, 0.300855, 0.848359},
                                     {-0.293093, 0.947852, 0.12519},
                                     {0.609435, -0.792271, 0.029926},
                                     {-0.40416, 0.89042, -0.209302},
                                     {0.104886, 0.622757, 0.775353},
                                     {0.13811, -0.884292, 0.446042},
                                     {-0.531316, 0.462603, 0.709719},
                                     {-0.0749454, 0.0546115, 0.995691},
                                     {-0.307886, -0.782869, 0.540668},
                                     {-0.145564, 0.832899, -0.533938},
                                     {-0.734822, -0.395011, -0.551364},
                                     {-0.892592, 0.45057, -0.0163148},
                                     {-0.611459, 0.774063, -0.164148},
                                     {0.313613, -0.644045, -0.697749},
                                     {0.286015, -0.957831, -0.0274987},
                                     {-0.149122, -0.981781, 0.117763},
                                     {0.656373, -0.718632, 0.229658},
                                     {-0.844891, 0.464422, -0.265466},
                                     {0.316523, -0.132894, 0.93923},
                                     {0.998767, 0.00915237, -0.0487939},
                                     {-0.724761, 0.251606, -0.641417},
                                     {0.773361, -0.209935, 0.598197},
                                     {0.124979, -0.0345928, 0.991556},
                                     {0.703937, 0.671213, 0.232264},
                                     {0.244363, 0.69386, -0.677381}};

double NOISE_TABLES<4>::g[514][4] = {{0.3966, 0.564479, 0.423247, 0.58731},
                                     {0.207686, 0.293048, -0.883543, -0.300569},
                                     {-0.145433, 0.307846, 0.936414, 0.0849082},
                                     {0.666268, 0.207833, 0.44005, -0.565021},
                                     {0.652951, -0.00227182, -0.588353, 0.47696},
                                     {0.221574, -0.823315, -0.367396, 0.371587},
                                     {-0.236882, -0.955985, 0.167044, -0.0455716},
                                     {-0.781451, -0.438422, 0.313148, 0.314737},
                                     {-0.225926, 0.956158, 0.150141, -0.110349},
                                     {-0.833293, -0.363813, 0.309378, -0.278475},
                                     {-0.873073, 0.00211995, 0.423987, 0.240777},
                                     {0.306914, -0.7367, 0.21705, -0.562109},
                                     {0.682326, -0.374178, -0.322874, 0.53868},
                                     {-0.192218, 0.2844, -0.00210586, -0.939236},
                                     {-0.544339, 0.512692, -0.534324, -0.394132},
                                     {0.284116, -0.183261, -0.728104, 0.596288},
                                     {0.183594, -0.932705, 0.254254, -0.17807},
                                     {-0.64169, -0.205595, 0.301285, -0.674679},
                                     {0.148202, -0.240829, 0.587807, 0.757972},
                                     {0.449893, -0.145313, 0.618109, -0.628029},
                                     {0.10435, 0.241438, -0.73631, 0.623431},
                                     {0.322788, 0.0994767, -0.00434734, 0.941219},
                                     {0.422486, -0.629475, -0.442919, -0.478632},
                                     {0.385144, 0.483074, -0.784525, 0.053138},
                                     {0.42928, -0.128703, -0.366779, 0.815247},
                                     {0.489462, 0.157652, 0.785911, -0.34339},
                                     {-0.214972, 0.700646, -0.0211753, -0.680025},
                                     {0.35655, -0.209979, 0.897849, -0.150495},
                                     {-0.076423, 0.836021, 0.527187, 0.13154},
                                     {-0.923646, 0.0314742, -0.327382, 0.196745},
                                     {-0.448991, 0.87173, -0.154501, 0.120931},
                                     {0.977875, -0.149525, -0.134619, -0.0572834},
                                     {0.250627, 0.508589, -0.596248, -0.568342},
                                     {0.721136, -0.602061, 0.291308, 0.180621},
                                     {-0.556466, -0.167224, 0.679021, -0.44868},
                                     {-0.425316, -0.637457, -0.379061, -0.518718},
                                     {-0.384742, 0.142519, 0.87612, -0.253133},
                                     {-0.637148, -0.481892, -0.600691, 0.0315185},
                                     {0.501334, 0.857258, -0.11734, 0.0022026},
                                     {0.917651, 0.0368148, 0.18608, -0.349192},
                                     {0.715984, 0.499081, 0.428469, 0.233879},
                                     {-0.33469, -0.463351, 0.814315, 0.10089},
                                     {-0.0108647, -0.646727, -0.55418, -0.523937},
                                     {0.814467, 0.57796, 0.0439751, 0.0259406},
                                     {0.176981, -0.459889, 0.852448, 0.174677},
                                     {-0.594521, 0.2006, 0.479296, -0.613661},
                                     {-0.296544, -0.66192, -0.660758, -0.193188},
                                     {0.552435, 0.0238813, -0.828288, -0.0904599},
                                     {0.81773, 0.3791, 0.0550689, 0.429614},
                                     {0.186315, 0.227278, 0.695315, -0.655872},
                                     {0.575947, -0.537464, 0.184169, 0.587791},
                                     {0.471377, 0.475964, 0.17765, -0.720904},
                                     {-0.613022, 0.153936, 0.760917, 0.146672},
                                     {0.297196, -0.313326, 0.187985, 0.882136},
                                     {-0.898109, -0.12216, 0.0316785, 0.421277},
                                     {0.251227, -0.515579, -0.441395, 0.690097},
                                     {-0.816822, 0.275739, -0.490435, -0.127453},
                                     {-0.0536727, -0.0294697, -0.348803, -0.935194},
                                     {0.416032, 0.528296, -0.0170906, 0.739951},
                                     {-0.529771, -0.32045, -0.692976, -0.369376},
                                     {-0.640762, -0.161788, 0.316987, 0.680271},
                                     {0.0064156, -0.427237, -0.135966, 0.893835},
                                     {-0.617571, -0.254647, -0.354157, -0.654472},
                                     {-0.481219, -0.78939, 0.257056, 0.28145},
                                     {-0.460855, 0.420169, -0.266908, -0.734732},
                                     {-0.324338, 0.505725, 0.709785, 0.367766},
                                     {-0.867004, -0.130448, -0.0277134, -0.480124},
                                     {-0.433253, 0.617241, -0.483873, 0.444042},
                                     {-0.725647, -0.22864, 0.647887, -0.0374377},
                                     {0.573867, -0.621648, -0.48646, 0.218145},
                                     {-0.846039, -0.157257, -0.449647, -0.239386},
                                     {-0.812685, 0.527575, 0.221465, -0.11028},
                                     {0.487958, -0.197467, -0.163563, -0.834356},
                                     {-0.187005, 0.457608, 0.734737, -0.464528},
                                     {0.903127, -0.216889, 0.0404167, 0.368357},
                                     {0.369741, 0.120311, -0.868549, 0.30731},
                                     {-0.173836, -0.270056, -0.697615, -0.640456},
                                     {0.0141874, -0.0217574, -0.32394, 0.945721},
                                     {0.278108, 0.316916, -0.380316, 0.823152},
                                     {0.556537, 0.736762, 0.108059, 0.368473},
                                     {-0.706484, -0.0525948, -0.699774, 0.0918124},
                                     {0.970553, 0.167163, 0.155321, 0.0771967},
                                     {0.799861, 0.0880928, 0.441702, 0.396688},
                                     {-0.940329, 0.274188, 0.0514292, 0.194827},
                                     {0.112483, -0.984542, -0.126443, 0.0451367},
                                     {-0.883989, -0.393168, -0.238698, 0.0837004},
                                     {0.754818, -0.131129, 0.567742, -0.301204},
                                     {-0.552476, 0.120932, -0.761782, -0.315964},
                                     {0.8378, -0.192508, -0.171916, -0.48112},
                                     {0.89415, -0.210934, 0.387082, 0.0785524},
                                     {0.0622882, 0.1887, 0.934266, -0.296073},
                                     {-0.409742, 0.185908, 0.27674, 0.849096},
                                     {-0.476167, -0.600529, -0.487339, 0.418487},
                                     {-0.316251, 0.0188809, 0.335442, -0.887191},
                                     {0.232989, -0.717448, -0.0349111, 0.655565},
                                     {0.597784, 0.21959, 0.254963, 0.727618},
                                     {-0.601204, -0.223947, 0.657606, 0.394913},
                                     {-0.283001, -0.348646, 0.530459, -0.719007},
                                     {-0.0217517, -0.391103, -0.883317, -0.25752},
                                     {-0.28506, -0.119544, 0.588338, 0.747201},
                                     {0.913283, 0.107572, -0.262486, 0.292309},
                                     {0.276777, 0.189932, 0.568026, 0.751443},
                                     {0.809873, 0.290422, 0.487329, -0.149233},
                                     {0.669484, 0.0268262, 0.738559, 0.0748527},
                                     {0.625212, -0.566228, -0.0501739, -0.534769},
                                     {-0.417575, -0.527939, 0.455064, 0.582948},
                                     {0.141708, -0.0501356, -0.987945, -0.0370026},
                                     {0.230493, -0.587281, -0.152535, -0.760728},
                                     {-0.693449, 0.529716, 0.00843522, -0.488321},
                                     {-0.514916, 0.67448, 0.377116, -0.37111},
                                     {0.0721797, -0.204176, 0.841643, -0.494712},
                                     {0.62109, -0.437169, 0.650406, -0.0101057},
                                     {0.221762, 0.655354, -0.150918, -0.706085},
                                     {-0.0418541, 0.69175, 0.464089, 0.55168},
                                     {-0.392686, -0.142914, -0.0771214, -0.905221},
                                     {-0.499222, -0.516884, 0.00997627, -0.695348},
                                     {-0.132351, -0.397851, 0.289778, 0.860364},
                                     {-0.116953, 0.859767, -0.277326, 0.412569},
                                     {-0.420042, 0.717699, -0.555292, -0.0110998},
                                     {0.498195, -0.293886, -0.785358, 0.22056},
                                     {-0.130403, -0.706956, -0.312377, 0.62099},
                                     {0.0628368, 0.136674, 0.861757, 0.484507},
                                     {0.697412, -0.228603, 0.250549, -0.631334},
                                     {-0.41447, -0.304384, -0.369856, 0.773803},
                                     {-0.739257, 0.430684, 0.448312, 0.258895},
                                     {0.707515, 0.161745, -0.0388176, -0.686844},
                                     {-0.150637, -0.804078, -0.542715, 0.190335},
                                     {-0.334267, 0.0266575, -0.940638, 0.05248},
                                     {-0.0128381, 0.32431, -0.924373, 0.200482},
                                     {0.298876, -0.128842, -0.842588, -0.42909},
                                     {0.681684, 0.5947, -0.295622, 0.306997},
                                     {0.563868, -0.182781, 0.449858, 0.668036},
                                     {0.923849, 0.275927, -0.192935, -0.182051},
                                     {-0.144332, 0.0252123, -0.9134, -0.379782},
                                     {0.500583, 0.462126, 0.731835, -0.0165344},
                                     {0.783017, 0.458745, 0.125446, -0.400876},
                                     {0.285519, 0.810783, -0.498437, 0.112568},
                                     {0.830314, -0.0288258, -0.507055, -0.22944},
                                     {-0.881805, 0.0807794, 0.336043, -0.32089},
                                     {-0.104195, 0.80065, 0.498675, -0.315319},
                                     {0.0863339, 0.449352, 0.265859, 0.848498},
                                     {-0.346937, 0.200739, -0.442646, 0.802124},
                                     {-0.139349, -0.118364, -0.668803, 0.720607},
                                     {-0.0382987, 0.404686, -0.391262, -0.825637},
                                     {0.0558261, 0.915931, -0.0524622, -0.393956},
                                     {-0.0963122, -0.5074, -0.696057, 0.498773},
                                     {-0.651087, 0.161344, 0.0492618, -0.740018},
                                     {-0.753608, 0.156929, -0.350541, -0.53345},
                                     {0.0772411, -0.115201, 0.505355, -0.851692},
                                     {-0.234778, 0.675125, -0.00839805, 0.699296},
                                     {0.591905, -0.230435, -0.540421, -0.551809},
                                     {-0.314978, 0.193376, -0.796097, 0.479191},
                                     {0.0899122, 0.585199, 0.793914, -0.138417},
                                     {0.362748, 0.767312, 0.492388, 0.192875},
                                     {-0.513788, -0.605397, 0.388027, -0.467923},
                                     {-0.579922, 0.371073, -0.703691, 0.175536},
                                     {-0.518207, 0.769929, 0.363265, 0.0819105},
                                     {-0.404626, 0.834503, -0.179128, -0.328323},
                                     {-0.491739, -0.801317, 0.0039489, -0.340689},
                                     {-0.16205, 0.304384, -0.0690012, 0.936125},
                                     {0.277272, 0.154124, 0.943307, 0.0976609},
                                     {0.823632, -0.25152, -0.48221, 0.160753},
                                     {-0.165263, -0.448625, -0.302819, -0.824454},
                                     {-0.229479, 0.0553714, 0.712654, -0.660605},
                                     {-0.18919, -0.905954, -0.29718, -0.234815},
                                     {-0.235521, 0.891597, 0.170089, 0.347354},
                                     {0.432232, 0.0566435, 0.251762, -0.86405},
                                     {-0.251848, -0.473755, 0.764748, -0.356776},
                                     {0.118396, 0.719541, 0.275706, -0.626283},
                                     {0.167366, -0.904479, 0.214395, 0.328543},
                                     {-0.752118, -0.273176, -0.362227, 0.478001},
                                     {-0.124596, -0.40576, 0.760569, 0.491293},
                                     {-0.0827556, -0.186714, 0.974415, -0.0938402},
                                     {0.152124, 0.820868, 0.079178, 0.544761},
                                     {0.521831, -0.796874, -0.0406404, 0.301716},
                                     {-0.107772, -0.79673, 0.356639, -0.47583},
                                     {-0.282502, -0.407823, -0.859924, 0.120017},
                                     {-0.549686, -0.7863, -0.282029, 0.00605861},
                                     {-0.455303, 0.553854, 0.351687, 0.601881},
                                     {-0.0239912, 0.659488, -0.664518, 0.350594},
                                     {0.0581978, 0.669567, -0.710906, -0.20714},
                                     {0.590643, -0.75143, 0.202333, -0.213436},
                                     {-0.582665, 0.437274, -0.166569, 0.664491},
                                     {0.73719, 0.28539, -0.598939, 0.127968},
                                     {0.476506, 0.411229, -0.600336, 0.493386},
                                     {-0.144859, -0.77094, -0.0684603, -0.616425},
                                     {0.211188, -0.886245, -0.155185, -0.381953},
                                     {0.293755, 0.725368, -0.336643, 0.523661},
                                     {0.333981, 0.802013, -0.378939, -0.318805},
                                     {-0.0847942, 0.557028, -0.415693, 0.713953},
                                     {-0.480506, -0.217267, -0.72165, 0.448475},
                                     {0.138476, -0.562358, -0.804054, 0.134448},
                                     {0.326335, -0.379109, 0.227467, -0.835488},
                                     {0.347074, 0.576619, 0.588744, -0.447695},
                                     {-0.582098, -0.632204, 0.509717, -0.0408605},
                                     {0.17048, -0.816078, -0.534754, -0.137812},
                                     {0.236625, 0.91684, 0.282418, -0.153799},
                                     {0.09755, 0.347047, 0.33001, -0.872431},
                                     {0.282442, -0.774077, 0.558413, 0.0959496},
                                     {0.605938, 0.679424, 0.380906, -0.161656},
                                     {0.607551, 0.508538, -0.269046, -0.547618},
                                     {-0.674865, 0.645797, 0.0633188, 0.351418},
                                     {0.686316, 0.592474, -0.401118, -0.130572},
                                     {0.824402, -0.536749, -0.13702, 0.116129},
                                     {0.664881, 0.206143, -0.242747, 0.675657},
                                     {0.121442, 0.539656, 0.773081, 0.310434},
                                     {-0.259371, -0.91246, -0.131031, 0.288053},
                                     {-0.479147, -0.473136, 0.0407929, 0.738171},
                                     {-0.988997, -0.118559, 0.0869354, -0.0164336},
                                     {0.654787, -0.156903, 0.0152464, 0.739191},
                                     {-0.178412, 0.398846, -0.714787, -0.54605},
                                     {-0.553813, 0.187505, 0.589564, 0.557268},
                                     {0.60236, 0.307484, -0.633372, -0.376108},
                                     {0.162858, -0.633189, 0.401326, 0.641472},
                                     {0.404143, -0.137226, 0.816029, 0.389787},
                                     {0.494529, 0.152378, -0.431805, -0.73876},
                                     {0.864593, -0.40003, 0.158965, -0.2592},
                                     {-0.16913, -0.784426, 0.589029, -0.0954786},
                                     {0.492717, 0.292249, 0.715538, 0.399782},
                                     {-0.153812, 0.313327, 0.599478, 0.720273},
                                     {-0.7547, 0.242425, 0.191, 0.578945},
                                     {0.062637, -0.0843262, 0.0788559, -0.991336},
                                     {-0.669503, 0.136757, -0.526071, 0.506273},
                                     {0.47891, -0.514986, 0.583609, 0.405999},
                                     {-0.657984, 0.000454589, -0.138546, 0.740177},
                                     {0.210304, -0.313976, -0.509264, -0.773202},
                                     {-0.769058, -0.5088, -0.195983, -0.333562},
                                     {0.266989, 0.264362, -0.107222, -0.920507},
                                     {-0.939282, 0.237949, -0.0730232, -0.236213},
                                     {0.752746, -0.461731, -0.411838, -0.224874},
                                     {-0.6754, 0.356672, 0.607108, -0.219181},
                                     {0.547087, -0.797894, -0.229937, -0.105783},
                                     {0.16953, -0.586082, 0.753246, -0.245741},
                                     {-0.281731, -0.0694107, 0.912762, 0.287533},
                                     {0.118704, 0.111371, -0.675153, -0.719496},
                                     {-0.288969, 0.425292, -0.847561, -0.131391},
                                     {-0.125155, -0.765708, 0.526488, 0.347617},
                                     {-0.297342, -0.1225, -0.0152089, 0.946758},
                                     {-0.783263, 0.450131, -0.321386, 0.283888},
                                     {-0.296458, 0.500393, 0.371153, -0.723854},
                                     {0.518157, -0.52786, 0.525683, -0.42016},
                                     {-0.110051, -0.470855, 0.159525, -0.86066},
                                     {-0.683128, -0.613667, -0.0893266, 0.385708},
                                     {-0.407913, 0.0819627, -0.561403, -0.715344},
                                     {-0.753685, -0.650154, 0.0946762, -0.0172123},
                                     {-0.0939369, 0.736528, -0.425184, -0.517611},
                                     {0.103569, 0.9843, -0.0230777, 0.141048},
                                     {0.127728, -0.513648, 0.555166, -0.641593},
                                     {0.434096, -0.469744, -0.745669, -0.186756},
                                     {-0.0425633, -0.12077, -0.923236, 0.362269},
                                     {0.47616, 0.77633, 0.0392142, -0.411152},
                                     {-0.177387, -0.763558, 0.13944, 0.605036},
                                     {-0.347184, 0.604497, 0.713482, -0.070643},
                                     {0.00423816, 0.0210573, 0.311046, 0.950152},
                                     {-0.0738423, 0.920237, -0.370337, -0.102767},
                                     {-0.739379, 0.626192, -0.219025, -0.115026},
                                     {0.3966, 0.564479, 0.423247, 0.58731},
                                     {0.207686, 0.293048, -0.883543, -0.300569},
                                     {-0.145433, 0.307846, 0.936414, 0.0849082},
                                     {0.666268, 0.207833, 0.44005, -0.565021},
                                     {0.652951, -0.00227182, -0.588353, 0.47696},
                                     {0.221574, -0.823315, -0.367396, 0.371587},
                                     {-0.236882, -0.955985, 0.167044, -0.0455716},
                                     {-0.781451, -0.438422, 0.313148, 0.314737},
                                     {-0.225926, 0.956158, 0.150141, -0.110349},
                                     {-0.833293, -0.363813, 0.309378, -0.278475},
                                     {-0.873073, 0.00211995, 0.423987, 0.240777},
                                     {0.306914, -0.7367, 0.21705, -0.562109},
                                     {0.682326, -0.374178, -0.322874, 0.53868},
                                     {-0.192218, 0.2844, -0.00210586, -0.939236},
                                     {-0.544339, 0.512692, -0.534324, -0.394132},
                                     {0.284116, -0.183261, -0.728104, 0.596288},
                                     {0.183594, -0.932705, 0.254254, -0.17807},
                                     {-0.64169, -0.205595, 0.301285, -0.674679},
                                     {0.148202, -0.240829, 0.587807, 0.757972},
                                     {0.449893, -0.145313, 0.618109, -0.628029},
                                     {0.10435, 0.241438, -0.73631, 0.623431},
                                     {0.322788, 0.0994767, -0.00434734, 0.941219},
                                     {0.422486, -0.629475, -0.442919, -0.478632},
                                     {0.385144, 0.483074, -0.784525, 0.053138},
                                     {0.42928, -0.128703, -0.366779, 0.815247},
                                     {0.489462, 0.157652, 0.785911, -0.34339},
                                     {-0.214972, 0.700646, -0.0211753, -0.680025},
                                     {0.35655, -0.209979, 0.897849, -0.150495},
                                     {-0.076423, 0.836021, 0.527187, 0.13154},
                                     {-0.923646, 0.0314742, -0.327382, 0.196745},
                                     {-0.448991, 0.87173, -0.154501, 0.120931},
                                     {0.977875, -0.149525, -0.134619, -0.0572834},
                                     {0.250627, 0.508589, -0.596248, -0.568342},
                                     {0.721136, -0.602061, 0.291308, 0.180621},
                                     {-0.556466, -0.167224, 0.679021, -0.44868},
                                     {-0.425316, -0.637457, -0.379061, -0.518718},
                                     {-0.384742, 0.142519, 0.87612, -0.253133},
                                     {-0.637148, -0.481892, -0.600691, 0.0315185},
                                     {0.501334, 0.857258, -0.11734, 0.0022026},
                                     {0.917651, 0.0368148, 0.18608, -0.349192},
                                     {0.715984, 0.499081, 0.428469, 0.233879},
                                     {-0.33469, -0.463351, 0.814315, 0.10089},
                                     {-0.0108647, -0.646727, -0.55418, -0.523937},
                                     {0.814467, 0.57796, 0.0439751, 0.0259406},
                                     {0.176981, -0.459889, 0.852448, 0.174677},
                                     {-0.594521, 0.2006, 0.479296, -0.613661},
                                     {-0.296544, -0.66192, -0.660758, -0.193188},
                                     {0.552435, 0.0238813, -0.828288, -0.0904599},
                                     {0.81773, 0.3791, 0.0550689, 0.429614},
                                     {0.186315, 0.227278, 0.695315, -0.655872},
                                     {0.575947, -0.537464, 0.184169, 0.587791},
                                     {0.471377, 0.475964, 0.17765, -0.720904},
                                     {-0.613022, 0.153936, 0.760917, 0.146672},
                                     {0.297196, -0.313326, 0.187985, 0.882136},
                                     {-0.898109, -0.12216, 0.0316785, 0.421277},
                                     {0.251227, -0.515579, -0.441395, 0.690097},
                                     {-0.816822, 0.275739, -0.490435, -0.127453},
                                     {-0.0536727, -0.0294697, -0.348803, -0.935194},
                                     {0.416032, 0.528296, -0.0170906, 0.739951},
                                     {-0.529771, -0.32045, -0.692976, -0.369376},
                                     {-0.640762, -0.161788, 0.316987, 0.680271},
                                     {0.0064156, -0.427237, -0.135966, 0.893835},
                                     {-0.617571, -0.254647, -0.354157, -0.654472},
                                     {-0.481219, -0.78939, 0.257056, 0.28145},
                                     {-0.460855, 0.420169, -0.266908, -0.734732},
                                     {-0.324338, 0.505725, 0.709785, 0.367766},
                                     {-0.867004, -0.130448, -0.0277134, -0.480124},
                                     {-0.433253, 0.617241, -0.483873, 0.444042},
                                     {-0.725647, -0.22864, 0.647887, -0.0374377},
                                     {0.573867, -0.621648, -0.48646, 0.218145},
                                     {-0.846039, -0.157257, -0.449647, -0.239386},
                                     {-0.812685, 0.527575, 0.221465, -0.11028},
                                     {0.487958, -0.197467, -0.163563, -0.834356},
                                     {-0.187005, 0.457608, 0.734737, -0.464528},
                                     {0.903127, -0.216889, 0.0404167, 0.368357},
                                     {0.369741, 0.120311, -0.868549, 0.30731},
                                     {-0.173836, -0.270056, -0.697615, -0.640456},
                                     {0.0141874, -0.0217574, -0.32394, 0.945721},
                                     {0.278108, 0.316916, -0.380316, 0.823152},
                                     {0.556537, 0.736762, 0.108059, 0.368473},
                                     {-0.706484, -0.0525948, -0.699774, 0.0918124},
                                     {0.970553, 0.167163, 0.155321, 0.0771967},
                                     {0.799861, 0.0880928, 0.441702, 0.396688},
                                     {-0.940329, 0.274188, 0.0514292, 0.194827},
                                     {0.112483, -0.984542, -0.126443, 0.0451367},
                                     {-0.883989, -0.393168, -0.238698, 0.0837004},
                                     {0.754818, -0.131129, 0.567742, -0.301204},
                                     {-0.552476, 0.120932, -0.761782, -0.315964},
                                     {0.8378, -0.192508, -0.171916, -0.48112},
                                     {0.89415, -0.210934, 0.387082, 0.0785524},
                                     {0.0622882, 0.1887, 0.934266, -0.296073},
                                     {-0.409742, 0.185908, 0.27674, 0.849096},
                                     {-0.476167, -0.600529, -0.487339, 0.418487},
                                     {-0.316251, 0.0188809, 0.335442, -0.887191},
                                     {0.232989, -0.717448, -0.0349111, 0.655565},
                                     {0.597784, 0.21959, 0.254963, 0.727618},
                                     {-0.601204, -0.223947, 0.657606, 0.394913},
                                     {-0.283001, -0.348646, 0.530459, -0.719007},
                                     {-0.0217517, -0.391103, -0.883317, -0.25752},
                                     {-0.28506, -0.119544, 0.588338, 0.747201},
                                     {0.913283, 0.107572, -0.262486, 0.292309},
                                     {0.276777, 0.189932, 0.568026, 0.751443},
                                     {0.809873, 0.290422, 0.487329, -0.149233},
                                     {0.669484, 0.0268262, 0.738559, 0.0748527},
                                     {0.625212, -0.566228, -0.0501739, -0.534769},
                                     {-0.417575, -0.527939, 0.455064, 0.582948},
                                     {0.141708, -0.0501356, -0.987945, -0.0370026},
                                     {0.230493, -0.587281, -0.152535, -0.760728},
                                     {-0.693449, 0.529716, 0.00843522, -0.488321},
                                     {-0.514916, 0.67448, 0.377116, -0.37111},
                                     {0.0721797, -0.204176, 0.841643, -0.494712},
                                     {0.62109, -0.437169, 0.650406, -0.0101057},
                                     {0.221762, 0.655354, -0.150918, -0.706085},
                                     {-0.0418541, 0.69175, 0.464089, 0.55168},
                                     {-0.392686, -0.142914, -0.0771214, -0.905221},
                                     {-0.499222, -0.516884, 0.00997627, -0.695348},
                                     {-0.132351, -0.397851, 0.289778, 0.860364},
                                     {-0.116953, 0.859767, -0.277326, 0.412569},
                                     {-0.420042, 0.717699, -0.555292, -0.0110998},
                                     {0.498195, -0.293886, -0.785358, 0.22056},
                                     {-0.130403, -0.706956, -0.312377, 0.62099},
                                     {0.0628368, 0.136674, 0.861757, 0.484507},
                                     {0.697412, -0.228603, 0.250549, -0.631334},
                                     {-0.41447, -0.304384, -0.369856, 0.773803},
                                     {-0.739257, 0.430684, 0.448312, 0.258895},
                                     {0.707515, 0.161745, -0.0388176, -0.686844},
                                     {-0.150637, -0.804078, -0.542715, 0.190335},
                                     {-0.334267, 0.0266575, -0.940638, 0.05248},
                                     {-0.0128381, 0.32431, -0.924373, 0.200482},
                                     {0.298876, -0.128842, -0.842588, -0.42909},
                                     {0.681684, 0.5947, -0.295622, 0.306997},
                                     {0.563868, -0.182781, 0.449858, 0.668036},
                                     {0.923849, 0.275927, -0.192935, -0.182051},
                                     {-0.144332, 0.0252123, -0.9134, -0.379782},
                                     {0.500583, 0.462126, 0.731835, -0.0165344},
                                     {0.783017, 0.458745, 0.125446, -0.400876},
                                     {0.285519, 0.810783, -0.498437, 0.112568},
                                     {0.830314, -0.0288258, -0.507055, -0.22944},
                                     {-0.881805, 0.0807794, 0.336043, -0.32089},
                                     {-0.104195, 0.80065, 0.498675, -0.315319},
                                     {0.0863339, 0.449352, 0.265859, 0.848498},
                                     {-0.346937, 0.200739, -0.442646, 0.802124},
                                     {-0.139349, -0.118364, -0.668803, 0.720607},
                                     {-0.0382987, 0.404686, -0.391262, -0.825637},
                                     {0.0558261, 0.915931, -0.0524622, -0.393956},
                                     {-0.0963122, -0.5074, -0.696057, 0.498773},
                                     {-0.651087, 0.161344, 0.0492618, -0.740018},
                                     {-0.753608, 0.156929, -0.350541, -0.53345},
                                     {0.0772411, -0.115201, 0.505355, -0.851692},
                                     {-0.234778, 0.675125, -0.00839805, 0.699296},
                                     {0.591905, -0.230435, -0.540421, -0.551809},
                                     {-0.314978, 0.193376, -0.796097, 0.479191},
                                     {0.0899122, 0.585199, 0.793914, -0.138417},
                                     {0.362748, 0.767312, 0.492388, 0.192875},
                                     {-0.513788, -0.605397, 0.388027, -0.467923},
                                     {-0.579922, 0.371073, -0.703691, 0.175536},
                                     {-0.518207, 0.769929, 0.363265, 0.0819105},
                                     {-0.404626, 0.834503, -0.179128, -0.328323},
                                     {-0.491739, -0.801317, 0.0039489, -0.340689},
                                     {-0.16205, 0.304384, -0.0690012, 0.936125},
                                     {0.277272, 0.154124, 0.943307, 0.0976609},
                                     {0.823632, -0.25152, -0.48221, 0.160753},
                                     {-0.165263, -0.448625, -0.302819, -0.824454},
                                     {-0.229479, 0.0553714, 0.712654, -0.660605},
                                     {-0.18919, -0.905954, -0.29718, -0.234815},
                                     {-0.235521, 0.891597, 0.170089, 0.347354},
                                     {0.432232, 0.0566435, 0.251762, -0.86405},
                                     {-0.251848, -0.473755, 0.764748, -0.356776},
                                     {0.118396, 0.719541, 0.275706, -0.626283},
                                     {0.167366, -0.904479, 0.214395, 0.328543},
                                     {-0.752118, -0.273176, -0.362227, 0.478001},
                                     {-0.124596, -0.40576, 0.760569, 0.491293},
                                     {-0.0827556, -0.186714, 0.974415, -0.0938402},
                                     {0.152124, 0.820868, 0.079178, 0.544761},
                                     {0.521831, -0.796874, -0.0406404, 0.301716},
                                     {-0.107772, -0.79673, 0.356639, -0.47583},
                                     {-0.282502, -0.407823, -0.859924, 0.120017},
                                     {-0.549686, -0.7863, -0.282029, 0.00605861},
                                     {-0.455303, 0.553854, 0.351687, 0.601881},
                                     {-0.0239912, 0.659488, -0.664518, 0.350594},
                                     {0.0581978, 0.669567, -0.710906, -0.20714},
                                     {0.590643, -0.75143, 0.202333, -0.213436},
                                     {-0.582665, 0.437274, -0.166569, 0.664491},
                                     {0.73719, 0.28539, -0.598939, 0.127968},
                                     {0.476506, 0.411229, -0.600336, 0.493386},
                                     {-0.144859, -0.77094, -0.0684603, -0.616425},
                                     {0.211188, -0.886245, -0.155185, -0.381953},
                                     {0.293755, 0.725368, -0.336643, 0.523661},
                                     {0.333981, 0.802013, -0.378939, -0.318805},
                                     {-0.0847942, 0.557028, -0.415693, 0.713953},
                                     {-0.480506, -0.217267, -0.72165, 0.448475},
                                     {0.138476, -0.562358, -0.804054, 0.134448},
                                     {0.326335, -0.379109, 0.227467, -0.835488},
                                     {0.347074, 0.576619, 0.588744, -0.447695},
                                     {-0.582098, -0.632204, 0.509717, -0.0408605},
                                     {0.17048, -0.816078, -0.534754, -0.137812},
                                     {0.236625, 0.91684, 0.282418, -0.153799},
                                     {0.09755, 0.347047, 0.33001, -0.872431},
                                     {0.282442, -0.774077, 0.558413, 0.0959496},
                                     {0.605938, 0.679424, 0.380906, -0.161656},
                                     {0.607551, 0.508538, -0.269046, -0.547618},
                                     {-0.674865, 0.645797, 0.0633188, 0.351418},
                                     {0.686316, 0.592474, -0.401118, -0.130572},
                                     {0.824402, -0.536749, -0.13702, 0.116129},
                                     {0.664881, 0.206143, -0.242747, 0.675657},
                                     {0.121442, 0.539656, 0.773081, 0.310434},
                                     {-0.259371, -0.91246, -0.131031, 0.288053},
                                     {-0.479147, -0.473136, 0.0407929, 0.738171},
                                     {-0.988997, -0.118559, 0.0869354, -0.0164336},
                                     {0.654787, -0.156903, 0.0152464, 0.739191},
                                     {-0.178412, 0.398846, -0.714787, -0.54605},
                                     {-0.553813, 0.187505, 0.589564, 0.557268},
                                     {0.60236, 0.307484, -0.633372, -0.376108},
                                     {0.162858, -0.633189, 0.401326, 0.641472},
                                     {0.404143, -0.137226, 0.816029, 0.389787},
                                     {0.494529, 0.152378, -0.431805, -0.73876},
                                     {0.864593, -0.40003, 0.158965, -0.2592},
                                     {-0.16913, -0.784426, 0.589029, -0.0954786},
                                     {0.492717, 0.292249, 0.715538, 0.399782},
                                     {-0.153812, 0.313327, 0.599478, 0.720273},
                                     {-0.7547, 0.242425, 0.191, 0.578945},
                                     {0.062637, -0.0843262, 0.0788559, -0.991336},
                                     {-0.669503, 0.136757, -0.526071, 0.506273},
                                     {0.47891, -0.514986, 0.583609, 0.405999},
                                     {-0.657984, 0.000454589, -0.138546, 0.740177},
                                     {0.210304, -0.313976, -0.509264, -0.773202},
                                     {-0.769058, -0.5088, -0.195983, -0.333562},
                                     {0.266989, 0.264362, -0.107222, -0.920507},
                                     {-0.939282, 0.237949, -0.0730232, -0.236213},
                                     {0.752746, -0.461731, -0.411838, -0.224874},
                                     {-0.6754, 0.356672, 0.607108, -0.219181},
                                     {0.547087, -0.797894, -0.229937, -0.105783},
                                     {0.16953, -0.586082, 0.753246, -0.245741},
                                     {-0.281731, -0.0694107, 0.912762, 0.287533},
                                     {0.118704, 0.111371, -0.675153, -0.719496},
                                     {-0.288969, 0.425292, -0.847561, -0.131391},
                                     {-0.125155, -0.765708, 0.526488, 0.347617},
                                     {-0.297342, -0.1225, -0.0152089, 0.946758},
                                     {-0.783263, 0.450131, -0.321386, 0.283888},
                                     {-0.296458, 0.500393, 0.371153, -0.723854},
                                     {0.518157, -0.52786, 0.525683, -0.42016},
                                     {-0.110051, -0.470855, 0.159525, -0.86066},
                                     {-0.683128, -0.613667, -0.0893266, 0.385708},
                                     {-0.407913, 0.0819627, -0.561403, -0.715344},
                                     {-0.753685, -0.650154, 0.0946762, -0.0172123},
                                     {-0.0939369, 0.736528, -0.425184, -0.517611},
                                     {0.103569, 0.9843, -0.0230777, 0.141048},
                                     {0.127728, -0.513648, 0.555166, -0.641593},
                                     {0.434096, -0.469744, -0.745669, -0.186756},
                                     {-0.0425633, -0.12077, -0.923236, 0.362269},
                                     {0.47616, 0.77633, 0.0392142, -0.411152},
                                     {-0.177387, -0.763558, 0.13944, 0.605036},
                                     {-0.347184, 0.604497, 0.713482, -0.070643},
                                     {0.00423816, 0.0210573, 0.311046, 0.950152},
                                     {-0.0738423, 0.920237, -0.370337, -0.102767},
                                     {-0.739379, 0.626192, -0.219025, -0.115026},
                                     {0.3966, 0.564479, 0.423247, 0.58731},
                                     {0.207686, 0.293048, -0.883543, -0.300569}};

#endif
