/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.BaseModelMBean;
import org.apache.tomcat.util.modeler.NotificationInfo;
import org.apache.tomcat.util.modeler.OperationInfo;
import org.apache.tomcat.util.modeler.ParameterInfo;

public class ManagedBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String BASE_MBEAN = "org.apache.tomcat.util.modeler.BaseModelMBean";
    static final Object[] NO_ARGS_PARAM = new Object[0];
    static final Class<?>[] NO_ARGS_PARAM_SIG = new Class[0];
    private final ReadWriteLock mBeanInfoLock = new ReentrantReadWriteLock();
    transient MBeanInfo info = null;
    private Map<String, AttributeInfo> attributes = new HashMap<String, AttributeInfo>();
    private Map<String, OperationInfo> operations = new HashMap<String, OperationInfo>();
    protected String className = "org.apache.tomcat.util.modeler.BaseModelMBean";
    protected String description = null;
    protected String domain = null;
    protected String group = null;
    protected String name = null;
    protected NotificationInfo[] notifications = new NotificationInfo[0];
    protected String type = null;

    public ManagedBean() {
        AttributeInfo attributeInfo = new AttributeInfo();
        attributeInfo.setName("modelerType");
        attributeInfo.setDescription("Type of the modeled resource. Can be set only once");
        attributeInfo.setType("java.lang.String");
        attributeInfo.setWriteable(false);
        this.addAttribute(attributeInfo);
    }

    public AttributeInfo[] getAttributes() {
        AttributeInfo[] attributeInfoArray = new AttributeInfo[this.attributes.size()];
        this.attributes.values().toArray(attributeInfoArray);
        return attributeInfoArray;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        Lock lock = this.mBeanInfoLock.writeLock();
        lock.lock();
        try {
            this.className = string;
            this.info = null;
        }
        finally {
            lock.unlock();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        Lock lock = this.mBeanInfoLock.writeLock();
        lock.lock();
        try {
            this.description = string;
            this.info = null;
        }
        finally {
            lock.unlock();
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        Lock lock = this.mBeanInfoLock.writeLock();
        lock.lock();
        try {
            this.name = string;
            this.info = null;
        }
        finally {
            lock.unlock();
        }
    }

    public NotificationInfo[] getNotifications() {
        return this.notifications;
    }

    public OperationInfo[] getOperations() {
        OperationInfo[] operationInfoArray = new OperationInfo[this.operations.size()];
        this.operations.values().toArray(operationInfoArray);
        return operationInfoArray;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        Lock lock = this.mBeanInfoLock.writeLock();
        lock.lock();
        try {
            this.type = string;
            this.info = null;
        }
        finally {
            lock.unlock();
        }
    }

    public void addAttribute(AttributeInfo attributeInfo) {
        this.attributes.put(attributeInfo.getName(), attributeInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotification(NotificationInfo notificationInfo) {
        Lock lock = this.mBeanInfoLock.writeLock();
        lock.lock();
        try {
            NotificationInfo[] notificationInfoArray = new NotificationInfo[this.notifications.length + 1];
            System.arraycopy(this.notifications, 0, notificationInfoArray, 0, this.notifications.length);
            notificationInfoArray[this.notifications.length] = notificationInfo;
            this.notifications = notificationInfoArray;
            this.info = null;
        }
        finally {
            lock.unlock();
        }
    }

    public void addOperation(OperationInfo operationInfo) {
        this.operations.put(this.createOperationKey(operationInfo), operationInfo);
    }

    public DynamicMBean createMBean() throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        return this.createMBean(null);
    }

    public DynamicMBean createMBean(Object object) throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        BaseModelMBean baseModelMBean = null;
        if (this.getClassName().equals(BASE_MBEAN)) {
            baseModelMBean = new BaseModelMBean();
        } else {
            Class<?> clazz = null;
            Exception exception = null;
            try {
                clazz = Class.forName(this.getClassName());
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (clazz == null) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader != null) {
                        clazz = classLoader.loadClass(this.getClassName());
                    }
                }
                catch (Exception exception3) {
                    exception = exception3;
                }
            }
            if (clazz == null) {
                throw new MBeanException(exception, "Cannot load ModelMBean class " + this.getClassName());
            }
            try {
                baseModelMBean = (BaseModelMBean)clazz.newInstance();
            }
            catch (RuntimeOperationsException runtimeOperationsException) {
                throw runtimeOperationsException;
            }
            catch (Exception exception4) {
                throw new MBeanException(exception4, "Cannot instantiate ModelMBean of class " + this.getClassName());
            }
        }
        baseModelMBean.setManagedBean(this);
        if (object != null) {
            baseModelMBean.setManagedResource(object, "ObjectReference");
        }
        return baseModelMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MBeanInfo getMBeanInfo() {
        Lock lock = this.mBeanInfoLock.readLock();
        lock.lock();
        try {
            if (this.info != null) {
                MBeanInfo mBeanInfo = this.info;
                return mBeanInfo;
            }
        }
        finally {
            lock.unlock();
        }
        lock = this.mBeanInfoLock.writeLock();
        lock.lock();
        try {
            AttributeInfo[] attributeInfoArray = this.getAttributes();
            MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[attributeInfoArray.length];
            for (int i = 0; i < attributeInfoArray.length; ++i) {
                mBeanAttributeInfoArray[i] = attributeInfoArray[i].createAttributeInfo();
            }
            OperationInfo[] operationInfoArray = this.getOperations();
            MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[operationInfoArray.length];
            for (int i = 0; i < operationInfoArray.length; ++i) {
                mBeanOperationInfoArray[i] = operationInfoArray[i].createOperationInfo();
            }
            NotificationInfo[] notificationInfoArray = this.getNotifications();
            MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[notificationInfoArray.length];
            for (int i = 0; i < notificationInfoArray.length; ++i) {
                mBeanNotificationInfoArray[i] = notificationInfoArray[i].createNotificationInfo();
            }
            MBeanInfo mBeanInfo = this.info = new MBeanInfo(this.getClassName(), this.getDescription(), mBeanAttributeInfoArray, new MBeanConstructorInfo[0], mBeanOperationInfoArray, mBeanNotificationInfoArray);
            return mBeanInfo;
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ManagedBean[");
        stringBuilder.append("name=");
        stringBuilder.append(this.name);
        stringBuilder.append(", className=");
        stringBuilder.append(this.className);
        stringBuilder.append(", description=");
        stringBuilder.append(this.description);
        if (this.group != null) {
            stringBuilder.append(", group=");
            stringBuilder.append(this.group);
        }
        stringBuilder.append(", type=");
        stringBuilder.append(this.type);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    Method getGetter(String string, BaseModelMBean baseModelMBean, Object object) throws AttributeNotFoundException, ReflectionException {
        Method method = null;
        AttributeInfo attributeInfo = this.attributes.get(string);
        if (attributeInfo == null) {
            throw new AttributeNotFoundException(" Cannot find attribute " + string + " for " + object);
        }
        String string2 = attributeInfo.getGetMethod();
        if (string2 == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + string + " get method name");
        }
        Object object2 = null;
        NoSuchMethodException noSuchMethodException = null;
        try {
            object2 = baseModelMBean;
            method = object2.getClass().getMethod(string2, NO_ARGS_PARAM_SIG);
        }
        catch (NoSuchMethodException noSuchMethodException2) {
            noSuchMethodException = noSuchMethodException2;
        }
        if (method == null && object != null) {
            try {
                object2 = object;
                method = object2.getClass().getMethod(string2, NO_ARGS_PARAM_SIG);
                noSuchMethodException = null;
            }
            catch (NoSuchMethodException noSuchMethodException3) {
                noSuchMethodException = noSuchMethodException3;
            }
        }
        if (noSuchMethodException != null) {
            throw new ReflectionException(noSuchMethodException, "Cannot find getter method " + string2);
        }
        return method;
    }

    public Method getSetter(String string, BaseModelMBean baseModelMBean, Object object) throws AttributeNotFoundException, ReflectionException {
        Method method = null;
        AttributeInfo attributeInfo = this.attributes.get(string);
        if (attributeInfo == null) {
            throw new AttributeNotFoundException(" Cannot find attribute " + string);
        }
        String string2 = attributeInfo.getSetMethod();
        if (string2 == null) {
            throw new AttributeNotFoundException("Cannot find attribute " + string + " set method name");
        }
        String string3 = attributeInfo.getType();
        Class[] classArray = new Class[]{BaseModelMBean.getAttributeClass(string3)};
        Object object2 = null;
        NoSuchMethodException noSuchMethodException = null;
        try {
            object2 = baseModelMBean;
            method = object2.getClass().getMethod(string2, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException2) {
            noSuchMethodException = noSuchMethodException2;
        }
        if (method == null && object != null) {
            try {
                object2 = object;
                method = object2.getClass().getMethod(string2, classArray);
                noSuchMethodException = null;
            }
            catch (NoSuchMethodException noSuchMethodException3) {
                noSuchMethodException = noSuchMethodException3;
            }
        }
        if (noSuchMethodException != null) {
            throw new ReflectionException(noSuchMethodException, "Cannot find setter method " + string2 + " " + object);
        }
        return method;
    }

    public Method getInvoke(String string, Object[] objectArray, String[] stringArray, BaseModelMBean baseModelMBean, Object object) throws MBeanException, ReflectionException {
        Method method = null;
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (objectArray.length != stringArray.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Inconsistent arguments and signature"), "Inconsistent arguments and signature");
        }
        OperationInfo operationInfo = this.operations.get(this.createOperationKey(string, stringArray));
        if (operationInfo == null) {
            throw new MBeanException(new ServiceNotFoundException("Cannot find operation " + string), "Cannot find operation " + string);
        }
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = BaseModelMBean.getAttributeClass(stringArray[i]);
        }
        Object object2 = null;
        NoSuchMethodException noSuchMethodException = null;
        try {
            object2 = baseModelMBean;
            method = object2.getClass().getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException2) {
            noSuchMethodException = noSuchMethodException2;
        }
        try {
            if (method == null && object != null) {
                object2 = object;
                method = object2.getClass().getMethod(string, classArray);
            }
        }
        catch (NoSuchMethodException noSuchMethodException3) {
            noSuchMethodException = noSuchMethodException3;
        }
        if (method == null) {
            throw new ReflectionException(noSuchMethodException, "Cannot find method " + string + " with this signature");
        }
        return method;
    }

    private String createOperationKey(OperationInfo operationInfo) {
        StringBuilder stringBuilder = new StringBuilder(operationInfo.getName());
        stringBuilder.append('(');
        for (ParameterInfo parameterInfo : operationInfo.getSignature()) {
            stringBuilder.append(parameterInfo.getType());
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
        return stringBuilder.toString().intern();
    }

    private String createOperationKey(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('(');
        for (String string2 : stringArray) {
            stringBuilder.append(string2);
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
        return stringBuilder.toString().intern();
    }
}

