/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.tomcat.util.modeler.BaseModelMBean;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;

public class UserMBean
extends BaseModelMBean {
    protected Registry registry = MBeanUtils.createRegistry();
    protected ManagedBean managed = this.registry.findManagedBean("User");

    public String[] getGroups() {
        User user = (User)this.resource;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Group> iterator = user.getGroups();
        while (iterator.hasNext()) {
            Group group = null;
            try {
                group = iterator.next();
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), group);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create object name for group " + group);
                illegalArgumentException.initCause(malformedObjectNameException);
                throw illegalArgumentException;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getRoles() {
        User user = (User)this.resource;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Role> iterator = user.getRoles();
        while (iterator.hasNext()) {
            Role role = null;
            try {
                role = iterator.next();
                ObjectName objectName = MBeanUtils.createObjectName(this.managed.getDomain(), role);
                arrayList.add(objectName.toString());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create object name for role " + role);
                illegalArgumentException.initCause(malformedObjectNameException);
                throw illegalArgumentException;
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public void addGroup(String string) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Group group = user.getUserDatabase().findGroup(string);
        if (group == null) {
            throw new IllegalArgumentException("Invalid group name '" + string + "'");
        }
        user.addGroup(group);
    }

    public void addRole(String string) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Role role = user.getUserDatabase().findRole(string);
        if (role == null) {
            throw new IllegalArgumentException("Invalid role name '" + string + "'");
        }
        user.addRole(role);
    }

    public void removeGroup(String string) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Group group = user.getUserDatabase().findGroup(string);
        if (group == null) {
            throw new IllegalArgumentException("Invalid group name '" + string + "'");
        }
        user.removeGroup(group);
    }

    public void removeRole(String string) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Role role = user.getUserDatabase().findRole(string);
        if (role == null) {
            throw new IllegalArgumentException("Invalid role name '" + string + "'");
        }
        user.removeRole(role);
    }
}

