/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.apache.coyote.ContainerThreadMarker;
import org.apache.coyote.http11.upgrade.UpgradeProcessorBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class UpgradeServletInputStream
extends ServletInputStream {
    private static final Log log = LogFactory.getLog(UpgradeServletInputStream.class);
    private static final StringManager sm = StringManager.getManager(UpgradeServletInputStream.class);
    private final UpgradeProcessorBase processor;
    private final SocketWrapperBase<?> socketWrapper;
    private volatile boolean closed = false;
    private volatile boolean eof = false;
    private volatile Boolean ready = Boolean.TRUE;
    private volatile ReadListener listener = null;

    public UpgradeServletInputStream(UpgradeProcessorBase upgradeProcessorBase, SocketWrapperBase<?> socketWrapperBase) {
        this.processor = upgradeProcessorBase;
        this.socketWrapper = socketWrapperBase;
    }

    public final boolean isFinished() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sis.isFinished.ise"));
        }
        return this.eof;
    }

    public final boolean isReady() {
        if (this.listener == null) {
            throw new IllegalStateException(sm.getString("upgrade.sis.isReady.ise"));
        }
        if (this.eof || this.closed) {
            return false;
        }
        if (this.ready != null) {
            return this.ready;
        }
        try {
            this.ready = this.socketWrapper.isReadyForRead();
        }
        catch (IOException iOException) {
            this.onError(iOException);
        }
        return this.ready;
    }

    public final void setReadListener(ReadListener readListener) {
        if (readListener == null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sis.readListener.null"));
        }
        if (this.listener != null) {
            throw new IllegalArgumentException(sm.getString("upgrade.sis.readListener.set"));
        }
        if (this.closed) {
            throw new IllegalStateException(sm.getString("upgrade.sis.read.closed"));
        }
        this.listener = readListener;
        if (ContainerThreadMarker.isContainerThread()) {
            this.processor.addDispatch(DispatchType.NON_BLOCKING_READ);
        } else {
            this.socketWrapper.registerReadInterest();
        }
        this.ready = null;
    }

    public final int read() throws IOException {
        this.preReadChecks();
        return this.readInternal();
    }

    public final int readLine(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.preReadChecks();
        if (n2 <= 0) {
            return 0;
        }
        int n4 = 0;
        while ((n3 = this.readInternal()) != -1) {
            byArray[n++] = (byte)n3;
            if (n3 != 10 && ++n4 != n2) continue;
        }
        return n4 > 0 ? n4 : -1;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        this.preReadChecks();
        try {
            int n3 = this.socketWrapper.read(this.listener == null, byArray, n, n2);
            if (n3 == -1) {
                this.eof = true;
            }
            return n3;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public void close() throws IOException {
        this.eof = true;
        this.closed = true;
    }

    private void preReadChecks() {
        if (!(this.listener == null || this.ready != null && this.ready.booleanValue())) {
            throw new IllegalStateException(sm.getString("upgrade.sis.read.ise"));
        }
        if (this.closed) {
            throw new IllegalStateException(sm.getString("upgrade.sis.read.closed"));
        }
        this.ready = null;
    }

    private int readInternal() throws IOException {
        int n;
        byte[] byArray = new byte[1];
        try {
            n = this.socketWrapper.read(this.listener == null, byArray, 0, 1);
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        if (n == 0) {
            return -1;
        }
        if (n == -1) {
            this.eof = true;
            return -1;
        }
        return byArray[0] & 0xFF;
    }

    final void onDataAvailable() {
        try {
            if (this.listener == null || !this.socketWrapper.isReadyForRead()) {
                return;
            }
        }
        catch (IOException iOException) {
            this.onError(iOException);
        }
        this.ready = Boolean.TRUE;
        ClassLoader classLoader = this.processor.getUpgradeToken().getContextBind().bind(false, null);
        try {
            if (!this.eof) {
                this.listener.onDataAvailable();
            }
            if (this.eof) {
                this.listener.onAllDataRead();
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.onError(throwable);
        }
        finally {
            this.processor.getUpgradeToken().getContextBind().unbind(false, classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onError(Throwable throwable) {
        block9: {
            if (this.listener == null) {
                return;
            }
            ClassLoader classLoader = this.processor.getUpgradeToken().getContextBind().bind(false, null);
            try {
                this.listener.onError(throwable);
            }
            catch (Throwable throwable2) {
                ExceptionUtils.handleThrowable((Throwable)throwable2);
                log.warn((Object)sm.getString("upgrade.sis.onErrorFail"), throwable2);
            }
            finally {
                this.processor.getUpgradeToken().getContextBind().unbind(false, classLoader);
            }
            try {
                this.close();
            }
            catch (IOException iOException) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)sm.getString("upgrade.sis.errorCloseFail"), (Throwable)iOException);
            }
        }
        this.ready = Boolean.FALSE;
    }

    final boolean isClosed() {
        return this.closed;
    }
}

