/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.ui;

import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.ContributedLibraryReleases;
import cc.arduino.contributions.libraries.ui.ContributedLibraryReleasesComparator;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.ui.FilteredAbstractTableModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import processing.app.BaseNoGui;

public class LibrariesIndexTableModel
extends FilteredAbstractTableModel<ContributedLibraryReleases> {
    private final List<ContributedLibraryReleases> contributions = new ArrayList<ContributedLibraryReleases>();
    private final String[] columnNames = new String[]{"Description"};
    private final Class<?>[] columnTypes = new Class[]{ContributedPlatform.class};
    Predicate<ContributedLibraryReleases> selectedCategoryFilter = null;
    String[] selectedFilters = null;

    @Override
    public void updateIndexFilter(String[] filters, Predicate<ContributedLibraryReleases> additionalFilter) {
        this.selectedCategoryFilter = additionalFilter;
        this.selectedFilters = filters;
        this.update();
    }

    private boolean stringContainsAll(String string, String[] filters) {
        if (string == null) {
            return false;
        }
        if (filters == null) {
            return true;
        }
        for (String filter : filters) {
            if (string.toLowerCase().contains(filter.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.contributions.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int colum) {
        return this.columnTypes[colum];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.contributions.size()) {
            return null;
        }
        ContributedLibraryReleases contribution = this.contributions.get(row);
        return contribution;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public ContributedLibraryReleases getReleases(int row) {
        return this.contributions.get(row);
    }

    public ContributedLibrary getSelectedRelease(int row) {
        return this.contributions.get(row).getSelected();
    }

    public void update() {
        this.updateContributions();
        this.fireTableDataChanged();
    }

    private boolean filterCondition(ContributedLibraryReleases lib) {
        if (this.selectedCategoryFilter != null && !this.selectedCategoryFilter.test(lib)) {
            return false;
        }
        ContributedLibrary latest = lib.getLatest();
        String compoundTargetSearchText = latest.getName() + " " + latest.getParagraph() + " " + latest.getSentence();
        if (latest.getProvidesIncludes() != null) {
            compoundTargetSearchText = compoundTargetSearchText + " " + latest.getProvidesIncludes();
        }
        return this.stringContainsAll(compoundTargetSearchText, this.selectedFilters);
    }

    public void updateLibrary(ContributedLibrary lib) {
        int row = -1;
        for (ContributedLibraryReleases releases : this.contributions) {
            if (!releases.shouldContain(lib)) continue;
            row = this.contributions.indexOf(releases);
        }
        this.updateContributions();
        for (ContributedLibraryReleases releases : this.contributions) {
            if (!releases.shouldContain(lib)) continue;
            if (row == -1) {
                row = this.contributions.indexOf(releases);
                this.fireTableRowsInserted(row, row);
            } else {
                this.fireTableRowsUpdated(row, row);
            }
            return;
        }
        this.fireTableRowsDeleted(row, row);
    }

    private List<ContributedLibraryReleases> rebuildContributionsFromIndex() {
        ArrayList<ContributedLibraryReleases> res = new ArrayList<ContributedLibraryReleases>();
        BaseNoGui.librariesIndexer.getIndex().getLibraries().forEach(lib -> {
            for (ContributedLibraryReleases contribution : res) {
                if (!contribution.shouldContain(lib)) continue;
                contribution.add(lib);
                return;
            }
            res.add(new ContributedLibraryReleases(lib));
        });
        return res;
    }

    private void updateContributions() {
        List<ContributedLibraryReleases> all = this.rebuildContributionsFromIndex();
        this.contributions.clear();
        all.stream().filter(this::filterCondition).forEach(this.contributions::add);
        Collections.sort(this.contributions, new ContributedLibraryReleasesComparator("Arduino"));
    }
}

