/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.services;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.autoupdate.services.AutoupdateSettings;
import org.netbeans.modules.autoupdate.services.Trampoline;
import org.netbeans.modules.autoupdate.services.UpdateManagerImpl;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogFactory;
import org.netbeans.modules.autoupdate.updateprovider.AutoupdateCatalogProvider;
import org.netbeans.modules.autoupdate.updateprovider.LocalNBMsProvider;
import org.netbeans.modules.autoupdate.updateprovider.ProviderCategory;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class UpdateUnitProviderImpl {
    private UpdateProvider provider;
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.services.UpdateUnitProviderImpl");
    private static final String REMOVED_MASK = "_removed";
    private static final String URL = "url";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ENABLED = "enabled";
    private static final String CATEGORY_NAME = "categoryName";
    private static final LookupListenerImpl UPDATE_PROVIDERS = new LookupListenerImpl();

    public UpdateUnitProviderImpl(UpdateProvider provider) {
        this.provider = provider;
    }

    public String getName() {
        return this.getUpdateProvider().getName();
    }

    public String getDescription() {
        return this.getUpdateProvider().getDescription();
    }

    public UpdateUnitProvider.CATEGORY getCategory() {
        return this.getUpdateProvider().getCategory();
    }

    public Image getSourceIcon() {
        UpdateProvider up = this.getUpdateProvider();
        if (up instanceof AutoupdateCatalogProvider) {
            return ((AutoupdateCatalogProvider)up).getProviderCategory().getIcon();
        }
        return ProviderCategory.forValue(UpdateUnitProvider.CATEGORY.COMMUNITY).getIcon();
    }

    public String getSourceDescription() {
        UpdateProvider up = this.getUpdateProvider();
        if (up instanceof AutoupdateCatalogProvider) {
            return ((AutoupdateCatalogProvider)up).getProviderCategory().getDisplayName();
        }
        return ProviderCategory.forValue(UpdateUnitProvider.CATEGORY.COMMUNITY).getDisplayName();
    }

    public String getContentDescription() {
        UpdateProvider up = this.getUpdateProvider();
        if (up instanceof AutoupdateCatalogProvider) {
            return ((AutoupdateCatalogProvider)up).getContentDescription();
        }
        return null;
    }

    public String getDisplayName() {
        return UpdateUnitProviderImpl.loadDisplayName(this.getUpdateProvider());
    }

    public void setDisplayName(String name) {
        UpdateUnitProviderImpl.storeDisplayName(this.getUpdateProvider(), name);
    }

    public URL getProviderURL() {
        return UpdateUnitProviderImpl.loadUrl(this.getUpdateProvider());
    }

    public void setProviderURL(URL url) {
        UpdateUnitProviderImpl.storeUrl(this.getUpdateProvider(), url);
    }

    public List<UpdateUnit> getUpdateUnits(UpdateManager.TYPE ... types) {
        return UpdateManagerImpl.getUpdateUnits(this.getUpdateProvider(), types);
    }

    public boolean refresh(ProgressHandle handle, boolean force) throws IOException {
        boolean res = false;
        if (handle != null) {
            handle.progress(NbBundle.getMessage(UpdateUnitProviderImpl.class, (String)"UpdateUnitProviderImpl_FormatCheckingForUpdates", (Object)this.getDisplayName()));
        }
        UpdateProvider updateProvider = this.getUpdateProvider();
        updateProvider.refresh(force);
        if (force) {
            AutoupdateSettings.setLastCheck(new Date());
            AutoupdateSettings.setLastCheck(updateProvider.getName(), new Date());
        }
        UpdateManagerImpl.getInstance().clearCache();
        return res;
    }

    public void setEnable(boolean state) {
        UpdateManagerImpl.getInstance().clearCache();
        UpdateUnitProviderImpl.storeState(this.getUpdateProvider(), state);
    }

    public boolean isEnabled() {
        return UpdateUnitProviderImpl.loadState(this.getUpdateProvider().getName());
    }

    public UpdateProvider getUpdateProvider() {
        assert (this.provider != null) : "UpdateProvider found.";
        return this.provider;
    }

    public static void remove(UpdateUnitProvider unitProvider) {
        UpdateUnitProviderImpl impl = Trampoline.API.impl(unitProvider);
        impl.remove();
    }

    private void remove() {
        try {
            if (UpdateUnitProviderImpl.getPreferences().nodeExists(this.getName())) {
                UpdateUnitProviderImpl.getPreferences().node(this.getName()).removeNode();
                UpdateUnitProviderImpl.getPreferences().node(this.getName() + REMOVED_MASK).putBoolean(REMOVED_MASK, true);
            } else {
                UpdateUnitProviderImpl.getPreferences().node(this.getName() + REMOVED_MASK).putBoolean(REMOVED_MASK, true);
            }
        }
        catch (BackingStoreException bsx) {
            Exceptions.printStackTrace((Throwable)bsx);
        }
        UpdateManagerImpl.getInstance().clearCache();
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String codeName, String displayName, URL url) {
        return UpdateUnitProviderImpl.createUpdateUnitProvider(codeName, displayName, url, ProviderCategory.forValue(UpdateUnitProvider.CATEGORY.COMMUNITY));
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String codeName, String displayName, URL url, ProviderCategory category) {
        codeName = UpdateUnitProviderImpl.normalizeCodeName(codeName);
        UpdateUnitProviderImpl.storeProvider(codeName, displayName, url, category);
        AutoupdateCatalogProvider catalog = new AutoupdateCatalogProvider(codeName, displayName, url, category);
        return Trampoline.API.createUpdateUnitProvider(new UpdateUnitProviderImpl(catalog));
    }

    public static UpdateUnitProvider createUpdateUnitProvider(String name, File ... files) {
        name = UpdateUnitProviderImpl.normalizeCodeName(name);
        LocalNBMsProvider provider = new LocalNBMsProvider(name, files);
        return Trampoline.API.createUpdateUnitProvider(new UpdateUnitProviderImpl(provider));
    }

    public static List<UpdateUnitProvider> getUpdateUnitProviders(boolean onlyEnabled) {
        FileObject auTypeFolder = FileUtil.getConfigFile((String)"Services/AutoupdateType");
        if (auTypeFolder != null) {
            for (FileObject fileObject : auTypeFolder.getChildren()) {
                try {
                    if (UpdateUnitProviderImpl.getPreferences().nodeExists(fileObject.getName()) || UpdateUnitProviderImpl.getPreferences().nodeExists(fileObject.getName() + REMOVED_MASK)) continue;
                    try {
                        UpdateProvider p = AutoupdateCatalogFactory.createUpdateProvider(fileObject);
                        if (p != null) {
                            UpdateUnitProviderImpl.getPreferences().node(fileObject.getName()).putBoolean("loaded", true);
                            err.log(Level.FINEST, "{0} loaded", fileObject);
                            continue;
                        }
                        err.log(Level.INFO, "{0} cannot be loaded (missing url or url_key)", fileObject);
                        UpdateUnitProviderImpl.getPreferences().node(fileObject.getName()).putBoolean("loaded", false);
                    }
                    catch (Exception x) {
                        Exceptions.printStackTrace((Throwable)x);
                    }
                }
                catch (BackingStoreException bse) {
                    err.log(Level.INFO, bse.getMessage() + " while loading " + fileObject, bse);
                }
            }
        }
        Collection<? extends UpdateProvider> col = UPDATE_PROVIDERS.allInstances();
        HashMap<String, UpdateProvider> providerMap = new HashMap<String, UpdateProvider>();
        for (UpdateProvider updateProvider : col) {
            try {
                if (UpdateUnitProviderImpl.getPreferences().nodeExists(updateProvider.getName() + REMOVED_MASK)) {
                    continue;
                }
            }
            catch (BackingStoreException bsx) {
                Exceptions.printStackTrace((Throwable)bsx);
            }
            providerMap.put(updateProvider.getName(), updateProvider);
        }
        try {
            Preferences p = UpdateUnitProviderImpl.getPreferences();
            String[] stringArray = p.childrenNames();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    UpdateProvider provider = UpdateUnitProviderImpl.loadProvider(stringArray[i]);
                    if (err.isLoggable(Level.FINE) && provider != null && providerMap.containsKey(provider.getName())) {
                        err.log(Level.FINE, "Customized Provider " + provider.getName());
                    }
                    if (provider != null) {
                        providerMap.put(provider.getName(), provider);
                    }
                    boolean enabled = UpdateUnitProviderImpl.loadState(stringArray[i]);
                    if (!onlyEnabled || enabled) continue;
                    providerMap.remove(stringArray[i]);
                }
            }
        }
        catch (BackingStoreException bse) {
            err.log(Level.INFO, bse.getMessage(), bse);
        }
        ArrayList<UpdateUnitProvider> unitProviders = new ArrayList<UpdateUnitProvider>(providerMap.values().size());
        for (UpdateProvider p : providerMap.values()) {
            UpdateUnitProviderImpl impl = new UpdateUnitProviderImpl(p);
            unitProviders.add(Trampoline.API.createUpdateUnitProvider(impl));
        }
        return unitProviders;
    }

    public static void refreshProviders(ProgressHandle handle, boolean force) throws IOException {
        List<UpdateUnitProvider> providers = UpdateUnitProviderImpl.getUpdateUnitProviders(true);
        for (UpdateUnitProvider p : providers) {
            p.refresh(handle, force);
            AutoupdateSettings.setLastCheck(p.getName(), new Date());
        }
        if (force) {
            AutoupdateSettings.setLastCheck(new Date());
        }
        UpdateManagerImpl.getInstance().clearCache();
    }

    private static void storeProvider(String codeName, String displayName, URL url, ProviderCategory c) {
        if (codeName.contains("/")) {
            codeName = codeName.replaceAll("/", "_");
        }
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(codeName);
        assert (providerPreferences != null) : "Preferences node " + codeName + " found.";
        providerPreferences.put(URL, url.toString());
        providerPreferences.put(DISPLAY_NAME, displayName);
        providerPreferences.put(CATEGORY_NAME, c.getDisplayName());
        providerPreferences.put("originalCategoryIconBase", c.getIconBase());
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/modules/autoupdate");
    }

    static UpdateProvider loadProvider(String codeName) {
        URL url;
        ProviderCategory pc;
        String displayName;
        block9: {
            UpdateUnitProvider.CATEGORY c;
            try {
                if (UpdateUnitProviderImpl.getPreferences().nodeExists(codeName + REMOVED_MASK)) {
                    return null;
                }
            }
            catch (BackingStoreException e) {
                err.log(Level.INFO, e.getMessage(), e);
            }
            Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(codeName);
            assert (providerPreferences != null) : "Preferences node " + codeName + " found.";
            String toUrl = providerPreferences.get(URL, providerPreferences.get("originalUrl", null));
            displayName = providerPreferences.get(DISPLAY_NAME, providerPreferences.get("originalDisplayName", codeName));
            String categoryName = providerPreferences.get(CATEGORY_NAME, providerPreferences.get("originalCategoryName", UpdateUnitProvider.CATEGORY.COMMUNITY.name()));
            try {
                c = UpdateUnitProvider.CATEGORY.valueOf(categoryName);
            }
            catch (IllegalArgumentException ex) {
                c = null;
            }
            String categoryIconBase = providerPreferences.get("originalCategoryIconBase", null);
            pc = c != null ? ProviderCategory.forValue(c) : ProviderCategory.create(categoryIconBase, categoryName);
            if (toUrl == null) {
                return null;
            }
            url = null;
            try {
                url = new URL(toUrl);
            }
            catch (MalformedURLException mue) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError((Object)mue);
            }
        }
        return new AutoupdateCatalogProvider(codeName, displayName, url, pc);
    }

    private static boolean loadState(String codename) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(codename);
        assert (providerPreferences != null) : "Preferences node " + codename + " found.";
        String enabled = providerPreferences.get(ENABLED, providerPreferences.get("originalEnabled", null));
        return !Boolean.FALSE.toString().equals(enabled);
    }

    private static void storeState(UpdateProvider p, boolean isEnabled) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(p.getName());
        assert (providerPreferences != null) : "Preferences node " + p.getName() + " found.";
        providerPreferences.put(ENABLED, Boolean.valueOf(isEnabled).toString());
        try {
            if (UpdateUnitProviderImpl.getPreferences().nodeExists(p.getName() + REMOVED_MASK)) {
                UpdateUnitProviderImpl.getPreferences().node(p.getName() + REMOVED_MASK).removeNode();
            }
        }
        catch (BackingStoreException x) {
            err.log(Level.INFO, x.getMessage(), x);
        }
    }

    private static String loadDisplayName(UpdateProvider p) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(p.getName());
        assert (providerPreferences != null) : "Preferences node " + p.getName() + " found.";
        return providerPreferences.get(DISPLAY_NAME, p.getDisplayName());
    }

    private static void storeDisplayName(UpdateProvider p, String displayName) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(p.getName());
        assert (providerPreferences != null) : "Preferences node " + p.getName() + " found.";
        if (displayName == null) {
            providerPreferences.remove(DISPLAY_NAME);
        } else if (!displayName.equals(p.getDisplayName())) {
            providerPreferences.put(DISPLAY_NAME, displayName);
        }
    }

    private static URL loadUrl(UpdateProvider p) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(p.getName());
        assert (providerPreferences != null) : "Preferences node " + p.getName() + " found.";
        String urlSpec = null;
        if (p instanceof AutoupdateCatalogProvider) {
            urlSpec = ((AutoupdateCatalogProvider)p).getUpdateCenterURL().toExternalForm();
        }
        if ((urlSpec = providerPreferences.get(URL, urlSpec)) == null || urlSpec.length() == 0) {
            return null;
        }
        int idx = urlSpec.indexOf("?unique");
        if (idx != -1) {
            urlSpec = urlSpec.substring(0, idx);
        }
        err.log(Level.FINE, "Use urlSpec " + urlSpec + " for Provider " + p);
        URL url = null;
        try {
            url = new URL(urlSpec);
        }
        catch (MalformedURLException x) {
            err.log(Level.INFO, x.getMessage(), x);
        }
        return url;
    }

    private static void storeUrl(UpdateProvider p, URL url) {
        Preferences providerPreferences = UpdateUnitProviderImpl.getPreferences().node(p.getName());
        assert (providerPreferences != null) : "Preferences node " + p.getName() + " found.";
        if (url == null) {
            providerPreferences.remove(URL);
        } else {
            URL orig = null;
            if (p instanceof AutoupdateCatalogProvider) {
                orig = ((AutoupdateCatalogProvider)p).getUpdateCenterURL();
            }
            if (!url.toExternalForm().equals(orig.toExternalForm())) {
                providerPreferences.put(URL, url.toExternalForm());
                if (p instanceof AutoupdateCatalogProvider) {
                    ((AutoupdateCatalogProvider)p).setUpdateCenterURL(url);
                }
            }
        }
    }

    private static String normalizeCodeName(String codeName) {
        List<Character> illegalChars = Arrays.asList(Character.valueOf('\"'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf(':'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('|'));
        StringBuilder buf = new StringBuilder();
        for (char ch : codeName.toCharArray()) {
            if (illegalChars.contains(Character.valueOf(ch))) {
                ch = '_';
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public String toString() {
        return this.provider.toString();
    }

    private static class LookupListenerImpl
    implements LookupListener {
        final Lookup.Result<UpdateProvider> result = Lookup.getDefault().lookupResult(UpdateProvider.class);

        public LookupListenerImpl() {
            this.result.addLookupListener((LookupListener)this);
        }

        public void resultChanged(LookupEvent ev) {
            err.log(Level.FINE, "Lookup.Result changed " + ev);
            try {
                UpdateUnitProviderImpl.refreshProviders(null, false);
            }
            catch (IOException ioe) {
                err.log(Level.INFO, ioe.getMessage(), ioe);
            }
        }

        public Collection<? extends UpdateProvider> allInstances() {
            Collection res = this.result.allInstances();
            return res;
        }
    }
}

